/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.data.types;

import adalid.core.Constants;
import adalid.core.XS2;
import adalid.core.primitives.NumericPrimitive;
import java.math.BigDecimal;

/**
 * @author Jorge Campins
 */
public class BigDecimalData extends NumericPrimitive {

    public static final BigDecimal ZERO = BigDecimal.ZERO;

    private int _precision = Constants.DEFAULT_DECIMAL_PRECISION;

    private int _scale = 0;

    {
        XS2.setDataClass(this, BigDecimalData.class);
        XS2.setDataType(this, BigDecimal.class);
        setMinMaxNumbers();
    }

    /**
     * @return the precision
     */
    public Integer getPrecision() {
        return _precision;
    }

    /**
     * @param precision the precision to set
     */
    public void setPrecision(Integer precision) {
        XS2.checkAccess();
        int def = Constants.DEFAULT_DECIMAL_PRECISION;
        int max = Constants.MAX_DECIMAL_PRECISION;
        _precision = precision == null || precision < 1 ? def : precision > max ? max : precision;
        if (_scale > _precision) {
            _scale = _precision;
        }
        setMinMaxNumbers();
    }

    /**
     * @return the scale
     */
    public Integer getScale() {
        return _scale;
    }

    /**
     * @param scale the scale to set
     */
    public void setScale(Integer scale) {
        XS2.checkAccess();
        _scale = scale == null || scale < 0 ? 0 : scale > _precision ? _precision : scale;
        setMinMaxNumbers();
    }

    private void setMinMaxNumbers() {
        /*
        int p = _precision > 0 ? _precision : Constants.DEFAULT_DECIMAL_PRECISION;
        int s = _scale > p ? 0 : _scale;
        **/
        int p = _precision;
        int s = _scale;
        BigDecimal one = BigDecimal.ONE.divide(BigDecimal.TEN.pow(s));
        BigDecimal max = BigDecimal.TEN.pow(p - s).subtract(one);
        BigDecimal min = BigDecimal.ZERO.subtract(max);
        setMinNumber(min);
        setMaxNumber(max);
    }

}
