/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.data.types;

import adalid.core.XS2;
import adalid.core.expressions.CharacterOrderedPairX;
import adalid.core.expressions.CharacterScalarX;
import adalid.core.expressions.XB;
import adalid.core.primitives.NumericPrimitive;

/**
 * @author Jorge Campins
 */
public class LongData extends NumericPrimitive {

    public static final Long ZERO = 0L;

    {
        XS2.setDataClass(this, LongData.class);
        XS2.setDataType(this, Long.class);
        setMinNumber(Long.MIN_VALUE);
        setMaxNumber(Long.MAX_VALUE);
    }

    public CharacterOrderedPairX toZeroPaddedString(int width) {
        return XB.Character.OrderedPair.toZeroPaddedString(this, width);
    }

    public CharacterScalarX toZeroPaddedString() {
        return XB.Character.Scalar.toZeroPaddedString(this);
    }

}
