/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.interfaces;

import adalid.core.enums.CascadeType;
import adalid.core.enums.FetchType;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.QuickAddingFilter;

/**
 * @author Jorge Campins
 */
public interface EntityReference extends Entity, Parameter, Property {
//
//  /**
//   * @return the extension
//   */
//  boolean isExtension();

    /**
     * @return the oneToOne
     */
    boolean isOneToOne();

    /**
     * @return the manyToOne
     */
    boolean isManyToOne();

    /**
     * @return the fetch type
     */
    FetchType getFetchType();

    /**
     * @return the cascade type
     */
    CascadeType[] getCascadeType();

    /**
     * @return the cascade type
     */
    String getCascadeTypeString();

    /**
     * @return the navigability
     */
    Navigability getNavigability();

    /**
     * @return the masterDetailView
     */
    MasterDetailView getMasterDetailView();

    /**
     * @return the quick-adding filter
     */
    QuickAddingFilter getQuickAddingFilter();

    /**
     * @return the key-properties-query-mapping indicator
     */
    boolean isKeyPropertiesQueryMappingEnabled();

}
