/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.wrappers;

import adalid.commons.util.StrUtils;
import adalid.core.ExportOperation;
import adalid.core.Operation;
import adalid.core.ReportOperation;
import adalid.core.View;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.programmers.ChiefProgrammer;
import org.apache.commons.lang.StringUtils;

/**
 * @author Jorge Campins
 */
public class OperationWrapper extends ArtifactWrapper {

    private Operation _operation;

    private OperationWrapper() {
        this(null);
    }

    public OperationWrapper(Operation operation) {
        super(operation);
        _operation = operation;
    }

    /**
     * @return the wrapped operation
     */
    @Override
    public Operation getWrapped() {
        return _operation;
    }

    public String getBundleExportReportOperationLabel() {
        return getBundleValueString(getExportReportOperationLabel());
    }

    public String getExportReportOperationLabel() {
        String label = _operation.getDefaultCollectionLabel();
        if (StringUtils.isNotBlank(label)) {
            return label;
        }
        View view
            = _operation instanceof ExportOperation ? ((ExportOperation) _operation).getView()
                : _operation instanceof ReportOperation ? ((ReportOperation) _operation).getView()
                    : null;
        /**/
        if (view != null) {
            label = view.getDefaultLabel();
            if (StringUtils.isNotBlank(label)) {
                return label;
            }
        }
        return null;
    }

    public String getUnderscoredProperName() {
        String string = _operation.getProperName();
        return StrUtils.getLowerCaseIdentifier(string, '_');
    }

    /**
     * @return the SQL operation function name
     */
    public String getSqlOperationFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlOperationFunctionName(_operation);
    }

    /**
     * @param maxIdentifierLength
     * @return the SQL operation function name
     */
    public String getSqlOperationFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlOperationFunctionName(_operation, maxIdentifierLength);
    }

    /**
     * @return the SQL schema quailified operation function name
     */
    public String getSqlSchemaQualifiedOperationFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedOperationFunctionName(_operation);
    }

    /**
     * @param maxIdentifierLength
     * @return the SQL schema quailified operation function name
     */
    public String getSqlSchemaQualifiedOperationFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedOperationFunctionName(_operation, maxIdentifierLength);
    }

    /**
     * @return the SQL schema quailified short operation function name
     */
    public String getSqlSchemaQualifiedShortOperationFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedShortOperationFunctionName(_operation);
    }

    /**
     * @param maxIdentifierLength
     * @return the SQL schema quailified short operation function name
     */
    public String getSqlSchemaQualifiedShortOperationFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedShortOperationFunctionName(_operation, maxIdentifierLength);
    }

}
