/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.jee2.meta.proyecto.base;

import adalid.commons.util.KVP;
import adalid.core.Display;
import adalid.core.Page;
import java.util.Map;
import meta.psm.PageAttributeKeys;
import meta.psm.ProjectAttributeKeys;

/**
 * @author Jorge Campins
 */
public class ProyectoJava2 extends ProyectoJava1 {

    public ProyectoJava2() {
        super();
    }

    private static final String[] X_PAGE_NAMES = new String[]{
        "ArchivoAdjunto11",
        "ArchivoAdjunto12",
        "ElementoSegmento11PorConjuntoSegmento",
        "ElementoSegmento21PorConjuntoSegmento",
        "FiltroFuncionPar11PorFiltroFuncion",
        "FiltroFuncionPar12PorFiltroFuncion",
        "FiltroFuncionPar21PorFiltroFuncion",
        "FiltroFuncionPar22PorFiltroFuncion",
        "RastroFuncion11",
        "RastroFuncion12",
        "RastroFuncionPar11PorRastroFuncion",
        "RastroFuncionPar12PorRastroFuncion",
        "RastroInforme11",
        "RastroInforme12",
        "RastroProceso11",
        "RastroProceso12",
        "TareaUsuario11",
        "TareaUsuario12",
        "VistaFuncionCol21PorVista",
        "VistaFuncionCol22PorVista"
    };

    @Override
    public void addDirectives() {
        super.addDirectives();
        Map<String, ? extends Display> displays = getDisplaysMap();
        for (String name : X_PAGE_NAMES) {
            if (!displays.containsKey(name)) {
                addFileExclusionPattern("^.*/pages/impl/" + name + "\\.java$");
            }
        }
    }

    @Override
    public void addAttributes() {
        super.addAttributes();
        /**/
        addAttribute(ProjectAttributeKeys.CUSTOM_LAYOUT, false);
        addAttribute(ProjectAttributeKeys.HLB_RENDERING, false);
        addAttribute(ProjectAttributeKeys.HCB_RENDERING, false);
        addAttribute(ProjectAttributeKeys.HRB_RENDERING, false);
        addAttribute(ProjectAttributeKeys.INLINE_HELP_RENDERING, true);
        addAttribute(ProjectAttributeKeys.PARTIAL_STATE_SAVING, true);
//      addAttribute(ProjectAttributeKeys.SESSION_TIMEOUT, 30);
        /**/
        for (String name : X_PAGE_NAMES) {
            addAttribute(Page.class, name,
                KVP.join(PageAttributeKeys.ABSTRACT, true)
            );
        }
    }

    public void addHolidaysListBeanAttribute() {
        final String beanName = "holidaysList";
        addHolidaysListBeanAttribute(beanName);
    }

    public void addHolidaysListBeanAttribute(String beanName) {
        final String classSimpleName = "HolidaysList";
        addBeanAttribute(classSimpleName, beanName);
    }

}
