/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.util;

import adalid.commons.properties.BootstrappingFile;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.FilUtils;
import javax.swing.JFileChooser;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author Jorge Campins
 */
public class Utility {

    private static final Logger logger = Logger.getLogger(Utility.class);

    private static final String ARGS_FAILED = "method getArguments failed";

    private static final String ARGS_SUFFIX = ".args";

    private static final String USER_DIR = System.getProperty("user.dir");

    private static ProjectObjectModel pom;

    private static ProjectObjectModel pom() {
        if (pom == null) {
            pom = new ProjectObjectModel();
        }
        return pom;
    }

    protected static String getAdalidProjectVersion() {
        return pom().getProjectVersionNumber();
    }

    protected static void logAdalidProjectVersion() {
        pom().logProjectVersion();
    }

    public static String chooseDirectory(String path) {
        String currentDirectoryPath = FilUtils.isDirectory(path) ? path : USER_DIR;
        JFileChooser chooser = new JFileChooser(currentDirectoryPath);
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int option = chooser.showOpenDialog(null);
        return option == JFileChooser.APPROVE_OPTION ? chooser.getSelectedFile().getPath() : null;
    }

    public static String[] getArguments(Class<?> clazz) {
        return getArguments(clazz == null ? null : clazz.getName());
    }

    public static String[] getArguments(String clazz) {
        ExtendedProperties properties;
        String[] arguments = null;
        if (clazz == null) {
            logger.error(ARGS_FAILED + "; null value for clazz parameter");
        } else {
            properties = PropertiesHandler.getPrivateProperties();
            arguments = getArguments(clazz, properties, Level.TRACE);
            if (arguments == null) {
                properties = PropertiesHandler.getBootstrapping();
                arguments = getArguments(clazz, properties, Level.INFO);
            }
        }
        return arguments == null ? new String[0] : arguments;
    }

    private static String[] getArguments(String clazz, ExtendedProperties properties, Level level) {
        if (properties == null) {
            logger.log(level, ARGS_FAILED + "; properties is null");
        } else if (properties.isEmpty()) {
            logger.log(level, ARGS_FAILED + "; properties is empty");
        } else {
            String key = clazz + ARGS_SUFFIX;
            try {
                String[] strings = properties.getStringArray(key);
                if (strings == null || strings.length == 0) {
                    logger.log(level, ARGS_FAILED + "; property " + key + " not found");
                } else {
                    return strings;
                }
            } catch (Exception e) {
                logger.log(level, ARGS_FAILED + "; " + key + " not properly defined (" + e + ")");
            }
        }
        return null;
    }

    public static void setBootstrappingFileName(String name) {
        BootstrappingFile.setName(name);
    }

}
