/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.util.setup;

import adalid.commons.util.ThrowableUtils;
import adalid.util.Utility;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/**
 * @author Jorge Campins
 */
public class FileDownloader extends Utility {

    private static final Logger logger = Logger.getLogger(FileDownloader.class);

    private static final File UD, PD, WS;

    private static final String VN;

    static {
        UD = new File(System.getProperty("user.dir"));
        PD = UD.getParentFile();
        WS = PD == null ? UD : PD;
        VN = getAdalidProjectVersion();
        logAdalidProjectVersion();
    }

    private static final String[] DROPBOX_LINKS = new String[]{
        "https://www.dropbox.com/s/a2bdi7uxvm4rpmn/adalid-" + VN + ".zip?dl=1",
        "https://www.dropbox.com/s/ghcx2rmusurndwi/third-party-" + VN + ".zip?dl=1",
        "https://www.dropbox.com/s/swjoz4rcjsn03la/workspace?dl=1"
    };

    public static void main(String[] args) {
        download();
    }

    public static void download() {
        for (String spec : DROPBOX_LINKS) {
            downloadDropboxFile(spec);
        }
    }

    private static void downloadDropboxFile(String spec) {
//      info("downloading file {0}", spec);
        String file = StringUtils.substringBefore(StringUtils.substringAfterLast(spec, "/"), "?dl=1");
        downloadDropboxFile(spec, file);
    }

    private static void downloadDropboxFile(String spec, String file) {
//      info("downloading file {0} to {1}", spec, file);
        try {
            URL source = new URL(spec);
            File target = new File(WS, file);
            downloadDropboxFile(source, target);
        } catch (MalformedURLException ex) {
            logger.fatal(ThrowableUtils.getString(ex), ex);
        }
    }

    private static void downloadDropboxFile(URL source, File target) {
//      info("downloading file {0} to {1}", source, target);
        info("downloading file {0} to {1}", target.getName(), target.getParent());
        try {
            FileUtils.copyURLToFile(source, target);
        } catch (IOException ex) {
            logger.fatal(ThrowableUtils.getString(ex), ex);
        }
    }

    private static void info(String pattern, Object... arguments) {
        logger.info(MessageFormat.format(pattern, arguments));
    }

}
