/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ProcessOperation;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.EntityWarnings;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.QueryMapping;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.control.acceso.Usuario;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.TRUE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bpl = Kleenean.FALSE, bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, onload = SelectOnloadOption.EXECUTE, sortOption = SortOption.DESC)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
@EntityWarnings(enabled = Kleenean.TRUE)
public class ArchivoAdjunto extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private ArchivoAdjunto() {
        this(null, null);
    }

    public ArchivoAdjunto(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of ArchivoAdjunto's attributes">
        setLocalizedLabel(ENGLISH, "attached file");
        setLocalizedLabel(SPANISH, "archivo adjunto");
        setLocalizedShortLabel(ENGLISH, "attachment");
        setLocalizedShortLabel(SPANISH, "adjunto");
        setLocalizedCollectionLabel(ENGLISH, "Attached Files");
        setLocalizedCollectionLabel(SPANISH, "Archivos Adjuntos");
        setLocalizedCollectionShortLabel(ENGLISH, "Attachments");
        setLocalizedCollectionShortLabel(SPANISH, "Adjuntos");
        setLocalizedDescription(ENGLISH, "audit trail of the execution of file upload operations on the server");
        setLocalizedDescription(SPANISH, "rastro de auditoría de la ejecución de operaciones de carga de archivos en el servidor");
        // </editor-fold>
    }

    @PrimaryKey
    public LongProperty id;

//  @BusinessKey
    @FileReference(loadField = "fechaHoraCarga")
    @ColumnField(nullable = Kleenean.FALSE, unique = Kleenean.TRUE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE)
    @StringField(maxLength = 200)
    public StringProperty archivoServidor;

    @NameProperty
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    @StringField(maxLength = 200)
    public StringProperty archivoCliente;

    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    @QueryMapping(mapKeyProperties = Kleenean.FALSE)
    public Usuario propietario;

    @PropertyField(table = Kleenean.TRUE, search = Kleenean.TRUE, report = Kleenean.TRUE)
    @StringField(maxLength = 30)
    public StringProperty codigoUsuarioPropietario;

    @PropertyField(table = Kleenean.FALSE, search = Kleenean.TRUE, report = Kleenean.TRUE)
    @StringField(maxLength = 100)
    public StringProperty nombreUsuarioPropietario;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE, search = Kleenean.TRUE)
    public TimestampProperty fechaHoraCarga;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public StringProperty tipoContenido;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE, search = Kleenean.FALSE)
    public LongProperty longitud;

//  @ColumnField(nullable = Kleenean.FALSE)
    public BinaryProperty octetos;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE, search = Kleenean.TRUE)
    public BooleanProperty restaurable;

    /**
     * BLOB property getter (for velocity templates)
     *
     * @return the BLOB property
     */
    public BinaryProperty getBlobProperty() {
        return octetos;
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        propietario.setInitialValue(SpecialEntityValue.CURRENT_USER);
        propietario.setDefaultValue(SpecialEntityValue.CURRENT_USER);
        fechaHoraCarga.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        fechaHoraCarga.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        restaurable.setInitialValue(false);
        restaurable.setDefaultValue(false);
        // <editor-fold defaultstate="collapsed" desc="localization of ArchivoAdjunto's properties">
        archivoServidor.setLocalizedLabel(ENGLISH, "attached file's server file name");
        archivoServidor.setLocalizedLabel(SPANISH, "archivo servidor del archivo adjunto");
        archivoServidor.setLocalizedShortLabel(ENGLISH, "server file");
        archivoServidor.setLocalizedShortLabel(SPANISH, "archivo servidor");
        archivoServidor.setLocalizedTooltip(ENGLISH, "open the attached file");
        archivoServidor.setLocalizedTooltip(SPANISH, "abrir el archivo adjunto");
        /**/
        archivoCliente.setLocalizedLabel(ENGLISH, "attached file's client file name");
        archivoCliente.setLocalizedLabel(SPANISH, "archivo cliente del archivo adjunto");
        archivoCliente.setLocalizedShortLabel(ENGLISH, "client file");
        archivoCliente.setLocalizedShortLabel(SPANISH, "archivo cliente");
        /**/
        propietario.setLocalizedLabel(ENGLISH, "attached file's owner");
        propietario.setLocalizedLabel(SPANISH, "propietario del archivo adjunto");
        propietario.setLocalizedShortLabel(ENGLISH, "owner");
        propietario.setLocalizedShortLabel(SPANISH, "propietario");
        /**/
        codigoUsuarioPropietario.setLocalizedLabel(ENGLISH, "owner");
        codigoUsuarioPropietario.setLocalizedLabel(SPANISH, "propietario");
        /**/
        nombreUsuarioPropietario.setLocalizedLabel(ENGLISH, "owner name");
        nombreUsuarioPropietario.setLocalizedLabel(SPANISH, "nombre del propietario");
        /**/
        fechaHoraCarga.setLocalizedLabel(ENGLISH, "upload timestamp");
        fechaHoraCarga.setLocalizedLabel(SPANISH, "fecha hora carga");
        /**/
        tipoContenido.setLocalizedLabel(ENGLISH, "content type");
        tipoContenido.setLocalizedLabel(SPANISH, "tipo contenido");
        /**/
        longitud.setLocalizedLabel(ENGLISH, "length");
        longitud.setLocalizedLabel(SPANISH, "longitud");
        /**/
        octetos.setLocalizedLabel(ENGLISH, "bytes");
        octetos.setLocalizedLabel(SPANISH, "octetos");
        /**/
        restaurable.setLocalizedLabel(ENGLISH, "restorable");
        restaurable.setLocalizedLabel(SPANISH, "restaurable");
        // </editor-fold>
    }

    protected EliminarArchivoServidorWeb eliminarArchivoServidorWeb;

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class EliminarArchivoServidorWeb extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EliminarArchivoServidorWeb's attributes">
            setLocalizedLabel(ENGLISH, "delete the file from the web server");
            setLocalizedLabel(SPANISH, "eliminar el archivo del servidor web");
            setLocalizedDescription(ENGLISH, "delete the file only from the web server; the file will remain stored in the database");
            setLocalizedDescription(SPANISH, "elimina el archivo solo del servidor web; el archivo quedará almacenado en la base de datos");
            // </editor-fold>
        }

        @InstanceReference
        protected ArchivoAdjunto archivoAdjunto;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of EliminarArchivoServidorWeb's parameters">
            archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
            // </editor-fold>
        }

    }

    protected RestaurarArchivoServidorWeb restaurarArchivoServidorWeb;

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class RestaurarArchivoServidorWeb extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of RestaurarArchivoServidorWeb's attributes">
            setLocalizedLabel(ENGLISH, "restore the file on the web server");
            setLocalizedLabel(SPANISH, "restaurar el archivo del servidor web");
            setLocalizedDescription(ENGLISH, "restore the file on the web server using the file stored in the database");
            setLocalizedDescription(SPANISH, "restaura el archivo del servidor web con el contenido del archivo almacenado en la base de datos");
            // </editor-fold>
        }

        @InstanceReference
        protected ArchivoAdjunto archivoAdjunto;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of RestaurarArchivoServidorWeb's parameters">
            archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
            // </editor-fold>
        }

        protected Check check101;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            check101 = archivoAdjunto.restaurable.isTrue();
            // <editor-fold defaultstate="collapsed" desc="localization of RestaurarArchivoServidorWeb's expressions">
            check101.setLocalizedDescription(ENGLISH, "the file is restorable");
            check101.setLocalizedDescription(SPANISH, "el archivo es restaurable");
            check101.setLocalizedErrorMessage(ENGLISH, "the file is not restorable");
            check101.setLocalizedErrorMessage(SPANISH, "el archivo no es restaurable");
            // </editor-fold>
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            archivoAdjunto.setSearchQueryFilter(check101);
        }

    }

    protected EliminarTotalmente eliminarTotalmente;

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class EliminarTotalmente extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EliminarTotalmente's attributes">
            setLocalizedLabel(ENGLISH, "completely delete the file");
            setLocalizedLabel(SPANISH, "eliminar totalmente el archivo");
            setLocalizedDescription(ENGLISH, "delete the file from both the web server and the database");
            setLocalizedDescription(SPANISH, "elimina el archivo tanto del servidor web como de la base de datos");
            // </editor-fold>
        }

        @InstanceReference
        protected ArchivoAdjunto archivoAdjunto;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            archivoAdjunto.restaurable.setCurrentValue(false);
            // <editor-fold defaultstate="collapsed" desc="localization of EliminarTotalmente's parameters">
            archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
            // </editor-fold>
        }

    }

}
