/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ExportOperation;
import adalid.core.ReportOperation;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.EntityWarnings;
import adalid.core.annotations.ExportOperationClass;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.QueryMapping;
import adalid.core.annotations.ReportOperationClass;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.StandardRelationalOp;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.interfaces.Artifact;
import adalid.core.parameters.StringParameter;
import adalid.core.parameters.TimestampParameter;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.CondicionEjeFun;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.control.acceso.Usuario;
import meta.entidad.comun.operacion.basica.RecursoValor;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.TRUE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, onload = SelectOnloadOption.EXECUTE, sortOption = SortOption.DESC)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.TRUE)
@EntityWarnings(enabled = Kleenean.FALSE)
@EntityTriggers(afterValue = Kleenean.TRUE)
public class RastroFuncion extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private RastroFuncion() {
        this(null, null);
    }

    public RastroFuncion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE, heading = Kleenean.TRUE, search = Kleenean.TRUE)
    public TimestampProperty fechaHoraEjecucion;

    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    @QueryMapping(mapKeyProperties = Kleenean.FALSE)
    public Usuario usuario;

    @PropertyField(table = Kleenean.TRUE, search = Kleenean.TRUE, report = Kleenean.TRUE, heading = Kleenean.TRUE)
    @StringField(maxLength = 30)
    public StringProperty codigoUsuario;

    @PropertyField(table = Kleenean.FALSE, search = Kleenean.TRUE, report = Kleenean.TRUE, heading = Kleenean.TRUE)
    @StringField(maxLength = 100)
    public StringProperty nombreUsuario;

//  20171213: remove foreign-key referring to Funcion
//  @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(hidden = Kleenean.TRUE)
    @QueryMapping(mapKeyProperties = Kleenean.FALSE)
    public Funcion funcion;

    @PropertyField(table = Kleenean.TRUE, search = Kleenean.TRUE, report = Kleenean.TRUE, heading = Kleenean.TRUE)
    @StringField(maxLength = 200)
    public StringProperty codigoFuncion;

    @PropertyField(table = Kleenean.FALSE, search = Kleenean.TRUE, report = Kleenean.TRUE, heading = Kleenean.TRUE)
    @StringField(maxLength = 200)
    public StringProperty nombreFuncion;

    @UniformResourceLocator(urlType = UrlType.INTERNAL, urlDisplayType = UrlDisplayType.BUTTON)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE, search = Kleenean.FALSE, headertextless = Kleenean.TRUE)
    public StringProperty paginaFuncion;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idClaseRecursoValor;

    @ColumnField(nullable = Kleenean.TRUE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    public RecursoValor recursoValor;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idRecurso;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty versionRecurso;

    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE, search = Kleenean.TRUE)
    public StringProperty codigoRecurso;

    @PropertyField(table = Kleenean.FALSE, report = Kleenean.TRUE, search = Kleenean.TRUE)
    public StringProperty nombreRecurso;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idPropietarioRecurso;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idSegmentoRecurso;

    @UniformResourceLocator(urlType = UrlType.INTERNAL, urlDisplayType = UrlDisplayType.BUTTON)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE, search = Kleenean.FALSE, headertextless = Kleenean.TRUE)
    public StringProperty paginaRecurso;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public CondicionEjeFun condicionEjeFun;

//  @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public StringProperty descripcionError;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of RastroFuncion's attributes">
        setLocalizedLabel(ENGLISH, "function trail");
        setLocalizedLabel(SPANISH, "rastro de función");
        setLocalizedShortLabel(ENGLISH, "function trail");
        setLocalizedShortLabel(SPANISH, "rastro");
        setLocalizedCollectionLabel(ENGLISH, "Function Trails");
        setLocalizedCollectionLabel(SPANISH, "Rastros de Función");
        setLocalizedCollectionShortLabel(ENGLISH, "Function Trails");
        setLocalizedCollectionShortLabel(SPANISH, "Rastros");
        setLocalizedDescription(ENGLISH, "audit trail of the execution of registration operations and business processes");
        setLocalizedDescription(SPANISH, "rastro de auditoría de la ejecución de operaciones de registro y procesos de negocio");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        fechaHoraEjecucion.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        fechaHoraEjecucion.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        condicionEjeFun.setInitialValue(condicionEjeFun.EJECUTADO_SIN_ERRORES);
        condicionEjeFun.setDefaultValue(condicionEjeFun.EJECUTADO_SIN_ERRORES);
        // <editor-fold defaultstate="collapsed" desc="localization of RastroFuncion's properties">
        fechaHoraEjecucion.setLocalizedLabel(ENGLISH, "timestamp");
        fechaHoraEjecucion.setLocalizedLabel(SPANISH, "fecha y hora");
        /**/
        usuario.setLocalizedLabel(ENGLISH, "user");
        usuario.setLocalizedLabel(SPANISH, "usuario");
        /**/
        codigoUsuario.setLocalizedLabel(ENGLISH, "user");
        codigoUsuario.setLocalizedLabel(SPANISH, "usuario");
        /**/
        nombreUsuario.setLocalizedLabel(ENGLISH, "user name");
        nombreUsuario.setLocalizedLabel(SPANISH, "nombre del usuario");
        /**/
        funcion.setLocalizedLabel(ENGLISH, "function");
        funcion.setLocalizedLabel(SPANISH, "función");
        /**/
        codigoFuncion.setLocalizedLabel(ENGLISH, "function");
        codigoFuncion.setLocalizedLabel(SPANISH, "función");
        /**/
        nombreFuncion.setLocalizedLabel(ENGLISH, "function name");
        nombreFuncion.setLocalizedLabel(SPANISH, "nombre de la función");
        /**/
        paginaFuncion.setLocalizedLabel(ENGLISH, "function page");
        paginaFuncion.setLocalizedLabel(SPANISH, "página de la función");
        paginaFuncion.setLocalizedTooltip(ENGLISH, "open the function's processing page");
        paginaFuncion.setLocalizedTooltip(SPANISH, "abrir la página de procesamiento de la función");
        /**/
        idClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        idClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        /**/
        recursoValor.setLocalizedLabel(ENGLISH, "resource");
        recursoValor.setLocalizedLabel(SPANISH, "recurso");
        /**/
        idRecurso.setLocalizedLabel(ENGLISH, "resource");
        idRecurso.setLocalizedLabel(SPANISH, "recurso");
        /**/
        versionRecurso.setLocalizedLabel(ENGLISH, "resource version");
        versionRecurso.setLocalizedLabel(SPANISH, "versión del recurso");
        /**/
        codigoRecurso.setLocalizedLabel(ENGLISH, "resource");
        codigoRecurso.setLocalizedLabel(SPANISH, "recurso");
        /**/
        nombreRecurso.setLocalizedLabel(ENGLISH, "resource name");
        nombreRecurso.setLocalizedLabel(SPANISH, "nombre del recurso");
        /**/
        idPropietarioRecurso.setLocalizedLabel(ENGLISH, "resource owner");
        idPropietarioRecurso.setLocalizedLabel(SPANISH, "propietario del recurso");
        /**/
        idSegmentoRecurso.setLocalizedLabel(ENGLISH, "resource segment");
        idSegmentoRecurso.setLocalizedLabel(SPANISH, "segmento del recurso");
        /**/
        paginaRecurso.setLocalizedLabel(ENGLISH, "resource page");
        paginaRecurso.setLocalizedLabel(SPANISH, "página del recurso");
        paginaRecurso.setLocalizedTooltip(ENGLISH, "open the resource's registration page");
        paginaRecurso.setLocalizedTooltip(SPANISH, "abrir la página de registro del recurso");
        /**/
        condicionEjeFun.setLocalizedLabel(ENGLISH, "function execution condition");
        condicionEjeFun.setLocalizedLabel(SPANISH, "condición de ejecución de función");
        condicionEjeFun.setLocalizedShortLabel(ENGLISH, "condition");
        condicionEjeFun.setLocalizedShortLabel(SPANISH, "condición");
        /**/
        descripcionError.setLocalizedLabel(ENGLISH, "message");
        descripcionError.setLocalizedLabel(SPANISH, "mensaje");
        // </editor-fold>
    }

    protected View rastros;

    @Override
    protected void settleViews() {
        super.settleViews();
        ViewField vf;
        /**/
        rastros.newControlField(codigoUsuario);
        /**/
        rastros.newHeadingField(nombreUsuario, codigoUsuario);
        /**/
        vf = rastros.newDetailField(fechaHoraEjecucion, SortOption.ASC);
        vf.setPixels(125);
        /**/
        vf = rastros.newDetailField(codigoFuncion);
        vf.setPixels(125);
        /**/
        vf = rastros.newDetailField(nombreFuncion);
        vf.setPixels(225);
        /**/
        vf = rastros.newDetailField(codigoRecurso);
        vf.setPixels(125);
        /**/
        vf = rastros.newDetailField(nombreRecurso);
        vf.setPixels(225);
        /**/
        vf = rastros.newDetailField(condicionEjeFun.codigo);
        vf.setPixels(105);
        // <editor-fold defaultstate="collapsed" desc="localization of RastroFuncion's views">
        rastros.setLocalizedLabel(ENGLISH, "Function Trails");
        rastros.setLocalizedLabel(SPANISH, "Rastros de Función");
        ViewField vf001 = rastros.getField(codigoUsuario);
        if (vf001 != null) {
            vf001.setLocalizedLabel(ENGLISH, "user");
            vf001.setLocalizedLabel(SPANISH, "usuario");
        }
        ViewField vf002 = rastros.getField(nombreUsuario);
        if (vf002 != null) {
            vf002.setLocalizedLabel(ENGLISH, "user name");
            vf002.setLocalizedLabel(SPANISH, "nombre del usuario");
        }
        ViewField vf003 = rastros.getField(fechaHoraEjecucion);
        if (vf003 != null) {
            vf003.setLocalizedLabel(ENGLISH, "timestamp");
            vf003.setLocalizedLabel(SPANISH, "fecha/hora");
        }
        ViewField vf004 = rastros.getField(codigoFuncion);
        if (vf004 != null) {
            vf004.setLocalizedLabel(ENGLISH, "function");
            vf004.setLocalizedLabel(SPANISH, "función");
        }
        ViewField vf005 = rastros.getField(nombreFuncion);
        if (vf005 != null) {
            vf005.setLocalizedLabel(ENGLISH, "function name");
            vf005.setLocalizedLabel(SPANISH, "nombre de la función");
        }
        ViewField vf006 = rastros.getField(codigoRecurso);
        if (vf006 != null) {
            vf006.setLocalizedLabel(ENGLISH, "resource");
            vf006.setLocalizedLabel(SPANISH, "recurso");
        }
        ViewField vf007 = rastros.getField(nombreRecurso);
        if (vf007 != null) {
            vf007.setLocalizedLabel(ENGLISH, "resource name");
            vf007.setLocalizedLabel(SPANISH, "nombre del recurso");
        }
        ViewField vf008 = rastros.getField(condicionEjeFun.codigo);
        if (vf008 != null) {
            vf008.setLocalizedLabel(ENGLISH, "condition");
            vf008.setLocalizedLabel(SPANISH, "condición");
        }
        // </editor-fold>
    }

    protected ExportarArchivoRastros archivoRastros;

    @ExportOperationClass(viewField = "rastros")
    @OperationClass(access = OperationAccess.RESTRICTED)
    public class ExportarArchivoRastros extends ExportOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of ExportarArchivoRastros's attributes">
//          setLocalizedCollectionLabel(ENGLISH, "Function Trails File");
//          setLocalizedCollectionLabel(SPANISH, "Archivo de Rastros de Función");
            setLocalizedLabel(ENGLISH, "generate function trails file");
            setLocalizedLabel(SPANISH, "generar archivo de rastros");
            // </editor-fold>
        }

        @ParameterField(linkedField = "fechaHoraEjecucion", operator = StandardRelationalOp.GTEQ)
        protected TimestampParameter desde;

        @ParameterField(linkedField = "fechaHoraEjecucion", operator = StandardRelationalOp.LTEQ)
        protected TimestampParameter hasta;

        @ParameterField(linkedField = "usuario")
        protected Usuario usuario;

        @ParameterField(linkedField = "funcion")
        protected Funcion funcion;

        @ParameterField(linkedField = "codigoRecurso")
        protected StringParameter codigoRecurso;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of ExportarArchivoRastros's parameters">
            desde.setLocalizedLabel(ENGLISH, "from");
            desde.setLocalizedLabel(SPANISH, "desde");
            /**/
            hasta.setLocalizedLabel(ENGLISH, "to");
            hasta.setLocalizedLabel(SPANISH, "hasta");
            /**/
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            /**/
            funcion.setLocalizedLabel(ENGLISH, "function");
            funcion.setLocalizedLabel(SPANISH, "función");
            /**/
            codigoRecurso.setLocalizedLabel(ENGLISH, "resource code");
            codigoRecurso.setLocalizedLabel(SPANISH, "código del recurso");
            // </editor-fold>
        }

    }

    protected EmitirInformeRastros informeRastros;

    @ReportOperationClass(viewField = "rastros")
    @OperationClass(access = OperationAccess.RESTRICTED)
    public class EmitirInformeRastros extends ReportOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformeRastros's attributes">
//          setLocalizedCollectionLabel(ENGLISH, "Function Trails Report");
//          setLocalizedCollectionLabel(SPANISH, "Informe de Rastros de Función");
            setLocalizedLabel(ENGLISH, "generate function trails report");
            setLocalizedLabel(SPANISH, "generar informe de rastros");
            // </editor-fold>
        }

        @ParameterField(linkedField = "fechaHoraEjecucion", operator = StandardRelationalOp.GTEQ)
        protected TimestampParameter desde;

        @ParameterField(linkedField = "fechaHoraEjecucion", operator = StandardRelationalOp.LTEQ)
        protected TimestampParameter hasta;

        @ParameterField(linkedField = "usuario")
        protected Usuario usuario;

        @ParameterField(linkedField = "funcion")
        protected Funcion funcion;

        @ParameterField(linkedField = "codigoRecurso")
        protected StringParameter codigoRecurso;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformeRastros's parameters">
            desde.setLocalizedLabel(ENGLISH, "from");
            desde.setLocalizedLabel(SPANISH, "desde");
            /**/
            hasta.setLocalizedLabel(ENGLISH, "to");
            hasta.setLocalizedLabel(SPANISH, "hasta");
            /**/
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            /**/
            funcion.setLocalizedLabel(ENGLISH, "function");
            funcion.setLocalizedLabel(SPANISH, "función");
            /**/
            codigoRecurso.setLocalizedLabel(ENGLISH, "resource code");
            codigoRecurso.setLocalizedLabel(SPANISH, "código del recurso");
            // </editor-fold>
        }

    }

}
