/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ExportOperation;
import adalid.core.ReportOperation;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ExportOperationClass;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.ReportOperationClass;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SortOption;
import adalid.core.enums.StandardRelationalOp;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.interfaces.Artifact;
import adalid.core.parameters.BooleanParameter;
import adalid.core.parameters.StringParameter;
import adalid.core.parameters.TimestampParameter;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.configuracion.basica.Parametro;
import meta.entidad.comun.control.acceso.Usuario;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.FALSE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PROTECTED)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.TRUE)
@EntityTriggers(afterValue = Kleenean.TRUE)
public class RastroFuncionPar extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private RastroFuncionPar() {
        this(null, null);
    }

    public RastroFuncionPar(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @ForeignKey(onDelete = OnDeleteAction.CASCADE, onUpdate = OnUpdateAction.CASCADE)
    @ManyToOne(navigability = Navigability.BIDIRECTIONAL, view = MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    @Allocation(maxDepth = 2, maxRound = 0)
    public RastroFuncion rastroFuncion;

//  20171213: remove foreign-key referring to Parametro
//  @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public Parametro parametro;

    @StringField(maxLength = 200)
    public StringProperty codigoParametro;

    @StringField(maxLength = 200)
    public StringProperty nombreParametro;

    @PropertyField(table = Kleenean.FALSE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty valorParametro;

    @PropertyField(table = Kleenean.FALSE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty codigoRecursoParametro;

    @PropertyField(table = Kleenean.FALSE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty nombreRecursoParametro;

    /*
    @ColumnField(calculable = Kleenean.TRUE)
    @PropertyField(table = Kleenean.TRUE, detail = Kleenean.FALSE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty sintesisValorParametro;
    **/
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty valorAparenteParametro;

    @PropertyField(table = Kleenean.FALSE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty valorAnterior;

    @PropertyField(table = Kleenean.FALSE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty codigoRecursoAnterior;

    @PropertyField(table = Kleenean.FALSE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty nombreRecursoAnterior;

    /*
    @ColumnField(calculable = Kleenean.TRUE)
    @PropertyField(table = Kleenean.TRUE, detail = Kleenean.FALSE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty sintesisValorAnterior;
    **/
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE, export = Kleenean.FALSE)
    public StringProperty valorAparenteAnterior;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public BooleanProperty diferenteValor;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idClaseRecursoValor;

    @UniformResourceLocator(urlType = UrlType.INTERNAL, urlDisplayType = UrlDisplayType.BUTTON)
//  @PropertyField(table = Kleenean.FALSE, detail = Kleenean.FALSE, report = Kleenean.FALSE, search = Kleenean.FALSE, headertextless = Kleenean.TRUE)
    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty paginaRecurso;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of RastroFuncionPar's attributes">
        setLocalizedLabel(ENGLISH, "function trail parameter");
        setLocalizedLabel(SPANISH, "rastro de parámetro de función");
        setLocalizedShortLabel(ENGLISH, "parameter");
        setLocalizedShortLabel(SPANISH, "parámetro");
        setLocalizedCollectionLabel(ENGLISH, "Function Trail Parameters");
        setLocalizedCollectionLabel(SPANISH, "Rastros de Parámetros de Función");
        setLocalizedCollectionShortLabel(ENGLISH, "Parameters");
        setLocalizedCollectionShortLabel(SPANISH, "Parámetros");
        setLocalizedDescription(ENGLISH, "audit trail of the parameters of the execution of registration operations and business processes");
        setLocalizedDescription(SPANISH, "rastro de auditoría de los parámetros de la ejecución de operaciones de registro y procesos de negocio");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /*
        sintesisValorAnterior.setCalculableValueExpression(XB.Character.DataAggregate.
            coalesce(nombreRecursoAnterior, codigoRecursoAnterior, valorAnterior));
        **/
 /*
        sintesisValorParametro.setCalculableValueExpression(XB.Character.DataAggregate.
            coalesce(nombreRecursoParametro, codigoRecursoParametro, valorParametro));
        **/
        diferenteValor.setInitialValue(false);
        diferenteValor.setDefaultValue(false);
        // <editor-fold defaultstate="collapsed" desc="localization of RastroFuncionPar's properties">
        rastroFuncion.setLocalizedLabel(ENGLISH, "function trail");
        rastroFuncion.setLocalizedLabel(SPANISH, "rastro de función");
        rastroFuncion.setLocalizedShortLabel(ENGLISH, "function trail");
        rastroFuncion.setLocalizedShortLabel(SPANISH, "rastro");
        /**/
        parametro.setLocalizedLabel(ENGLISH, "parameter");
        parametro.setLocalizedLabel(SPANISH, "parámetro");
        /**/
        codigoParametro.setLocalizedLabel(ENGLISH, "parameter code");
        codigoParametro.setLocalizedLabel(SPANISH, "código parámetro");
        /**/
        nombreParametro.setLocalizedLabel(ENGLISH, "parameter name");
        nombreParametro.setLocalizedLabel(SPANISH, "nombre parámetro");
        /**/
        valorParametro.setLocalizedLabel(ENGLISH, "value");
        valorParametro.setLocalizedLabel(SPANISH, "valor");
        /**/
        codigoRecursoParametro.setLocalizedLabel(ENGLISH, "code");
        codigoRecursoParametro.setLocalizedLabel(SPANISH, "código");
        /**/
        nombreRecursoParametro.setLocalizedLabel(ENGLISH, "name");
        nombreRecursoParametro.setLocalizedLabel(SPANISH, "nombre");
        /**/
        valorAparenteParametro.setLocalizedLabel(ENGLISH, "value+");
        valorAparenteParametro.setLocalizedLabel(SPANISH, "valor+");
        /**/
        valorAnterior.setLocalizedLabel(ENGLISH, "previous value");
        valorAnterior.setLocalizedLabel(SPANISH, "valor anterior");
        /**/
        codigoRecursoAnterior.setLocalizedLabel(ENGLISH, "previous value code");
        codigoRecursoAnterior.setLocalizedLabel(SPANISH, "código anterior");
        /**/
        nombreRecursoAnterior.setLocalizedLabel(ENGLISH, "previous value name");
        nombreRecursoAnterior.setLocalizedLabel(SPANISH, "nombre anterior");
        /**/
        valorAparenteAnterior.setLocalizedLabel(ENGLISH, "previous value+");
        valorAparenteAnterior.setLocalizedLabel(SPANISH, "valor anterior+");
        /**/
        diferenteValor.setLocalizedLabel(ENGLISH, "different");
        diferenteValor.setLocalizedLabel(SPANISH, "diferente");
        diferenteValor.setLocalizedTooltip(ENGLISH, "indication of whether the value is, or not, different from the previous value");
        diferenteValor.setLocalizedTooltip(SPANISH, "indicación de si el valor es, o no, diferente al valor anterior");
        /**/
        idClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        idClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        /**/
        paginaRecurso.setLocalizedLabel(ENGLISH, "detail");
        paginaRecurso.setLocalizedLabel(SPANISH, "detalle");
        paginaRecurso.setLocalizedTooltip(ENGLISH, "open the resource's detailed query page");
        paginaRecurso.setLocalizedTooltip(SPANISH, "abrir la página de consulta detallada del recurso");
        // </editor-fold>
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        linkForeignOwnerProperty(rastroFuncion.usuario);
        linkForeignSegmentProperty(rastroFuncion.usuario);
        linkForeignQueryProperty(rastroFuncion.fechaHoraEjecucion);
        linkForeignQueryProperty(rastroFuncion.funcion);
        linkForeignQueryProperty(rastroFuncion.codigoFuncion);
        linkForeignQueryProperty(rastroFuncion.nombreFuncion);
        linkForeignQueryProperty(rastroFuncion.codigoRecurso);
        linkForeignQueryProperty(rastroFuncion.nombreRecurso);
    }

    protected View rastrosConParametros;

    @Override
    protected void settleViews() {
        super.settleViews();
        ViewField vf;
        /**/
        rastrosConParametros.newControlField(rastroFuncion);
        /**/
        rastrosConParametros.newHeadingField(rastroFuncion.fechaHoraEjecucion, rastroFuncion);
        /**/
        rastrosConParametros.newHeadingField(rastroFuncion.codigoUsuario, rastroFuncion);
        /**/
        rastrosConParametros.newHeadingField(rastroFuncion.nombreUsuario, rastroFuncion);
        /**/
        rastrosConParametros.newHeadingField(rastroFuncion.codigoFuncion, rastroFuncion);
        /**/
        rastrosConParametros.newHeadingField(rastroFuncion.nombreFuncion, rastroFuncion);
        /**/
        rastrosConParametros.newHeadingField(rastroFuncion.codigoRecurso, rastroFuncion);
        /**/
        rastrosConParametros.newHeadingField(rastroFuncion.nombreRecurso, rastroFuncion);
        /**/
        rastrosConParametros.newHeadingField(rastroFuncion.condicionEjeFun.codigo, rastroFuncion);
        /**/
        vf = rastrosConParametros.newDetailField(id, SortOption.ASC);
        vf.setPixels(0);
        /**/
        vf = rastrosConParametros.newDetailField(parametro.nombreParametro);
        vf.setPixels(240);
        /**/
        vf = rastrosConParametros.newDetailField(valorAparenteParametro);
        vf.setPixels(320);
        /**/
        vf = rastrosConParametros.newDetailField(valorAparenteAnterior);
        vf.setPixels(320);
        /**/
        rastrosConParametros.newDetailField(diferenteValor);
        // <editor-fold defaultstate="collapsed" desc="localization of RastroFuncionPar's views">
        rastrosConParametros.setLocalizedLabel(ENGLISH, "Function Trail Parameters");
        rastrosConParametros.setLocalizedLabel(SPANISH, "Rastros de Parámetros de Función");
        ViewField vf001 = rastrosConParametros.getField(rastroFuncion);
        if (vf001 != null) {
            vf001.setLocalizedLabel(ENGLISH, "function trail");
            vf001.setLocalizedLabel(SPANISH, "rastro de función");
        }
        ViewField vf002 = rastrosConParametros.getField(rastroFuncion.fechaHoraEjecucion);
        if (vf002 != null) {
            vf002.setLocalizedLabel(ENGLISH, "timestamp");
            vf002.setLocalizedLabel(SPANISH, "fecha/hora");
        }
        ViewField vf003 = rastrosConParametros.getField(rastroFuncion.codigoUsuario);
        if (vf003 != null) {
            vf003.setLocalizedLabel(ENGLISH, "user");
            vf003.setLocalizedLabel(SPANISH, "usuario");
        }
        ViewField vf004 = rastrosConParametros.getField(rastroFuncion.nombreUsuario);
        if (vf004 != null) {
            vf004.setLocalizedLabel(ENGLISH, "user name");
            vf004.setLocalizedLabel(SPANISH, "nombre del usuario");
        }
        ViewField vf005 = rastrosConParametros.getField(rastroFuncion.codigoFuncion);
        if (vf005 != null) {
            vf005.setLocalizedLabel(ENGLISH, "function");
            vf005.setLocalizedLabel(SPANISH, "función");
        }
        ViewField vf006 = rastrosConParametros.getField(rastroFuncion.nombreFuncion);
        if (vf006 != null) {
            vf006.setLocalizedLabel(ENGLISH, "function name");
            vf006.setLocalizedLabel(SPANISH, "nombre de la función");
        }
        ViewField vf007 = rastrosConParametros.getField(rastroFuncion.codigoRecurso);
        if (vf007 != null) {
            vf007.setLocalizedLabel(ENGLISH, "resource");
            vf007.setLocalizedLabel(SPANISH, "recurso");
        }
        ViewField vf008 = rastrosConParametros.getField(rastroFuncion.nombreRecurso);
        if (vf008 != null) {
            vf008.setLocalizedLabel(ENGLISH, "resource name");
            vf008.setLocalizedLabel(SPANISH, "nombre del recurso");
        }
        ViewField vf009 = rastrosConParametros.getField(rastroFuncion.condicionEjeFun.codigo);
        if (vf009 != null) {
            vf009.setLocalizedLabel(ENGLISH, "condition");
            vf009.setLocalizedLabel(SPANISH, "condición");
        }
        ViewField vf010 = rastrosConParametros.getField(id);
        if (vf010 != null) {
            vf010.setLocalizedLabel(ENGLISH, "trail");
            vf010.setLocalizedLabel(SPANISH, "rastro");
        }
        ViewField vf011 = rastrosConParametros.getField(parametro.nombreParametro);
        if (vf011 != null) {
            vf011.setLocalizedLabel(ENGLISH, "parameter");
            vf011.setLocalizedLabel(SPANISH, "parámetro");
        }
        ViewField vf012 = rastrosConParametros.getField(valorAparenteParametro);
        if (vf012 != null) {
            vf012.setLocalizedLabel(ENGLISH, "value");
            vf012.setLocalizedLabel(SPANISH, "valor");
        }
        ViewField vf013 = rastrosConParametros.getField(valorAparenteAnterior);
        if (vf013 != null) {
            vf013.setLocalizedLabel(ENGLISH, "previous value");
            vf013.setLocalizedLabel(SPANISH, "valor anterior");
        }
        ViewField vf014 = rastrosConParametros.getField(diferenteValor);
        if (vf014 != null) {
            vf014.setLocalizedLabel(ENGLISH, "different");
            vf014.setLocalizedLabel(SPANISH, "diferente");
        }
        // </editor-fold>
    }

    protected ExportarArchivoRastrosConParametros archivoRastrosConParametros;

    @ExportOperationClass(viewField = "rastrosConParametros")
    @OperationClass(access = OperationAccess.PROTECTED)
    public class ExportarArchivoRastrosConParametros extends ExportOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of ExportarArchivoRastrosConParametros's attributes">
//          setLocalizedCollectionLabel(ENGLISH, "Function Trail Parameters File");
//          setLocalizedCollectionLabel(SPANISH, "Archivo de Rastros de Parámetros de Función");
            setLocalizedLabel(ENGLISH, "generate function trail parameters file");
            setLocalizedLabel(SPANISH, "generar archivo de rastros con parámetros");
            // </editor-fold>
        }

        @ParameterField(linkedColumn = "fecha_hora_ejecucion_1", operator = StandardRelationalOp.GTEQ)
        protected TimestampParameter desde;

        @ParameterField(linkedColumn = "fecha_hora_ejecucion_1", operator = StandardRelationalOp.LTEQ)
        protected TimestampParameter hasta;

        @ParameterField(linkedColumn = "usuario_1")
        protected Usuario usuario;

        @ParameterField(linkedColumn = "funcion_1")
        protected Funcion funcion;

        @ParameterField(linkedColumn = "codigo_recurso_1")
        protected StringParameter codigoRecurso;

        @ParameterField(linkedField = "diferenteValor")
        protected BooleanParameter diferente;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of ExportarArchivoRastrosConParametros's parameters">
            desde.setLocalizedLabel(ENGLISH, "fron");
            desde.setLocalizedLabel(SPANISH, "desde");
            /**/
            hasta.setLocalizedLabel(ENGLISH, "to");
            hasta.setLocalizedLabel(SPANISH, "hasta");
            /**/
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            /**/
            funcion.setLocalizedLabel(ENGLISH, "function");
            funcion.setLocalizedLabel(SPANISH, "función");
            /**/
            codigoRecurso.setLocalizedLabel(ENGLISH, "resource code");
            codigoRecurso.setLocalizedLabel(SPANISH, "código del recurso");
            /**/
            diferente.setLocalizedLabel(ENGLISH, "different");
            diferente.setLocalizedLabel(SPANISH, "diferente");
            // </editor-fold>
        }

    }

    protected EmitirInformeRastrosConParametros informeRastrosConParametros;

    @ReportOperationClass(viewField = "rastrosConParametros")
    @OperationClass(access = OperationAccess.PROTECTED)
    public class EmitirInformeRastrosConParametros extends ReportOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformeRastrosConParametros's attributes">
//          setLocalizedCollectionLabel(ENGLISH, "Function Trail Parameters Report");
//          setLocalizedCollectionLabel(SPANISH, "Informe de Rastros de Parámetros de Función");
            setLocalizedLabel(ENGLISH, "generate function trail parameters report");
            setLocalizedLabel(SPANISH, "generar informe de rastros con parámetros");
            // </editor-fold>
        }

        @ParameterField(linkedColumn = "fecha_hora_ejecucion_1", operator = StandardRelationalOp.GTEQ)
        protected TimestampParameter desde;

        @ParameterField(linkedColumn = "fecha_hora_ejecucion_1", operator = StandardRelationalOp.LTEQ)
        protected TimestampParameter hasta;

        @ParameterField(linkedColumn = "usuario_1")
        protected Usuario usuario;

        @ParameterField(linkedColumn = "funcion_1")
        protected Funcion funcion;

        @ParameterField(linkedColumn = "codigo_recurso_1")
        protected StringParameter codigoRecurso;

        @ParameterField(linkedField = "diferenteValor")
        protected BooleanParameter diferente;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformeRastrosConParametros's parameters">
            desde.setLocalizedLabel(ENGLISH, "from");
            desde.setLocalizedLabel(SPANISH, "desde");
            /**/
            hasta.setLocalizedLabel(ENGLISH, "to");
            hasta.setLocalizedLabel(SPANISH, "hasta");
            /**/
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            /**/
            funcion.setLocalizedLabel(ENGLISH, "function");
            funcion.setLocalizedLabel(SPANISH, "función");
            /**/
            codigoRecurso.setLocalizedLabel(ENGLISH, "resource code");
            codigoRecurso.setLocalizedLabel(SPANISH, "código del recurso");
            /**/
            diferente.setLocalizedLabel(ENGLISH, "different");
            diferente.setLocalizedLabel(SPANISH, "diferente");
            // </editor-fold>
        }

    }

}
