/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.Tab;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.QueryMapping;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.CondicionEjeFun;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.control.acceso.Usuario;
import meta.entidad.comun.operacion.basica.RecursoValor;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.TRUE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, onload = SelectOnloadOption.EXECUTE, sortOption = SortOption.DESC)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
@EntityTriggers(afterValue = Kleenean.TRUE)
public class RastroProceso extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private RastroProceso() {
        this(null, null);
    }

    public RastroProceso(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE, search = Kleenean.TRUE)
    public TimestampProperty fechaHoraInicioEjecucion;

    public TimestampProperty fechaHoraFinEjecucion;

    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    @QueryMapping(mapKeyProperties = Kleenean.FALSE)
    public Usuario usuario;

    @PropertyField(table = Kleenean.TRUE, search = Kleenean.TRUE, report = Kleenean.TRUE)
    @StringField(maxLength = 30)
    public StringProperty codigoUsuario;

    @PropertyField(table = Kleenean.FALSE, search = Kleenean.TRUE, report = Kleenean.TRUE)
    @StringField(maxLength = 100)
    public StringProperty nombreUsuario;

//  20171213: remove foreign-key referring to Funcion
//  @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(hidden = Kleenean.TRUE)
    @QueryMapping(mapKeyProperties = Kleenean.FALSE)
    public Funcion funcion;

    @PropertyField(table = Kleenean.TRUE, search = Kleenean.TRUE, report = Kleenean.TRUE)
    @StringField(maxLength = 200)
    public StringProperty codigoFuncion;

    @PropertyField(table = Kleenean.FALSE, search = Kleenean.TRUE, report = Kleenean.TRUE)
    @StringField(maxLength = 200)
    public StringProperty nombreFuncion;

    @UniformResourceLocator(urlType = UrlType.INTERNAL, urlDisplayType = UrlDisplayType.BUTTON)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE, search = Kleenean.FALSE, headertextless = Kleenean.TRUE)
    public StringProperty paginaFuncion;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idClaseRecursoValor;

    @ColumnField(nullable = Kleenean.TRUE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    public RecursoValor recursoValor;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idRecurso;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty versionRecurso;

    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE, search = Kleenean.TRUE)
    public StringProperty codigoRecurso;

    @PropertyField(table = Kleenean.FALSE, report = Kleenean.TRUE, search = Kleenean.TRUE)
    public StringProperty nombreRecurso;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idPropietarioRecurso;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idSegmentoRecurso;

    @UniformResourceLocator(urlType = UrlType.INTERNAL, urlDisplayType = UrlDisplayType.BUTTON)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE, search = Kleenean.FALSE, headertextless = Kleenean.TRUE)
    public StringProperty paginaRecurso;

    @StringField(maxLength = 20)
    public StringProperty etiquetaLenguaje;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public CondicionEjeFun condicionEjeFun;

    @FileReference(loadField = "fechaHoraInicioEjecucion")
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE, search = Kleenean.FALSE)
    public StringProperty nombreArchivo;

//  @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public StringProperty descripcionError;

    public LongProperty idGrupoProceso;

    public LongProperty idRastroProcesoSuperior;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    public CondicionEjeFun condicionEjeTem;

    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty nombreArchivoTem;

    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty descripcionErrorTem;

    @StringField(maxLength = 146) // 48*3+2 for nnnnnnnnn.nnnnnnnnn.nnnnnnnnnnn would be "safe"
    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty ultimaTransaccion;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(hidden = Kleenean.TRUE)
    public IntegerProperty transacciones;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty subprocesos;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty subprocesosPendientes;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty subprocesosEnProgreso;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty subprocesosSinErrores;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty subprocesosConErrores;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty subprocesosCancelados;

    @StringField(maxLength = 100)
    public StringProperty procedimientoAfterUpdate;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of RastroProceso's attributes">
        setLocalizedLabel(ENGLISH, "process trail");
        setLocalizedLabel(SPANISH, "rastro de proceso");
        setLocalizedShortLabel(ENGLISH, "process trail");
        setLocalizedShortLabel(SPANISH, "rastro");
        setLocalizedCollectionLabel(ENGLISH, "Process Trails");
        setLocalizedCollectionLabel(SPANISH, "Rastros de Proceso");
        setLocalizedCollectionShortLabel(ENGLISH, "Process Trails");
        setLocalizedCollectionShortLabel(SPANISH, "Rastros");
        setLocalizedDescription(ENGLISH, "audit trail of the execution of business processes");
        setLocalizedDescription(SPANISH, "rastro de auditoría de la ejecución de procesos de negocio");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        fechaHoraInicioEjecucion.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        fechaHoraInicioEjecucion.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        condicionEjeFun.setInitialValue(condicionEjeFun.EJECUCION_PENDIENTE);
        condicionEjeFun.setDefaultValue(condicionEjeFun.EJECUCION_PENDIENTE);
        condicionEjeTem.setInitialValue(condicionEjeFun.EJECUCION_PENDIENTE);
        condicionEjeTem.setDefaultValue(condicionEjeFun.EJECUCION_PENDIENTE);
        transacciones.setInitialValue(0);
        transacciones.setDefaultValue(0);
        subprocesos.setInitialValue(0);
        subprocesos.setDefaultValue(0);
        subprocesosPendientes.setInitialValue(0);
        subprocesosPendientes.setDefaultValue(0);
        subprocesosEnProgreso.setInitialValue(0);
        subprocesosEnProgreso.setDefaultValue(0);
        subprocesosSinErrores.setInitialValue(0);
        subprocesosSinErrores.setDefaultValue(0);
        subprocesosConErrores.setInitialValue(0);
        subprocesosConErrores.setDefaultValue(0);
        subprocesosCancelados.setInitialValue(0);
        subprocesosCancelados.setDefaultValue(0);
        // <editor-fold defaultstate="collapsed" desc="localization of RastroProceso's properties">
        fechaHoraInicioEjecucion.setLocalizedLabel(ENGLISH, "start");
        fechaHoraInicioEjecucion.setLocalizedLabel(SPANISH, "inicio");
        /**/
        fechaHoraFinEjecucion.setLocalizedLabel(ENGLISH, "end");
        fechaHoraFinEjecucion.setLocalizedLabel(SPANISH, "fin");
        /**/
        usuario.setLocalizedLabel(ENGLISH, "user");
        usuario.setLocalizedLabel(SPANISH, "usuario");
        /**/
        codigoUsuario.setLocalizedLabel(ENGLISH, "user");
        codigoUsuario.setLocalizedLabel(SPANISH, "usuario");
        /**/
        nombreUsuario.setLocalizedLabel(ENGLISH, "user name");
        nombreUsuario.setLocalizedLabel(SPANISH, "nombre del usuario");
        /**/
        funcion.setLocalizedLabel(ENGLISH, "function");
        funcion.setLocalizedLabel(SPANISH, "función");
        /**/
        codigoFuncion.setLocalizedLabel(ENGLISH, "function");
        codigoFuncion.setLocalizedLabel(SPANISH, "función");
        /**/
        nombreFuncion.setLocalizedLabel(ENGLISH, "function name");
        nombreFuncion.setLocalizedLabel(SPANISH, "nombre de la función");
        /**/
        paginaFuncion.setLocalizedLabel(ENGLISH, "function page");
        paginaFuncion.setLocalizedLabel(SPANISH, "página de la función");
        paginaFuncion.setLocalizedTooltip(ENGLISH, "open the function's processing page");
        paginaFuncion.setLocalizedTooltip(SPANISH, "abrir la página de procesamiento de la función");
        /**/
        idClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        idClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        /**/
        recursoValor.setLocalizedLabel(ENGLISH, "resource");
        recursoValor.setLocalizedLabel(SPANISH, "recurso");
        /**/
        idRecurso.setLocalizedLabel(ENGLISH, "resource");
        idRecurso.setLocalizedLabel(SPANISH, "recurso");
        /**/
        versionRecurso.setLocalizedLabel(ENGLISH, "resource version");
        versionRecurso.setLocalizedLabel(SPANISH, "versión del recurso");
        /**/
        codigoRecurso.setLocalizedLabel(ENGLISH, "resource");
        codigoRecurso.setLocalizedLabel(SPANISH, "recurso");
        /**/
        nombreRecurso.setLocalizedLabel(ENGLISH, "resource name");
        nombreRecurso.setLocalizedLabel(SPANISH, "nombre del recurso");
        /**/
        idPropietarioRecurso.setLocalizedLabel(ENGLISH, "resource owner");
        idPropietarioRecurso.setLocalizedLabel(SPANISH, "propietario del recurso");
        /**/
        idSegmentoRecurso.setLocalizedLabel(ENGLISH, "resource segment");
        idSegmentoRecurso.setLocalizedLabel(SPANISH, "segmento del recurso");
        /**/
        paginaRecurso.setLocalizedLabel(ENGLISH, "resource page");
        paginaRecurso.setLocalizedLabel(SPANISH, "página del recurso");
        paginaRecurso.setLocalizedTooltip(ENGLISH, "open the resource's registration page");
        paginaRecurso.setLocalizedTooltip(SPANISH, "abrir la página de registro del recurso");
        /**/
        etiquetaLenguaje.setLocalizedLabel(ENGLISH, "language tag");
        etiquetaLenguaje.setLocalizedLabel(SPANISH, "etiqueta de lenguaje");
        etiquetaLenguaje.setLocalizedShortLabel(ENGLISH, "language");
        etiquetaLenguaje.setLocalizedShortLabel(SPANISH, "lenguaje");
        /**/
        condicionEjeFun.setLocalizedLabel(ENGLISH, "function execution condition");
        condicionEjeFun.setLocalizedLabel(SPANISH, "condición de ejecución de función");
        condicionEjeFun.setLocalizedShortLabel(ENGLISH, "condition");
        condicionEjeFun.setLocalizedShortLabel(SPANISH, "condición");
        /**/
        nombreArchivo.setLocalizedLabel(ENGLISH, "file");
        nombreArchivo.setLocalizedLabel(SPANISH, "archivo");
        nombreArchivo.setLocalizedTooltip(ENGLISH, "open the process file");
        nombreArchivo.setLocalizedTooltip(SPANISH, "abrir el archivo del proceso");
        /**/
        descripcionError.setLocalizedLabel(ENGLISH, "message");
        descripcionError.setLocalizedLabel(SPANISH, "mensaje");
        /**/
        idGrupoProceso.setLocalizedLabel(ENGLISH, "process group");
        idGrupoProceso.setLocalizedLabel(SPANISH, "grupo de procesos");
        /**/
        idRastroProcesoSuperior.setLocalizedLabel(ENGLISH, "parent process trail");
        idRastroProcesoSuperior.setLocalizedLabel(SPANISH, "rastro proceso superior");
        idRastroProcesoSuperior.setLocalizedShortLabel(ENGLISH, "parent");
        idRastroProcesoSuperior.setLocalizedShortLabel(SPANISH, "superior");
        /**/
        condicionEjeTem.setLocalizedLabel(ENGLISH, "function execution temporal condition");
        condicionEjeTem.setLocalizedLabel(SPANISH, "condición temporal de ejecución de función");
        condicionEjeTem.setLocalizedShortLabel(ENGLISH, "temporal condition");
        condicionEjeTem.setLocalizedShortLabel(SPANISH, "condición temporal");
        /**/
        nombreArchivoTem.setLocalizedLabel(ENGLISH, "temporal file");
        nombreArchivoTem.setLocalizedLabel(SPANISH, "archivo temporal");
        /**/
        descripcionErrorTem.setLocalizedLabel(ENGLISH, "temporal message");
        descripcionErrorTem.setLocalizedLabel(SPANISH, "mensaje temporal");
        /**/
        ultimaTransaccion.setLocalizedLabel(ENGLISH, "last transaction");
        ultimaTransaccion.setLocalizedLabel(SPANISH, "última transacción");
        /**/
        transacciones.setLocalizedLabel(ENGLISH, "transaction count");
        transacciones.setLocalizedLabel(SPANISH, "cantidad de transacciones");
        /**/
        subprocesos.setLocalizedLabel(ENGLISH, "subprocesses");
        subprocesos.setLocalizedLabel(SPANISH, "subprocesos");
        /**/
        subprocesosPendientes.setLocalizedLabel(ENGLISH, "pending subprocesses");
        subprocesosPendientes.setLocalizedLabel(SPANISH, "subprocesos pendientes");
        /**/
        subprocesosEnProgreso.setLocalizedLabel(ENGLISH, "running subprocesses");
        subprocesosEnProgreso.setLocalizedLabel(SPANISH, "subprocesos en progreso");
        /**/
        subprocesosSinErrores.setLocalizedLabel(ENGLISH, "subprocesses without errors");
        subprocesosSinErrores.setLocalizedLabel(SPANISH, "subprocesos sin errores");
        /**/
        subprocesosConErrores.setLocalizedLabel(ENGLISH, "subprocesses with errors");
        subprocesosConErrores.setLocalizedLabel(SPANISH, "subprocesos con errores");
        /**/
        subprocesosCancelados.setLocalizedLabel(ENGLISH, "canceled subprocesses");
        subprocesosCancelados.setLocalizedLabel(SPANISH, "subprocesos cancelados");
        /**/
        procedimientoAfterUpdate.setLocalizedLabel(ENGLISH, "after update procedure");
        procedimientoAfterUpdate.setLocalizedLabel(SPANISH, "procedimiento after update");
        // </editor-fold>
    }

    Key key101;

    @Override
    protected void settleKeys() {
        super.settleKeys();
        key101.setUnique(false);
        key101.newKeyField(ultimaTransaccion);
    }

    protected Tab tab1, tab2;

    @Override
    protected void settleTabs() {
        super.settleTabs();
        tab1.newTabField(fechaHoraInicioEjecucion, fechaHoraFinEjecucion, usuario, codigoUsuario, nombreUsuario,
            funcion, codigoFuncion, nombreFuncion, paginaFuncion, idClaseRecursoValor, recursoValor,
            idRecurso, versionRecurso, codigoRecurso, nombreRecurso, idPropietarioRecurso, idSegmentoRecurso, paginaRecurso,
            etiquetaLenguaje,
            condicionEjeFun, nombreArchivo, descripcionError
        );
        tab2.newTabField(idGrupoProceso, idRastroProcesoSuperior, subprocesos, subprocesosPendientes, subprocesosEnProgreso,
            subprocesosSinErrores, subprocesosConErrores, subprocesosCancelados, procedimientoAfterUpdate);
        // <editor-fold defaultstate="collapsed" desc="localization of RastroProceso's tabs">
        tab1.setLocalizedLabel(ENGLISH, "general");
        tab1.setLocalizedLabel(SPANISH, "general");
        /**/
        tab2.setLocalizedLabel(ENGLISH, "subprocesses");
        tab2.setLocalizedLabel(SPANISH, "subprocesos");
        // </editor-fold>
    }

}
