/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.configuracion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UrlProperty;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(catalog = Kleenean.TRUE, independent = Kleenean.TRUE, resourceType = ResourceType.CONFIGURATION, resourceGender = ResourceGender.FEMININE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PUBLIC, rowsLimit = 0)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.FALSE)
@EntityDetailView(enabled = Kleenean.FALSE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class Aplicacion extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private Aplicacion() {
        this(null, null);
    }

    public Aplicacion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @StringField(maxLength = 100)
    public StringProperty codigoAplicacion;

    @NameProperty
    public StringProperty nombreAplicacion;

    @DescriptionProperty
    public StringProperty descripcionAplicacion;

    @ColumnField(nullable = Kleenean.FALSE)
    @StringField(maxLength = 100)
    public StringProperty servidorAplicacion;

    @ColumnField(nullable = Kleenean.FALSE)
    @StringField(maxLength = 10)
    public StringProperty puertoAplicacion;

    @UrlProperty
    public StringProperty urlAplicacion;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esPublica;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esEspecial;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of Aplicacion's attributes">
        setLocalizedLabel(ENGLISH, "application");
        setLocalizedLabel(SPANISH, "aplicación");
        setLocalizedCollectionLabel(ENGLISH, "Applications");
        setLocalizedCollectionLabel(SPANISH, "Aplicaciones");
        setLocalizedDescription(ENGLISH, "application including the user interface and client-side logic");
        setLocalizedDescription(SPANISH, "aplicación que incluye la interfaz de usuario y la lógica del lado del cliente");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        servidorAplicacion.setInitialValue("localhost");
        servidorAplicacion.setDefaultValue("localhost");
        puertoAplicacion.setInitialValue("8080");
        puertoAplicacion.setDefaultValue("8080");
        esPublica.setInitialValue(false);
        esPublica.setDefaultValue(false);
        esEspecial.setInitialValue(false);
        esEspecial.setDefaultValue(false);
        // <editor-fold defaultstate="collapsed" desc="localization of Aplicacion's properties">
        codigoAplicacion.setLocalizedLabel(ENGLISH, "application code");
        codigoAplicacion.setLocalizedLabel(SPANISH, "código de la aplicación");
        codigoAplicacion.setLocalizedShortLabel(ENGLISH, "code");
        codigoAplicacion.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombreAplicacion.setLocalizedLabel(ENGLISH, "application name");
        nombreAplicacion.setLocalizedLabel(SPANISH, "nombre de la aplicación");
        nombreAplicacion.setLocalizedShortLabel(ENGLISH, "name");
        nombreAplicacion.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        descripcionAplicacion.setLocalizedLabel(ENGLISH, "application description");
        descripcionAplicacion.setLocalizedLabel(SPANISH, "descripción de la aplicación");
        descripcionAplicacion.setLocalizedShortLabel(ENGLISH, "description");
        descripcionAplicacion.setLocalizedShortLabel(SPANISH, "descripción");
        /**/
        servidorAplicacion.setLocalizedLabel(ENGLISH, "application server");
        servidorAplicacion.setLocalizedLabel(SPANISH, "servidor aplicación");
        servidorAplicacion.setLocalizedShortLabel(ENGLISH, "server");
        servidorAplicacion.setLocalizedShortLabel(SPANISH, "servidor");
        /**/
        puertoAplicacion.setLocalizedLabel(ENGLISH, "application port");
        puertoAplicacion.setLocalizedLabel(SPANISH, "puerto aplicación");
        puertoAplicacion.setLocalizedShortLabel(ENGLISH, "port");
        puertoAplicacion.setLocalizedShortLabel(SPANISH, "puerto");
        /**/
        urlAplicacion.setLocalizedLabel(ENGLISH, "application URL");
        urlAplicacion.setLocalizedLabel(SPANISH, "URL de la aplicación");
        urlAplicacion.setLocalizedShortLabel(ENGLISH, "URL");
        urlAplicacion.setLocalizedShortLabel(SPANISH, "URL");
        /**/
        esPublica.setLocalizedLabel(ENGLISH, "public");
        esPublica.setLocalizedLabel(SPANISH, "pública");
        /**/
        esEspecial.setLocalizedLabel(ENGLISH, "special");
        esEspecial.setLocalizedLabel(SPANISH, "especial");
        // </editor-fold>
    }

}
