/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.configuracion.basica;

import adalid.core.AbstractPersistentEnumerationEntity;
import adalid.core.Instance;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.PrimaryKey;
import adalid.core.enums.Kleenean;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.TRUE, resourceType = ResourceType.CONFIGURATION, resourceGender = ResourceGender.FEMININE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PUBLIC, rowsLimit = 0)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.FALSE)
@EntityDetailView(enabled = Kleenean.FALSE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class ClaseJava extends AbstractPersistentEnumerationEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private ClaseJava() {
        this(null, null);
    }

    public ClaseJava(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of ClaseJava's attributes">
        setLocalizedLabel(ENGLISH, "data class");
        setLocalizedLabel(SPANISH, "clase de dato");
        setLocalizedShortLabel(ENGLISH, "class");
        setLocalizedShortLabel(SPANISH, "clase");
        setLocalizedCollectionLabel(ENGLISH, "Data Classes");
        setLocalizedCollectionLabel(SPANISH, "Clases de Datos");
        setLocalizedCollectionShortLabel(ENGLISH, "Classes");
        setLocalizedCollectionShortLabel(SPANISH, "Clases");
        setLocalizedDescription(ENGLISH, "Java class that encapsulates, hides, or wraps a data type");
        setLocalizedDescription(SPANISH, "clase Java que encapsula, oculta o envuelve un tipo de datos");
        // </editor-fold>
    }

    @PrimaryKey
    public IntegerProperty numero;

    @BusinessKey
    public StringProperty codigo;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of ClaseJava's properties">
        codigo.setLocalizedLabel(ENGLISH, "data class code");
        codigo.setLocalizedLabel(SPANISH, "código de la clase de dato");
        codigo.setLocalizedShortLabel(ENGLISH, "code");
        codigo.setLocalizedShortLabel(SPANISH, "código");
        // </editor-fold>
    }

    public Instance JAVA_BIG_DECIMAL;

    public Instance JAVA_BIG_INTEGER;

    public Instance JAVA_BINARY;

    public Instance JAVA_BOOLEAN;

    public Instance JAVA_BYTE;

    public Instance JAVA_CHARACTER;

    public Instance JAVA_DATE;

    public Instance JAVA_DOUBLE;

    public Instance JAVA_FLOAT;

    public Instance JAVA_INTEGER;

    public Instance JAVA_LONG;

    public Instance JAVA_SHORT;

    public Instance JAVA_STRING;

    public Instance JAVA_TIME;

    public Instance JAVA_TIMESTAMP;

    public Instance JAVA_OBJECT;

    @Override
    protected void settleInstances() {
        super.settleInstances();
        int i = 0;
        JAVA_BIG_DECIMAL.newInstanceField(numero, ++i);
        JAVA_BIG_INTEGER.newInstanceField(numero, ++i);
        JAVA_BINARY.newInstanceField(numero, ++i);
        JAVA_BOOLEAN.newInstanceField(numero, ++i);
        JAVA_BYTE.newInstanceField(numero, ++i);
        JAVA_CHARACTER.newInstanceField(numero, ++i);
        JAVA_DATE.newInstanceField(numero, ++i);
        JAVA_DOUBLE.newInstanceField(numero, ++i);
        JAVA_FLOAT.newInstanceField(numero, ++i);
        JAVA_INTEGER.newInstanceField(numero, ++i);
        JAVA_LONG.newInstanceField(numero, ++i);
        JAVA_SHORT.newInstanceField(numero, ++i);
        JAVA_STRING.newInstanceField(numero, ++i);
        JAVA_TIME.newInstanceField(numero, ++i);
        JAVA_TIMESTAMP.newInstanceField(numero, ++i);
        JAVA_OBJECT.newInstanceField(numero, ++i);
        /**/
        JAVA_BIG_DECIMAL.newInstanceField(codigo, "BigDecimal");
        JAVA_BIG_INTEGER.newInstanceField(codigo, "BigInteger");
        JAVA_BINARY.newInstanceField(codigo, "Binary");
        JAVA_BOOLEAN.newInstanceField(codigo, "Boolean");
        JAVA_BYTE.newInstanceField(codigo, "Byte");
        JAVA_CHARACTER.newInstanceField(codigo, "Character");
        JAVA_DATE.newInstanceField(codigo, "Date");
        JAVA_DOUBLE.newInstanceField(codigo, "Double");
        JAVA_FLOAT.newInstanceField(codigo, "Float");
        JAVA_INTEGER.newInstanceField(codigo, "Integer");
        JAVA_LONG.newInstanceField(codigo, "Long");
        JAVA_SHORT.newInstanceField(codigo, "Short");
        JAVA_STRING.newInstanceField(codigo, "String");
        JAVA_TIME.newInstanceField(codigo, "Time");
        JAVA_TIMESTAMP.newInstanceField(codigo, "Timestamp");
        JAVA_OBJECT.newInstanceField(codigo, "Object");
        // <editor-fold defaultstate="collapsed" desc="localization of ClaseJava's instances">
        JAVA_BIG_DECIMAL.newInstanceField(codigo, "BigDecimal", ENGLISH);
        JAVA_BIG_DECIMAL.newInstanceField(codigo, "BigDecimal", SPANISH);
        /**/
        JAVA_BIG_INTEGER.newInstanceField(codigo, "BigInteger", ENGLISH);
        JAVA_BIG_INTEGER.newInstanceField(codigo, "BigInteger", SPANISH);
        /**/
        JAVA_BINARY.newInstanceField(codigo, "Binary", ENGLISH);
        JAVA_BINARY.newInstanceField(codigo, "Binary", SPANISH);
        /**/
        JAVA_BOOLEAN.newInstanceField(codigo, "Boolean", ENGLISH);
        JAVA_BOOLEAN.newInstanceField(codigo, "Boolean", SPANISH);
        /**/
        JAVA_BYTE.newInstanceField(codigo, "Byte", ENGLISH);
        JAVA_BYTE.newInstanceField(codigo, "Byte", SPANISH);
        /**/
        JAVA_CHARACTER.newInstanceField(codigo, "Character", ENGLISH);
        JAVA_CHARACTER.newInstanceField(codigo, "Character", SPANISH);
        /**/
        JAVA_DATE.newInstanceField(codigo, "Date", ENGLISH);
        JAVA_DATE.newInstanceField(codigo, "Date", SPANISH);
        /**/
        JAVA_DOUBLE.newInstanceField(codigo, "Double", ENGLISH);
        JAVA_DOUBLE.newInstanceField(codigo, "Double", SPANISH);
        /**/
        JAVA_FLOAT.newInstanceField(codigo, "Float", ENGLISH);
        JAVA_FLOAT.newInstanceField(codigo, "Float", SPANISH);
        /**/
        JAVA_INTEGER.newInstanceField(codigo, "Integer", ENGLISH);
        JAVA_INTEGER.newInstanceField(codigo, "Integer", SPANISH);
        /**/
        JAVA_LONG.newInstanceField(codigo, "Long", ENGLISH);
        JAVA_LONG.newInstanceField(codigo, "Long", SPANISH);
        /**/
        JAVA_SHORT.newInstanceField(codigo, "Short", ENGLISH);
        JAVA_SHORT.newInstanceField(codigo, "Short", SPANISH);
        /**/
        JAVA_STRING.newInstanceField(codigo, "String", ENGLISH);
        JAVA_STRING.newInstanceField(codigo, "String", SPANISH);
        /**/
        JAVA_TIME.newInstanceField(codigo, "Time", ENGLISH);
        JAVA_TIME.newInstanceField(codigo, "Time", SPANISH);
        /**/
        JAVA_TIMESTAMP.newInstanceField(codigo, "Timestamp", ENGLISH);
        JAVA_TIMESTAMP.newInstanceField(codigo, "Timestamp", SPANISH);
        /**/
        JAVA_OBJECT.newInstanceField(codigo, "Object", ENGLISH);
        JAVA_OBJECT.newInstanceField(codigo, "Object", SPANISH);
        // </editor-fold>
    }

}
