/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.configuracion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(catalog = Kleenean.TRUE, independent = Kleenean.TRUE, resourceType = ResourceType.CONFIGURATION, resourceGender = ResourceGender.FEMININE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PUBLIC, rowsLimit = 0)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class Funcion extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private Funcion() {
        this(null, null);
    }

    public Funcion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @StringField(maxLength = 200)
    public StringProperty codigoFuncion;

    @NameProperty
    @StringField(maxLength = 200)
    public StringProperty nombreFuncion;

    @StringField(maxLength = 200)
    public StringProperty nombreJava;

    @StringField(maxLength = 200)
    public StringProperty nombreSql;

    @DescriptionProperty
    public StringProperty descripcionFuncion;

    public StringProperty clausulaWhere;

    public StringProperty clausulaOrder;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esPublica;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esProgramatica;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esProtegida;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esPersonalizable;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esSegmentable;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esSupervisable;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esHeredada;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public TipoFuncion tipoFuncion;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public TipoRastroFun tipoRastroFun;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public Dominio dominio;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.CASCADE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public GrupoProceso grupoProceso;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of Funcion's attributes">
        setLocalizedLabel(ENGLISH, "function");
        setLocalizedLabel(SPANISH, "función");
        setLocalizedCollectionLabel(ENGLISH, "Functions");
        setLocalizedCollectionLabel(SPANISH, "Funciones");
        setLocalizedDescription(ENGLISH, "application function (CRUD, business process, generation of files and reports, etc.)");
        setLocalizedDescription(SPANISH, "función de la aplicación (CRUD, proceso de negocio, generación de archivos e informes, etc.)");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        tipoRastroFun.setInitialValue(tipoRastroFun.NINGUNO);
        tipoRastroFun.setDefaultValue(tipoRastroFun.NINGUNO);
        esPublica.setInitialValue(false);
        esPublica.setDefaultValue(false);
        esProgramatica.setInitialValue(false);
        esProgramatica.setDefaultValue(false);
        esProtegida.setInitialValue(false);
        esProtegida.setDefaultValue(false);
        esPersonalizable.setInitialValue(false);
        esPersonalizable.setDefaultValue(false);
        esSegmentable.setInitialValue(false);
        esSegmentable.setDefaultValue(false);
        esSupervisable.setInitialValue(false);
        esSupervisable.setDefaultValue(false);
        esHeredada.setInitialValue(false);
        esHeredada.setDefaultValue(false);
        // <editor-fold defaultstate="collapsed" desc="localization of Funcion's properties">
        codigoFuncion.setLocalizedLabel(ENGLISH, "function code");
        codigoFuncion.setLocalizedLabel(SPANISH, "código de la función");
        codigoFuncion.setLocalizedShortLabel(ENGLISH, "code");
        codigoFuncion.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombreFuncion.setLocalizedLabel(ENGLISH, "function name");
        nombreFuncion.setLocalizedLabel(SPANISH, "nombre de la función");
        nombreFuncion.setLocalizedShortLabel(ENGLISH, "name");
        nombreFuncion.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        nombreJava.setLocalizedLabel(ENGLISH, "java name");
        nombreJava.setLocalizedLabel(SPANISH, "nombre java");
        /**/
        nombreSql.setLocalizedLabel(ENGLISH, "sql name");
        nombreSql.setLocalizedLabel(SPANISH, "nombre sql");
        /**/
        descripcionFuncion.setLocalizedLabel(ENGLISH, "function description");
        descripcionFuncion.setLocalizedLabel(SPANISH, "descripción de la función");
        descripcionFuncion.setLocalizedShortLabel(ENGLISH, "description");
        descripcionFuncion.setLocalizedShortLabel(SPANISH, "descripción");
        /**/
        clausulaWhere.setLocalizedLabel(ENGLISH, "where clause");
        clausulaWhere.setLocalizedLabel(SPANISH, "clausula where");
        /**/
        clausulaOrder.setLocalizedLabel(ENGLISH, "order clause");
        clausulaOrder.setLocalizedLabel(SPANISH, "clausula order");
        /**/
        esPublica.setLocalizedLabel(ENGLISH, "public");
        esPublica.setLocalizedLabel(SPANISH, "pública");
        /**/
        esProgramatica.setLocalizedLabel(ENGLISH, "programmatic");
        esProgramatica.setLocalizedLabel(SPANISH, "programática");
        /**/
        esProtegida.setLocalizedLabel(ENGLISH, "protected");
        esProtegida.setLocalizedLabel(SPANISH, "protegida");
        /**/
        esPersonalizable.setLocalizedLabel(ENGLISH, "personalizable");
        esPersonalizable.setLocalizedLabel(SPANISH, "personalizable");
        /**/
        esSegmentable.setLocalizedLabel(ENGLISH, "segmentable");
        esSegmentable.setLocalizedLabel(SPANISH, "segmentable");
        /**/
        esSupervisable.setLocalizedLabel(ENGLISH, "supervisable");
        esSupervisable.setLocalizedLabel(SPANISH, "supervisable");
        /**/
        esHeredada.setLocalizedLabel(ENGLISH, "inherited");
        esHeredada.setLocalizedLabel(SPANISH, "heredada");
        /**/
        tipoFuncion.setLocalizedLabel(ENGLISH, "function type");
        tipoFuncion.setLocalizedLabel(SPANISH, "tipo de función");
        tipoFuncion.setLocalizedShortLabel(ENGLISH, "type");
        tipoFuncion.setLocalizedShortLabel(SPANISH, "tipo");
        /**/
        tipoRastroFun.setLocalizedLabel(ENGLISH, "function trail type");
        tipoRastroFun.setLocalizedLabel(SPANISH, "tipo de rastro de función");
        tipoRastroFun.setLocalizedShortLabel(ENGLISH, "function trail type");
        tipoRastroFun.setLocalizedShortLabel(SPANISH, "tipo de rastro");
        /**/
        dominio.setLocalizedLabel(ENGLISH, "domain");
        dominio.setLocalizedLabel(SPANISH, "dominio");
        /**/
        grupoProceso.setLocalizedLabel(ENGLISH, "process group");
        grupoProceso.setLocalizedLabel(SPANISH, "grupo de procesos");
        grupoProceso.setLocalizedShortLabel(ENGLISH, "group");
        grupoProceso.setLocalizedShortLabel(SPANISH, "grupo");
        // </editor-fold>
    }

}
