/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.configuracion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ProcessOperation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(catalog = Kleenean.TRUE, independent = Kleenean.TRUE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PUBLIC, rowsLimit = 0)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class GrupoProceso extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private GrupoProceso() {
        this(null, null);
    }

    public GrupoProceso(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    public StringProperty codigoGrupoProceso;

    @NameProperty
    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty nombreGrupoProceso;

    @DescriptionProperty
    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty descripcionGrupoProceso;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idRastroProceso;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public CondicionEjeFun condicionEjeFun;

    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public TimestampProperty fechaHoraInicioEjecucion;

    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    public TimestampProperty fechaHoraFinEjecucion;

    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE)
    @StringField(maxLength = 200)
    public StringProperty codigoFuncion;

    @PropertyField(table = Kleenean.TRUE, report = Kleenean.FALSE)
    @StringField(maxLength = 200)
    public StringProperty nombreFuncion;

    protected Cancelar cancelar;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of GrupoProceso's attributes">
        setLocalizedLabel(ENGLISH, "process group");
        setLocalizedLabel(SPANISH, "grupo de procesos");
        setLocalizedShortLabel(ENGLISH, "group");
        setLocalizedShortLabel(SPANISH, "grupo");
        setLocalizedCollectionLabel(ENGLISH, "Process Groups");
        setLocalizedCollectionLabel(SPANISH, "Grupos de Procesos");
        setLocalizedCollectionShortLabel(ENGLISH, "Groups");
        setLocalizedCollectionShortLabel(SPANISH, "Grupos");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of GrupoProceso's properties">
        codigoGrupoProceso.setLocalizedLabel(ENGLISH, "process group code");
        codigoGrupoProceso.setLocalizedLabel(SPANISH, "código del grupo de procesos");
        codigoGrupoProceso.setLocalizedShortLabel(ENGLISH, "code");
        codigoGrupoProceso.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombreGrupoProceso.setLocalizedLabel(ENGLISH, "process group name");
        nombreGrupoProceso.setLocalizedLabel(SPANISH, "nombre del grupo de procesos");
        nombreGrupoProceso.setLocalizedShortLabel(ENGLISH, "name");
        nombreGrupoProceso.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        descripcionGrupoProceso.setLocalizedLabel(ENGLISH, "process group description");
        descripcionGrupoProceso.setLocalizedLabel(SPANISH, "descripción del grupo de procesos");
        descripcionGrupoProceso.setLocalizedShortLabel(ENGLISH, "description");
        descripcionGrupoProceso.setLocalizedShortLabel(SPANISH, "descripción");
        /**/
        idRastroProceso.setLocalizedLabel(ENGLISH, "process trail");
        idRastroProceso.setLocalizedLabel(SPANISH, "rastro de proceso");
        /**/
        condicionEjeFun.setLocalizedLabel(ENGLISH, "function execution condition");
        condicionEjeFun.setLocalizedLabel(SPANISH, "condición de ejecución de función");
        condicionEjeFun.setLocalizedShortLabel(ENGLISH, "condition");
        condicionEjeFun.setLocalizedShortLabel(SPANISH, "condición");
        /**/
        fechaHoraInicioEjecucion.setLocalizedLabel(ENGLISH, "start");
        fechaHoraInicioEjecucion.setLocalizedLabel(SPANISH, "inicio");
        /**/
        fechaHoraFinEjecucion.setLocalizedLabel(ENGLISH, "end");
        fechaHoraFinEjecucion.setLocalizedLabel(SPANISH, "fin");
        /**/
        codigoFuncion.setLocalizedLabel(ENGLISH, "function");
        codigoFuncion.setLocalizedLabel(SPANISH, "función");
        /**/
        nombreFuncion.setLocalizedLabel(ENGLISH, "function name");
        nombreFuncion.setLocalizedLabel(SPANISH, "nombre de la función");
        // </editor-fold>
    }

    // <editor-fold defaultstate="collapsed" desc="Operations">
    @OperationClass(access = OperationAccess.PROTECTED)
    public class Cancelar extends ProcessOperation {

        @InstanceReference
        protected GrupoProceso grupoProceso;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Cancelar's attributes">
            setLocalizedLabel(ENGLISH, "cancel");
            setLocalizedLabel(SPANISH, "cancelar");
            // </editor-fold>
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Cancelar's parameters">
            grupoProceso.setLocalizedLabel(ENGLISH, "process group");
            grupoProceso.setLocalizedLabel(SPANISH, "grupo de procesos");
            grupoProceso.setLocalizedShortLabel(ENGLISH, "group");
            grupoProceso.setLocalizedShortLabel(SPANISH, "grupo");
            // </editor-fold>
        }

    }
    // </editor-fold>

}
