/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.configuracion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UrlProperty;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.UrlType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(catalog = Kleenean.TRUE, independent = Kleenean.TRUE, resourceType = ResourceType.CONFIGURATION, resourceGender = ResourceGender.FEMININE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PUBLIC, rowsLimit = 0)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class Pagina extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private Pagina() {
        this(null, null);
    }

    public Pagina(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @StringField(maxLength = 100)
    public StringProperty codigoPagina;

    @NameProperty
    public StringProperty nombrePagina;

    @DescriptionProperty
    public StringProperty descripcionPagina;

    @UrlProperty(urlType = UrlType.INTERNAL)
    public StringProperty urlPagina;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esPublica;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esEspecial;

    @ForeignKey(onDelete = OnDeleteAction.CASCADE, onUpdate = OnUpdateAction.CASCADE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(hidden = Kleenean.TRUE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public Aplicacion aplicacion;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public TipoPagina tipoPagina;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public Dominio dominio;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public Dominio dominioMaestro;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.CASCADE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public Parametro parametro;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of Pagina's attributes">
        setLocalizedLabel(ENGLISH, "page");
        setLocalizedLabel(SPANISH, "página");
        setLocalizedCollectionLabel(ENGLISH, "Pages");
        setLocalizedCollectionLabel(SPANISH, "Páginas");
        setLocalizedDescription(ENGLISH, "web application page");
        setLocalizedDescription(SPANISH, "página de la aplicación web");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        esPublica.setInitialValue(false);
        esPublica.setDefaultValue(false);
        esEspecial.setInitialValue(false);
        esEspecial.setDefaultValue(false);
        // <editor-fold defaultstate="collapsed" desc="localization of Pagina's properties">
        codigoPagina.setLocalizedLabel(ENGLISH, "page code");
        codigoPagina.setLocalizedLabel(SPANISH, "código de la página");
        codigoPagina.setLocalizedShortLabel(ENGLISH, "code");
        codigoPagina.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombrePagina.setLocalizedLabel(ENGLISH, "page name");
        nombrePagina.setLocalizedLabel(SPANISH, "nombre de la página");
        nombrePagina.setLocalizedShortLabel(ENGLISH, "name");
        nombrePagina.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        descripcionPagina.setLocalizedLabel(ENGLISH, "page description");
        descripcionPagina.setLocalizedLabel(SPANISH, "descripción de la página");
        descripcionPagina.setLocalizedShortLabel(ENGLISH, "description");
        descripcionPagina.setLocalizedShortLabel(SPANISH, "descripción");
        /**/
        urlPagina.setLocalizedLabel(ENGLISH, "page URL");
        urlPagina.setLocalizedLabel(SPANISH, "URL de la página");
        urlPagina.setLocalizedShortLabel(ENGLISH, "URL");
        urlPagina.setLocalizedShortLabel(SPANISH, "URL");
        /**/
        esPublica.setLocalizedLabel(ENGLISH, "public");
        esPublica.setLocalizedLabel(SPANISH, "pública");
        /**/
        esEspecial.setLocalizedLabel(ENGLISH, "special");
        esEspecial.setLocalizedLabel(SPANISH, "especial");
        /**/
        aplicacion.setLocalizedLabel(ENGLISH, "application");
        aplicacion.setLocalizedLabel(SPANISH, "aplicación");
        /**/
        tipoPagina.setLocalizedLabel(ENGLISH, "page type");
        tipoPagina.setLocalizedLabel(SPANISH, "tipo de página");
        tipoPagina.setLocalizedShortLabel(ENGLISH, "type");
        tipoPagina.setLocalizedShortLabel(SPANISH, "tipo");
        /**/
        dominio.setLocalizedLabel(ENGLISH, "domain");
        dominio.setLocalizedLabel(SPANISH, "dominio");
        /**/
        dominioMaestro.setLocalizedLabel(ENGLISH, "master domain");
        dominioMaestro.setLocalizedLabel(SPANISH, "dominio maestro");
        dominioMaestro.setLocalizedShortLabel(ENGLISH, "master");
        dominioMaestro.setLocalizedShortLabel(SPANISH, "maestro");
        /**/
        parametro.setLocalizedLabel(ENGLISH, "parameter");
        parametro.setLocalizedLabel(SPANISH, "parámetro");
        // </editor-fold>
    }

}
