/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.configuracion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(catalog = Kleenean.TRUE, independent = Kleenean.TRUE, resourceType = ResourceType.CONFIGURATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PUBLIC, rowsLimit = 0)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class Parametro extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private Parametro() {
        this(null, null);
    }

    public Parametro(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @StringField(maxLength = 200)
    public StringProperty codigoParametro;

    @NameProperty
    @StringField(maxLength = 200)
    public StringProperty nombreParametro;

    @StringField(maxLength = 200)
    public StringProperty detalleParametro;

    @DescriptionProperty
    public StringProperty descripcionParametro;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public TipoDatoPar tipoDatoPar;

    /**
     * many-to-one entity reference property field
     */
    @Allocation(maxDepth = 1, maxRound = 0)
    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    public ClaseJava claseJava;

    public BooleanProperty anulable;

    public IntegerProperty longitud;

    public IntegerProperty precision;

    public IntegerProperty escala;

    public IntegerProperty pixeles;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of Parametro's attributes">
        setLocalizedLabel(ENGLISH, "parameter");
        setLocalizedLabel(SPANISH, "parámetro");
        setLocalizedCollectionLabel(ENGLISH, "Parameters");
        setLocalizedCollectionLabel(SPANISH, "Parámetros");
        setLocalizedDescription(ENGLISH, "parameter of an application function");
        setLocalizedDescription(SPANISH, "parámetro de una función de la aplicación");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of Parametro's properties">
        codigoParametro.setLocalizedLabel(ENGLISH, "parameter code");
        codigoParametro.setLocalizedLabel(SPANISH, "código del parámetro");
        codigoParametro.setLocalizedShortLabel(ENGLISH, "code");
        codigoParametro.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombreParametro.setLocalizedLabel(ENGLISH, "parameter name");
        nombreParametro.setLocalizedLabel(SPANISH, "nombre del parámetro");
        nombreParametro.setLocalizedShortLabel(ENGLISH, "name");
        nombreParametro.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        detalleParametro.setLocalizedLabel(ENGLISH, "parameter detail");
        detalleParametro.setLocalizedLabel(SPANISH, "detalle parámetro");
        detalleParametro.setLocalizedShortLabel(ENGLISH, "detail");
        detalleParametro.setLocalizedShortLabel(SPANISH, "detalle");
        /**/
        descripcionParametro.setLocalizedLabel(ENGLISH, "parameter description");
        descripcionParametro.setLocalizedLabel(SPANISH, "descripción del parámetro");
        descripcionParametro.setLocalizedShortLabel(ENGLISH, "description");
        descripcionParametro.setLocalizedShortLabel(SPANISH, "descripción");
        /**/
        tipoDatoPar.setLocalizedLabel(ENGLISH, "parameter data type");
        tipoDatoPar.setLocalizedLabel(SPANISH, "tipo de dato de parámetro");
        tipoDatoPar.setLocalizedShortLabel(ENGLISH, "data type");
        tipoDatoPar.setLocalizedShortLabel(SPANISH, "tipo de dato");
        /**/
        claseJava.setLocalizedLabel(ENGLISH, "data class");
        claseJava.setLocalizedLabel(SPANISH, "clase de dato");
        claseJava.setLocalizedShortLabel(ENGLISH, "class");
        claseJava.setLocalizedShortLabel(SPANISH, "clase");
        /**/
        anulable.setLocalizedLabel(ENGLISH, "nullable");
        anulable.setLocalizedLabel(SPANISH, "anulable");
        /**/
        longitud.setLocalizedLabel(ENGLISH, "length");
        longitud.setLocalizedLabel(SPANISH, "longitud");
        /**/
        precision.setLocalizedLabel(ENGLISH, "precision");
        precision.setLocalizedLabel(SPANISH, "precisión");
        /**/
        escala.setLocalizedLabel(ENGLISH, "scale");
        escala.setLocalizedLabel(SPANISH, "escala");
        /**/
        pixeles.setLocalizedLabel(ENGLISH, "pixels");
        pixeles.setLocalizedLabel(SPANISH, "pixeles");
        // </editor-fold>
    }

}
