/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.configuracion.basica;

import adalid.core.AbstractPersistentEnumerationEntity;
import adalid.core.Instance;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.PrimaryKey;
import adalid.core.enums.Kleenean;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.TRUE, resourceType = ResourceType.CONFIGURATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PUBLIC, rowsLimit = 0)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.FALSE)
@EntityDetailView(enabled = Kleenean.FALSE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class TipoValor extends AbstractPersistentEnumerationEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private TipoValor() {
        this(null, null);
    }

    public TipoValor(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public IntegerProperty numero;

    @BusinessKey
    public StringProperty codigo;

    public Instance CONTINUO;

    public Instance DISCRETO;

    public Instance OBJETO;

    public Instance RECURSO;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of TipoValor's attributes">
        setLocalizedLabel(ENGLISH, "value type");
        setLocalizedLabel(SPANISH, "tipo de valor");
        setLocalizedCollectionLabel(ENGLISH, "Value Types");
        setLocalizedCollectionLabel(SPANISH, "Tipos de Valor");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of TipoValor's properties">
        codigo.setLocalizedLabel(ENGLISH, "value type code");
        codigo.setLocalizedLabel(SPANISH, "código del tipo de valor");
        codigo.setLocalizedShortLabel(ENGLISH, "code");
        codigo.setLocalizedShortLabel(SPANISH, "código");
        // </editor-fold>
    }

    @Override
    protected void settleInstances() {
        super.settleInstances();
        CONTINUO.newInstanceField(numero, 11);
        CONTINUO.newInstanceField(codigo, "Cont\u00EDnuo");
        DISCRETO.newInstanceField(numero, 21);
        DISCRETO.newInstanceField(codigo, "Discreto");
        OBJETO.newInstanceField(numero, 22);
        OBJETO.newInstanceField(codigo, "Objeto");
        RECURSO.newInstanceField(numero, 23);
        RECURSO.newInstanceField(codigo, "Recurso");
        // <editor-fold defaultstate="collapsed" desc="localization of TipoValor's instances">
        CONTINUO.newInstanceField(codigo, "Continuous", ENGLISH);
        CONTINUO.newInstanceField(codigo, "Contínuo", SPANISH);
        /**/
        DISCRETO.newInstanceField(codigo, "Discrete", ENGLISH);
        DISCRETO.newInstanceField(codigo, "Discreto", SPANISH);
        /**/
        OBJETO.newInstanceField(codigo, "Object", ENGLISH);
        OBJETO.newInstanceField(codigo, "Objeto", SPANISH);
        /**/
        RECURSO.newInstanceField(codigo, "Resource", ENGLISH);
        RECURSO.newInstanceField(codigo, "Recurso", SPANISH);
        // </editor-fold>
    }

}
