/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ClaseRecurso;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.TRUE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, onload = SelectOnloadOption.EXECUTE)
@EntityInsertOperation(enabled = Kleenean.TRUE)
@EntityUpdateOperation(enabled = Kleenean.TRUE)
@EntityDeleteOperation(enabled = Kleenean.TRUE)
@EntityTableView(enabled = Kleenean.TRUE, inserts = Kleenean.TRUE, updates = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class ConjuntoSegmento extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private ConjuntoSegmento() {
        this(null, null);
    }

    public ConjuntoSegmento(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @StringField(maxLength = 200)
    public StringProperty codigoConjuntoSegmento;

    @NameProperty
    @StringField(maxLength = 200)
    public StringProperty nombreConjuntoSegmento;

    @DescriptionProperty
    public StringProperty descripcionConjuntoSegmento;

//  20171213: remove foreign-key referring to ClaseRecurso
//  @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 2, maxRound = 1)
    public ClaseRecurso claseRecurso;

    @Allocation(maxDepth = 1, maxRound = 0)
    @ForeignKey(onDelete = OnDeleteAction.CASCADE, onUpdate = OnUpdateAction.CASCADE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    public Usuario usuarioSupervisor;

    @PropertyField(hidden = Kleenean.TRUE)
    @StringField(maxLength = 200)
    public StringProperty nombreClaseFabricador;

    @PropertyField(hidden = Kleenean.TRUE)
    public BooleanProperty esConjuntoEspecial;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of ConjuntoSegmento's attributes">
        setLocalizedLabel(ENGLISH, "segment set");
        setLocalizedLabel(SPANISH, "conjunto de segmentos");
        setLocalizedShortLabel(ENGLISH, "segment set");
        setLocalizedShortLabel(SPANISH, "conjunto");
        setLocalizedCollectionLabel(ENGLISH, "Segment Sets");
        setLocalizedCollectionLabel(SPANISH, "Conjuntos de Segmentos");
        setLocalizedCollectionShortLabel(ENGLISH, "Segment Sets");
        setLocalizedCollectionShortLabel(SPANISH, "Conjuntos");
        setLocalizedDescription(ENGLISH, "segment set of a resource class; typically represents a set of rows of a table in the database");
        setLocalizedDescription(SPANISH, "conjunto de segmentos de una clase de recursos; normalmente representa un conjunto de filas de una tabla en la base de datos");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        esConjuntoEspecial.setInitialValue(false);
        esConjuntoEspecial.setDefaultValue(usuarioSupervisor.isNotNull().or(nombreClaseFabricador.isNotNull()));
        // <editor-fold defaultstate="collapsed" desc="localization of ConjuntoSegmento's properties">
        codigoConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set code");
        codigoConjuntoSegmento.setLocalizedLabel(SPANISH, "código del conjunto de segmentos");
        codigoConjuntoSegmento.setLocalizedShortLabel(ENGLISH, "code");
        codigoConjuntoSegmento.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombreConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set name");
        nombreConjuntoSegmento.setLocalizedLabel(SPANISH, "nombre del conjunto de segmentos");
        nombreConjuntoSegmento.setLocalizedShortLabel(ENGLISH, "name");
        nombreConjuntoSegmento.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        descripcionConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set description");
        descripcionConjuntoSegmento.setLocalizedLabel(SPANISH, "descripción del conjunto de segmentos");
        descripcionConjuntoSegmento.setLocalizedShortLabel(ENGLISH, "description");
        descripcionConjuntoSegmento.setLocalizedShortLabel(SPANISH, "descripción");
        /**/
        claseRecurso.setLocalizedLabel(ENGLISH, "resource class");
        claseRecurso.setLocalizedLabel(SPANISH, "clase de recurso");
        claseRecurso.setLocalizedShortLabel(ENGLISH, "class");
        claseRecurso.setLocalizedShortLabel(SPANISH, "clase");
        /**/
        usuarioSupervisor.setLocalizedLabel(ENGLISH, "supervisor");
        usuarioSupervisor.setLocalizedLabel(SPANISH, "usuario supervisor");
        /**/
        nombreClaseFabricador.setLocalizedLabel(ENGLISH, "factory class");
        nombreClaseFabricador.setLocalizedLabel(SPANISH, "nombre clase fabricador");
        /**/
        esConjuntoEspecial.setLocalizedLabel(ENGLISH, "special set");
        esConjuntoEspecial.setLocalizedLabel(SPANISH, "conjunto especial");
        // </editor-fold>
    }

    protected Segment modificables;

    protected Check check101;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        modificables = not(esConjuntoEspecial);
        check101 = claseRecurso.esClaseRecursoSegmento.isTrue();

        // <editor-fold defaultstate="collapsed" desc="localization of ConjuntoSegmento's expressions">
        modificables.setLocalizedDescription(ENGLISH, "the set is not a basic configuration set");
        modificables.setLocalizedDescription(SPANISH, "el conjunto no es un conjunto de configuración básica del sistema");
        modificables.setLocalizedErrorMessage(ENGLISH, "the set is a basic configuration set; "
            + "it can't be modified or deleted");
        modificables.setLocalizedErrorMessage(SPANISH, "el conjunto es un conjunto de configuración básica del sistema; "
            + "no se permite modificarlo ni eliminarlo");
        /**/
        check101.setLocalizedLabel(ENGLISH, "verify resource class");
        check101.setLocalizedLabel(SPANISH, "chequear clase de recurso");
        check101.setLocalizedDescription(ENGLISH, "the resource class must be a class used to segment");
        check101.setLocalizedDescription(SPANISH, "la clase de recurso debe ser una clase utilizada para segmentar");
        check101.setLocalizedErrorMessage(ENGLISH, "the resource class is not a class used to segment");
        check101.setLocalizedErrorMessage(SPANISH, "la clase de recurso no es una clase utilizada para segmentar");
        // </editor-fold>
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        setUpdateFilter(modificables);
        setDeleteFilter(modificables);
        claseRecurso.setSearchQueryFilter(check101);
    }

}
