/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.VariantString;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Segment;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.FALSE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE)
@EntityInsertOperation(enabled = Kleenean.TRUE)
@EntityUpdateOperation(enabled = Kleenean.TRUE)
@EntityDeleteOperation(enabled = Kleenean.TRUE)
@EntityTableView(enabled = Kleenean.FALSE)
@EntityDetailView(enabled = Kleenean.FALSE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class ElementoSegmento extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private ElementoSegmento() {
        this(null, null);
    }

    public ElementoSegmento(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @VariantString
    @PropertyField(table = Kleenean.TRUE, detail = Kleenean.TRUE, create = Kleenean.TRUE, update = Kleenean.TRUE, required = Kleenean.TRUE, search = Kleenean.FALSE)
    public StringProperty segmento;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty segmentoEnteroGrande;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idSegmento;

    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty codigoSegmento;

    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty nombreSegmento;

    @ForeignKey(onDelete = OnDeleteAction.CASCADE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.BIDIRECTIONAL, view = MasterDetailView.TABLE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public ConjuntoSegmento conjuntoSegmento;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of ElementoSegmento's attributes">
        setLocalizedLabel(ENGLISH, "segment set element");
        setLocalizedLabel(SPANISH, "elemento del conjunto de segmentos");
        setLocalizedShortLabel(ENGLISH, "element");
        setLocalizedShortLabel(SPANISH, "elemento");
        setLocalizedCollectionLabel(ENGLISH, "Segment Set Elements");
        setLocalizedCollectionLabel(SPANISH, "Elementos del Conjunto de Segmentos");
        setLocalizedCollectionShortLabel(ENGLISH, "Elements");
        setLocalizedCollectionShortLabel(SPANISH, "Elementos");
        setLocalizedDescription(ENGLISH, "segment set element; typically represents a row of a table in the database");
        setLocalizedDescription(SPANISH, "elemento de conjunto de segmentos; normalmente representa una fila de una tabla en la base de datos");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of ElementoSegmento's properties">
        segmento.setLocalizedLabel(ENGLISH, "segment");
        segmento.setLocalizedLabel(SPANISH, "segmento");
        /**/
        segmentoEnteroGrande.setLocalizedLabel(ENGLISH, "segment");
        segmentoEnteroGrande.setLocalizedLabel(SPANISH, "segmento");
        /**/
        idSegmento.setLocalizedLabel(ENGLISH, "segment");
        idSegmento.setLocalizedLabel(SPANISH, "segmento");
        /**/
        codigoSegmento.setLocalizedLabel(ENGLISH, "segment");
        codigoSegmento.setLocalizedLabel(SPANISH, "segmento");
        /**/
        nombreSegmento.setLocalizedLabel(ENGLISH, "segment name");
        nombreSegmento.setLocalizedLabel(SPANISH, "nombre del segmento");
        /**/
        conjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set");
        conjuntoSegmento.setLocalizedLabel(SPANISH, "conjunto de segmentos");
        conjuntoSegmento.setLocalizedShortLabel(ENGLISH, "set");
        conjuntoSegmento.setLocalizedShortLabel(SPANISH, "conjunto");
        // </editor-fold>
    }

    protected Key uk_elemento_segmento_0001;

    @Override
    protected void settleKeys() {
        super.settleKeys();
        uk_elemento_segmento_0001.setUnique(true);
        uk_elemento_segmento_0001.newKeyField(conjuntoSegmento, segmentoEnteroGrande);
    }

    protected Segment modificables;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        modificables = not(conjuntoSegmento.esConjuntoEspecial);
        // <editor-fold defaultstate="collapsed" desc="localization of ElementoSegmento's expressions">
        modificables.setLocalizedDescription(ENGLISH, "the set is not a basic configuration set");
        modificables.setLocalizedDescription(SPANISH, "el conjunto no es un conjunto de configuración básica del sistema");
        modificables.setLocalizedErrorMessage(ENGLISH, "the set is a basic configuration set; "
            + "it can't be modified or deleted");
        modificables.setLocalizedErrorMessage(SPANISH, "el conjunto es un conjunto de configuración básica del sistema; "
            + "no se permite modificarlo ni eliminarlo");
        // </editor-fold>
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        setMasterDetailFilter(conjuntoSegmento.modificables);
        setInsertFilter(conjuntoSegmento.modificables);
        setUpdateFilter(modificables);
        setDeleteFilter(modificables);
        segmento.setModifyingFilter(conjuntoSegmento.isNotNull());
        idSegmento.setModifyingFilter(conjuntoSegmento.isNotNull());
    }

}
