/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Constants;
import adalid.core.Instance;
import adalid.core.ProcessOperation;
import adalid.core.Tab;
import adalid.core.Transition;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityDocGen;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ImageProperty;
import adalid.core.annotations.InactiveIndicator;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.MimeType;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.OperationLogging;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SpecialCharacterValue;
import adalid.core.enums.UploadStorageOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.interfaces.State;
import adalid.core.parameters.BooleanParameter;
import adalid.core.parameters.IntegerParameter;
import adalid.core.parameters.StringParameter;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.Pagina;
import meta.entidad.comun.configuracion.basica.PaginaEspecial;
import meta.entidad.comun.configuracion.basica.PaginaInicio;

/**
 * @author Jorge Campins
 */
@EntityClass(independent = Kleenean.TRUE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bpl = Kleenean.FALSE, bws = Kleenean.FALSE, fws = Kleenean.FALSE, state = Kleenean.FALSE)
@EntityDocGen(stateDiagram = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, onload = SelectOnloadOption.EXECUTE)
@EntityInsertOperation(enabled = Kleenean.TRUE)
@EntityUpdateOperation(enabled = Kleenean.TRUE)
@EntityDeleteOperation(enabled = Kleenean.TRUE)
@EntityTableView(enabled = Kleenean.TRUE, inserts = Kleenean.TRUE, updates = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.TRUE)
@EntityTriggers(afterValue = Kleenean.TRUE)
public class Usuario extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private Usuario() {
        this(null, null);
    }

    public Usuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @PropertyField(update = Kleenean.FALSE)
    public StringProperty codigoUsuario;

    @NameProperty
    public StringProperty nombreUsuario;

    @PropertyField(auditable = Kleenean.FALSE, password = Kleenean.TRUE, hidden = Kleenean.TRUE, filter = Kleenean.FALSE, sort = Kleenean.FALSE)
    @StringField(maxLength = 128)
    public StringProperty passwordUsuario;

    @StringField(maxLength = 100)
    @PropertyField(table = Kleenean.FALSE, report = Kleenean.FALSE)
    public StringProperty correoElectronico;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE, report = Kleenean.TRUE, overlay = Kleenean.TRUE)
    public BooleanProperty esSuperUsuario;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE, report = Kleenean.TRUE, overlay = Kleenean.TRUE)
    public BooleanProperty esUsuarioEspecial;

    @InactiveIndicator
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE, report = Kleenean.TRUE, overlay = Kleenean.TRUE)
    public BooleanProperty esUsuarioInactivo;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, hidden = Kleenean.TRUE)
    public BooleanProperty esUsuarioModificado;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public BooleanProperty esUsuarioAutomatico;

    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public TimestampProperty fechaHoraRegistro;

    @Allocation(maxDepth = 1, maxRound = 0)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE, report = Kleenean.TRUE, overlay = Kleenean.TRUE)
    public Usuario usuarioSupervisor;

    @ImageProperty(displayHeight = 120)
    @PropertyField(table = Kleenean.TRUE)
    public BinaryProperty octetos;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty limiteArchivoDetalle;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty limiteArchivoResumen;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty limiteInformeDetalle;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty limiteInformeResumen;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty limiteInformeGrafico;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty menusRestringidos;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty operadoresRestringidos;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty filtrosRestringidos;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty vistasRestringidas;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty descargasRestringidas;

    @Allocation(maxDepth = 1, maxRound = 0)
    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public PaginaInicio paginaInicio;

    @Allocation(maxDepth = 2, maxRound = 0)
    @ColumnField(nullable = Kleenean.TRUE)
//  @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public Pagina paginaMenu;

    @Allocation(maxDepth = 1, maxRound = 0)
    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public PaginaEspecial otraPagina;

    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    @StringField(maxLength = 100)
    public StringProperty temaInterfaz;

    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public IntegerProperty filasPorPagina;

    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public BooleanProperty ayudaPorCampos;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of Usuario's attributes">
        setLocalizedLabel(ENGLISH, "user");
        setLocalizedLabel(SPANISH, "usuario");
        setLocalizedCollectionLabel(ENGLISH, "Users");
        setLocalizedCollectionLabel(SPANISH, "Usuarios");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        esSuperUsuario.setInitialValue(false);
        esSuperUsuario.setDefaultValue(false);
        esUsuarioEspecial.setInitialValue(false);
        esUsuarioEspecial.setDefaultValue(false);
        esUsuarioInactivo.setInitialValue(false);
        esUsuarioInactivo.setDefaultValue(false);
        esUsuarioModificado.setInitialValue(false);
        esUsuarioModificado.setDefaultValue(false);
        esUsuarioAutomatico.setInitialValue(false);
        esUsuarioAutomatico.setDefaultValue(false);
        limiteArchivoDetalle.setInitialValue(10000);
        limiteArchivoDetalle.setDefaultValue(10000);
        limiteArchivoDetalle.setMinValue(0);
        limiteArchivoDetalle.setMaxValue(1000000);
        limiteArchivoResumen.setInitialValue(10000);
        limiteArchivoResumen.setDefaultValue(10000);
        limiteArchivoResumen.setMinValue(0);
        limiteArchivoResumen.setMaxValue(1000000);
        limiteInformeDetalle.setInitialValue(10000);
        limiteInformeDetalle.setDefaultValue(10000);
        limiteInformeDetalle.setMinValue(0);
        limiteInformeDetalle.setMaxValue(1000000);
        limiteInformeResumen.setInitialValue(10000);
        limiteInformeResumen.setDefaultValue(10000);
        limiteInformeResumen.setMinValue(0);
        limiteInformeResumen.setMaxValue(1000000);
        limiteInformeGrafico.setInitialValue(10000);
        limiteInformeGrafico.setDefaultValue(10000);
        limiteInformeGrafico.setMinValue(0);
        limiteInformeGrafico.setMaxValue(1000000);
        menusRestringidos.setInitialValue(false);
        menusRestringidos.setDefaultValue(false);
        operadoresRestringidos.setInitialValue(false);
        operadoresRestringidos.setDefaultValue(false);
        filtrosRestringidos.setInitialValue(false);
        filtrosRestringidos.setDefaultValue(false);
        vistasRestringidas.setInitialValue(false);
        vistasRestringidas.setDefaultValue(false);
        descargasRestringidas.setInitialValue(false);
        descargasRestringidas.setDefaultValue(false);
        paginaInicio.setDefaultValue(paginaInicio.PREDETERMINADA);
        paginaInicio.setInitialValue(paginaInicio.PREDETERMINADA);
        filasPorPagina.setDefaultValue(0);
        filasPorPagina.setMaxValue(Constants.MAXIMUM_ROWS_PER_PAGE_LIMIT);
        filasPorPagina.setMinValue(0);
        ayudaPorCampos.setDefaultValue(true);
        // <editor-fold defaultstate="collapsed" desc="localization of Usuario's properties">
        codigoUsuario.setLocalizedLabel(ENGLISH, "user code");
        codigoUsuario.setLocalizedLabel(SPANISH, "código del usuario");
        codigoUsuario.setLocalizedShortLabel(ENGLISH, "code");
        codigoUsuario.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombreUsuario.setLocalizedLabel(ENGLISH, "user name");
        nombreUsuario.setLocalizedLabel(SPANISH, "nombre del usuario");
        nombreUsuario.setLocalizedShortLabel(ENGLISH, "name");
        nombreUsuario.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        passwordUsuario.setLocalizedLabel(ENGLISH, "user password");
        passwordUsuario.setLocalizedLabel(SPANISH, "password usuario");
        passwordUsuario.setLocalizedShortLabel(ENGLISH, "password");
        passwordUsuario.setLocalizedShortLabel(SPANISH, "contraseña");
        /**/
        correoElectronico.setLocalizedLabel(ENGLISH, "e-mail");
        correoElectronico.setLocalizedLabel(SPANISH, "correo electronico");
        /**/
        esSuperUsuario.setLocalizedLabel(ENGLISH, "super user");
        esSuperUsuario.setLocalizedLabel(SPANISH, "súper usuario");
        esSuperUsuario.setLocalizedShortLabel(ENGLISH, "super");
        esSuperUsuario.setLocalizedShortLabel(SPANISH, "súper");
        esSuperUsuario.setLocalizedDescription(ENGLISH, "designated as super-user");
        esSuperUsuario.setLocalizedDescription(SPANISH, "designado como súper-usuario");
        /**/
        esUsuarioEspecial.setLocalizedLabel(ENGLISH, "special user");
        esUsuarioEspecial.setLocalizedLabel(SPANISH, "usuario especial");
        esUsuarioEspecial.setLocalizedShortLabel(ENGLISH, "special");
        esUsuarioEspecial.setLocalizedShortLabel(SPANISH, "especial");
        esUsuarioEspecial.setLocalizedDescription(ENGLISH, "special user");
        esUsuarioEspecial.setLocalizedDescription(SPANISH, "usuario especial");
        /**/
        esUsuarioInactivo.setLocalizedLabel(ENGLISH, "inactive user");
        esUsuarioInactivo.setLocalizedLabel(SPANISH, "usuario inactivo");
        esUsuarioInactivo.setLocalizedShortLabel(ENGLISH, "inactive");
        esUsuarioInactivo.setLocalizedShortLabel(SPANISH, "inactivo");
        esUsuarioInactivo.setLocalizedDescription(ENGLISH, "inactive user");
        esUsuarioInactivo.setLocalizedDescription(SPANISH, "usuario inactivo");
        /**/
        esUsuarioModificado.setLocalizedLabel(ENGLISH, "modified user");
        esUsuarioModificado.setLocalizedLabel(SPANISH, "usuario modificado");
        esUsuarioModificado.setLocalizedShortLabel(ENGLISH, "modified");
        esUsuarioModificado.setLocalizedShortLabel(SPANISH, "modificado");
        esUsuarioModificado.setLocalizedDescription(ENGLISH, "modified user");
        esUsuarioModificado.setLocalizedDescription(SPANISH, "usuario modificado");
        /**/
        esUsuarioAutomatico.setLocalizedLabel(ENGLISH, "automatically registered user");
        esUsuarioAutomatico.setLocalizedLabel(SPANISH, "usuario registrado automáticamente");
        esUsuarioAutomatico.setLocalizedShortLabel(ENGLISH, "automatic");
        esUsuarioAutomatico.setLocalizedShortLabel(SPANISH, "automático");
        esUsuarioAutomatico.setLocalizedDescription(ENGLISH, "automatically registered user");
        esUsuarioAutomatico.setLocalizedDescription(SPANISH, "usuario registrado automáticamente");
        /**/
        fechaHoraRegistro.setLocalizedLabel(ENGLISH, "automatic registration timestamp");
        fechaHoraRegistro.setLocalizedLabel(SPANISH, "fecha/hora registro automático");
        fechaHoraRegistro.setLocalizedShortLabel(ENGLISH, "registration timestamp");
        fechaHoraRegistro.setLocalizedShortLabel(SPANISH, "fecha/hora registro");
        fechaHoraRegistro.setLocalizedDescription(ENGLISH, "automatic registration timestamp");
        fechaHoraRegistro.setLocalizedDescription(SPANISH, "fecha/hora de registro automático");
        /**/
        usuarioSupervisor.setLocalizedLabel(ENGLISH, "supervisor");
        usuarioSupervisor.setLocalizedLabel(SPANISH, "usuario supervisor");
        usuarioSupervisor.setLocalizedShortLabel(ENGLISH, "supervisor");
        usuarioSupervisor.setLocalizedShortLabel(SPANISH, "supervisor");
        usuarioSupervisor.setLocalizedDescription(ENGLISH, "user that supervises this user");
        usuarioSupervisor.setLocalizedDescription(SPANISH, "usuario que supervisa a este usuario");
        usuarioSupervisor.setLocalizedTooltip(ENGLISH, "supervisor code");
        usuarioSupervisor.setLocalizedTooltip(SPANISH, "código del usuario supervisor");
        /**/
        octetos.setLocalizedLabel(ENGLISH, "portrait");
        octetos.setLocalizedLabel(SPANISH, "retrato");
        octetos.setLocalizedTooltip(ENGLISH, "user portrait");
        octetos.setLocalizedTooltip(SPANISH, "retrato del usuario");
        /**/
        limiteArchivoDetalle.setLocalizedLabel(ENGLISH, "detailed file limit");
        limiteArchivoDetalle.setLocalizedLabel(SPANISH, "limite archivo detalle");
        limiteArchivoDetalle.setLocalizedDescription(ENGLISH, "limit of rows of user-defined views that the user can save in files of type \"Detail\"; if it is 0 the user has no limit");
        limiteArchivoDetalle.setLocalizedDescription(SPANISH, "límite de filas al guardar los resultados de la consulta, mediante vistas definidas por el usuario, en archivos de tipo \"Detalle\"; si es 0 el usuario no tiene límite");
        limiteArchivoDetalle.setLocalizedTooltip(ENGLISH, "limit of rows for files of type \"Detail\"");
        limiteArchivoDetalle.setLocalizedTooltip(SPANISH, "límite de filas para archivos de tipo \"Detalle\"");
        /**/
        limiteArchivoResumen.setLocalizedLabel(ENGLISH, "summary file limit");
        limiteArchivoResumen.setLocalizedLabel(SPANISH, "limite archivo resumen");
        limiteArchivoResumen.setLocalizedDescription(ENGLISH, "limit of rows of user-defined views that the user can save in files of type \"Summary\"; if it is 0 the user has no limit");
        limiteArchivoResumen.setLocalizedDescription(SPANISH, "límite de filas al guardar los resultados de la consulta, mediante vistas definidas por el usuario, en archivos de tipo \"Resumen\"; si es 0 el usuario no tiene límite");
        limiteArchivoResumen.setLocalizedTooltip(ENGLISH, "limit of rows for files of type \"Summary\"");
        limiteArchivoResumen.setLocalizedTooltip(SPANISH, "límite de filas para archivos de tipo \"Resumen\"");
        /**/
        limiteInformeDetalle.setLocalizedLabel(ENGLISH, "detailed report limit");
        limiteInformeDetalle.setLocalizedLabel(SPANISH, "limite informe detalle");
        limiteInformeDetalle.setLocalizedDescription(ENGLISH, "limit of rows of user-defined views that the user can save in reports of type \"Detail\"; if it is 0 the user has no limit");
        limiteInformeDetalle.setLocalizedDescription(SPANISH, "límite de filas al guardar los resultados de la consulta, mediante vistas definidas por el usuario, en informes de tipo \"Detalle\"; si es 0 el usuario no tiene límite");
        limiteInformeDetalle.setLocalizedTooltip(ENGLISH, "limit of rows for reports of type \"Detail\"");
        limiteInformeDetalle.setLocalizedTooltip(SPANISH, "límite de filas para informes de tipo \"Detalle\"");
        /**/
        limiteInformeResumen.setLocalizedLabel(ENGLISH, "summary report limit");
        limiteInformeResumen.setLocalizedLabel(SPANISH, "limite informe resumen");
        limiteInformeResumen.setLocalizedDescription(ENGLISH, "limit of rows of user-defined views that the user can save in reports of type \"Summary\"; if it is 0 the user has no limit");
        limiteInformeResumen.setLocalizedDescription(SPANISH, "límite de filas al guardar los resultados de la consulta, mediante vistas definidas por el usuario, en informes de tipo \"Resumen\"; si es 0 el usuario no tiene límite");
        limiteInformeResumen.setLocalizedTooltip(ENGLISH, "limit of rows for reports of type \"Summary\"");
        limiteInformeResumen.setLocalizedTooltip(SPANISH, "límite de filas para informes de tipo \"Resumen\"");
        /**/
        limiteInformeGrafico.setLocalizedLabel(ENGLISH, "chart report limit");
        limiteInformeGrafico.setLocalizedLabel(SPANISH, "limite informe grafico");
        limiteInformeGrafico.setLocalizedDescription(ENGLISH, "limit of rows of user-defined views that the user can save in reports of type \"Chart\"; if it is 0 the user has no limit");
        limiteInformeGrafico.setLocalizedDescription(SPANISH, "límite de filas al guardar los resultados de la consulta, mediante vistas definidas por el usuario, en informes de tipo \"Gráfico\"; si es 0 el usuario no tiene límite");
        limiteInformeGrafico.setLocalizedTooltip(ENGLISH, "limit of rows for reports of type \"Chart\"");
        limiteInformeGrafico.setLocalizedTooltip(SPANISH, "límite de filas para informes de tipo \"Gráfico\"");
        /**/
        menusRestringidos.setLocalizedLabel(ENGLISH, "restricted menus");
        menusRestringidos.setLocalizedLabel(SPANISH, "menus restringidos");
        menusRestringidos.setLocalizedDescription(ENGLISH, "restricted access to menus");
        menusRestringidos.setLocalizedDescription(SPANISH, "acceso restringido a menús");
        /**/
        operadoresRestringidos.setLocalizedLabel(ENGLISH, "restricted operators");
        operadoresRestringidos.setLocalizedLabel(SPANISH, "operadores restringidos");
        operadoresRestringidos.setLocalizedDescription(ENGLISH, "restricted access to comparison operators in search criteria");
        operadoresRestringidos.setLocalizedDescription(SPANISH, "acceso restringido a operadores de comparación en criterios de búsqueda");
        operadoresRestringidos.setLocalizedTooltip(ENGLISH, "restricted access to comparison operators");
        operadoresRestringidos.setLocalizedTooltip(SPANISH, "acceso restringido a operadores de comparación");
        /**/
        filtrosRestringidos.setLocalizedLabel(ENGLISH, "restricted filters");
        filtrosRestringidos.setLocalizedLabel(SPANISH, "filtros restringidos");
        filtrosRestringidos.setLocalizedDescription(ENGLISH, "restricted access to query filters");
        filtrosRestringidos.setLocalizedDescription(SPANISH, "acceso restringido a filtros de búsqueda");
        /**/
        vistasRestringidas.setLocalizedLabel(ENGLISH, "restricted views");
        vistasRestringidas.setLocalizedLabel(SPANISH, "vistas restringidas");
        vistasRestringidas.setLocalizedDescription(ENGLISH, "restricted access to generate files and reports");
        vistasRestringidas.setLocalizedDescription(SPANISH, "acceso restringido para generar archivos e informes");
        vistasRestringidas.setLocalizedTooltip(ENGLISH, "restricted access to files and reports");
        vistasRestringidas.setLocalizedTooltip(SPANISH, "acceso restringido a archivos e informes");
        /**/
        descargasRestringidas.setLocalizedLabel(ENGLISH, "restricted downloads");
        descargasRestringidas.setLocalizedLabel(SPANISH, "descargas restringidas");
        descargasRestringidas.setLocalizedDescription(ENGLISH, "restricted access to download files");
        descargasRestringidas.setLocalizedDescription(SPANISH, "acceso restringido para descargar archivos");
        descargasRestringidas.setLocalizedTooltip(ENGLISH, "restricted access to file downloads");
        descargasRestringidas.setLocalizedTooltip(SPANISH, "acceso restringido a descargas de archivos");
        /**/
        paginaInicio.setLocalizedLabel(ENGLISH, "landing page");
        paginaInicio.setLocalizedLabel(SPANISH, "página de inicio");
        /**/
        paginaMenu.setLocalizedLabel(ENGLISH, "menu page");
        paginaMenu.setLocalizedLabel(SPANISH, "página del menú");
        paginaMenu.setLocalizedDescription(ENGLISH, "page to be used as home page; must be specified if landing page is \"Menu page\"");
        paginaMenu.setLocalizedDescription(SPANISH, "página que se ha de utilizar como página de inicio; se debe especificar si página de inicio es \"Página del menú\"");
        /**/
        otraPagina.setLocalizedLabel(ENGLISH, "other page");
        otraPagina.setLocalizedLabel(SPANISH, "otra página");
        otraPagina.setLocalizedDescription(ENGLISH, "special page to be used as home page; must be specified if landing page is \"Other page\"");
        otraPagina.setLocalizedDescription(SPANISH, "página especial que se ha de utilizar como página de inicio; se debe especificar si página de inicio es \"Otra página\"");
        /**/
        temaInterfaz.setLocalizedLabel(ENGLISH, "user interface theme");
        temaInterfaz.setLocalizedLabel(SPANISH, "tema de la interfaz");
        /**/
        filasPorPagina.setLocalizedLabel(ENGLISH, "rows per page");
        filasPorPagina.setLocalizedLabel(SPANISH, "filas por página");
        filasPorPagina.setLocalizedDescription(ENGLISH, "initial number of rows per page");
        filasPorPagina.setLocalizedDescription(SPANISH, "número inicial de filas por página de presentación tabular");
        /**/
        ayudaPorCampos.setLocalizedLabel(ENGLISH, "inline help");
        ayudaPorCampos.setLocalizedLabel(SPANISH, "ayuda en línea");
        ayudaPorCampos.setLocalizedDescription(ENGLISH, "show the descriptions of the fields on the page");
        ayudaPorCampos.setLocalizedDescription(SPANISH, "mostrar las descripciones de los campos de la página");
        // </editor-fold>
    }

    protected Tab tab10, tab20, tab30, tab40;

    @Override
    protected void settleTabs() {
        super.settleTabs();
        tab10.newTabField(octetos, correoElectronico, esSuperUsuario, esUsuarioEspecial, esUsuarioInactivo, esUsuarioAutomatico, fechaHoraRegistro, usuarioSupervisor);
        tab20.newTabField(limiteArchivoDetalle, limiteArchivoResumen, limiteInformeDetalle, limiteInformeResumen, limiteInformeGrafico);
        tab30.newTabField(menusRestringidos, operadoresRestringidos, filtrosRestringidos, vistasRestringidas, descargasRestringidas);
        tab40.newTabField(paginaInicio, paginaMenu, otraPagina, temaInterfaz, filasPorPagina, ayudaPorCampos);
        // <editor-fold defaultstate="collapsed" desc="localization of Usuario's tabs">
        tab10.setLocalizedLabel(ENGLISH, "general");
        tab10.setLocalizedLabel(SPANISH, "general");
        /**/
        tab20.setLocalizedLabel(ENGLISH, "limits");
        tab20.setLocalizedLabel(SPANISH, "límites");
        /**/
        tab30.setLocalizedLabel(ENGLISH, "restrictions");
        tab30.setLocalizedLabel(SPANISH, "restricciones");
        /**/
        tab40.setLocalizedLabel(ENGLISH, "settings");
        tab40.setLocalizedLabel(SPANISH, "configuración");
        // </editor-fold>
    }

    public Instance ADMINISTRADOR;

    public Instance AUDITOR;

    public Instance OPERADOR;

    /**
     * Administrator user instance getter (for velocity templates)
     *
     * @return the administrator user instance
     */
    public Instance getAdministratorUserInstance() {
        return ADMINISTRADOR;
    }

    /**
     * Auditor user instance getter (for velocity templates)
     *
     * @return the auditor user instance
     */
    public Instance getAuditorUserInstance() {
        return AUDITOR;
    }

    /**
     * Basic user instance getter (for velocity templates)
     *
     * @return the basic user instance
     */
    public Instance getBasicUserInstance() {
        return OPERADOR;
    }

    @Override
    protected void settleInstances() {
        super.settleInstances();
        ADMINISTRADOR.newInstanceField(id, 101);
        ADMINISTRADOR.newInstanceField(codigoUsuario, "admin");
        ADMINISTRADOR.newInstanceField(nombreUsuario, "Administrador");
        ADMINISTRADOR.newInstanceField(passwordUsuario, "sesamo");
        ADMINISTRADOR.newInstanceField(esSuperUsuario, true);
        ADMINISTRADOR.newInstanceField(esUsuarioEspecial, true);
        AUDITOR.newInstanceField(id, 102);
        AUDITOR.newInstanceField(codigoUsuario, "audit");
        AUDITOR.newInstanceField(nombreUsuario, "Auditor");
        AUDITOR.newInstanceField(passwordUsuario, "sesamo");
        AUDITOR.newInstanceField(esSuperUsuario, false);
        AUDITOR.newInstanceField(esUsuarioEspecial, true);
        OPERADOR.newInstanceField(id, 103);
        OPERADOR.newInstanceField(codigoUsuario, "oper");
        OPERADOR.newInstanceField(nombreUsuario, "Operador");
        OPERADOR.newInstanceField(passwordUsuario, "sesamo");
        OPERADOR.newInstanceField(esSuperUsuario, false);
        OPERADOR.newInstanceField(esUsuarioEspecial, true);
        // <editor-fold defaultstate="collapsed" desc="localization of Usuario's instances">
        ADMINISTRADOR.newInstanceField(codigoUsuario, "admin", ENGLISH);
        ADMINISTRADOR.newInstanceField(codigoUsuario, "admin", SPANISH);
        /**/
        ADMINISTRADOR.newInstanceField(nombreUsuario, "Administrator", ENGLISH);
        ADMINISTRADOR.newInstanceField(nombreUsuario, "Administrador", SPANISH);
        /**/
        AUDITOR.newInstanceField(codigoUsuario, "audit", ENGLISH);
        AUDITOR.newInstanceField(codigoUsuario, "audit", SPANISH);
        /**/
        AUDITOR.newInstanceField(nombreUsuario, "Auditor", ENGLISH);
        AUDITOR.newInstanceField(nombreUsuario, "Auditor", SPANISH);
        /**/
        OPERADOR.newInstanceField(codigoUsuario, "oper", ENGLISH);
        OPERADOR.newInstanceField(codigoUsuario, "oper", SPANISH);
        /**/
        OPERADOR.newInstanceField(nombreUsuario, "Operator", ENGLISH);
        OPERADOR.newInstanceField(nombreUsuario, "Operador", SPANISH);
        // </editor-fold>
    }

    protected Segment usuarioActual, demasUsuarios;

    protected Segment usuariosEspeciales, usuariosOrdinarios;

    protected Segment superUsuarios, usuariosEstandar;

    protected Segment usuariosActivos, usuariosInactivos;

    protected Segment conPaginaMenu, conOtraPagina;

    protected Check check101, check102;

    protected State eliminable, modificable, designableComoSuper, superAnulable, desactivable, reactivable;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        usuarioActual = codigoUsuario.isEqualTo(SpecialCharacterValue.CURRENT_USER_CODE);
        demasUsuarios = codigoUsuario.isNotEqualTo(SpecialCharacterValue.CURRENT_USER_CODE);
        usuariosEspeciales = esUsuarioEspecial.isTrue();
        usuariosOrdinarios = esUsuarioEspecial.isFalse();
        superUsuarios = esSuperUsuario.isTrue();
        usuariosEstandar = esSuperUsuario.isFalse();
        usuariosActivos = esUsuarioInactivo.isFalse();
        usuariosInactivos = esUsuarioInactivo.isTrue();
        conPaginaMenu = paginaInicio.isEqualTo(paginaInicio.PAGINA_MENU);
        conOtraPagina = paginaInicio.isEqualTo(paginaInicio.OTRA_PAGINA);
        check101 = conPaginaMenu.implies(paginaMenu.isNotNull());
        check102 = conOtraPagina.implies(otraPagina.isNotNull());
        eliminable = usuariosOrdinarios.and(demasUsuarios);
        modificable = usuariosOrdinarios.and(usuariosActivos);
        reactivable = eliminable.and(usuariosInactivos);
        desactivable = modificable.and(demasUsuarios);
        superAnulable = desactivable.and(superUsuarios);
        designableComoSuper = desactivable.and(usuariosEstandar);
        // <editor-fold defaultstate="collapsed" desc="localization of Usuario's expressions">
        usuarioActual.setLocalizedDescription(ENGLISH, "the user is your own user");
        usuarioActual.setLocalizedDescription(SPANISH, "el usuario es su propio usuario");
        usuarioActual.setLocalizedErrorMessage(ENGLISH, "the user is not your own user");
        usuarioActual.setLocalizedErrorMessage(SPANISH, "el usuario no es su propio usuario");
        /**/
        demasUsuarios.setLocalizedDescription(ENGLISH, "the user is not your own user");
        demasUsuarios.setLocalizedDescription(SPANISH, "el usuario no es su propio usuario");
        demasUsuarios.setLocalizedErrorMessage(ENGLISH, "the user is your own user");
        demasUsuarios.setLocalizedErrorMessage(SPANISH, "el usuario es su propio usuario");
        /**/
        usuariosEspeciales.setLocalizedDescription(ENGLISH, "the user is a special user");
        usuariosEspeciales.setLocalizedDescription(SPANISH, "el usuario es un usuario especial");
        usuariosEspeciales.setLocalizedErrorMessage(ENGLISH, "the user is not a special user");
        usuariosEspeciales.setLocalizedErrorMessage(SPANISH, "el usuario no es un usuario especial");
        /**/
        usuariosOrdinarios.setLocalizedDescription(ENGLISH, "the user is not a special user");
        usuariosOrdinarios.setLocalizedDescription(SPANISH, "el usuario no es un usuario especial");
        usuariosOrdinarios.setLocalizedErrorMessage(ENGLISH, "the user is a special user");
        usuariosOrdinarios.setLocalizedErrorMessage(SPANISH, "el usuario es un usuario especial");
        /**/
        superUsuarios.setLocalizedDescription(ENGLISH, "the user is a super-user");
        superUsuarios.setLocalizedDescription(SPANISH, "el usuario es un súper-usuario");
        superUsuarios.setLocalizedErrorMessage(ENGLISH, "the user is not a super-user");
        superUsuarios.setLocalizedErrorMessage(SPANISH, "el usuario no es un súper-usuario");
        /**/
        usuariosEstandar.setLocalizedDescription(ENGLISH, "the user is not a super-user");
        usuariosEstandar.setLocalizedDescription(SPANISH, "el usuario no es un súper-usuario");
        usuariosEstandar.setLocalizedErrorMessage(ENGLISH, "the user is a super-user");
        usuariosEstandar.setLocalizedErrorMessage(SPANISH, "el usuario es un súper usuario");
        /**/
        usuariosActivos.setLocalizedDescription(ENGLISH, "the user is an active user");
        usuariosActivos.setLocalizedDescription(SPANISH, "el usuario es un usuario activo");
        usuariosActivos.setLocalizedErrorMessage(ENGLISH, "the user is an inactive user");
        usuariosActivos.setLocalizedErrorMessage(SPANISH, "el usuario es un usuario inactivo");
        /**/
        usuariosInactivos.setLocalizedDescription(ENGLISH, "the user is an inactive user");
        usuariosInactivos.setLocalizedDescription(SPANISH, "el usuario es un usuario inactivo");
        usuariosInactivos.setLocalizedErrorMessage(ENGLISH, "the user is an active user");
        usuariosInactivos.setLocalizedErrorMessage(SPANISH, "el usuario es un usuario activo");
        /**/
        conPaginaMenu.setLocalizedDescription(ENGLISH, "landing page is \"Menu page\"");
        conPaginaMenu.setLocalizedDescription(SPANISH, "página de inicio es \"Página del menú\"");
        conPaginaMenu.setLocalizedErrorMessage(ENGLISH, "landing page is not \"Menu page\"");
        conPaginaMenu.setLocalizedErrorMessage(SPANISH, "página de inicio no es \"Página del menú\"");
        /**/
        conOtraPagina.setLocalizedDescription(ENGLISH, "landing page is \"Other page\"");
        conOtraPagina.setLocalizedDescription(SPANISH, "página de inicio es \"Otra página\"");
        conOtraPagina.setLocalizedErrorMessage(ENGLISH, "landing page is not \"Other page\"");
        conOtraPagina.setLocalizedErrorMessage(SPANISH, "página de inicio no es \"Otra página\"");
        /**/
        check101.setLocalizedDescription(ENGLISH, "menu page must be specified if landing page is \"Menu page\"");
        check101.setLocalizedDescription(SPANISH, "página del menú se debe especificar si página de inicio es \"Página del menú\"");
        check101.setLocalizedErrorMessage(ENGLISH, "menu page must be specified if landing page is \"Menu page\"");
        check101.setLocalizedErrorMessage(SPANISH, "página del menú se debe especificar si página de inicio es \"Página del menú\"");
        /**/
        check102.setLocalizedDescription(ENGLISH, "other page must be specified if landing page is \"Other page\"");
        check102.setLocalizedDescription(SPANISH, "otra página se debe especificar si página de inicio es \"Otra página\"");
        check102.setLocalizedErrorMessage(ENGLISH, "other page must be specified if landing page is \"Other page\"");
        check102.setLocalizedErrorMessage(SPANISH, "otra página se debe especificar si página de inicio es \"Otra página\"");
        /**/
        eliminable.setLocalizedDescription(ENGLISH, "deletable");
        eliminable.setLocalizedDescription(SPANISH, "eliminable");
        /**/
        modificable.setLocalizedDescription(ENGLISH, "updatable");
        modificable.setLocalizedDescription(SPANISH, "modificable");
        /**/
        designableComoSuper.setLocalizedDescription(ENGLISH, "designable as super-user");
        designableComoSuper.setLocalizedDescription(SPANISH, "designable como súper-usuario");
        /**/
        superAnulable.setLocalizedDescription(ENGLISH, "designated as super-user");
        superAnulable.setLocalizedDescription(SPANISH, "designado como súper-usuario");
        /**/
        desactivable.setLocalizedDescription(ENGLISH, "active user");
        desactivable.setLocalizedDescription(SPANISH, "usuario activo");
        /**/
        reactivable.setLocalizedDescription(ENGLISH, "inactive user");
        reactivable.setLocalizedDescription(SPANISH, "usuario inactivo");
        // </editor-fold>
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        setUpdateFilter(modificable);
        setDeleteFilter(eliminable);
        paginaMenu.setRenderingFilter(conPaginaMenu);
        otraPagina.setRenderingFilter(conOtraPagina);
    }

    protected Transition designacion, anulacion, desactivacion, reactivacion;

    @Override
    protected void settleTransitions() {
        super.settleTransitions();
        designacion.settle(designableComoSuper, superAnulable);
        anulacion.settle(superAnulable, designableComoSuper);
        desactivacion.settle(desactivable, reactivable);
        reactivacion.settle(reactivable, desactivable);
    }

    protected DesignarSuper designarSuper;

    protected AnularSuper anularSuper;

    protected Desactivar desactivar;

    protected Reactivar reactivar;

    protected Sincronizar sincronizar;

    protected AsignarPassword asignarPassword;

    protected AsignarSupervisor asignarSupervisor;

    protected AnularSupervisor anularSupervisor;

    protected CambiarConfiguracion cambiarConfiguracion;

    protected CambiarPassword cambiarPassword;

    protected CargarRetrato cargarRetrato;

    protected RecortarRetrato recortarRetrato;

    protected TomarRetrato tomarRetrato;

    @Override
    protected void settleOperations() {
        super.settleOperations();
        designarSuper.addTransition(designacion);
        anularSuper.addTransition(anulacion);
        desactivar.addTransition(desactivacion);
        reactivar.addTransition(reactivacion);
//      asignarPassword.addTransition(modificacion);
//      asignarSupervisor.addTransition(modificacion);
    }

    // <editor-fold defaultstate="collapsed" desc="Operations">
    protected Agregar agregar;

    @OperationClass(access = OperationAccess.PRIVATE)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class Agregar extends ProcessOperation {

        @ParameterField(required = Kleenean.TRUE)
        protected StringParameter codigo;

        @ParameterField(required = Kleenean.FALSE)
        protected StringParameter nombre;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Agregar's attributes">
            setLocalizedLabel(ENGLISH, "add");
            setLocalizedLabel(SPANISH, "agregar");
            // </editor-fold>
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Agregar's parameters">
            codigo.setLocalizedLabel(ENGLISH, "code");
            codigo.setLocalizedLabel(SPANISH, "código");
            /**/
            nombre.setLocalizedLabel(ENGLISH, "name");
            nombre.setLocalizedLabel(SPANISH, "nombre");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class DesignarSuper extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of DesignarSuper's attributes">
            setLocalizedLabel(ENGLISH, "designate super");
            setLocalizedLabel(SPANISH, "designar súper");
            setLocalizedDescription(ENGLISH, "Designate a user as a super-user.");
            setLocalizedDescription(SPANISH, "Designa un usuario como súper-usuario.");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of DesignarSuper's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            usuario.setLocalizedDescription(ENGLISH, "Code of the user you want to designate as super-user. It is a required datum and has no default value.");
            usuario.setLocalizedDescription(SPANISH, "Código del usuario que desea designar como súper-usuario. Es un dato obligatorio y no tiene valor por omisión.");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class AnularSuper extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of AnularSuper's attributes">
            setLocalizedLabel(ENGLISH, "annul super");
            setLocalizedLabel(SPANISH, "anular súper");
            setLocalizedDescription(ENGLISH, "Annul the designation of a user as a super-user.");
            setLocalizedDescription(SPANISH, "Anula la designación de un usuario como súper-usuario.");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of AnularSuper's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            usuario.setLocalizedDescription(ENGLISH, "Code of the super-user whose designation you want to annul. It is a required datum and has no default value.");
            usuario.setLocalizedDescription(SPANISH, "Código del súper-usuario cuya designación desea anular. Es un dato obligatorio y no tiene valor por omisión.");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class Desactivar extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Desactivar's attributes">
            setLocalizedLabel(ENGLISH, "deactivate");
            setLocalizedLabel(SPANISH, "desactivar");
            setLocalizedDescription(ENGLISH, "Deactivate an active user.");
            setLocalizedDescription(SPANISH, "Desactiva un usuario activo.");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Desactivar's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            usuario.setLocalizedDescription(ENGLISH, "Code of the user you want to deactivate. It is a required datum and has no default value.");
            usuario.setLocalizedDescription(SPANISH, "Código del usuario que desea desactivar. Es un dato obligatorio y no tiene valor por omisión.");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class Reactivar extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Reactivar's attributes">
            setLocalizedLabel(ENGLISH, "reactivate");
            setLocalizedLabel(SPANISH, "reactivar");
            setLocalizedDescription(ENGLISH, "Reactivate an inactive user.");
            setLocalizedDescription(SPANISH, "Reactiva un usuario inactivo.");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Reactivar's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            usuario.setLocalizedDescription(ENGLISH, "Code of the user you want to reactivate. It is a required datum and has no default value.");
            usuario.setLocalizedDescription(SPANISH, "Código del usuario que desea reactivar. Es un dato obligatorio y no tiene valor por omisión.");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PROTECTED, logging = OperationLogging.FAILURE)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class Sincronizar extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Sincronizar's attributes">
            setLocalizedLabel(ENGLISH, "synchronize");
            setLocalizedLabel(SPANISH, "sincronizar");
            setLocalizedDescription(ENGLISH, "Synchronize the authorizations of a user. The user's authorizations will be updated the next time the user starts a session.");
            setLocalizedDescription(SPANISH, "Sincroniza las autorizaciones de un usuario. Las autorizaciones del usuario serán actualizadas la próxima vez que el usuario inicie una sesión de trabajo.");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Sincronizar's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            usuario.setLocalizedDescription(ENGLISH, "Code of the user you want to synchronize. It is a required datum and has no default value.");
            usuario.setLocalizedDescription(SPANISH, "Código del usuario que desea sincronizar. Es un dato obligatorio y no tiene valor por omisión.");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class AsignarPassword extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of AsignarPassword's attributes">
            setLocalizedLabel(ENGLISH, "assign password");
            setLocalizedLabel(SPANISH, "asignar password");
            setLocalizedDescription(ENGLISH, "Assign a new password to a user.");
            setLocalizedDescription(SPANISH, "Asigna una nueva contraseña a un usuario.");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @ParameterField(auditable = Kleenean.FALSE, password = Kleenean.TRUE, required = Kleenean.TRUE)
        @StringField(maxLength = 32)
        protected StringParameter password;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of AsignarPassword's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            usuario.setLocalizedDescription(ENGLISH, "Code of the user you want to assign a new password. It is a required datum and has no default value.");
            usuario.setLocalizedDescription(SPANISH, "Código del usuario al que desea asignar una nueva contraseña. Es un dato obligatorio y no tiene valor por omisión.");
            /**/
            password.setLocalizedLabel(ENGLISH, "password");
            password.setLocalizedLabel(SPANISH, "contraseña");
            password.setLocalizedDescription(ENGLISH, "New password. It is a required datum and has no default value.");
            password.setLocalizedDescription(SPANISH, "Nueva contraseña. Es un dato obligatorio y no tiene valor por omisión.");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class AsignarSupervisor extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of AsignarSupervisor's attributes">
            setLocalizedLabel(ENGLISH, "assign supervisor");
            setLocalizedLabel(SPANISH, "asignar supervisor");
            setLocalizedDescription(ENGLISH, "Assign a new supervisor to a user.");
            setLocalizedDescription(SPANISH, "Asigna un nuevo supervisor a un usuario.");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @ParameterField(required = Kleenean.TRUE)
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario supervisor;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of AsignarSupervisor's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            usuario.setLocalizedDescription(ENGLISH, "Code of the user you want to assign a new supervisor. It is a required datum and has no default value.");
            usuario.setLocalizedDescription(SPANISH, "Código del usuario al que desea asignar un nuevo supervisor. Es un dato obligatorio y no tiene valor por omisión.");
            /**/
            supervisor.setLocalizedLabel(ENGLISH, "supervisor");
            supervisor.setLocalizedLabel(SPANISH, "supervisor");
            supervisor.setLocalizedDescription(ENGLISH, "User code of the new supervisor. It is a required datum and has no default value.");
            supervisor.setLocalizedDescription(SPANISH, "Código de usuario del nuevo supervisor. Es un dato obligatorio y no tiene valor por omisión.");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PROTECTED)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class AnularSupervisor extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of AnularSupervisor's attributes">
            setLocalizedLabel(ENGLISH, "annul supervisor");
            setLocalizedLabel(SPANISH, "anular supervisor");
            setLocalizedDescription(ENGLISH, "Annul the supervisor to a user.");
            setLocalizedDescription(SPANISH, "Anula el supervisor a un usuario.");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of AnularSupervisor's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            usuario.setLocalizedDescription(ENGLISH, "Code of the user whose supervisor you want to annul. It is a required datum and has no default value.");
            usuario.setLocalizedDescription(SPANISH, "Código del usuario cuyo supervisor desea anular. Es un dato obligatorio y no tiene valor por omisión.");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PRIVATE)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class CambiarConfiguracion extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of CambiarConfiguracion's attributes">
            setLocalizedLabel(ENGLISH, "change settings");
            setLocalizedLabel(SPANISH, "cambiar configuración");
            // </editor-fold>
        }

        @InstanceReference
        protected Usuario usuario;

        @ParameterField(required = Kleenean.TRUE)
        protected PaginaInicio paginaInicio;

        @ParameterField
        protected Pagina paginaMenu;

        @ParameterField
        protected PaginaEspecial otraPagina;

        @ParameterField(required = Kleenean.TRUE)
        protected StringParameter tema;

        @ParameterField(required = Kleenean.TRUE)
        protected IntegerParameter filasPorPagina;

        @ParameterField(required = Kleenean.TRUE)
        protected BooleanParameter ayudaPorCampos;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            paginaInicio.setDefaultValue(paginaInicio.PREDETERMINADA);
            paginaInicio.setInitialValue(usuario.paginaInicio);
            paginaMenu.setInitialValue(usuario.paginaMenu);
            otraPagina.setInitialValue(usuario.otraPagina);
            filasPorPagina.setDefaultValue(0);
            filasPorPagina.setInitialValue(usuario.filasPorPagina);
            filasPorPagina.setMaxValue(Constants.MAXIMUM_ROWS_PER_PAGE_LIMIT);
            filasPorPagina.setMinValue(0);
            ayudaPorCampos.setDefaultValue(true);
            ayudaPorCampos.setInitialValue(usuario.ayudaPorCampos);
            // <editor-fold defaultstate="collapsed" desc="localization of CambiarConfiguracion's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            /**/
            paginaInicio.setLocalizedLabel(ENGLISH, "landing page");
            paginaInicio.setLocalizedLabel(SPANISH, "página de inicio");
            /**/
            paginaMenu.setLocalizedLabel(ENGLISH, "menu page");
            paginaMenu.setLocalizedLabel(SPANISH, "página del menú");
            paginaMenu.setLocalizedDescription(ENGLISH, "page to be used as home page; must be specified if landing page is \"Menu page\"");
            paginaMenu.setLocalizedDescription(SPANISH, "página que se ha de utilizar como página de inicio; se debe especificar si página de inicio es \"Página del menú\"");
            /**/
            otraPagina.setLocalizedLabel(ENGLISH, "other page");
            otraPagina.setLocalizedLabel(SPANISH, "otra página");
            otraPagina.setLocalizedDescription(ENGLISH, "special page to be used as home page; must be specified if landing page is \"Other page\"");
            otraPagina.setLocalizedDescription(SPANISH, "página especial que se ha de utilizar como página de inicio; se debe especificar si página de inicio es \"Otra página\"");
            /**/
            tema.setLocalizedLabel(ENGLISH, "theme");
            tema.setLocalizedLabel(SPANISH, "tema");
            /**/
            filasPorPagina.setLocalizedLabel(ENGLISH, "rows per page");
            filasPorPagina.setLocalizedLabel(SPANISH, "filas por página");
            filasPorPagina.setLocalizedDescription(ENGLISH, "initial number of rows per page");
            filasPorPagina.setLocalizedDescription(SPANISH, "número inicial de filas por página de presentación tabular");
            /**/
            ayudaPorCampos.setLocalizedLabel(ENGLISH, "inline help");
            ayudaPorCampos.setLocalizedLabel(SPANISH, "ayuda en línea");
            ayudaPorCampos.setLocalizedDescription(ENGLISH, "show the descriptions of the fields on the page");
            ayudaPorCampos.setLocalizedDescription(SPANISH, "mostrar las descripciones de los campos de la página");
            // </editor-fold>
        }

        BooleanExpression conPaginaMenu, conOtraPagina;

        protected Check check101, check102, check103;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            /**/
            conPaginaMenu = paginaInicio.isEqualTo(paginaInicio.PAGINA_MENU);
            conOtraPagina = paginaInicio.isEqualTo(paginaInicio.OTRA_PAGINA);
            check101 = conPaginaMenu.implies(paginaMenu.isNotNull());
            check102 = conOtraPagina.implies(otraPagina.isNotNull());
            check103 = conOtraPagina.and(otraPagina.isNotNull()).implies(otraPagina.inactiva.isFalse());
            // <editor-fold defaultstate="collapsed" desc="localization of CambiarConfiguracion's expressions">
            conPaginaMenu.setLocalizedDescription(ENGLISH, "landing page is \"Menu page\"");
            conPaginaMenu.setLocalizedDescription(SPANISH, "página de inicio es \"Página del menú\"");
            conPaginaMenu.setLocalizedErrorMessage(ENGLISH, "landing page is not \"Menu page\"");
            conPaginaMenu.setLocalizedErrorMessage(SPANISH, "página de inicio no es \"Página del menú\"");
            /**/
            conOtraPagina.setLocalizedDescription(ENGLISH, "landing page is \"Other page\"");
            conOtraPagina.setLocalizedDescription(SPANISH, "página de inicio es \"Otra página\"");
            conOtraPagina.setLocalizedErrorMessage(ENGLISH, "landing page is not \"Other page\"");
            conOtraPagina.setLocalizedErrorMessage(SPANISH, "página de inicio no es \"Otra página\"");
            /**/
            check101.setLocalizedDescription(ENGLISH, "menu page must be specified if landing page is \"Menu page\"");
            check101.setLocalizedDescription(SPANISH, "página del menú se debe especificar si página de inicio es \"Página del menú\"");
            check101.setLocalizedErrorMessage(ENGLISH, "menu page must be specified if landing page is \"Menu page\"");
            check101.setLocalizedErrorMessage(SPANISH, "página del menú se debe especificar si página de inicio es \"Página del menú\"");
            /**/
            check102.setLocalizedDescription(ENGLISH, "other page must be specified if landing page is \"Other page\"");
            check102.setLocalizedDescription(SPANISH, "otra página se debe especificar si página de inicio es \"Otra página\"");
            check102.setLocalizedErrorMessage(ENGLISH, "other page must be specified if landing page is \"Other page\"");
            check102.setLocalizedErrorMessage(SPANISH, "otra página se debe especificar si página de inicio es \"Otra página\"");
            /**/
            check103.setLocalizedDescription(ENGLISH, "other page is active");
            check103.setLocalizedDescription(SPANISH, "otra página se encuentra activa");
            check103.setLocalizedErrorMessage(ENGLISH, "other page is inactive");
            check103.setLocalizedErrorMessage(SPANISH, "otra página se encuentra inactiva");
            // </editor-fold>
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            /*
            paginaInicio.setRemoveInstanceArray(paginaInicio.OTRA_PAGINA);
            **/
            paginaMenu.setModifyingFilter(conPaginaMenu);
//          paginaMenu.setRenderingFilter(conPaginaMenu);
            paginaMenu.setRequiringFilter(conPaginaMenu);
//          paginaMenu.setNullifyingFilter(not(conPaginaMenu));
            paginaMenu.setSearchQueryFilter(paginaMenu.dominioMaestro.isNull()
                .and(paginaMenu.parametro.isNull())
                .and(paginaMenu.tipoPagina.isEqualTo(paginaMenu.tipoPagina.TABLA)
                    .or(paginaMenu.tipoPagina.isEqualTo(paginaMenu.tipoPagina.ARBOL))
                    .or(paginaMenu.tipoPagina.isEqualTo(paginaMenu.tipoPagina.CONSULTA_TABLA))
                    .or(paginaMenu.tipoPagina.isEqualTo(paginaMenu.tipoPagina.CONSULTA_ARBOL))));
            /**/
            otraPagina.setModifyingFilter(conOtraPagina);
//          otraPagina.setRenderingFilter(conOtraPagina);
            otraPagina.setRequiringFilter(conOtraPagina);
//          otraPagina.setNullifyingFilter(not(conOtraPagina));
            otraPagina.setSearchQueryFilter(otraPagina.inactiva.isFalse());
        }

    }

    @OperationClass(access = OperationAccess.PRIVATE)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class CambiarPassword extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of CambiarPassword's attributes">
            setLocalizedLabel(ENGLISH, "change password");
            setLocalizedLabel(SPANISH, "cambiar contraseña");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @ParameterField(auditable = Kleenean.FALSE, password = Kleenean.TRUE, required = Kleenean.TRUE)
        @StringField(maxLength = 32)
        protected StringParameter password;

        @ParameterField(auditable = Kleenean.FALSE, password = Kleenean.TRUE, required = Kleenean.TRUE)
        @StringField(maxLength = 32)
        protected StringParameter nuevoPassword;

        @ParameterField(auditable = Kleenean.FALSE, password = Kleenean.TRUE, required = Kleenean.TRUE)
        @StringField(maxLength = 32)
        protected StringParameter confirmacionPassword;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of CambiarPassword's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            /**/
            password.setLocalizedLabel(ENGLISH, "password");
            password.setLocalizedLabel(SPANISH, "contraseña");
            password.setLocalizedDescription(ENGLISH, "current password");
            password.setLocalizedDescription(SPANISH, "contraseña actual");
            /**/
            nuevoPassword.setLocalizedLabel(ENGLISH, "new password");
            nuevoPassword.setLocalizedLabel(SPANISH, "nueva contraseña");
            /**/
            confirmacionPassword.setLocalizedLabel(ENGLISH, "new password");
            confirmacionPassword.setLocalizedLabel(SPANISH, "nueva contraseña");
            confirmacionPassword.setLocalizedDescription(ENGLISH, "confirmation of the new password");
            confirmacionPassword.setLocalizedDescription(SPANISH, "confirmación de la nueva contraseña");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PRIVATE)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class CargarRetrato extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarRetrato's attributes">
            setLocalizedLabel(ENGLISH, "upload portrait");
            setLocalizedLabel(SPANISH, "cargar retrato");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @FileReference(max = 500000, types = MimeType.IMAGE, storage = UploadStorageOption.ROW, blobField = "octetos")
        @ParameterField(required = Kleenean.TRUE)
        protected StringParameter retrato;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarRetrato's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            /**/
            retrato.setLocalizedLabel(ENGLISH, "portrait");
            retrato.setLocalizedLabel(SPANISH, "retrato");
            retrato.setLocalizedDescription(ENGLISH, "The portrait must be a graphic file with a maximum size of 500 KB");
            retrato.setLocalizedDescription(SPANISH, "El retrato debe ser un archivo gráfico con un tamaño máximo de 500 KB");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PRIVATE)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class RecortarRetrato extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of RecortarRetrato's attributes">
            setLocalizedLabel(ENGLISH, "crop portrait");
            setLocalizedLabel(SPANISH, "recortar retrato");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of RecortarRetrato's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            // </editor-fold>
        }

    }

    @OperationClass(access = OperationAccess.PRIVATE)
    @ProcessOperationClass(overloading = Kleenean.FALSE)
    public class TomarRetrato extends ProcessOperation {

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of TomarRetrato's attributes">
            setLocalizedLabel(ENGLISH, "take portrait");
            setLocalizedLabel(SPANISH, "tomar retrato");
            // </editor-fold>
        }

        @InstanceReference
        @Allocation(maxDepth = 1, maxRound = 0)
        protected Usuario usuario;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of TomarRetrato's parameters">
            usuario.setLocalizedLabel(ENGLISH, "user");
            usuario.setLocalizedLabel(SPANISH, "usuario");
            // </editor-fold>
        }

    }
    // </editor-fold>

}
