/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.operacion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.control.acceso.Usuario;

/**
 * @author Jorge Campins
 */
@EntityClass(base = Kleenean.TRUE, independent = Kleenean.FALSE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE)
@EntityInsertOperation(enabled = Kleenean.TRUE)
@EntityUpdateOperation(enabled = Kleenean.TRUE)
@EntityDeleteOperation(enabled = Kleenean.TRUE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class FiltroFuncion extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    @Deprecated
    private FiltroFuncion() {
        this(null, null);
    }

    public FiltroFuncion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @StringField(maxLength = 100)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.FALSE, heading = Kleenean.FALSE, defaultCondition = DefaultCondition.UNCONDITIONALLY_ON_INSERT)
    public StringProperty codigoFiltroFuncion;

    @NameProperty
    public StringProperty nombreFiltroFuncion;

    @DescriptionProperty
    public StringProperty descripcionFiltroFuncion;

//  20171213: remove foreign-key referring to Funcion
//  @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.BIDIRECTIONAL, view = MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 2, maxRound = 0)
    public Funcion funcion;

    @OwnerProperty
    @ForeignKey(onDelete = OnDeleteAction.CASCADE, onUpdate = OnUpdateAction.CASCADE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, search = Kleenean.TRUE, table = Kleenean.TRUE, report = Kleenean.TRUE)
    public Usuario usuario;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(hidden = Kleenean.TRUE)
    public BooleanProperty esPublico;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idFiltroFuncionOriginal;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of FiltroFuncion's attributes">
        setLocalizedLabel(ENGLISH, "query filter");
        setLocalizedLabel(SPANISH, "filtro de búsqueda");
        setLocalizedShortLabel(ENGLISH, "filter");
        setLocalizedShortLabel(SPANISH, "filtro");
        setLocalizedCollectionLabel(ENGLISH, "Query Filters");
        setLocalizedCollectionLabel(SPANISH, "Filtros de Búsqueda");
        setLocalizedCollectionShortLabel(ENGLISH, "Filters");
        setLocalizedCollectionShortLabel(SPANISH, "Filtros");
        setLocalizedDescription(ENGLISH, "query filter defined by the end user");
        setLocalizedDescription(SPANISH, "filtro de búsqueda definido por el usuario final");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        codigoFiltroFuncion.setDefaultValue(funcion.dominio.codigoDominio.concat("-").concat(id.toCharString()));
        esPublico.setInitialValue(false);
        esPublico.setDefaultValue(false);
        // <editor-fold defaultstate="collapsed" desc="localization of FiltroFuncion's properties">
        codigoFiltroFuncion.setLocalizedLabel(ENGLISH, "query filter code");
        codigoFiltroFuncion.setLocalizedLabel(SPANISH, "código del filtro de búsqueda");
        codigoFiltroFuncion.setLocalizedShortLabel(ENGLISH, "code");
        codigoFiltroFuncion.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombreFiltroFuncion.setLocalizedLabel(ENGLISH, "query filter name");
        nombreFiltroFuncion.setLocalizedLabel(SPANISH, "nombre del filtro de búsqueda");
        nombreFiltroFuncion.setLocalizedShortLabel(ENGLISH, "name");
        nombreFiltroFuncion.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        descripcionFiltroFuncion.setLocalizedLabel(ENGLISH, "query filter description");
        descripcionFiltroFuncion.setLocalizedLabel(SPANISH, "descripción del filtro de búsqueda");
        descripcionFiltroFuncion.setLocalizedShortLabel(ENGLISH, "description");
        descripcionFiltroFuncion.setLocalizedShortLabel(SPANISH, "descripción");
        /**/
        funcion.setLocalizedLabel(ENGLISH, "function");
        funcion.setLocalizedLabel(SPANISH, "función");
        /**/
        usuario.setLocalizedLabel(ENGLISH, "owner");
        usuario.setLocalizedLabel(SPANISH, "propietario");
        /**/
        esPublico.setLocalizedLabel(ENGLISH, "public");
        esPublico.setLocalizedLabel(SPANISH, "público");
        /**/
        idFiltroFuncionOriginal.setLocalizedLabel(ENGLISH, "original query filter");
        idFiltroFuncionOriginal.setLocalizedLabel(SPANISH, "filtro original");
        idFiltroFuncionOriginal.setLocalizedShortLabel(ENGLISH, "original");
        idFiltroFuncionOriginal.setLocalizedShortLabel(SPANISH, "original");
        // </editor-fold>
    }

}
