/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.psm;

/**
 * @author Jorge Campins
 */
public class ProjectAttributeKeys {

    /**
     * true si la interfaz gráfica de la aplicación generada tiene un layout personalizado que se debe utilizar en lugar del layout generado; de lo
     * contrario false. El valor por omisión es false. El nombre del archivo de layout generado es fullPageLayout.xhtml y se almacena en el
     * subdirectorio src\main\webapp\ templates\base del módulo alias-web de la aplicación, donde alias es el alias del proyecto generado (vea Método
     * setAlias); el archivo de layout personalizado debe tener el mismo nombre y se debe almacenar en el subdirectorio src\main\
     * webapp\templates\custom-made.
     */
    public static final String CUSTOM_LAYOUT = "custom_layout";

    /**
     * Número de pixeles de ancho de la ventana inicial de la interfaz gráfica de la aplicación generada. El valor máximo es 3840. El valor mínimo es
     * 640. El valor por omisión es 1240. Este atributo era utilizado por JEE1; no es utilizado por JEE2.
     */
    @Deprecated
    public static final String DEFAULT_WINDOW_WIDTH = "default_window_width";

    /**
     * Número de pixeles de alto de la ventana inicial de la interfaz gráfica de la aplicación generada. El valor máximo es 2160. El valor mínimo es
     * 480. El valor por omisión es 930. Este atributo era utilizado por JEE1; no es utilizado por JEE2.
     */
    @Deprecated
    public static final String DEFAULT_WINDOW_HEIGHT = "default_window_height";

    /**
     * Parámetro javax.faces.FACELETS_REFRESH_PERIOD. Define el período utilizado para actualizar el árbol de sintaxis abstracta de facelet desde el
     * archivo de definición de vista. El valor por omisión para proyectos en etapas de Aceptación y Producción es -1. En las demás etapas el valor
     * por omisión depende del servidor de aplicaciones.
     */
    public static final String FACELETS_REFRESH_PERIOD = "facelets_refresh_period";

    /**
     * true si el layout de la interfaz gráfica de la aplicación generada debe incluir el archivo de imagen index_hlb.png en el bloque izquierdo del
     * encabezado de página; de lo contrario false. El valor por omisión es false. El archivo index_hlb.png se almacena en el subdirectorio
     * src\main\webapp\resources\images\base del módulo alias-web de la aplicación, donde alias es el alias del proyecto generado.
     */
    public static final String HLB_RENDERING = "hlb_rendering";

    /**
     * true si el layout de la interfaz gráfica de la aplicación generada debe incluir el nombre de la aplicación en el bloque central del encabezado
     * de página; de lo contrario false. El valor por omisión es false.
     */
    public static final String HCB_RENDERING = "hcb_rendering";

    /**
     * true si el layout de la interfaz gráfica de la aplicación generada debe incluir el archivo de imagen index_hrb.png en el bloque derecho del
     * encabezado de página; de lo contrario false. El valor por omisión es false. El archivo index_hrb.png se almacena en el subdirectorio
     * src\main\webapp\resources\images\base del módulo alias-web de la aplicación, donde alias es el alias del proyecto generado.
     */
    public static final String HRB_RENDERING = "hrb_rendering";

    /**
     * Ruta relativa de la página inicial predeterminada de la interfaz gráfica de la aplicación generada. El valor por omisión es
     * /faces/views/base/code/Menu.xhtml.
     */
    public static final String INITIAL_PAGE_LOCATION = "initial_page_location";

    /**
     * Nombre de la ventana inicial de la interfaz gráfica de la aplicación generada. El valor por omisión es el alias del proyecto generado.
     */
    public static final String INITIAL_WINDOW_TARGET = "initial_window_target";

    /**
     * true la interfaz gráfica de la aplicación generada debe mostrar componentes de ayuda-en-línea; de lo contrario false. El valor por omisión es
     * true.
     */
    public static final String INLINE_HELP_RENDERING = "inline_help_rendering";

    /**
     * true la interfaz gráfica de la aplicación generada debe salvar parcialmente el estado de las páginas; de lo contrario false. El valor por
     * omisión es true. El estado de las páginas es salvado cuando la interfaz abre una nueva página y sirve para reponer el estado de la página
     * salvada en el caso de que el usuario deba regresar a ella.
     */
    public static final String PARTIAL_STATE_SAVING = "partial_state_saving";

    /**
     * true si el encabezado de página de los informes generados debe ser de doble altura; de lo contrario false. El valor por omisión es false.
     */
    public static final String RPH_DOUBLE_HEIGHT = "rph_double_height";

    /**
     * Número de pixeles de ancho de la imagen incluida en el bloque izquierdo del encabezado de página de los informes generados. El valor máximo es
     * 160. El valor por omisión es 56.
     */
    public static final String RPH_LEFT_IMAGE_WIDTH = "rph_left_image_width";

    /**
     * Número de pixeles de alto de la imagen incluida en el bloque izquierdo del encabezado de página de los informes generados. El valor máximo es
     * 64 o 32, dependiendo de si el encabezado es o no es de doble altura, respectivamente. El valor por omisión es 32.
     */
    public static final String RPH_LEFT_IMAGE_HEIGHT = "rph_left_image_height";

    /**
     * true si el encabezado de página de los informes generados no debe incluir el archivo de imagen alias1.png (donde alias es el alias del proyecto
     * generado) en el bloque izquierdo del encabezado; de lo contrario false. El valor por omisión es false. Cada directorio de informes contiene un
     * subdirectorio resources donde se encuentra un archivo alias1.png.
     */
    public static final String RPH_NO_LEFT_IMAGE = "rph_no_left_image";

    /**
     * Número de pixeles de ancho de la imagen incluida en el bloque derecho del encabezado de página de los informes generados. El valor máximo es
     * 160. El valor por omisión es 56.
     */
    public static final String RPH_RIGHT_IMAGE_WIDTH = "rph_right_image_width";

    /**
     * Número de pixeles de alto de la imagen incluida en el bloque derecho del encabezado de página de los informes generados. El valor máximo es 64
     * o 32, dependiendo de si el encabezado es o no es de doble altura, respectivamente. El valor por omisión es 32.
     */
    public static final String RPH_RIGHT_IMAGE_HEIGHT = "rph_right_image_height";

    /**
     * true si el encabezado de página de los informes generados no debe incluir el archivo de imagen alias2.png (donde alias es el alias del proyecto
     * generado) en el bloque derecho del encabezado; de lo contrario false. El valor por omisión es false. Cada directorio de informes contiene un
     * subdirectorio resources donde se encuentra un archivo alias2.png.
     */
    public static final String RPH_NO_RIGHT_IMAGE = "rph_no_right_image";

    /**
     * Número de minutos que se debe especificar como tiempo de espera (valor del elemento session-timeout) al generar el descriptor de despliegue
     * (web.xml) del módulo alias-web de la aplicación, donde alias es el alias del proyecto generado. El valor por omisión es 30.
     */
    public static final String SESSION_TIMEOUT = "session_timeout";

}
