/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons;

import adalid.commons.ProjectObjectModel;
import adalid.commons.ProjectObjectModelReader;
import adalid.commons.properties.PropertiesHandler;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractProjectObjectModel
implements ProjectObjectModelReader {
    private static final Logger logger = Logger.getLogger(ProjectObjectModel.class);
    private static final String EMPTY = "";
    private static final String V10SS = "1.0-SNAPSHOT";
    private final Properties pom;
    private final boolean empty;

    protected AbstractProjectObjectModel(String resource) {
        this.pom = StringUtils.isBlank((String)resource) ? null : PropertiesHandler.getResourceAsProperties(resource, Level.ERROR, Level.TRACE);
        this.empty = this.pom == null || this.pom.isEmpty();
    }

    @Override
    public String getProjectGroupId() {
        return this.empty ? EMPTY : StringUtils.trimToEmpty((String)this.pom.getProperty("project.groupId"));
    }

    @Override
    public String getProjectArtifactId() {
        return this.empty ? EMPTY : StringUtils.trimToEmpty((String)this.pom.getProperty("project.artifactId"));
    }

    @Override
    public String getProjectVersion() {
        return this.empty ? V10SS : StringUtils.defaultIfBlank((String)this.pom.getProperty("project.version"), (String)V10SS);
    }

    @Override
    public String getProjectName() {
        return this.empty ? EMPTY : StringUtils.trimToEmpty((String)this.pom.getProperty("project.name"));
    }

    @Override
    public String getProjectBuildTimestamp() {
        return this.empty ? EMPTY : StringUtils.trimToEmpty((String)this.pom.getProperty("project.build.timestamp"));
    }

    @Override
    public String getProjectVersionNumber() {
        String version = this.getProjectVersion();
        if (version.contains("SNAPSHOT")) {
            String timestamp = this.getProjectBuildTimestamp();
            return timestamp.isEmpty() ? version : StringUtils.replace((String)version, (String)"SNAPSHOT", (String)StringUtils.substringBefore((String)timestamp, (String)"-"));
        }
        return version;
    }

    public void logProjectVersion() {
        String name = StringUtils.defaultIfBlank((String)this.getProjectName(), (String)"?");
        String version = this.getProjectVersionNumber();
        logger.info((Object)(name + " " + version));
    }
}

