/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.bundles;

import adalid.commons.i18n.EnglishLinguist;
import adalid.commons.i18n.Linguist;
import adalid.commons.i18n.SpanishLinguist;
import adalid.commons.util.BitUtils;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Bundle {
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale SPANISH = Locale.forLanguageTag("es");
    public static final Locale PORTUGUESE = Locale.forLanguageTag("pt");
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{ENGLISH, SPANISH};
    private static final Linguist[] SUPPORTING_LINGUISTS = new Linguist[]{new EnglishLinguist(), new SpanishLinguist()};
    private static final Logger logger = Logger.getLogger(Bundle.class);
    private static final String BASE_NAME = Bundle.class.getName();
    private static final Locale defaultLocale = ENGLISH;
    private static final Linguist defaultLinguist = SUPPORTING_LINGUISTS[Bundle.indexOfLocale(defaultLocale)];
    private static final ResourceBundle defaultResourceBundle = ResourceBundle.getBundle(BASE_NAME, defaultLocale);
    private static final ResourceBundle specialResourceBundle = ResourceBundle.getBundle(BASE_NAME, Locale.forLanguageTag("adalid"));
    private static final ResourceBundle[] RESOURCE_BUNDLES = new ResourceBundle[]{ResourceBundle.getBundle(BASE_NAME, ENGLISH), ResourceBundle.getBundle(BASE_NAME, SPANISH)};
    private static ResourceBundle resourceBundle;
    private static Locale locale;
    private static Linguist linguist;

    private static void initialise() {
        resourceBundle = defaultResourceBundle;
        locale = defaultLocale;
        linguist = defaultLinguist;
    }

    public static Locale[] getSupportedLocales() {
        return SUPPORTED_LOCALES;
    }

    public static boolean isSupportedLocale(Locale locale) {
        return locale != null && ArrayUtils.contains((Object[])SUPPORTED_LOCALES, (Object)locale);
    }

    private static int indexOfLocale(Locale locale) {
        return locale == null ? -1 : ArrayUtils.indexOf((Object[])SUPPORTED_LOCALES, (Object)locale);
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale newLocale) {
        if (newLocale == null) {
            logger.warn((Object)("null value for locale parameter; falling back to " + defaultLocale));
            Bundle.initialise();
        } else if (newLocale.equals(locale)) {
            logger.trace((Object)("Locale " + newLocale + " already set."));
        } else if (Bundle.isSupportedLocale(newLocale)) {
            try {
                logger.trace((Object)("Change of Locale (from \"" + locale + "\" to \"" + newLocale + "\")"));
                resourceBundle = ResourceBundle.getBundle(BASE_NAME, newLocale);
                locale = newLocale;
                linguist = SUPPORTING_LINGUISTS[Bundle.indexOfLocale(newLocale)];
            }
            catch (MissingResourceException e) {
                logger.warn((Object)("Locale " + newLocale + " bundle missing; falling back to " + defaultLocale));
                Bundle.initialise();
            }
        } else {
            logger.warn((Object)("Locale " + newLocale + " not supported yet; falling back to " + defaultLocale));
            Bundle.initialise();
        }
    }

    public static Linguist getLinguist() {
        return linguist;
    }

    public static boolean getBoolean(String key) {
        String trimmed = Bundle.getTrimmedToNullString(key);
        return BitUtils.valueOf(trimmed);
    }

    public static String getString(String key) {
        String trimmed = Bundle.getTrimmedToNullString(key);
        return trimmed == null ? key : trimmed;
    }

    public static String getTrimmedToEmptyString(String key) {
        String trimmed = Bundle.getTrimmedToNullString(key);
        return trimmed == null ? "" : trimmed;
    }

    public static String getTrimmedToNullString(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        String string = Bundle.getTrimmedToNullString(key, resourceBundle);
        if (string == null) {
            string = Bundle.getTrimmedToNullString(key, specialResourceBundle);
        }
        return string;
    }

    public static String getTrimmedToNullString(String key, Locale locale) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        int index = Bundle.indexOfLocale(locale);
        if (index == -1) {
            return null;
        }
        String string = Bundle.getTrimmedToNullString(key, RESOURCE_BUNDLES[index]);
        return string;
    }

    private static String getTrimmedToNullString(String key, ResourceBundle rb) {
        String string = Bundle.getUntrimmedString(key, rb);
        return StringUtils.trimToNull((String)string);
    }

    public static String getUntrimmedString(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        String string = Bundle.getUntrimmedString(key, resourceBundle);
        if (string == null) {
            string = Bundle.getUntrimmedString(key, specialResourceBundle);
        }
        return string;
    }

    public static String getUntrimmedString(String key, Locale locale) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        int index = Bundle.indexOfLocale(locale);
        if (index == -1) {
            return null;
        }
        String string = Bundle.getUntrimmedString(key, RESOURCE_BUNDLES[index]);
        return string;
    }

    private static String getUntrimmedString(String key, ResourceBundle rb) {
        try {
            String string = rb.getString(key);
            return string == null || string.isEmpty() ? null : string;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    static {
        Bundle.initialise();
    }
}

