/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.properties;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.LogUtils;
import adalid.commons.util.LongUtils;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Dictionary {
    private static final Logger logger = Logger.getLogger(Dictionary.class);
    private static final ExtendedProperties bootstrapping = PropertiesHandler.getBootstrapping();
    private static final String DIR = System.getProperty("user.dir");
    private static final String SEP = System.getProperty("file.separator");
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String DFLS = bootstrapping.getString("sql.dictionary.file.line.separator", "UNSPECIFIED");
    private static final String DICTIONARY_FILE_LINE_SEPARATOR = StringUtils.isBlank((String)DFLS) ? LINE_SEPARATOR : (DFLS.equalsIgnoreCase("CRLF") ? "\r\n" : (DFLS.equalsIgnoreCase("LF") ? "\n" : LINE_SEPARATOR));
    private static final String RESOURCES = DIR + SEP + bootstrapping.getString("sql.dictionary.path", "resources").replace("/", SEP);
    private static final String DICTIONARY_DIR = RESOURCES + SEP + "dictionary";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static int errorCount;
    private static int warningCount;
    private static Level _infoLevel;
    private static boolean _fairInfoLevel;
    private final String simpleName;
    private final String fileName;
    private final String filePath;
    private final Map<String, String> map = new TreeMap<String, String>();
    private final Properties properties;
    private final Set<String> errors = new TreeSet<String>();
    private final Set<String> warnings = new TreeSet<String>();

    public static Level getInfoLevel() {
        return _infoLevel;
    }

    public static void setInfoLevel(Level level) {
        _infoLevel = LogUtils.check(level, Level.OFF, Level.INFO);
        _fairInfoLevel = LogUtils.fair(_infoLevel);
    }

    public static Dictionary load(Class<?> clazz, String folder) {
        return new Dictionary(clazz, folder);
    }

    public static boolean isValidNumericCode(String value) {
        return LongUtils.valueOf(value, (Long)0L) != 0L;
    }

    public static void printSummary() {
        if (warningCount > 0) {
            logger.warn((Object)("warnings=" + warningCount));
        }
        if (errorCount > 0) {
            logger.warn((Object)("errors=" + errorCount));
        }
    }

    public static int getErrorCount() {
        return errorCount;
    }

    public static int getWarningCount() {
        return warningCount;
    }

    public static void reset() {
        errorCount = 0;
        warningCount = 0;
    }

    private Dictionary(Class<?> clazz, String folder) {
        this.simpleName = clazz.getSimpleName();
        this.fileName = this.simpleName + PROPERTIES_SUFFIX;
        this.filePath = DICTIONARY_DIR + (String)(folder != null && folder.matches("^\\w+$") ? SEP + folder + SEP : SEP) + this.fileName;
        this.properties = PropertiesHandler.loadProperties(this.filePath, true, Level.DEBUG);
        this.log(true);
        this.check();
    }

    private void check() {
        for (Object key : this.properties.keySet()) {
            String value = this.properties.getProperty("" + key);
            if (Dictionary.isValidNumericCode(value)) continue;
            if (StringUtils.isBlank((String)value)) {
                this.warn("property " + this.simpleName + " [" + key + "] value is missing");
                continue;
            }
            this.warn("\"" + value + "\" is an invalid numeric code; property " + this.simpleName + " [" + key + "] value will be replaced");
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Object setProperty(String key, String value) {
        Object previousValue = this.properties.setProperty(key, value);
        if (previousValue != null && !previousValue.equals(value)) {
            if (StringUtils.isBlank((String)("" + previousValue))) {
                this.warn("assigning value to property " + this.simpleName + " [" + key + "]");
            } else {
                this.warn("replacing value of property " + this.simpleName + " [" + key + "]");
            }
        }
        this.putProperty(key, value);
        return previousValue;
    }

    public String putProperty(String key, String value) {
        String previousKey = this.map.put(value, key);
        if (previousKey != null && !previousKey.equals(key)) {
            int c = key.compareTo(previousKey);
            String k1 = c < 0 ? key : previousKey;
            String k2 = c < 0 ? previousKey : key;
            this.error("\"" + value + "\" is the same numeric code for properties " + this.simpleName + " [" + k1 + "] and [" + k2 + "]");
        }
        return previousKey;
    }

    public void store() {
        PropertiesHandler.storeProperties(this.properties, this.filePath, null, DICTIONARY_FILE_LINE_SEPARATOR);
        this.log(false);
    }

    private void log(boolean initializing) {
        String path = StringUtils.substringAfter((String)this.filePath, (String)DIR).replace(SEP, "/");
        if (this.properties.isEmpty()) {
            if (initializing) {
                this.info("initializing " + path);
            } else {
                this.warn("file " + path + " is empty");
            }
        } else {
            this.info("file " + path + " has " + this.properties.size() + " properties");
        }
    }

    private void info(String message) {
        if (_fairInfoLevel) {
            logger.log((Priority)_infoLevel, (Object)message);
        }
    }

    private void warn(String message) {
        if (this.warnings.add(message)) {
            ++warningCount;
            logger.warn((Object)message);
        }
    }

    private void error(String message) {
        if (this.errors.add(message)) {
            ++errorCount;
            logger.error((Object)message);
        }
    }

    static {
        _infoLevel = Level.OFF;
    }
}

