/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class FilUtils {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean WINDOWS = StringUtils.containsIgnoreCase((String)OS_NAME, (String)"windows");
    private static final String ENV_VAR_LEFT_MARK = WINDOWS ? "%" : "${";
    private static final String ENV_VAR_RIGHT_MARK = WINDOWS ? "%" : "}";
    private static final String HOME_ENV_VAR = WINDOWS ? "USERPROFILE" : "HOME";
    private static final String HOME_VAR = ENV_VAR_LEFT_MARK + HOME_ENV_VAR + ENV_VAR_RIGHT_MARK;
    private static final String HOME_DIR = System.getenv(HOME_ENV_VAR);
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String WORKSPACE_FOLDER_NAME = "workspace";
    private static final String workspace_folder_path;
    private static final String[] user_dir_folder_keys;
    private static final String[] user_home_folder_keys;
    private static final String[] workspace_folder_keys;

    private static String workspaceFolderPath() {
        File dir = FilUtils.workspaceFolderFile(new File(USER_DIR));
        if (dir != null) {
            return dir.getPath();
        }
        String suffix = FILE_SEP + WORKSPACE_FOLDER_NAME;
        String search = suffix + FILE_SEP;
        int i = StringUtils.lastIndexOfIgnoreCase((String)USER_DIR, (String)search);
        String base = i < 0 ? USER_HOME : USER_DIR.substring(0, i);
        return base + suffix;
    }

    private static File workspaceFolderFile(File dir) {
        File file = new File(dir.getPath() + FILE_SEP + WORKSPACE_FOLDER_NAME);
        File parent = dir.getParentFile();
        return FilUtils.isVisibleFile(file) ? dir : (parent == null ? null : FilUtils.workspaceFolderFile(parent));
    }

    private static String[] workspaceFolderKeys() {
        return FilUtils.regexFolderKeys(WORKSPACE_FOLDER_NAME);
    }

    private static String[] regexFolderKeys(String folderName) {
        String key1 = "(?i)\\$" + folderName;
        String key2 = "(?i)\\$\\{" + folderName + "\\}";
        return new String[]{key1, key2};
    }

    public static String getDefaultEnvironmentalWorkspaceFolderPath() {
        return HOME_VAR + FILE_SEP + WORKSPACE_FOLDER_NAME;
    }

    public static String getCurrentEnvironmentalWorkspaceFolderPath() {
        if (StringUtils.isBlank((String)HOME_DIR) && StringUtils.isBlank((String)USER_HOME)) {
            return workspace_folder_path;
        }
        if (StringUtils.startsWithIgnoreCase((String)workspace_folder_path, (String)HOME_DIR)) {
            return HOME_VAR + StringUtils.removeStartIgnoreCase((String)workspace_folder_path, (String)HOME_DIR);
        }
        if (StringUtils.startsWithIgnoreCase((String)workspace_folder_path, (String)USER_HOME)) {
            return HOME_VAR + StringUtils.removeStartIgnoreCase((String)workspace_folder_path, (String)USER_HOME);
        }
        return workspace_folder_path;
    }

    public static String getWorkspaceFolderPath() {
        return workspace_folder_path;
    }

    public static String fixSlashedPath(String path) {
        return FilUtils.slashedPath(FilUtils.fixPath(path));
    }

    public static String fixPath(String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        String string = path.trim();
        string = string.replace(FILE_SEP, SLASH);
        string = FilUtils.replaceAll(string, user_dir_folder_keys, USER_DIR);
        string = FilUtils.replaceAll(string, user_home_folder_keys, USER_HOME);
        string = FilUtils.replaceAll(string, workspace_folder_keys, workspace_folder_path);
        string = string.replace(SLASH, FILE_SEP);
        return string;
    }

    private static String replaceAll(String string, String[] keys, String path) {
        if (StringUtils.isBlank((String)path)) {
            return string;
        }
        String replacement = path.replace(FILE_SEP, SLASH);
        for (String regex : keys) {
            string = string.replaceAll(regex, replacement);
        }
        return string;
    }

    public static String slashedPath(String path) {
        return StringUtils.isBlank((String)path) ? null : StringUtils.replace((String)path.trim(), (String)FILE_SEP, (String)SLASH);
    }

    public static String packagePath(String pack) {
        return StringUtils.isBlank((String)pack) ? null : StringUtils.replace((String)pack.trim(), (String)DOT, (String)FILE_SEP);
    }

    public static String packageSlashedPath(String pack) {
        return StringUtils.isBlank((String)pack) ? null : StringUtils.replace((String)pack.trim(), (String)DOT, (String)SLASH);
    }

    public static String delimitedPath(File file) {
        return FilUtils.delimitedPath(file, null);
    }

    public static String delimitedPath(File file, char separator) {
        return FilUtils.delimitedPath(file, "" + separator);
    }

    public static String delimitedPath(File file, String separator) {
        return FilUtils.delimitedPath(file, separator, 0);
    }

    public static String delimitedPath(File file, char separator, int parts) {
        return FilUtils.delimitedPath(file, "" + separator, parts);
    }

    public static String delimitedPath(File file, String separator, int parts) {
        return file == null ? null : FilUtils.delimitedPath(file.getAbsolutePath(), separator, parts);
    }

    public static String delimitedPath(String path) {
        return FilUtils.delimitedPath(path, null);
    }

    public static String delimitedPath(String path, char separator) {
        return FilUtils.delimitedPath(path, "" + separator);
    }

    public static String delimitedPath(String path, String separator) {
        return FilUtils.delimitedPath(path, separator, 0);
    }

    public static String delimitedPath(String path, char separator, int parts) {
        return FilUtils.delimitedPath(path, "" + separator, parts);
    }

    public static String delimitedPath(String path, String separator, int parts) {
        String substringAfter = StringUtils.substringAfter((String)path, (String)File.separator);
        if (StringUtils.isBlank((String)substringAfter)) {
            return null;
        }
        Object[] split = StringUtils.split((String)substringAfter, (String)File.separator);
        Object[] array = (String[])ArrayUtils.subarray((Object[])split, (int)(parts > 0 ? split.length - parts : 0), (int)split.length);
        return StringUtils.join((Object[])array, (String)StringUtils.defaultIfBlank((String)separator, (String)File.separator));
    }

    public static File getDirectory(String pathname) {
        File file;
        boolean b = StringUtils.isNotBlank((String)pathname);
        if (b && (b = (file = new File(pathname)).isDirectory())) {
            return file;
        }
        return null;
    }

    public static File getFile(String pathname) {
        File file;
        boolean b = StringUtils.isNotBlank((String)pathname);
        if (b && (b = (file = new File(pathname)).isFile())) {
            return file;
        }
        return null;
    }

    public static boolean exists(String pathname) {
        boolean b = StringUtils.isNotBlank((String)pathname);
        if (b) {
            File file = new File(pathname);
            b = file.exists();
        }
        return b;
    }

    public static boolean isDirectory(String pathname) {
        boolean b = StringUtils.isNotBlank((String)pathname);
        if (b) {
            File file = new File(pathname);
            b = file.isDirectory();
        }
        return b;
    }

    public static boolean isFile(String pathname) {
        boolean b = StringUtils.isNotBlank((String)pathname);
        if (b) {
            File file = new File(pathname);
            b = file.isFile();
        }
        return b;
    }

    public static boolean isPath(String path) {
        boolean b = StringUtils.isNotBlank((String)path);
        if (b) {
            String[] pathnames;
            String sep = System.getProperty("path.separator");
            for (String pathname : pathnames = StringUtils.split((String)path, (String)sep)) {
                b &= FilUtils.exists(pathname);
            }
        }
        return b;
    }

    public static boolean isVisibleDirectory(File file) {
        return file != null && file.isDirectory() && !file.isHidden();
    }

    public static boolean isNotVisibleDirectory(File file) {
        return !FilUtils.isVisibleDirectory(file);
    }

    public static boolean isReadableDirectory(File file) {
        return file != null && file.isDirectory() && file.canRead();
    }

    public static boolean isNotReadableDirectory(File file) {
        return !FilUtils.isReadableDirectory(file);
    }

    public static boolean isWritableDirectory(File file) {
        return file != null && file.isDirectory() && file.canWrite();
    }

    public static boolean isNotWritableDirectory(File file) {
        return !FilUtils.isWritableDirectory(file);
    }

    public static boolean isVisibleFile(File file) {
        return file != null && file.isFile() && !file.isHidden();
    }

    public static boolean isNotVisibleFile(File file) {
        return !FilUtils.isVisibleFile(file);
    }

    public static boolean isReadableFile(File file) {
        return file != null && file.isFile() && file.canRead();
    }

    public static boolean isNotReadableFile(File file) {
        return !FilUtils.isReadableFile(file);
    }

    public static boolean isWritableFile(File file) {
        return file != null && file.isFile() && file.canWrite();
    }

    public static boolean isNotWritableFile(File file) {
        return !FilUtils.isWritableFile(file);
    }

    public static boolean mkdir(String dir) {
        File file = new File(dir);
        return file.isDirectory() || file.mkdirs();
    }

    public static boolean mkdirs(String dirs) {
        File file = new File(dirs);
        return file.isDirectory() || file.mkdirs();
    }

    public static List<String> directoriesPathList(File file) {
        ArrayList<String> list = new ArrayList<String>();
        if (FilUtils.isVisibleDirectory(file)) {
            list.add(file.getPath());
            for (File sub : file.listFiles(FilUtils.visibleDirectoryFilter())) {
                list.addAll(FilUtils.directoriesPathList(sub));
            }
        }
        return list;
    }

    public static Map<String, File> directoriesMap(File file) {
        LinkedHashMap<String, File> map = new LinkedHashMap<String, File>();
        if (FilUtils.isVisibleDirectory(file)) {
            map.put(file.getPath(), file);
            for (File sub : file.listFiles(FilUtils.visibleDirectoryFilter())) {
                map.putAll(FilUtils.directoriesMap(sub));
            }
        }
        return map;
    }

    public static Map<String, File> directoriesMap(File directory, String[] pathnames) {
        return FilUtils.directoriesMap(directory, pathnames, null);
    }

    public static Map<String, File> directoriesMap(File directory, String[] pathnames, File top) {
        LinkedHashMap<String, File> map = new LinkedHashMap<String, File>();
        for (String pathname : pathnames) {
            File file = new File(directory, pathname);
            if (FilUtils.isVisibleDirectory(top)) {
                map.putAll(FilUtils.parentDirectoriesMap(file, top));
            }
            map.putAll(FilUtils.directoriesMap(file));
        }
        return map;
    }

    public static Map<String, File> parentDirectoriesMap(File file) {
        return FilUtils.parentDirectoriesMap(file, null);
    }

    public static Map<String, File> parentDirectoriesMap(File file, File top) {
        File parent;
        File topdir;
        LinkedHashMap<String, File> map = new LinkedHashMap<String, File>();
        File file2 = topdir = FilUtils.isVisibleDirectory(top) ? top : null;
        if ((FilUtils.isVisibleDirectory(file) || FilUtils.isVisibleFile(file)) && FilUtils.isVisibleDirectory(parent = file.getParentFile()) && !parent.equals(topdir)) {
            map.putAll(FilUtils.parentDirectoriesMap(parent, topdir));
            map.put(parent.getPath(), parent);
        }
        return map;
    }

    public static FileFilter visibleDirectoryFilter() {
        return file -> FilUtils.isVisibleDirectory(file);
    }

    public static FileFilter nameContainsFilter(String string) {
        return file -> FilUtils.isVisibleFile(file) && StringUtils.containsIgnoreCase((String)file.getName(), (String)string);
    }

    public static FileFilter nameEndsWithFilter(String suffix) {
        return file -> FilUtils.isVisibleFile(file) && StringUtils.endsWithIgnoreCase((String)file.getName(), (String)suffix);
    }

    public static FileFilter nameStartsWithFilter(String prefix) {
        return file -> FilUtils.isVisibleFile(file) && StringUtils.startsWithIgnoreCase((String)file.getName(), (String)prefix);
    }

    static {
        user_dir_folder_keys = FilUtils.regexFolderKeys("USER_DIR");
        user_home_folder_keys = FilUtils.regexFolderKeys("USER_HOME");
        workspace_folder_path = FilUtils.workspaceFolderPath();
        workspace_folder_keys = FilUtils.workspaceFolderKeys();
    }
}

