/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.util.ObjUtils;
import adalid.commons.util.StrUtils;
import org.apache.commons.lang.StringUtils;

public class KVP {
    public static final String EQUALS = "=";
    public static final String SEPARATOR = ", ";
    public static final String OPEN = "(";
    public static final String CLOSE = ")";
    private static final String EMPTY = "";
    private final String _key;
    private final Object _value;
    private String _equals;
    private String _separator;
    private String _open;
    private String _close;

    public static KVP join(String key, Object value) {
        return new KVP(key, value);
    }

    public static KVP join(String key, Object ... value) {
        return new KVP(key, value);
    }

    public static KVP[] array(Object o) {
        Object object;
        if (o == null) {
            object = null;
        } else if (o instanceof KVP) {
            KVP[] kVPArray = new KVP[1];
            object = kVPArray;
            kVPArray[0] = (KVP)o;
        } else {
            object = o.getClass().isArray() && o.getClass().getComponentType().equals(KVP.class) ? (KVP[])o : null;
        }
        return object;
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray() && o.getClass().getComponentType().equals(KVP.class);
    }

    private KVP(String key, Object value) {
        this._key = key;
        this._value = value;
        this._equals = EQUALS;
        this._separator = SEPARATOR;
        this._open = OPEN;
        this._close = CLOSE;
    }

    public KVP delimitedBy(String equals, String separator, String open, String close) {
        this._equals = equals == null ? EQUALS : equals;
        this._separator = separator == null ? SEPARATOR : separator;
        this._open = open == null ? OPEN : open;
        this._close = close == null ? CLOSE : close;
        return this;
    }

    public String getKey() {
        return this._key;
    }

    public Object getValue() {
        return this._value;
    }

    public String getStringKey() {
        return StringUtils.trimToEmpty((String)this._key);
    }

    public String getStringValue() {
        return this.getStringValue(this._equals, this._separator, this._open, this._close);
    }

    public String getStringValue(String equals, String separator, String open, String close) {
        return StrUtils.getString(equals, separator, open, close, this._value);
    }

    public KVP[] toArray() {
        return new KVP[]{this};
    }

    public KVP[] toArray(KVP that) {
        KVP[] kVPArray;
        if (that != null) {
            KVP[] kVPArray2 = new KVP[2];
            kVPArray2[0] = this;
            kVPArray = kVPArray2;
            kVPArray2[1] = that;
        } else {
            kVPArray = this.toArray();
        }
        return kVPArray;
    }

    public KVP[] toArray(Object that) {
        KVP[] kVPArray;
        if (that instanceof KVP) {
            KVP[] kVPArray2 = new KVP[2];
            kVPArray2[0] = this;
            kVPArray = kVPArray2;
            kVPArray2[1] = (KVP)that;
        } else {
            kVPArray = this.toArray();
        }
        return kVPArray;
    }

    public String toString() {
        return this.toString(this._equals, this._separator, this._open, this._close);
    }

    public String toString(String equals, String separator, String open, String close) {
        if (StringUtils.isBlank((String)this._key) && ObjUtils.isBlank(this._value)) {
            return EMPTY;
        }
        if (ObjUtils.isBlank(this._value)) {
            return this.getStringKey();
        }
        if (StringUtils.isBlank((String)this._key)) {
            return this.getStringValue(equals, separator, open, close);
        }
        return this.getStringKey() + equals + this.getStringValue(equals, separator, open, close);
    }
}

