/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.util.FilUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class ManUtils {
    private static final Logger logger = Logger.getLogger(ManUtils.class);
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String MANIFEST_NAME = "MANIFEST.MF";
    private static final String MANIFEST_PATH = USER_DIR + FILE_SEP + "MANIFEST.MF";

    public static Manifest getManifest() {
        return ManUtils.getManifest(MANIFEST_PATH);
    }

    public static Manifest getManifest(String path) {
        File file = new File(path);
        if (FilUtils.isVisibleFile(file)) {
            try {
                FileInputStream stream = new FileInputStream(file);
                return new Manifest(stream);
            }
            catch (IOException ex) {
                logger.fatal((Object)ex);
            }
        }
        return null;
    }

    public static String getBuiltBy(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue("Built-By");
    }

    public static String getManifestVersion(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.MANIFEST_VERSION);
    }

    public static String getSignatureVersion(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.SIGNATURE_VERSION);
    }

    public static String getContentType(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.CONTENT_TYPE);
    }

    public static String getClassPath(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.CLASS_PATH);
    }

    public static String getMainClass(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.MAIN_CLASS);
    }

    public static String getSealed(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.SEALED);
    }

    public static String getExtensionList(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.EXTENSION_LIST);
    }

    public static String getExtensionName(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.EXTENSION_NAME);
    }

    public static String getImplementationTitle(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    public static String getImplementationVersion(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public static String getImplementationVendor(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
    }

    public static String getImplementationDate(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue("Implementation-Date");
    }

    public static String getImplementationTimestamp(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue("Implementation-Timestamp");
    }

    public static String getSpecificationTitle(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
    }

    public static String getSpecificationVersion(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
    }

    public static String getSpecificationVendor(Manifest manifest) {
        if (manifest == null) {
            manifest = ManUtils.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
    }
}

