/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import org.apache.log4j.Logger;

public class RunUtils {
    private static final String[] suffix = new String[]{"b", "k", "m", "g"};

    public static void logMemory(Logger logger) {
        RunUtils.logMemory(logger, null);
    }

    public static void logMemory(Logger logger, String remarks) {
        long tm = Runtime.getRuntime().totalMemory();
        long fm = Runtime.getRuntime().freeMemory();
        long um = tm - fm;
        if (remarks != null) {
            logger.info((Object)remarks);
        }
        logger.info((Object)("used-memory=" + RunUtils.amount(um)));
        logger.info((Object)("free-memory=" + RunUtils.amount(fm)));
        logger.info((Object)("full-memory=" + RunUtils.amount(tm)));
    }

    private static String amount(long bytes) {
        return bytes / RunUtils.divisor(bytes) + RunUtils.suffix(bytes);
    }

    private static long divisor(long bytes) {
        for (int i = 3; i > 0; --i) {
            long p = (long)Math.pow(2.0, 10 * i);
            if (bytes <= 20L * p) continue;
            return p;
        }
        return 1L;
    }

    private static String suffix(long bytes) {
        for (int i = 3; i > 0; --i) {
            long p = (long)Math.pow(2.0, 10 * i);
            if (bytes <= 20L * p) continue;
            return suffix[i];
        }
        return suffix[0];
    }
}

