/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final Logger logger = Logger.getLogger(XmlUtils.class);
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String XML1 = "<?xml ";
    private static final String XML2 = "?>";
    private static final String LF = "\n";

    public static File toXmlFile(Object object) {
        if (object == null) {
            return null;
        }
        String pathname = USER_DIR + FILE_SEP + "xml" + FILE_SEP + object.getClass().getSimpleName() + ".xml";
        return XmlUtils.toXmlFile(object, pathname);
    }

    public static File toXmlFile(Object object, String pathname) {
        if (object == null || pathname == null) {
            return null;
        }
        File file = new File(pathname);
        if (file.getParentFile().isDirectory() || file.getParentFile().mkdirs()) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal(object, file);
                return file;
            }
            catch (JAXBException ex) {
                logger.error((Object)ex);
            }
        }
        return null;
    }

    public static String toXmlString(Object object) {
        return XmlUtils.toXmlString(object, false);
    }

    public static String toXmlString(Object object, boolean prologless) {
        if (object == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, (Writer)sw);
            String string = sw.toString();
            boolean prologued = StringUtils.startsWithIgnoreCase((String)string, (String)XML1);
            return prologued && prologless ? StringUtils.removeStart((String)StringUtils.substringAfter((String)string, (String)XML2), (String)LF) : string;
        }
        catch (JAXBException ex) {
            logger.error((Object)ex);
            return object.toString();
        }
    }

    public static String toPrettyString(String xml) {
        return XmlUtils.toPrettyString(xml, 4);
    }

    public static String toPrettyString(String xml, int indent) {
        if (StringUtils.isBlank((String)xml)) {
            return null;
        }
        try {
            byte[] bytes = xml.getBytes("utf-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
            document.normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | TransformerException | XPathExpressionException | DOMException | SAXException e) {
            return xml;
        }
    }
}

