/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.LogUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.core.AbstractArtifact;
import adalid.core.Instance;
import adalid.core.Operation;
import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.Transition;
import adalid.core.enums.ExpressionUsage;
import adalid.core.enums.OperationKind;
import adalid.core.expressions.VariantX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.ComparisonX;
import adalid.core.interfaces.ConditionalX;
import adalid.core.interfaces.DataAggregateX;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityExpression;
import adalid.core.interfaces.EnumerationEntity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NamedValue;
import adalid.core.interfaces.NaryExpression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.OrderedPairX;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.RowsAggregateX;
import adalid.core.interfaces.ScalarX;
import adalid.core.interfaces.SpecialValue;
import adalid.core.interfaces.State;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.interfaces.TypedArtifact;
import adalid.core.sql.QueryJoin;
import adalid.core.sql.QueryTable;
import adalid.core.wrappers.ExpressionWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractExpression
extends AbstractArtifact
implements NaryExpression {
    private static final Logger logger = Logger.getLogger(Expression.class);
    private static final String EOL = "\n";
    private static final String TAB = "\t";
    private Class<?> _dataType;
    private Expression _parentExpression;
    private Field _foreignExpressionField;
    private final List<ExpressionUsage> _verifiedUsages = new ArrayList<ExpressionUsage>();
    Set<String> crossReferencedExpressionsSet;

    public List<Operation> getInitialStateBusinessOperationsList() {
        Entity declaringEntity;
        ArrayList<Operation> list = new ArrayList<Operation>();
        if (this instanceof State && (declaringEntity = this.getDeclaringEntity()) != null) {
            for (Operation operation : declaringEntity.getBusinessOperationsList()) {
                if (!OperationKind.INSTANCE.equals((Object)operation.getOperationKind())) continue;
                for (Transition transition : operation.getTransitionsList()) {
                    State state;
                    if (transition == null || !this.equals(state = transition.getX()) || list.contains(operation)) continue;
                    list.add(operation);
                }
            }
        }
        return list;
    }

    public List<Operation> getFinalStateBusinessOperationsList() {
        Entity declaringEntity;
        ArrayList<Operation> list = new ArrayList<Operation>();
        if (this instanceof State && (declaringEntity = this.getDeclaringEntity()) != null) {
            for (Operation operation : declaringEntity.getBusinessOperationsList()) {
                if (!OperationKind.INSTANCE.equals((Object)operation.getOperationKind())) continue;
                for (Transition transition : operation.getTransitionsList()) {
                    State state;
                    if (transition == null || !this.equals(state = transition.getY()) || list.contains(operation)) continue;
                    list.add(operation);
                }
            }
        }
        return list;
    }

    @Override
    public Class<?> getDataType() {
        return this._dataType;
    }

    protected void setDataType(Class<?> dataType) {
        this._dataType = dataType;
    }

    @Override
    public Expression getParentExpression() {
        return this._parentExpression;
    }

    private void setParentExpression(Expression parentExpression) {
        if (parentExpression == null || this.getDeclaringArtifact() == null) {
            this._parentExpression = parentExpression;
            Object[] operands = this.getOperands();
            if (operands != null) {
                for (Object operand : operands) {
                    if (!(operand instanceof AbstractExpression)) continue;
                    AbstractExpression childExpression = (AbstractExpression)operand;
                    childExpression.setParentExpression(this);
                }
            }
        }
    }

    public Field getForeignExpressionField() {
        return this._foreignExpressionField;
    }

    protected void setForeignExpressionField(Field foreignExpressionField) {
        this._foreignExpressionField = foreignExpressionField;
    }

    public String getForeignExpressionName() {
        return this._foreignExpressionField == null ? null : this._foreignExpressionField.getName();
    }

    public Class<?> getForeignExpressionType() {
        return this._foreignExpressionField == null ? null : this._foreignExpressionField.getDeclaringClass();
    }

    @Override
    public List<ExpressionUsage> getVerifiedUsages() {
        return this._verifiedUsages;
    }

    @Override
    public Set<String> getStringsSet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Object[] operands = this.getOperands();
        if (operands != null) {
            for (Object operand : operands) {
                if (operand instanceof String) {
                    set.add(operand.toString());
                    continue;
                }
                if (!(operand instanceof Expression)) continue;
                Expression expression = (Expression)operand;
                set.addAll(expression.getStringsSet());
            }
        }
        return set;
    }

    @Override
    public List<Property> getReferencedColumnsList() {
        return new ArrayList<Property>(this.getReferencedColumnsMap().values());
    }

    public List<Property> getCorrespondingReferencedColumnsList(QueryTable searchQueryTable1, QueryTable searchQueryTable2) {
        Level level = Level.TRACE;
        String trace = this.getTrace();
        logger.log((Priority)level, (Object)(this.getFullName() + "/" + trace));
        List<Property> referencedColumnsList1 = this.getReferencedColumnsList();
        ArrayList<Property> referencedColumnsList2 = new ArrayList<Property>();
        for (Property property1 : referencedColumnsList1) {
            String alias = searchQueryTable1.getSqlAlias(property1);
            logger.log((Priority)level, (Object)("\t-" + searchQueryTable1.getName() + "/" + alias + " -> " + property1.getFullName()));
            Property property2 = searchQueryTable2.getProperty(alias);
            logger.log((Priority)level, (Object)("\t+" + searchQueryTable2.getName() + "/" + alias + " -> " + (property2 == null ? null : property2.getFullName())));
            if (property2 == null) continue;
            referencedColumnsList2.add(property2);
        }
        return referencedColumnsList2;
    }

    @Override
    public Map<String, Property> getReferencedColumnsMap() {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        Object[] operands = this.getOperands();
        if (operands != null) {
            for (Object operand : operands) {
                if (operand instanceof Property) {
                    Property property = (Property)operand;
                    map.put(property.getPathString(), property);
                    continue;
                }
                if (!(operand instanceof Expression)) continue;
                Expression expression = (Expression)operand;
                map.putAll(expression.getReferencedColumnsMap());
            }
        }
        return map;
    }

    @Override
    public List<QueryJoin> getReferencedJoinsList() {
        return new ArrayList<QueryJoin>(this.getReferencedJoinsMap().values());
    }

    @Override
    public List<QueryJoin> getReferencedJoinsList(QueryTable queryTable) {
        return new ArrayList<QueryJoin>(this.getReferencedJoinsMap(queryTable).values());
    }

    @Override
    public Map<String, QueryJoin> getReferencedJoinsMap() {
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity instanceof PersistentEntity) {
            PersistentEntity pent = (PersistentEntity)declaringEntity;
            QueryTable queryTable = pent.getQueryTable();
            return this.getReferencedJoinsMap(queryTable);
        }
        return new LinkedHashMap<String, QueryJoin>();
    }

    @Override
    public Map<String, QueryJoin> getReferencedJoinsMap(QueryTable queryTable) {
        List<Property> columns = this.getReferencedColumnsList();
        return queryTable.getReferencedJoinsMap(columns);
    }

    @Override
    public Set<String> getCrossReferencedExpressionsSet() {
        return this.getCrossReferencedExpressionsSet(this.getDeclaringEntity());
    }

    @Override
    public Set<String> getCrossReferencedExpressionsSet(Entity declaringEntity) {
        if (this.crossReferencedExpressionsSet == null) {
            Object[] operands;
            this.crossReferencedExpressionsSet = new LinkedHashSet<String>();
            if (declaringEntity != null && (operands = this.getOperands()) != null) {
                for (Object operand : operands) {
                    if (operand instanceof Primitive || !(operand instanceof Expression)) continue;
                    Expression expression = (Expression)operand;
                    Entity expressionDeclaringEntity = expression.getDeclaringEntity();
                    if (expressionDeclaringEntity == null || expressionDeclaringEntity.equals(declaringEntity)) {
                        this.crossReferencedExpressionsSet.addAll(expression.getCrossReferencedExpressionsSet(declaringEntity));
                        continue;
                    }
                    String key = expression.getCrossReferencedExpressionsKey();
                    if (key == null) continue;
                    this.crossReferencedExpressionsSet.add(key);
                }
            }
        }
        return this.crossReferencedExpressionsSet;
    }

    @Override
    public String getCrossReferencedExpressionsKey() {
        Entity declaringEntity = this.getDeclaringEntity();
        String key = declaringEntity == null ? null : declaringEntity.getRoot().getName() + "." + this.getName();
        return key;
    }

    @Override
    public boolean isCrossReferencedExpression() {
        return TLC.getProject().containsCrossReferencedExpression(this);
    }

    @Override
    public boolean isSingleEntityExpression() {
        Entity declaringEntity = this.getDeclaringEntity();
        return declaringEntity != null && this.isSingleEntityExpression(declaringEntity);
    }

    @Override
    public boolean isSingleEntityExpression(Entity declaringEntity) {
        if (declaringEntity == null) {
            return false;
        }
        Object[] operands = this.getOperands();
        if (operands != null) {
            for (Object operand : operands) {
                if (!(operand instanceof Expression)) continue;
                if (operand instanceof RowsAggregateX) {
                    return false;
                }
                Expression expression = (Expression)operand;
                Entity expressionDeclaringEntity = expression.getDeclaringEntity();
                if ((expressionDeclaringEntity == null || expressionDeclaringEntity.equals(declaringEntity)) && expression.isSingleEntityExpression(declaringEntity)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBooleanExpression() {
        return this instanceof BooleanExpression;
    }

    public boolean isCharacterExpression() {
        return this instanceof CharacterExpression;
    }

    public boolean isEntityExpression() {
        return this instanceof EntityExpression;
    }

    public boolean isNumericExpression() {
        return this instanceof NumericExpression;
    }

    public boolean isTemporalExpression() {
        return this instanceof TemporalExpression;
    }

    public boolean isComparisonExpression() {
        return this instanceof ComparisonX;
    }

    public boolean isConditionalExpression() {
        return this instanceof ConditionalX;
    }

    public boolean isDataAggregateExpression() {
        return this instanceof DataAggregateX;
    }

    public boolean isOrderedPairExpression() {
        return this instanceof OrderedPairX;
    }

    public boolean isRowsAggregateExpression() {
        return this instanceof RowsAggregateX;
    }

    public boolean isScalarExpression() {
        return this instanceof ScalarX;
    }

    public boolean isVariantExpression() {
        return this instanceof VariantX;
    }

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.checkArguments();
            this.setParentExpression(null);
        }
        return ok;
    }

    protected void checkArguments() {
        Level level;
        String name = this.getName();
        Artifact da = this.getDeclaringArtifact();
        boolean b1 = da instanceof Entity && da.depth() == 0;
        boolean b2 = da instanceof Operation;
        Entity declaringEntity = b1 ? (Entity)da : (b2 ? ((Operation)da).getDeclaringEntity() : null);
        boolean unusual = declaringEntity != null && declaringEntity.isUnusualExpressionsWarningsEnabled();
        Object object = level = unusual ? Project.getUnusualExpressionLevel() : null;
        if (LogUtils.fair(level)) {
            String expression = StringUtils.isBlank((String)name) ? " of " + da : " " + da + "." + name;
            this.checkUnusualArguments(expression, level);
        }
    }

    protected void checkUnusualArguments(String expression, Level level) {
        for (Object operand : this.getOperands()) {
            if (operand instanceof Instance) {
                this.checkUnusualInstance(expression, level, (Instance)operand);
                continue;
            }
            if (!(operand instanceof AbstractExpression)) continue;
            ((AbstractExpression)operand).checkUnusualArguments(expression, level);
        }
    }

    protected void checkUnusualInstance(String expression, Level level, Instance argument) {
        boolean ok;
        boolean bl = ok = argument.getDeclaringEntity() instanceof EnumerationEntity || argument.isUsualArgumentInExpressions();
        if (!ok) {
            String message = "unusual " + argument + " in expression" + expression + "; expressions usually include only instances of enumeration entities";
            logger.log((Priority)level, (Object)message);
            if (Level.ERROR.equals((Object)level) || Level.FATAL.equals((Object)level)) {
                Project.increaseParserErrorCount();
            } else if (Level.WARN.equals((Object)level)) {
                Project.increaseParserWarningCount();
            }
        }
    }

    protected void copyDataType(Object object) {
        this.setDataType(this.getObjectDataType(object));
    }

    protected Class<?> getObjectDataType(Object object) {
        if (object == null) {
            return Object.class;
        }
        if (object instanceof TypedArtifact) {
            TypedArtifact artifact = (TypedArtifact)object;
            return artifact.getDataType();
        }
        if (object instanceof Instance) {
            Instance instance = (Instance)object;
            Entity entity = instance.getDeclaringEntity();
            return entity != null ? entity.getDataType() : object.getClass();
        }
        if (object instanceof SpecialValue) {
            SpecialValue special = (SpecialValue)object;
            return special.getDataType();
        }
        return object.getClass();
    }

    public Expression getForeignExpression() {
        Entity foreignEntity;
        if (this._foreignExpressionField == null) {
            return null;
        }
        String errmsg = "failed to get foreign expression \"" + this._foreignExpressionField + "\" at " + this;
        Class<?> declaringClass = this._foreignExpressionField.getDeclaringClass();
        Entity declaringEntity = declaringClass == null ? null : this.getDeclaringEntity();
        Project declaringProject = declaringEntity == null ? null : declaringEntity.getDeclaringProject();
        Entity entity = foreignEntity = declaringProject == null ? null : declaringProject.getEntity(declaringClass);
        if (foreignEntity == null) {
            logger.error((Object)errmsg);
            logger.error((Object)("\tforeign expression field declaring class = " + declaringClass));
            logger.error((Object)("\tdeclaring entity = " + declaringEntity));
            logger.error((Object)("\tdeclaring project = " + declaringProject));
            logger.error((Object)("\tforeign entity = " + foreignEntity));
            Project.increaseParserErrorCount();
        } else {
            try {
                Object foreignExpression = this._foreignExpressionField.get(foreignEntity);
                if (foreignExpression instanceof Expression) {
                    return (Expression)foreignExpression;
                }
                logger.error((Object)errmsg);
                logger.error((Object)(TAB + this._foreignExpressionField + " = " + foreignExpression));
                Project.increaseParserErrorCount();
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                logger.error((Object)errmsg, ThrowableUtils.getCause(ex));
                Project.increaseParserErrorCount();
            }
        }
        return null;
    }

    public Class<? extends ExpressionWrapper> getDefaultWrapperClass() {
        return ExpressionWrapper.class;
    }

    @Override
    public String getExpressionString() {
        Object string;
        Operator operator = this.getOperator();
        Object[] operands = this.getOperands();
        Object object = string = operator == null ? "" : operator.name();
        if (operands != null && operands.length != 0) {
            Object[] strings = new String[operands.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = this.operandString(operands[i]);
            }
            string = (String)string + "(" + StringUtils.join((Object[])strings, (String)", ") + ")";
        }
        return string;
    }

    private String operandString(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Entity) {
            return ((Artifact)operand).getFullName();
        }
        if (operand instanceof Instance) {
            return ((Artifact)operand).getFullName();
        }
        if (operand instanceof NamedValue) {
            return ((NamedValue)operand).name();
        }
        if (operand instanceof Expression) {
            return ((Expression)operand).getExpressionString();
        }
        if (operand instanceof Artifact) {
            return ((Artifact)operand).getFullName();
        }
        return "" + operand;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "type" + faa + this._dataType + foo;
            string = (String)string + fee + tab + "parentExpression" + faa + this._parentExpression + foo;
        }
        return string;
    }

    private void track(String method) {
        this.track(method, this);
    }

    private void track(String method, Object ... parameters) {
        TLC.getProject().getParser().track(this.depth(), this.round(), this.getClassPath(), method, parameters);
    }
}

