/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.core.AbstractPersistentEntity;
import adalid.core.Instance;
import adalid.core.InstanceField;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.annotations.DiscriminatorColumn;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityExportOperation;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntityReportOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.StateProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.PersistentEnumerationEntityReference;
import adalid.core.interfaces.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

@EntityClass(resourceType=ResourceType.CONFIGURATION)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE, rowsLimit=0)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityReportOperation(enabled=Kleenean.FALSE)
@EntityExportOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.UNSPECIFIED)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
@EntityReferenceSearch(searchType=SearchType.LIST)
public abstract class AbstractPersistentEnumerationEntity
extends AbstractPersistentEntity
implements PersistentEnumerationEntityReference {
    private static final Logger logger = Logger.getLogger(Entity.class);
    private Instance[] _removeInstanceArray;
    private Instance[] _searchInstanceArray;

    public AbstractPersistentEnumerationEntity(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.check();
        }
        return ok;
    }

    private void check() {
        if (this.isRootInstance()) {
            if (this.getBusinessKeyProperty() == null) {
                String message = this.getName() + " does not have a busines key property";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            this.checkInstances();
        }
    }

    private void checkInstances() {
        List<Instance> instances = this.getInstancesList();
        if (instances.isEmpty()) {
            logger.error((Object)("enumeration entity " + this.getFullName() + " has no instances"));
            Project.increaseParserErrorCount();
        } else {
            Set<Locale> supportedLocales = TLC.getProject().getSupportedLocales();
            if (supportedLocales != null && !supportedLocales.isEmpty()) {
                ArrayList<String> labels = new ArrayList<String>();
                Property businessKeyProperty = this.getBusinessKeyProperty();
                for (Locale locale : supportedLocales) {
                    labels.clear();
                    block1: for (Instance instance : instances) {
                        String name = instance.getFullName();
                        for (InstanceField field : instance.getInstanceFieldsList()) {
                            if (!businessKeyProperty.equals(field.getProperty())) continue;
                            String value = field.getLocalizedValue(locale);
                            if (value == null) {
                                value = StrUtils.getWordyString(instance.getName());
                            }
                            if (labels.contains(value)) {
                                logger.error((Object)(name + " has duplicated business key \"" + value + "\" for locale \"" + locale + "\""));
                                Project.increaseParserErrorCount();
                                continue block1;
                            }
                            labels.add(value);
                            continue block1;
                        }
                        logger.error((Object)(name + " has no business key value for locale \"" + locale + "\""));
                        Project.increaseParserErrorCount();
                    }
                }
            }
        }
    }

    @Override
    public boolean isInsertEnabled() {
        return false;
    }

    @Override
    public boolean isUpdateEnabled() {
        if (super.isUpdateEnabled()) {
            List<Property> list = this.getPropertiesList();
            for (Property property : list) {
                if (!property.isUpdateField() || !property.isTableField() && (!property.isDetailField() || !this.isDetailViewEnabled())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDeleteEnabled() {
        return false;
    }

    @Override
    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidFieldAnnotations();
        if (this.isProperty()) {
            valid.add(DiscriminatorColumn.class);
            valid.add(StateProperty.class);
        }
        return valid;
    }

    public boolean isSelectItemsWithFilter() {
        return this._removeInstanceArray != null && this._removeInstanceArray.length > 0 || this._searchInstanceArray != null && this._searchInstanceArray.length > 0;
    }

    public Instance[] getSelectItemsArray() {
        List<Instance> list = this.getSelectItemsList();
        Instance[] array = new Instance[list.size()];
        return list.toArray(array);
    }

    public List<Instance> getSelectItemsList() {
        List<Instance> list = this.getInstancesList();
        if (this._removeInstanceArray != null && this._removeInstanceArray.length > 0) {
            List<Instance> remove = Arrays.asList(this._removeInstanceArray);
            list.removeAll(remove);
        }
        if (this._searchInstanceArray != null && this._searchInstanceArray.length > 0) {
            List<Instance> retain = Arrays.asList(this._searchInstanceArray);
            list.retainAll(retain);
        }
        return list;
    }

    public Instance[] getRemoveInstanceArray() {
        return this._removeInstanceArray;
    }

    public void setRemoveInstanceArray(Instance ... instances) {
        this._removeInstanceArray = instances;
        this._searchInstanceArray = null;
    }

    public String[] getRemoveInstanceStringArray() {
        if (this._removeInstanceArray == null || this._removeInstanceArray.length == 0) {
            return null;
        }
        int n = this._removeInstanceArray.length;
        String[] strings = new String[n];
        for (int i = 0; i < n; ++i) {
            strings[i] = this._removeInstanceArray[i].getInstanceKeyValue().toString();
        }
        return strings;
    }

    public Instance[] getSearchInstanceArray() {
        if (this._searchInstanceArray == null && this._removeInstanceArray != null && this._removeInstanceArray.length > 0) {
            this._searchInstanceArray = this.getInsertableRowsList().toArray(new Instance[0]);
            for (Instance instance : this._removeInstanceArray) {
                this._searchInstanceArray = (Instance[])ArrayUtils.removeElement((Object[])this._searchInstanceArray, (Object)instance);
            }
        }
        return this._searchInstanceArray;
    }

    public void setSearchInstanceArray(Instance ... instances) {
        this._searchInstanceArray = instances;
        this._removeInstanceArray = null;
    }

    public String[] getSearchInstanceStringArray() {
        if (this._searchInstanceArray == null || this._searchInstanceArray.length == 0) {
            return null;
        }
        int n = this._searchInstanceArray.length;
        String[] strings = new String[n];
        for (int i = 0; i < n; ++i) {
            strings[i] = this._searchInstanceArray[i].getInstanceKeyValue().toString();
        }
        return strings;
    }
}

