/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.LogUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.core.AbstractArtifact;
import adalid.core.EntityCollection;
import adalid.core.Instance;
import adalid.core.Key;
import adalid.core.Operation;
import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.Step;
import adalid.core.TLC;
import adalid.core.Tab;
import adalid.core.Transition;
import adalid.core.Trigger;
import adalid.core.View;
import adalid.core.XS1;
import adalid.core.annotations.CastingField;
import adalid.core.annotations.Extension;
import adalid.core.exceptions.InstantiationRuntimeException;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NamedValue;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class EntityAtlas {
    private static final Logger logger = Logger.getLogger(EntityAtlas.class);
    private static final Logger parserLogger = Logger.getLogger(Project.Parser.class);
    private static final String EOL = "\n";
    private static final String TAB = "\t";
    private final Entity _declaringArtifact;
    private final Map<String, Property> _properties = new LinkedHashMap<String, Property>();
    private final Map<String, EntityCollection> _entityCollections = new LinkedHashMap<String, EntityCollection>();
    private final Map<String, Property> _references = new LinkedHashMap<String, Property>();
    private final Map<String, Parameter> _parameterReferences = new LinkedHashMap<String, Parameter>();
    private final Map<String, Key> _keys = new LinkedHashMap<String, Key>();
    private final Map<String, Step> _steps = new LinkedHashMap<String, Step>();
    private final Map<String, Tab> _tabs = new LinkedHashMap<String, Tab>();
    private final Map<String, View> _views = new LinkedHashMap<String, View>();
    private final Map<String, Instance> _instances = new LinkedHashMap<String, Instance>();
    private final Map<String, NamedValue> _namedValues = new LinkedHashMap<String, NamedValue>();
    private final Map<String, Expression> _expressions = new LinkedHashMap<String, Expression>();
    private final Map<String, Transition> _transitions = new LinkedHashMap<String, Transition>();
    private final Map<String, Operation> _operations = new LinkedHashMap<String, Operation>();
    private final Map<String, Trigger> _triggers = new LinkedHashMap<String, Trigger>();
    private final Map<String, Class<?>> _operationClasses = new LinkedHashMap();
    private final Map<String, Field> _operationFields = new LinkedHashMap<String, Field>();
    char prepareFields;
    char prepareProperty;
    char prepareKey;
    char prepareStep;
    char prepareTab;
    char prepareView;
    char prepareInstance;
    char prepareExpression;
    char prepareTransition;
    char prepareOperation;
    char prepareTrigger;
    private int referenceIndex = 0;

    List<Property> getPropertiesList() {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Property value : this._properties.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<EntityCollection> getEntityCollectionsList() {
        ArrayList<EntityCollection> list = new ArrayList<EntityCollection>();
        for (EntityCollection value : this._entityCollections.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Property> getReferencesList() {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Property value : this._references.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Parameter> getParameterReferencesList() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Parameter value : this._parameterReferences.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Key> getKeysList() {
        ArrayList<Key> list = new ArrayList<Key>();
        for (Key value : this._keys.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Step> getStepsList() {
        ArrayList<Step> list = new ArrayList<Step>();
        for (Step value : this._steps.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Tab> getTabsList() {
        ArrayList<Tab> list = new ArrayList<Tab>();
        for (Tab value : this._tabs.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<View> getViewsList() {
        ArrayList<View> list = new ArrayList<View>();
        for (View value : this._views.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Instance> getInstancesList() {
        ArrayList<Instance> list = new ArrayList<Instance>();
        for (Instance value : this._instances.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<NamedValue> getNamedValuesList() {
        ArrayList<NamedValue> list = new ArrayList<NamedValue>();
        for (NamedValue value : this._namedValues.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Expression> getExpressionsList() {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Expression value : this._expressions.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    public List<Transition> getTransitionsList() {
        ArrayList<Transition> list = new ArrayList<Transition>();
        for (Transition value : this._transitions.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Operation> getOperationsList() {
        ArrayList<Operation> list = new ArrayList<Operation>();
        for (Operation value : this._operations.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    List<Trigger> getTriggersList() {
        ArrayList<Trigger> list = new ArrayList<Trigger>();
        for (Trigger value : this._triggers.values()) {
            if (value == null || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    Map<String, Property> getPropertiesMap() {
        return this._properties;
    }

    Map<String, EntityCollection> getEntityCollectionsMap() {
        return this._entityCollections;
    }

    Map<String, Property> getReferencesMap() {
        return this._references;
    }

    Map<String, Parameter> getParameterReferencesMap() {
        return this._parameterReferences;
    }

    Map<String, Key> getKeysMap() {
        return this._keys;
    }

    Map<String, Step> getStepsMap() {
        return this._steps;
    }

    Map<String, Tab> getTabsMap() {
        return this._tabs;
    }

    Map<String, View> getViewsMap() {
        return this._views;
    }

    Map<String, Instance> getInstancesMap() {
        return this._instances;
    }

    Map<String, NamedValue> getNamedValuesMap() {
        return this._namedValues;
    }

    Map<String, Expression> getExpressionsMap() {
        return this._expressions;
    }

    public Map<String, Transition> getTransitionsMap() {
        return this._transitions;
    }

    Map<String, Operation> getOperationsMap() {
        return this._operations;
    }

    Map<String, Trigger> getTriggersMap() {
        return this._triggers;
    }

    Map<String, Class<?>> getOperationClassesMap() {
        return this._operationClasses;
    }

    EntityAtlas(Entity declaringArtifact) {
        this._declaringArtifact = declaringArtifact;
    }

    void prepare() {
    }

    void finalise() {
        this.finaliseFields();
    }

    void checkOperationClasses() {
        Class<?>[] classArray;
        this.track("checkOperationClasses", new Object[0]);
        Class<?> dac = this._declaringArtifact.getClass();
        for (Class<?> clazz : classArray = dac.getClasses()) {
            if (!Operation.class.isAssignableFrom(clazz)) continue;
            String key = clazz.getSimpleName();
            if (this._operationClasses.containsKey(key)) {
                Class<?> operationClass = this._operationClasses.get(key);
                if (operationClass.equals(clazz)) continue;
                if (operationClass.isAssignableFrom(clazz)) {
                    this._operationClasses.put(key, clazz);
                    continue;
                }
                if (clazz.isAssignableFrom(operationClass)) continue;
                String pattern = "{0} is not assignable from {1}";
                String remarks = MessageFormat.format(pattern, operationClass.getName(), clazz.getName());
                this.logOperationReferenceOverride(Level.ERROR, clazz, operationClass, dac, remarks);
                Project.increaseParserErrorCount();
                continue;
            }
            this._operationClasses.put(key, clazz);
            this._operationFields.put(key, null);
        }
    }

    void checkOperationFields() {
        this.track("checkOperationFields", new Object[0]);
        String pattern = "there is no field for operation {0}";
        Set<String> keySet = this._operationFields.keySet();
        for (String key : keySet) {
            Class<?> operationClass = this._operationClasses.get(key);
            Field operationField = this._operationFields.get(key);
            if (operationField != null) continue;
            String message = MessageFormat.format(pattern, operationClass.getName());
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        }
    }

    private void logOperationReferenceOverride(Level level, Class<?> riding, Class<?> ridden, Class<?> declaring, String remarks) {
        Level detailLevel;
        if (LogUtils.foul(logger, level)) {
            return;
        }
        Object pattern = level.isGreaterOrEqual((Priority)Level.ERROR) ? "failed to override" : "overriding";
        pattern = (String)pattern + " reference to operation {0} at entity {1}";
        String message = MessageFormat.format((String)pattern, riding.getSimpleName(), declaring.getSimpleName());
        parserLogger.log((Priority)level, (Object)message);
        Level level2 = detailLevel = level.isGreaterOrEqual((Priority)Level.WARN) ? level : Project.getDetailLevel();
        if (LogUtils.foul(logger, detailLevel)) {
            return;
        }
        parserLogger.log((Priority)detailLevel, (Object)("\toverriding class: " + riding.getName()));
        parserLogger.log((Priority)detailLevel, (Object)("\toverridden class: " + ridden.getName()));
        if (StringUtils.isNotBlank((String)remarks)) {
            parserLogger.log((Priority)detailLevel, (Object)(TAB + remarks));
        }
    }

    void initialiseFields(Class<?> clazz) {
        this.track("initialiseFields", this._declaringArtifact, clazz.getSimpleName());
        String pattern = "there are several fields for operation {0}";
        int depth = this._declaringArtifact.depth();
        int round = this._declaringArtifact.round();
        Object[] classes = new Class[]{Property.class, EntityCollection.class, Key.class, Step.class, Tab.class, View.class, Instance.class, NamedValue.class, Expression.class, Transition.class, Operation.class, Trigger.class};
        Class<?> dac = this._declaringArtifact.getClass();
        Class<Entity> top = Entity.class;
        int i = ArrayUtils.indexOf((Object[])classes, clazz);
        if (i != -1) {
            Object c = classes[i];
            for (Field field : XS1.getFields(dac, top, c)) {
                String key;
                Class<?> operationClass;
                field.setAccessible(true);
                logger.trace((Object)field);
                String name = field.getName();
                Class<?> type = field.getType();
                if (c.equals(Expression.class) && Property.class.isAssignableFrom(type) || field.isAnnotationPresent(Extension.class) && Entity.class.isAssignableFrom(type)) continue;
                int modifiers = type.getModifiers();
                boolean restricted = NamedValue.class.isAssignableFrom(type) || Expression.class.isAssignableFrom(type) ? false : type.isInterface() || Modifier.isAbstract(modifiers);
                if ((restricted = restricted || !Modifier.isPublic(modifiers)) || (restricted = Modifier.isPrivate(modifiers = field.getModifiers())) || (restricted = Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers))) continue;
                if (Operation.class.isAssignableFrom(type) && (operationClass = this._operationClasses.get(key = type.getSimpleName())) != null) {
                    Field operationField = this._operationFields.get(key);
                    if (operationField == null) {
                        this._operationFields.put(key, field);
                    } else {
                        String message = MessageFormat.format(pattern, operationClass.getName());
                        logger.warn((Object)message);
                        Project.increaseParserWarningCount();
                    }
                }
                String errmsg = "failed to create a new instance of field \"" + field + "\" at " + this._declaringArtifact;
                try {
                    Object o = field.get(this._declaringArtifact);
                    if (o != null) continue;
                    logger.debug((Object)this.message(type, name, o, depth, round));
                    o = XS1.initialiseField(this._declaringArtifact, field);
                    if (o == null) {
                        logger.debug((Object)this.message(type, name, o, depth, round));
                        continue;
                    }
                    logger.debug((Object)this.message(type, name, o, depth, round));
                    field.set(this._declaringArtifact, o);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new InstantiationRuntimeException(errmsg, ex);
                }
            }
        }
    }

    private void finaliseFields() {
        int depth = this._declaringArtifact.depth();
        int round = this._declaringArtifact.round();
        int index = this._declaringArtifact.getStartWith();
        Class[] classes = new Class[]{Property.class, EntityCollection.class, Key.class, Step.class, Tab.class, View.class, Instance.class, NamedValue.class, Expression.class, Transition.class, Operation.class, Trigger.class};
        Class<?> dac = this._declaringArtifact.getClass();
        Class<Entity> top = Entity.class;
        for (Class c : classes) {
            for (Field field : XS1.getFields(dac, top, c)) {
                int modifiers;
                boolean restricted;
                field.setAccessible(true);
                logger.trace((Object)field);
                String name = field.getName();
                Class<?> type = field.getType();
                if (c.equals(Expression.class) && Property.class.isAssignableFrom(type) || (restricted = Modifier.isPrivate(modifiers = field.getModifiers()))) continue;
                boolean bl = restricted = Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers);
                if (restricted) continue;
                String errmsg = "failed to finalize field \"" + field + "\" at " + this._declaringArtifact;
                try {
                    Object o = field.get(this._declaringArtifact);
                    if (o == null) {
                        logger.debug((Object)this.message(type, name, o, depth, round));
                        continue;
                    }
                    if (o instanceof Property) {
                        this.finaliseProperty(field, (Property)o);
                        continue;
                    }
                    if (o instanceof EntityCollection) {
                        this.finaliseEntityCollection(field, (EntityCollection)o);
                        continue;
                    }
                    if (o instanceof Key) {
                        this.finaliseKey(field, (Key)o);
                        continue;
                    }
                    if (o instanceof Step) {
                        this.finaliseStep(field, (Step)o);
                        continue;
                    }
                    if (o instanceof Tab) {
                        this.finaliseTab(field, (Tab)o);
                        continue;
                    }
                    if (o instanceof View) {
                        this.finaliseView(field, (View)o);
                        continue;
                    }
                    if (o instanceof Instance) {
                        this.finaliseInstance(field, (Instance)o, index++);
                        continue;
                    }
                    if (o instanceof NamedValue) {
                        this.finaliseNamedValue(field, (NamedValue)o);
                        continue;
                    }
                    if (o instanceof Expression) {
                        this.finaliseExpression(field, (Expression)o);
                        continue;
                    }
                    if (o instanceof Transition) {
                        this.finaliseTransition(field, (Transition)o);
                        continue;
                    }
                    if (o instanceof Operation) {
                        this.finaliseOperation(field, (Operation)o);
                        continue;
                    }
                    if (!(o instanceof Trigger)) continue;
                    this.finaliseTrigger(field, (Trigger)o);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    logger.error((Object)errmsg, ThrowableUtils.getCause(ex));
                    Project.increaseParserErrorCount();
                }
            }
        }
    }

    int referencePropertiesCount() {
        return this.referenceIndex;
    }

    private void finaliseProperty(Field field, Property property) {
        Primitive primitive;
        if (field == null || property == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._properties.containsKey(key)) {
            return;
        }
        if (field.isAnnotationPresent(CastingField.class)) {
            XS1.annotateCastingField(field, property);
            return;
        }
        if (property.isNotDeclared()) {
            XS1.declare(property, this._declaringArtifact, field);
        }
        if (property instanceof Entity) {
            Entity root;
            boolean x;
            Entity entity = (Entity)((Object)property);
            ++this.referenceIndex;
            XS1.setReferenceIndex(entity, this.referenceIndex);
            if (!entity.isFinalised()) {
                entity.finalise();
            }
            boolean bl = x = property.depth() > 1 || property.isClassInPath(Operation.class);
            if (!x && (root = entity.getRoot()) != null) {
                root.getReferencesMap().put(property.getPathString(), property);
            }
        } else if (property instanceof Primitive && !(primitive = (Primitive)property).isFinalised()) {
            primitive.finalise();
        }
        if (!field.isAnnotationPresent(Extension.class)) {
            this._properties.put(key, property);
        }
    }

    private void finaliseEntityCollection(Field field, EntityCollection collection) {
        if (field == null || collection == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._entityCollections.containsKey(key)) {
            return;
        }
        if (collection.isNotDeclared()) {
            XS1.declare(collection, this._declaringArtifact, field);
        }
        if (!collection.isFinalised()) {
            collection.finalise();
        }
        this._entityCollections.put(key, collection);
    }

    private void finaliseKey(Field field, Key entityKey) {
        if (field == null || entityKey == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._keys.containsKey(key)) {
            return;
        }
        if (entityKey.isNotDeclared()) {
            entityKey.setDeclared(key, this._declaringArtifact, field);
        }
        if (!entityKey.isFinalised()) {
            entityKey.finalise();
        }
        this._keys.put(key, entityKey);
    }

    private void finaliseStep(Field field, Step entityStep) {
        if (field == null || entityStep == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._steps.containsKey(key)) {
            return;
        }
        if (entityStep.isNotDeclared()) {
            entityStep.setDeclared(key, this._declaringArtifact, field);
        }
        if (!entityStep.isFinalised()) {
            entityStep.finalise();
        }
        this._steps.put(key, entityStep);
    }

    private void finaliseTab(Field field, Tab entityTab) {
        if (field == null || entityTab == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._tabs.containsKey(key)) {
            return;
        }
        if (entityTab.isNotDeclared()) {
            entityTab.setDeclared(key, this._declaringArtifact, field);
        }
        if (!entityTab.isFinalised()) {
            entityTab.finalise();
        }
        this._tabs.put(key, entityTab);
    }

    private void finaliseView(Field field, View entityView) {
        if (field == null || entityView == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._views.containsKey(key)) {
            return;
        }
        if (entityView.isNotDeclared()) {
            entityView.setDeclared(key, this._declaringArtifact, field);
        }
        if (!entityView.isFinalised()) {
            entityView.finalise();
        }
        this._views.put(key, entityView);
    }

    private void finaliseInstance(Field field, Instance entityInstance, int index) {
        if (field == null || entityInstance == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._instances.containsKey(key)) {
            return;
        }
        if (entityInstance.isNotDeclared()) {
            entityInstance.setDeclared(key, this._declaringArtifact, field);
            entityInstance.annotate();
        }
        if (!entityInstance.isFinalised()) {
            entityInstance.finalise(index);
        }
        this._instances.put(key, entityInstance);
    }

    private void finaliseNamedValue(Field field, NamedValue namedValue) {
        if (field == null || namedValue == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._namedValues.containsKey(key)) {
            return;
        }
        this._namedValues.put(key, namedValue);
    }

    private void finaliseExpression(Field field, Expression expression) {
        if (field == null || expression == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._expressions.containsKey(key)) {
            return;
        }
        if (expression.isNotDeclared()) {
            XS1.declare(expression, this._declaringArtifact, field);
        }
        if (!expression.isFinalised()) {
            expression.finalise();
        }
        this._expressions.put(key, expression);
    }

    private void finaliseTransition(Field field, Transition transition) {
        if (field == null || transition == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._transitions.containsKey(key)) {
            return;
        }
        if (transition.isNotDeclared()) {
            transition.setDeclared(key, this._declaringArtifact, field);
        }
        this._transitions.put(key, transition);
    }

    private void finaliseOperation(Field field, Operation operation) {
        if (field == null || operation == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._operations.containsKey(key)) {
            return;
        }
        if (operation.isNotDeclared()) {
            operation.setDeclared(key, this._declaringArtifact, field);
            operation.annotate();
        }
        if (!operation.isFinalised()) {
            operation.finalise();
        }
        this._operations.put(key, operation);
    }

    private void finaliseTrigger(Field field, Trigger trigger) {
        if (field == null || trigger == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._triggers.containsKey(key)) {
            return;
        }
        if (trigger.isNotDeclared()) {
            trigger.setDeclared(key, this._declaringArtifact, field);
        }
        this._triggers.put(key, trigger);
    }

    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = "";
        if (fields || verbose) {
            string = (String)string + fee + tab + "properties" + faa + this._properties.size() + foo;
            string = (String)string + fee + tab + "references" + faa + this._references.size() + foo;
            string = (String)string + fee + tab + "keys" + faa + this._keys.size() + foo;
            string = (String)string + fee + tab + "steps" + faa + this._steps.size() + foo;
            string = (String)string + fee + tab + "tabs" + faa + this._tabs.size() + foo;
            string = (String)string + fee + tab + "views" + faa + this._views.size() + foo;
            string = (String)string + fee + tab + "instances" + faa + this._instances.size() + foo;
            string = (String)string + fee + tab + "values" + faa + this._namedValues.size() + foo;
            string = (String)string + fee + tab + "expressions" + faa + this._expressions.size() + foo;
            string = (String)string + fee + tab + "transitions" + faa + this._transitions.size() + foo;
            string = (String)string + fee + tab + "operations" + faa + this._operations.size() + foo;
            string = (String)string + fee + tab + "triggers" + faa + this._triggers.size() + foo;
            if (verbose) {
                // empty if block
            }
        }
        return string;
    }

    protected String mapsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        return this.mapsToString(n, key, verbose, fields, maps, true);
    }

    protected String mapsToString(int n, String key, boolean verbose, boolean fields, boolean maps, boolean d0) {
        Object string = "";
        if (maps || verbose) {
            Object valor;
            Entity e;
            Property p;
            for (String clave : this._properties.keySet()) {
                p = this._properties.get(clave);
                if (p instanceof Entity) {
                    e = (Entity)((Object)p);
                    string = (String)string + e.toString(n + 1, clave, verbose && d0, fields, maps & e.round() == 0);
                    continue;
                }
                if (p == null) continue;
                string = (String)string + p.toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._keys.keySet()) {
                valor = this._keys.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._steps.keySet()) {
                valor = this._steps.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._tabs.keySet()) {
                valor = this._tabs.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._views.keySet()) {
                valor = this._views.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._instances.keySet()) {
                valor = this._instances.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._namedValues.keySet()) {
                valor = this._namedValues.get(clave);
                string = (String)string + valor.name();
            }
            for (String clave : this._expressions.keySet()) {
                valor = this._expressions.get(clave);
                string = (String)string + valor.toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._transitions.keySet()) {
                valor = this._transitions.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose, fields, maps);
            }
            for (String clave : this._operations.keySet()) {
                valor = this._operations.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._triggers.keySet()) {
                valor = this._triggers.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose && d0, fields, maps);
            }
            for (String clave : this._references.keySet()) {
                p = this._references.get(clave);
                if (p instanceof Entity) {
                    e = (Entity)((Object)p);
                    string = (String)string + e.toString(n + 1, "<" + clave + ">", false, false, false);
                    continue;
                }
                if (p == null) continue;
                string = (String)string + p.toString(n + 1, "\u00bf" + clave + "?", false, false, false);
            }
        }
        return string;
    }

    private String message(Class<?> type, String name, Object value, int depth, int round) {
        String s1 = StringUtils.repeat((String)" ", (int)(0 + 4 * depth));
        String s2 = this._declaringArtifact + "," + depth + "," + round;
        String s3 = type.getSimpleName() + " " + name + "=" + value;
        String s4 = s1 + s2 + " " + s3;
        return s4;
    }

    private void track(String method, Object ... parameters) {
        Entity da = this._declaringArtifact;
        TLC.getProject().getParser().track(da.depth(), da.round(), da.getClassPath(), method, parameters);
    }
}

