/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.ColUtils;
import adalid.core.AbstractArtifact;
import adalid.core.Display;
import adalid.core.EntityCollectionAggregate;
import adalid.core.Project;
import adalid.core.Step;
import adalid.core.TLC;
import adalid.core.Tab;
import adalid.core.XS1;
import adalid.core.annotations.EntityCollectionField;
import adalid.core.annotations.OneToMany;
import adalid.core.enums.AggregateFunction;
import adalid.core.enums.CascadeType;
import adalid.core.enums.DataEntryFormat;
import adalid.core.enums.FetchType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.PropertyAccess;
import adalid.core.interfaces.AnnotatableArtifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Property;
import adalid.core.primitives.BooleanPrimitive;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EntityCollection
extends AbstractArtifact
implements AnnotatableArtifact {
    private static final Logger logger = Logger.getLogger(EntityCollection.class);
    private static final CascadeType[] default_cascade_type = new CascadeType[]{CascadeType.PERSIST, CascadeType.REFRESH};
    private boolean _annotatedWithOneToMany;
    private boolean _annotatedWithEntityCollectionField;
    private Entity _sourceEntity;
    private Class _targetEntityClass = Void.TYPE;
    private Entity _targetEntity;
    private String _mappedByFieldName;
    private Field _mappedByField;
    private Property _mappedByProperty;
    private FetchType _fetchType = FetchType.UNSPECIFIED;
    private CascadeType[] _cascadeType = default_cascade_type;
    private List<CascadeType> _cascadeList = Arrays.asList(default_cascade_type);
    private Kleenean _orphanRemoval = Kleenean.UNSPECIFIED;
    private Kleenean _createField = Kleenean.UNSPECIFIED;
    private Kleenean _updateField = Kleenean.UNSPECIFIED;
    private Kleenean _removeField = Kleenean.UNSPECIFIED;
    private Kleenean _detailField = Kleenean.UNSPECIFIED;
    private boolean _renderingFilterReadOnly;
    private BooleanExpression _renderingFilter;
    private PropertyAccess _propertyAccess = PropertyAccess.UNSPECIFIED;
    private DataEntryFormat _dataEntryFormat = DataEntryFormat.UNSPECIFIED;
    private Step _step;
    private Tab _tab;
    private Display _display;
    private Display _tableDisplay;
    private Display _detailDisplay;
    private final Map<Entity, Display> _extensionDisplays = new LinkedHashMap<Entity, Display>();
    private final Map<String, EntityCollectionAggregate> _aggregates = new LinkedHashMap<String, EntityCollectionAggregate>();

    public Entity getSourceEntity() {
        return this._sourceEntity;
    }

    public Class getTargetEntityClass() {
        return this._targetEntityClass;
    }

    public Entity getTargetEntity() {
        return this._targetEntity;
    }

    public String getMappedByFieldName() {
        return this._mappedByFieldName;
    }

    public Field getMappedByField() {
        return this._mappedByField;
    }

    public Property getMappedByProperty() {
        return this._mappedByProperty;
    }

    public boolean isOneToMany() {
        return this._annotatedWithOneToMany;
    }

    public FetchType getFetchType() {
        return FetchType.UNSPECIFIED.equals((Object)this._fetchType) ? (this.isUpdateField() ? FetchType.EAGER : FetchType.LAZY) : this._fetchType;
    }

    public void setFetchType(FetchType fetchType) {
        this._fetchType = fetchType == null ? FetchType.UNSPECIFIED : fetchType;
    }

    public CascadeType[] getCascadeType() {
        return this._cascadeType;
    }

    public void setCascadeType(CascadeType ... cascadeType) {
        this._cascadeType = this.cascadeTypeOf(cascadeType);
        this._cascadeList = Arrays.asList(this._cascadeType);
    }

    private CascadeType[] cascadeTypeOf(CascadeType ... cascadeType) {
        return cascadeType == null || cascadeType.length == 0 ? (this._cascadeType == null ? default_cascade_type : this._cascadeType) : cascadeType;
    }

    public String getCascadeTypeString() {
        if (ArrayUtils.contains((Object[])this._cascadeType, (Object)((Object)CascadeType.UNSPECIFIED))) {
            return null;
        }
        if (ArrayUtils.contains((Object[])this._cascadeType, (Object)((Object)CascadeType.ALL))) {
            return "CascadeType.ALL";
        }
        EnumSet<CascadeType> set = EnumSet.noneOf(CascadeType.class);
        if (this.cascadeListContainsAny(CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE)) {
            set.add(CascadeType.REFRESH);
        }
        set.addAll(this._cascadeList);
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (CascadeType ct : set) {
            list.add((CallSite)((Object)("CascadeType." + ct.name())));
        }
        return list.size() == 1 ? (String)list.get(0) : "{" + StringUtils.join(list, (String)", ") + "}";
    }

    public boolean isCascadeRefresh() {
        return this.cascadeListContainsAny(CascadeType.ALL, CascadeType.REFRESH, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE);
    }

    public boolean isCascadePersist() {
        return this.cascadeListContainsAny(CascadeType.ALL, CascadeType.PERSIST);
    }

    public boolean isCascadeMerge() {
        return this.cascadeListContainsAny(CascadeType.ALL, CascadeType.MERGE);
    }

    public boolean isCascadeRemove() {
        return this.cascadeListContainsAny(CascadeType.ALL, CascadeType.REMOVE);
    }

    private boolean cascadeListContainsAny(CascadeType ... types) {
        return !Collections.disjoint(this._cascadeList, Arrays.asList(types));
    }

    public boolean isOrphanRemoval() {
        return this._orphanRemoval.toBoolean(this.isUpdateField());
    }

    public void setOrphanRemoval(boolean remove) {
        this._orphanRemoval = Kleenean.valueOf(remove);
    }

    public boolean isCreateField() {
        boolean cascade = this.isCascadePersist();
        return cascade && this._createField.toBoolean(cascade);
    }

    public void setCreateField(boolean create) {
        this._createField = Kleenean.valueOf(create);
    }

    public boolean isUpdateField() {
        boolean cascade = this.isCascadeMerge();
        return cascade && this._updateField.toBoolean(cascade);
    }

    public void setUpdateField(boolean update) {
        this._updateField = Kleenean.valueOf(update);
    }

    boolean isRemoveField() {
        boolean cascade = this.isCascadeRemove();
        return cascade && this._removeField.toBoolean(cascade);
    }

    void setRemoveField(boolean remove) {
        this._removeField = Kleenean.valueOf(remove);
    }

    public boolean isDetailField() {
        boolean cascade = this.isCascadeRefresh();
        return cascade && this._detailField.toBoolean(cascade);
    }

    public void setDetailField(boolean detail) {
        this._detailField = Kleenean.valueOf(detail);
    }

    public boolean isAuditable() {
        return true;
    }

    public boolean isNullable() {
        return true;
    }

    public boolean isRenderingFilterReadOnly() {
        return this._renderingFilterReadOnly;
    }

    public BooleanExpression getRenderingFilter() {
        return this._renderingFilter;
    }

    public void setRenderingFilter(BooleanExpression renderingFilter) {
        this.setRenderingFilter(renderingFilter, false);
    }

    public void setRenderingFilter(BooleanExpression renderingFilter, boolean readOnly) {
        boolean log = this.depth() == 0;
        String message = "failed to set rendering filter of " + this.getFullName();
        if (renderingFilter == null) {
            if (log) {
                message = message + "; supplied expression is null";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else {
            this._renderingFilter = renderingFilter instanceof BooleanPrimitive ? renderingFilter.isTrue() : renderingFilter;
        }
        this._renderingFilterReadOnly = readOnly;
    }

    public PropertyAccess getPropertyAccess() {
        return this._propertyAccess;
    }

    public void setPropertyAccess(PropertyAccess access) {
        this._propertyAccess = access == null ? PropertyAccess.UNSPECIFIED : access;
    }

    public DataEntryFormat getDataEntryFormat() {
        return this._dataEntryFormat;
    }

    public void setDataEntryFormat(DataEntryFormat format) {
        this._dataEntryFormat = format == null ? DataEntryFormat.UNSPECIFIED : format;
    }

    public Step getStep() {
        return this._step;
    }

    void setStep(Step step) {
        this._step = step;
    }

    public Tab getTab() {
        return this._tab;
    }

    void setTab(Tab tab) {
        this._tab = tab;
    }

    public Display getDisplay() {
        this.setDisplays();
        return this._display;
    }

    public Display getTableDisplay() {
        this.setDisplays();
        return this._tableDisplay;
    }

    public Display getDetailDisplay() {
        this.setDisplays();
        return this._detailDisplay;
    }

    private void setDisplays() {
        if (this._display == null && this._sourceEntity != null && this._targetEntity != null && this._mappedByProperty instanceof EntityReference) {
            EntityReference reference = (EntityReference)this._mappedByProperty;
            Project project = TLC.getProject();
            if (project != null) {
                this._tableDisplay = project.getWritingTableDisplayOf(this._targetEntity, this._sourceEntity, reference);
                this._detailDisplay = project.getWritingDetailDisplayOf(this._targetEntity, this._sourceEntity, reference);
                this._display = DataEntryFormat.TABLE_OR_DETAIL.equals((Object)this._dataEntryFormat) ? (this._tableDisplay == null ? this._detailDisplay : this._tableDisplay) : (this._detailDisplay == null ? this._tableDisplay : this._detailDisplay);
            }
        }
    }

    public Display getExtensionDisplay(Entity extension) {
        Entity root = extension == null ? null : extension.getRoot();
        Display display = root == null ? null : this._extensionDisplays.get(root);
        return display == null ? this.extensionDisplay(root) : display;
    }

    private Display extensionDisplay(Entity extension) {
        Display display = null;
        if (this._sourceEntity != null && this._targetEntity != null && this._mappedByProperty instanceof EntityReference) {
            if (extension != null && this._targetEntity.getClass().isAssignableFrom(extension.getClass())) {
                EntityReference reference = this.extensionReference(extension);
                Project project = TLC.getProject();
                if (project != null) {
                    if (DataEntryFormat.TABLE_OR_DETAIL.equals((Object)this._dataEntryFormat)) {
                        display = project.getWritingTableDisplayOf(extension, this._sourceEntity, reference);
                        if (display == null) {
                            display = project.getWritingDetailDisplayOf(extension, this._sourceEntity, reference);
                        }
                    } else {
                        display = project.getWritingDetailDisplayOf(extension, this._sourceEntity, reference);
                        if (display == null) {
                            display = project.getWritingTableDisplayOf(extension, this._sourceEntity, reference);
                        }
                    }
                }
            }
            if (display != null) {
                this._extensionDisplays.put(extension, display);
            }
        }
        return display;
    }

    private EntityReference extensionReference(Entity extension) {
        String mappedByPropertyName = this._mappedByProperty.getName();
        for (Property property : extension.getPropertiesList()) {
            if (!(property instanceof EntityReference) || !property.getName().equals(mappedByPropertyName)) continue;
            return (EntityReference)property;
        }
        return null;
    }

    public List<EntityCollectionAggregate> getAggregatesList() {
        return ColUtils.toList(this._aggregates.values());
    }

    public EntityCollectionAggregate addCount(int minimum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, null);
    }

    public EntityCollectionAggregate addCount(int minimum, int maximum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, maximum);
    }

    public EntityCollectionAggregate addCount(String fieldName, int minimum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addCount(String fieldName, int minimum, int maximum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addSum(String fieldName, Number minimum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addSum(String fieldName, Number minimum, Number maximum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addAverage(String fieldName, Number minimum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addAverage(String fieldName, Number minimum, Number maximum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addCount(NumericExpression minimum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, null);
    }

    public EntityCollectionAggregate addCount(NumericExpression minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, maximum);
    }

    public EntityCollectionAggregate addCount(String fieldName, NumericExpression minimum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addCount(String fieldName, NumericExpression minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addSum(String fieldName, NumericExpression minimum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addSum(String fieldName, NumericExpression minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addAverage(String fieldName, NumericExpression minimum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addAverage(String fieldName, NumericExpression minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addCount(int minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, maximum);
    }

    public EntityCollectionAggregate addCount(NumericExpression minimum, int maximum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, maximum);
    }

    public EntityCollectionAggregate addCount(String fieldName, int minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addCount(String fieldName, NumericExpression minimum, int maximum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addSum(String fieldName, Number minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addSum(String fieldName, NumericExpression minimum, Number maximum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addAverage(String fieldName, Number minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addAverage(String fieldName, NumericExpression minimum, Number maximum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, maximum);
    }

    private EntityCollectionAggregate newAggregate(AggregateFunction function, String fieldName, Object minimum, Object maximum) {
        String key = EntityCollectionAggregate.key(function, fieldName);
        EntityCollectionAggregate aggregate = new EntityCollectionAggregate(this, function, fieldName, minimum, maximum);
        this._aggregates.put(key, aggregate);
        return aggregate;
    }

    public boolean isEntityCollectionField() {
        return this.isCreateField() || this.isUpdateField() || this.isDetailField();
    }

    public boolean isEntityCollectionWithDisplay() {
        return this.getDisplay() != null;
    }

    @Override
    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidFieldAnnotations();
        valid.add(OneToMany.class);
        valid.add(EntityCollectionField.class);
        return valid;
    }

    @Override
    void annotate(Field field) {
        super.annotate(field);
        if (field != null) {
            this.annotateOneToMany(field);
            this.annotateEntityCollectionField(field);
        }
    }

    private void annotateOneToMany(Field field) {
        this._annotatedWithOneToMany = field.isAnnotationPresent(OneToMany.class);
        if (this._annotatedWithOneToMany) {
            OneToMany annotation = field.getAnnotation(OneToMany.class);
            this._targetEntityClass = annotation.targetEntity();
            this._mappedByFieldName = annotation.mappedBy();
            this._fetchType = (FetchType)this.specified(new FetchType[]{annotation.fetch(), this._fetchType});
            this._cascadeType = this.cascadeTypeOf(annotation.cascade());
            this._cascadeList = Arrays.asList(this._cascadeType);
            this._orphanRemoval = (Kleenean)this.specified(new Kleenean[]{annotation.orphanRemoval(), this._orphanRemoval});
        }
    }

    private void annotateEntityCollectionField(Field field) {
        this._annotatedWithEntityCollectionField = field.isAnnotationPresent(EntityCollectionField.class);
        if (this._annotatedWithEntityCollectionField) {
            EntityCollectionField annotation = field.getAnnotation(EntityCollectionField.class);
            this._createField = (Kleenean)this.specified(new Kleenean[]{annotation.create(), this._createField});
            this._updateField = (Kleenean)this.specified(new Kleenean[]{annotation.update(), this._updateField});
            this._detailField = (Kleenean)this.specified(new Kleenean[]{annotation.detail(), this._detailField});
            this._propertyAccess = (PropertyAccess)this.specified(new PropertyAccess[]{annotation.access(), this._propertyAccess});
            this._dataEntryFormat = (DataEntryFormat)this.specified(new DataEntryFormat[]{annotation.format(), this._dataEntryFormat});
        }
    }

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.finaliseOneToMany();
        }
        return ok;
    }

    private boolean finaliseOneToMany() {
        Entity declaringEntity;
        if (this.depth() > 0) {
            return true;
        }
        boolean log = this.depth() == 0;
        String fullName = this.getFullName();
        this._sourceEntity = declaringEntity = this.getDeclaringEntity();
        if (this._sourceEntity == null) {
            String message = "no source entity defined for " + fullName;
            logger.fatal((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        Entity entity = this._targetEntity = this._targetEntityClass == null || this._targetEntityClass == Void.TYPE ? null : TLC.getProject().getEntity(this._targetEntityClass);
        if (this._targetEntity == null) {
            String message = "no target entity defined for " + fullName + "; it has an invalid target entity class.";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        Class<?> declaringEntityClass = declaringEntity.getClass();
        String decName = declaringEntityClass.getCanonicalName();
        String message = "no mapping defined for " + fullName;
        if (StringUtils.isBlank((String)this._mappedByFieldName)) {
            List<Field> fields = XS1.getEntityFields(this._targetEntityClass, Entity.class, declaringEntityClass);
            int size = fields.size();
            if (size == 0) {
                message = message + "; it has no mapped-by field name and there is no suitable " + decName + " field in " + this._targetEntityClass;
            } else if (size > 1) {
                message = message + "; it has no mapped-by field name and there is more than one suitable field in the target entity class.";
            } else {
                this._mappedByField = fields.get(0);
                this._mappedByFieldName = this._mappedByField.getName();
            }
        }
        if (StringUtils.isBlank((String)this._mappedByFieldName)) {
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        if (this._mappedByField == null) {
            Object[] strings = new String[]{declaringEntity.getName(), this.getName(), "mappedBy"};
            String role = StringUtils.join((Object[])strings, (String)".");
            Class[] validTypes = new Class[]{declaringEntityClass};
            this._mappedByField = XS1.getField(log, role, this._mappedByFieldName, this._targetEntityClass, Entity.class, validTypes);
        }
        if (this._mappedByField == null) {
            message = "no mapping defined for " + fullName + "; it has an invalid mapped-by field name.";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        this._mappedByProperty = XS1.getProperty(this._mappedByField, this._targetEntity);
        if (this._mappedByProperty == null) {
            message = "no mapping defined for " + fullName + "; it has an invalid mapped-by property name.";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        if (this._mappedByProperty.isCalculable()) {
            message = "no mapping defined for " + fullName + "; it has an invalid (calculable) mapped-by property.";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        if (this._mappedByProperty instanceof EntityReference) {
            EntityReference reference = (EntityReference)this._mappedByProperty;
            reference.setMappedCollection(this);
        }
        if (this.isUpdateField()) {
            if (FetchType.LAZY.equals((Object)this.getFetchType())) {
                message = fullName + " is an updatable collection and therefore requires its fetch type set to EAGER.";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            if (!this.isOrphanRemoval()) {
                message = fullName + " is an updatable collection but it will not allow deletions because its orphan removal option set to false.";
                logger.warn((Object)message);
                Project.increaseParserWarningCount();
            }
        }
        List<EntityCollectionAggregate> aggregates = this.getAggregatesList();
        for (EntityCollectionAggregate aggregate : aggregates) {
            aggregate.check();
        }
        return true;
    }
}

