/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.ObjUtils;
import adalid.core.AbstractArtifact;
import adalid.core.EntityCollection;
import adalid.core.Project;
import adalid.core.XS1;
import adalid.core.enums.AggregateFunction;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.NumericProperty;
import adalid.core.interfaces.Property;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EntityCollectionAggregate
extends AbstractArtifact {
    private static final Logger logger = Logger.getLogger(EntityCollection.class);
    private final EntityCollection _collection;
    private final AggregateFunction _function;
    private final String _fieldName;
    private Field _field;
    private Property _property;
    private final Object _minValue;
    private final Object _maxValue;
    private static final String EOL = "\n";

    static String key(AggregateFunction function, String fieldName) {
        return function + (String)(StringUtils.isBlank((String)fieldName) ? "" : "(" + fieldName + ")");
    }

    EntityCollectionAggregate(EntityCollection collection, AggregateFunction function, String fieldName, Object minimum, Object maximum) {
        this._collection = collection;
        this._function = function;
        this._fieldName = ObjUtils.nullif(fieldName, "*");
        this._minValue = minimum;
        this._maxValue = maximum;
        this.init(collection);
    }

    private void init(EntityCollection collection) {
        this.initDeclaringArtifact(collection);
    }

    public AggregateFunction getFunction() {
        return this._function;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public Field getField() {
        if (this._field == null && StringUtils.isNotBlank((String)this._fieldName)) {
            this._field = this.aggregateFunctionField();
        }
        return this._field;
    }

    public Property getProperty() {
        if (this._property == null && StringUtils.isNotBlank((String)this._fieldName)) {
            this._property = this.aggregateFunctionProperty();
        }
        return this._property;
    }

    public Object getMinValue() {
        return this._minValue;
    }

    public boolean isNumericMinValue() {
        return this._minValue instanceof Number;
    }

    public Object getMaxValue() {
        return this._maxValue;
    }

    public boolean isNumericMaxValue() {
        return this._maxValue instanceof Number;
    }

    boolean check() {
        boolean error;
        String message = "failed to add aggregate " + this._collection.getFullName() + "." + EntityCollectionAggregate.key(this._function, this._fieldName);
        if (AggregateFunction.COUNT.equals((Object)this._function)) {
            boolean bl = error = this._minValue == null && this._maxValue == null;
            if (error) {
                this.error(message, "no minimum nor maximum value has been specified");
            } else {
                boolean c;
                boolean b;
                boolean a;
                boolean bl2 = a = this.isNumericMinValue() && ObjUtils.lt(this._minValue, 0) != false;
                if (a) {
                    this.error(message, "minimum value is less than zero");
                }
                boolean bl3 = b = this.isNumericMaxValue() && ObjUtils.lt(this._maxValue, 0) != false;
                if (b) {
                    this.error(message, "maximum value is less than zero");
                }
                boolean bl4 = c = this.isNumericMinValue() && this.isNumericMaxValue() && ObjUtils.gt(this._minValue, this._maxValue) != false;
                if (c) {
                    this.error(message, "minimum value is greater than maximum value");
                }
                error = a || b || c;
            }
        } else {
            boolean b;
            boolean a;
            boolean bl = a = this.getProperty() == null;
            if (a) {
                this.error(message, "property argument is missing or invalid");
            }
            boolean bl5 = b = this._minValue == null && this._maxValue == null;
            if (b) {
                this.error(message, "no minimum nor maximum value has been specified");
            } else {
                boolean bl6 = b = this.isNumericMinValue() && this.isNumericMaxValue() && ObjUtils.gt(this._minValue, this._maxValue) != false;
                if (b) {
                    this.error(message, "minimum value is greater than maximum value");
                }
            }
            error = a || b;
        }
        return error;
    }

    private Field aggregateFunctionField() {
        Class targetEntityClass = this._collection.getTargetEntityClass();
        if (targetEntityClass == null || targetEntityClass == Void.TYPE) {
            return null;
        }
        String role = "aggregable property";
        Class<?>[] validTypes = this.validTypes();
        return XS1.getField(true, role, this._fieldName, targetEntityClass, Entity.class, validTypes);
    }

    private Property aggregateFunctionProperty() {
        Field field = this.getField();
        Entity targetEntity = this._collection.getTargetEntity();
        return field == null || targetEntity == null ? null : XS1.getProperty(field, targetEntity);
    }

    private Class<?>[] validTypes() {
        Class[] classArray;
        if (AggregateFunction.COUNT.equals((Object)this._function)) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Property.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = NumericProperty.class;
        }
        return classArray;
    }

    private void error(String message, String reasons) {
        logger.error((Object)(message + "; " + reasons));
        Project.increaseParserErrorCount();
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "function" + faa + this._function + foo;
            string = (String)string + fee + tab + "property" + faa + this._property + foo;
            string = (String)string + fee + tab + "minValue" + faa + this._minValue + foo;
            string = (String)string + fee + tab + "maxValue" + faa + this._maxValue + foo;
        }
        return string;
    }
}

