/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.Operation;
import adalid.core.View;
import adalid.core.XS1;
import adalid.core.annotations.ExportOperationClass;
import adalid.core.enums.ExportFileType;
import adalid.core.enums.ExportQueryType;
import adalid.core.enums.SortOption;
import adalid.core.interfaces.Entity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class ExportOperation
extends Operation {
    private boolean _annotatedWithExportOperationClass;
    private String _exportName;
    private String _viewName = "";
    private String _viewFieldName = "";
    private Field _viewField;
    private View _view;
    private ExportQueryType _queryType = ExportQueryType.DYNAMIC;
    private ExportFileType[] _fileTypes = new ExportFileType[]{ExportFileType.CSV};
    private int _rowsLimit = 10000;
    private int _detailRowsLimit = 10000;
    private int _summaryRowsLimit = 10000;
    private int _chartRowsLimit = 10000;
    private SortOption _sortOption = SortOption.ASC;

    public boolean isAnnotatedWithExportOperationClass() {
        return this._annotatedWithExportOperationClass;
    }

    @Override
    public String getProperName() {
        return this._exportName;
    }

    public String getExportName() {
        return this._exportName;
    }

    public String getViewName() {
        return this._viewName;
    }

    public String getViewFieldName() {
        return this._viewFieldName;
    }

    public Field getViewField() {
        return this._viewField;
    }

    public View getView() {
        return this._view;
    }

    public ExportQueryType getQueryType() {
        return this._queryType;
    }

    public ExportFileType[] getFileTypes() {
        return this._fileTypes;
    }

    public List<ExportFileType> getFileTypesList() {
        return Arrays.asList(this._fileTypes);
    }

    public int getRowsLimit() {
        return this._rowsLimit;
    }

    public int getDetailRowsLimit() {
        return this._detailRowsLimit;
    }

    public int getSummaryRowsLimit() {
        return this._summaryRowsLimit;
    }

    public int getChartRowsLimit() {
        return this._chartRowsLimit;
    }

    public SortOption getSortOption() {
        return this._sortOption;
    }

    @Override
    void initializeAnnotations() {
        super.initializeAnnotations();
        this._exportName = StringUtils.defaultIfBlank((String)this._exportName, (String)this.getName());
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
        if (type != null) {
            this.annotateExportOperationClass(type);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidTypeAnnotations();
        valid.add(ExportOperationClass.class);
        return valid;
    }

    private void annotateExportOperationClass(Class<?> type) {
        ExportOperationClass annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, ExportOperationClass.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(ExportOperationClass.class)) != null) {
            String name = annotation.name();
            if (StringUtils.isNotBlank((String)name)) {
                this._exportName = name;
            }
            this._viewName = annotation.view();
            this._viewFieldName = annotation.viewField();
            this._queryType = annotation.type();
            this._fileTypes = annotation.fileTypes();
            this._rowsLimit = Math.max(0, annotation.rowsLimit());
            this._detailRowsLimit = Math.max(0, annotation.detailRowsLimit());
            this._summaryRowsLimit = Math.max(0, annotation.summaryRowsLimit());
            this._chartRowsLimit = Math.max(0, annotation.chartRowsLimit());
            this._sortOption = annotation.sortOption();
            this._annotatedWithExportOperationClass = true;
            if (StringUtils.isNotBlank((String)this._viewFieldName)) {
                ExportOperation declaringOperation = this;
                Entity declaringEntity = declaringOperation.getDeclaringEntity();
                Class[] validTypes = new Class[]{View.class};
                Object[] strings = new String[]{declaringOperation.getName(), this.getName(), "viewField"};
                String role = StringUtils.join((Object[])strings, (String)".");
                this._viewField = XS1.getField(true, role, this._viewFieldName, declaringEntity.getClass(), Entity.class, validTypes);
                if (this._viewField != null) {
                    this._view = XS1.getView(this._viewField, declaringEntity);
                }
            }
        }
    }
}

