/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.Instance;
import adalid.core.interfaces.PersistentEntityReference;
import adalid.core.interfaces.Property;
import adalid.core.properties.StringProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class InstanceField
extends AbstractArtifact {
    private static final String EOL = "\n";
    private final Property _property;
    private final Object _value;
    private final Map<Locale, String> _localizedValue = new LinkedHashMap<Locale, String>();

    public Property getProperty() {
        return this._property;
    }

    public Object getValue() {
        String localizedValue;
        if (this._property instanceof StringProperty && (localizedValue = this.getLocalizedValue(null)) != null) {
            return localizedValue;
        }
        return this._value;
    }

    InstanceField(Instance instance, PersistentEntityReference property, Instance value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, BigDecimal value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, BigInteger value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Boolean value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Byte value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Character value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Date value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Double value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Float value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Integer value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Long value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Short value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, String value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, StringProperty property, String value, Locale locale) {
        this._property = property;
        this._value = value;
        this.setLocalizedValue(locale, value);
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Time value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    InstanceField(Instance instance, Property property, Timestamp value) {
        this._property = property;
        this._value = value;
        this.init(instance);
    }

    public String getLocalizedValue(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedValue.get(l);
    }

    private void setLocalizedValue(Locale locale, String value) {
        Locale l = this.localeWritingKey(locale);
        if (value == null) {
            this._localizedValue.remove(l);
        } else {
            this._localizedValue.put(l, value);
        }
    }

    void addLocalizedValue(Locale locale, String value) {
        this.setLocalizedValue(locale, value);
    }

    private void init(Instance instance) {
        this.initDeclaringArtifact(instance);
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        String property = this._property.getName();
        String value = "" + this._value;
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "property" + faa + property + foo;
            string = (String)string + fee + tab + "value" + faa + value + foo;
        }
        return string;
    }
}

