/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.ThrowableUtils;
import adalid.core.AbstractArtifact;
import adalid.core.ExportOperation;
import adalid.core.Primitive;
import adalid.core.ProcedureOperation;
import adalid.core.ProcessOperation;
import adalid.core.Project;
import adalid.core.ReportOperation;
import adalid.core.TLC;
import adalid.core.Transition;
import adalid.core.Trigger;
import adalid.core.XS1;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OperationDocGen;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.ExpressionUsage;
import adalid.core.enums.Kleenean;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.OperationKind;
import adalid.core.enums.OperationLogging;
import adalid.core.enums.OperationType;
import adalid.core.enums.SpecialCharacterValue;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.exceptions.InstantiationRuntimeException;
import adalid.core.expressions.BooleanDataAggregateX;
import adalid.core.expressions.BooleanOrderedPairX;
import adalid.core.expressions.BooleanScalarX;
import adalid.core.expressions.CharacterDataAggregateX;
import adalid.core.expressions.CharacterScalarX;
import adalid.core.expressions.EntityDataAggregateX;
import adalid.core.expressions.NumericDataAggregateX;
import adalid.core.expressions.NumericScalarX;
import adalid.core.expressions.TemporalDataAggregateX;
import adalid.core.expressions.TemporalScalarX;
import adalid.core.expressions.XB;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReferenceContainer;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.State;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.operations.BasicDatabaseOperation;
import adalid.core.operations.InsertOperation;
import adalid.core.wrappers.OperationWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@OperationClass
public abstract class Operation
extends AbstractArtifact
implements Comparable<Operation>,
EntityReferenceContainer {
    private static final Logger logger = Logger.getLogger(Operation.class);
    private static final String EOL = "\n";
    private static final String SELECT_OPERATION_KEY = "select";
    private static final String INSERT_OPERATION_KEY = "insert";
    private static final String UPDATE_OPERATION_KEY = "update";
    private static final String DELETE_OPERATION_KEY = "delete";
    private static final String[] RESERVED = new String[]{"ADA", "ADR", "ADX", "AIA", "AIR", "AIS", "AIX", "AIY", "AUA", "AUR", "AUS", "AUX", "AUY", "AV1", "AV2", "BDR", "BDX", "BIR", "BIX", "BIZ", "BUR", "BUX", "CK1", "CV1", "CX1", "DV1", "DV2", "JOB", "LOG", "LOX", "SQL", "VAL"};
    private boolean _initialised;
    private boolean _settled;
    private boolean _finished;
    private char _settler = (char)63;
    private boolean _annotatedWithOperationClass;
    private boolean _annotatedWithOperationDocGen;
    private final Map<String, Parameter> _parameters = new LinkedHashMap<String, Parameter>();
    private final Map<String, Expression> _expressions = new LinkedHashMap<String, Expression>();
    private final Map<String, Transition> _transitions = new LinkedHashMap<String, Transition>();
    private OperationType _operationType;
    private OperationKind _operationKind = OperationKind.CLASS;
    private OperationAccess _operationAccess = OperationAccess.UNSPECIFIED;
    private Kleenean _asynchronous = Kleenean.UNSPECIFIED;
    private boolean _confirmationRequired = Operation.getBusinessOperationConfirmationRequired(false);
    private boolean _complex;
    private OperationLogging _operationLogging = OperationLogging.UNSPECIFIED;
    private boolean _operationActivityDiagramGenEnabled = true;
    private final Map<Locale, String> _localizedConfirmationMessage = new LinkedHashMap<Locale, String>();
    private final Set<String> _allocationStrings = new LinkedHashSet<String>();
    char prepareFields;
    char prepareParameter;
    char prepareExpression;
    protected static final String EMAIL_REGEX = "^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    protected static final String URL_REGEX = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]$";
    protected static final SpecialCharacterValue NO_IMAGE = SpecialCharacterValue.NULL;
    protected static final SpecialEntityValue CURRENT_USER = SpecialEntityValue.CURRENT_USER;
    protected static final BooleanScalarX TRUTH = XB.TRUTH;
    protected static final BooleanScalarX UNTRUTH = XB.UNTRUTH;
    protected static final CharacterScalarX EMPTY = XB.EMPTY;
    protected static final CharacterScalarX CURRENT_USER_CODE = XB.CURRENT_USER_CODE;
    protected static final NumericScalarX CURRENT_USER_ID = XB.CURRENT_USER_ID;
    protected static final TemporalScalarX CURRENT_DATE = XB.CURRENT_DATE;
    protected static final TemporalScalarX CURRENT_TIME = XB.CURRENT_TIME;
    protected static final TemporalScalarX CURRENT_TIMESTAMP = XB.CURRENT_TIMESTAMP;
    protected static final String EMBED_CALENDAR = "https://calendar.google.com/calendar/embed";
    protected static final String EMBED_MAPS = "https://www.google.com/maps/embed";
    protected static final String EMBED_YOUTUBE = "https://www.youtube.com/embed";
    protected static final String GOOGLE = "https://www.google.com";
    protected static final String GOOGLE_CALENDAR = "https://calendar.google.com/calendar";
    protected static final String GOOGLE_MAPS = "https://www.google.com/maps";
    protected static final String YOUTUBE = "https://www.youtube.com";

    public static String getSelectOperationKey() {
        return SELECT_OPERATION_KEY;
    }

    public static String getInsertOperationKey() {
        return INSERT_OPERATION_KEY;
    }

    public static String getUpdateOperationKey() {
        return UPDATE_OPERATION_KEY;
    }

    public static String getDeleteOperationKey() {
        return DELETE_OPERATION_KEY;
    }

    public static String[] getCrudOperationKeys() {
        return new String[]{SELECT_OPERATION_KEY, INSERT_OPERATION_KEY, UPDATE_OPERATION_KEY, DELETE_OPERATION_KEY};
    }

    private static boolean getBusinessOperationConfirmationRequired(boolean unspecified) {
        Project project = TLC.getProject();
        return project != null && project.getBusinessOperationConfirmationRequired().toBoolean(unspecified);
    }

    protected static BooleanOrderedPairX and(BooleanExpression operand1, BooleanExpression operand2) {
        return XB.Boolean.OrderedPair.and(operand1, operand2);
    }

    protected static BooleanOrderedPairX nand(BooleanExpression operand1, BooleanExpression operand2) {
        return XB.Boolean.OrderedPair.nand(operand1, operand2);
    }

    protected static BooleanOrderedPairX or(BooleanExpression operand1, BooleanExpression operand2) {
        return XB.Boolean.OrderedPair.or(operand1, operand2);
    }

    protected static BooleanOrderedPairX nor(BooleanExpression operand1, BooleanExpression operand2) {
        return XB.Boolean.OrderedPair.nor(operand1, operand2);
    }

    protected static BooleanOrderedPairX xor(BooleanExpression operand1, BooleanExpression operand2) {
        return XB.Boolean.OrderedPair.xor(operand1, operand2);
    }

    protected static BooleanOrderedPairX xnor(BooleanExpression operand1, BooleanExpression operand2) {
        return XB.Boolean.OrderedPair.xnor(operand1, operand2);
    }

    protected static BooleanOrderedPairX xImpliesY(BooleanExpression operandX, BooleanExpression operandY) {
        return XB.Boolean.OrderedPair.xImpliesY(operandX, operandY);
    }

    protected static BooleanDataAggregateX and(BooleanExpression operand1, BooleanExpression operand2, BooleanExpression ... extraOperands) {
        return XB.Boolean.DataAggregate.and(operand1, operand2, extraOperands);
    }

    protected static BooleanDataAggregateX nand(BooleanExpression operand1, BooleanExpression operand2, BooleanExpression ... extraOperands) {
        return XB.Boolean.DataAggregate.nand(operand1, operand2, extraOperands);
    }

    protected static BooleanDataAggregateX or(BooleanExpression operand1, BooleanExpression operand2, BooleanExpression ... extraOperands) {
        return XB.Boolean.DataAggregate.or(operand1, operand2, extraOperands);
    }

    protected static BooleanDataAggregateX nor(BooleanExpression operand1, BooleanExpression operand2, BooleanExpression ... extraOperands) {
        return XB.Boolean.DataAggregate.nor(operand1, operand2, extraOperands);
    }

    protected static BooleanDataAggregateX naxor(BooleanExpression operand1, BooleanExpression operand2, BooleanExpression ... extraOperands) {
        return XB.Boolean.DataAggregate.naxor(operand1, operand2, extraOperands);
    }

    protected static BooleanDataAggregateX naxnor(BooleanExpression operand1, BooleanExpression operand2, BooleanExpression ... extraOperands) {
        return XB.Boolean.DataAggregate.naxnor(operand1, operand2, extraOperands);
    }

    protected static BooleanDataAggregateX norOrNaxor(BooleanExpression operand1, BooleanExpression operand2, BooleanExpression ... extraOperands) {
        return XB.Boolean.DataAggregate.norOrNaxor(operand1, operand2, extraOperands);
    }

    protected static BooleanScalarX not(BooleanExpression x) {
        return x.not();
    }

    public boolean isInitialised() {
        return this._initialised;
    }

    public boolean isSettled() {
        return this._settled;
    }

    public boolean isFinished() {
        return this._finished;
    }

    @Override
    protected char settler() {
        return this._settler;
    }

    public boolean isAnnotatedWithOperationClass() {
        return this._annotatedWithOperationClass;
    }

    public boolean isAnnotatedWithOperationDocGen() {
        return this._annotatedWithOperationDocGen;
    }

    public String getProperName() {
        return this.getName();
    }

    public List<Parameter> getParametersList() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Parameter value : this._parameters.values()) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public Parameter getInstanceParameter() {
        List<Parameter> parameters;
        if (OperationKind.INSTANCE.equals((Object)this._operationKind) && (parameters = this.getParametersList()) != null && !parameters.isEmpty()) {
            for (Parameter parameter : parameters) {
                if (!parameter.isInstanceReferenceField()) continue;
                return parameter;
            }
        }
        return null;
    }

    public List<Expression> getExpressionsList() {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Expression value : this._expressions.values()) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public List<State> getInitialStatesList() {
        ArrayList<State> list = new ArrayList<State>();
        for (Transition transition : this._transitions.values()) {
            State state;
            if (transition == null || (state = transition.getX()) == null || list.contains(state)) continue;
            list.add(state);
        }
        return list;
    }

    public List<State> getFinalStatesList() {
        ArrayList<State> list = new ArrayList<State>();
        for (Transition transition : this._transitions.values()) {
            State state;
            if (transition == null || (state = transition.getY()) == null || list.contains(state)) continue;
            list.add(state);
        }
        return list;
    }

    public List<Check> getChecksList() {
        ArrayList<Check> list = new ArrayList<Check>();
        for (Expression expression : this._expressions.values()) {
            Field field;
            Class<?> clazz;
            if (!(expression instanceof Check) || !Check.class.isAssignableFrom(clazz = (field = expression.getDeclaringField()).getType())) continue;
            Check check = (Check)expression;
            list.add(check);
        }
        return list;
    }

    public List<Check> getDatabaseTriggerChecksList() {
        ArrayList<Check> list = new ArrayList<Check>();
        for (Expression expression : this._expressions.values()) {
            Check check;
            Field field;
            Class<?> clazz;
            if (!(expression instanceof Check) || !Check.class.isAssignableFrom(clazz = (field = expression.getDeclaringField()).getType()) || Checkpoint.USER_INTERFACE.equals((Object)(check = (Check)expression).getCheckpoint())) continue;
            list.add(check);
        }
        return list;
    }

    public List<Check> getUserInterfaceChecksList() {
        ArrayList<Check> list = new ArrayList<Check>();
        for (Expression expression : this._expressions.values()) {
            Check check;
            Field field;
            Class<?> clazz;
            if (!(expression instanceof Check) || !Check.class.isAssignableFrom(clazz = (field = expression.getDeclaringField()).getType()) || Checkpoint.DATABASE_TRIGGER.equals((Object)(check = (Check)expression).getCheckpoint())) continue;
            list.add(check);
        }
        return list;
    }

    public List<Check> getInstanceParameterChecksList() {
        ArrayList<Check> list = new ArrayList<Check>();
        Parameter instanceParameter = this.getInstanceParameter();
        if (instanceParameter != null) {
            for (Expression expression : this._expressions.values()) {
                Check check;
                Field field;
                Class<?> clazz;
                if (!(expression instanceof Check) || !Check.class.isAssignableFrom(clazz = (field = expression.getDeclaringField()).getType()) || Checkpoint.DATABASE_TRIGGER.equals((Object)(check = (Check)expression).getCheckpoint()) || !this.isSingleParameterExpression(instanceParameter, expression)) continue;
                list.add(check);
            }
        }
        return list;
    }

    private boolean isSingleParameterExpression(Parameter parameter, Expression expression) {
        for (Object operand : expression.getOperands()) {
            if (!(operand instanceof Property ? !this.isPropertyWithinParameterScope(parameter, (Property)operand) : operand instanceof Expression && !this.isSingleParameterExpression(parameter, (Expression)operand))) continue;
            return false;
        }
        return true;
    }

    private boolean isPropertyWithinParameterScope(Parameter parameter, Property property) {
        List<Artifact> pathList = property.getPropertyParameterPathList();
        return pathList != null && !pathList.isEmpty() && parameter.equals(pathList.get(0));
    }

    public List<Transition> getTransitionsList() {
        ArrayList<Transition> list = new ArrayList<Transition>();
        for (Transition value : this._transitions.values()) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public List<Property> getCheckReferencedColumnsList() {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Expression expression : this.getChecksList()) {
            list.addAll(expression.getReferencedColumnsList());
        }
        return list;
    }

    public List<Property> getDatabaseTriggerCheckReferencedColumnsList() {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Expression expression : this.getDatabaseTriggerChecksList()) {
            list.addAll(expression.getReferencedColumnsList());
        }
        return list;
    }

    public List<Property> getUserInterfaceCheckReferencedColumnsList() {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Expression expression : this.getUserInterfaceChecksList()) {
            list.addAll(expression.getReferencedColumnsList());
        }
        return list;
    }

    public Map<String, Parameter> getParametersMap() {
        return this._parameters;
    }

    public Map<String, Expression> getExpressionsMap() {
        return this._expressions;
    }

    public Map<String, Transition> getTransitionsMap() {
        return this._transitions;
    }

    public Map<String, Trigger> getTriggersMap() {
        Entity entity = this.getDeclaringEntity();
        return entity.getTriggersMap();
    }

    public OperationType getOperationType() {
        return this._operationType;
    }

    public OperationKind getOperationKind() {
        return this._operationKind;
    }

    void setOperationKind(OperationKind operationKind) {
        this._operationKind = operationKind;
    }

    public OperationAccess getOperationAccess() {
        return this._operationAccess;
    }

    void setOperationAccess(OperationAccess operationAccess) {
        this._operationAccess = operationAccess;
    }

    public boolean isAsynchronous() {
        return this._asynchronous.toBoolean(!OperationKind.INSTANCE.equals((Object)this._operationKind));
    }

    public boolean isConfirmationRequired() {
        return this._confirmationRequired;
    }

    void setConfirmationRequired(boolean required) {
        this._confirmationRequired = required;
    }

    public boolean isComplex() {
        return !this.isSimple();
    }

    public boolean isSimple() {
        if (this._complex || this._confirmationRequired) {
            return false;
        }
        for (Parameter parameter : this.getParametersList()) {
            if (parameter.isInstanceReferenceField() || !parameter.isRequiredParameter()) continue;
            return false;
        }
        return true;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isSelfConstructor() {
        return this instanceof InsertOperation;
    }

    public OperationLogging getOperationLogging() {
        return this._operationLogging;
    }

    void setOperationLogging(OperationLogging operationLogging) {
        this._operationLogging = operationLogging;
    }

    public boolean isOperationActivityDiagramGenEnabled() {
        return this._operationActivityDiagramGenEnabled;
    }

    public String getDefaultConfirmationMessage() {
        return this.getLocalizedConfirmationMessage(null);
    }

    public void setDefaultConfirmationMessage(String message) {
        this.setLocalizedConfirmationMessage(null, message);
    }

    public String getLocalizedConfirmationMessage(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedConfirmationMessage.get(l);
    }

    public void setLocalizedConfirmationMessage(Locale locale, String message) {
        Locale l = this.localeWritingKey(locale);
        if (message == null) {
            this._localizedConfirmationMessage.remove(l);
        } else {
            this._localizedConfirmationMessage.put(l, message);
        }
    }

    public boolean isLocalizedConfirmationMessageDefined() {
        return this._localizedConfirmationMessage.size() > 0;
    }

    public Operation() {
        this.initOperation();
        Artifact declaringArtifact = TLC.getDeclaringArtifact();
        Field declaringField = TLC.getDeclaringField();
        if (declaringArtifact == null || declaringField == null) {
            this.track("allocate");
            this.initialise(false);
        } else {
            this.initOperation(declaringArtifact, declaringField);
        }
    }

    private void initOperation() {
        this._operationType = this instanceof BasicDatabaseOperation ? OperationType.CRUD : (this instanceof ExportOperation ? OperationType.EXPORT : (this instanceof ReportOperation ? OperationType.REPORT : (this instanceof ProcedureOperation ? OperationType.PROCEDURE : (this instanceof ProcessOperation ? OperationType.PROCESS : OperationType.UNSPECIFIED))));
    }

    private void initOperation(Artifact declaringArtifact, Field declaringField) {
        this.setDeclaringArtifact(declaringArtifact);
        this.setDeclaringField(declaringField);
        this.track("allocate", declaringArtifact, declaringField);
        this.initialise(true);
    }

    void initialise() {
        this.initialise(false);
    }

    private void initialise(boolean b) {
        this.track("initialise", b);
        if (this._initialised) {
            logger.warn((Object)(this.getFullName() + " already initialised! "));
            Project.increaseParserWarningCount();
            return;
        }
        this._initialised = true;
        this.addAllocationStrings();
        this.logAllocationStrings(Project.getDetailLevel());
        this.initialiseFields(Parameter.class);
        this.initialiseFields(Expression.class);
    }

    @Override
    public Set<String> getAllocationStrings() {
        return this._allocationStrings;
    }

    protected void addAllocationStrings() {
        this.track("addAllocationStrings");
        for (Field field : XS1.getFields(this.getClass(), Operation.class, Entity.class)) {
            Entity entity;
            Project project;
            String name = field.getName();
            Class<?> type = field.getType();
            int modifiers = type.getModifiers();
            boolean restricted = type.isInterface() && Expression.class.isAssignableFrom(type) ? false : Modifier.isAbstract(modifiers);
            if ((restricted = restricted || !Modifier.isPublic(modifiers)) || (restricted = Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isFinal(modifiers)) || (project = TLC.getProject()) == null || !((entity = project.getEntity(type)) instanceof EntityReferenceContainer)) continue;
            Entity container = entity;
            Set<String> strings = container.getAllocationStrings();
            for (String string : strings) {
                this.addAllocationStrings(name + "." + StringUtils.substringAfter((String)string, (String)"."));
            }
        }
    }

    protected void addAllocationStrings(String ... strings) {
        String name = this.getFullName();
        if (strings != null && strings.length > 0) {
            for (String string : strings) {
                if (!StringUtils.isNotBlank((String)string)) continue;
                this._allocationStrings.add(name + "." + string);
            }
        }
    }

    private void logAllocationStrings(Level level) {
        if (!(Level.OFF.equals((Object)level) || Level.ALL.equals((Object)level) || this._allocationStrings == null || this._allocationStrings.isEmpty())) {
            logger.log((Priority)level, (Object)(this.getFullName() + ".logAllocationStrings(" + this.depth() + "/" + this.round() + ")"));
            for (String string : this._allocationStrings) {
                logger.log((Priority)level, (Object)string);
            }
        }
    }

    void prepare() {
    }

    void settle() {
        if (this._settled) {
            return;
        }
        this._settled = true;
        this.settleAttributes();
        this.settleParameters();
        this.settleExpressions();
        this.verifyNames(Operation.class, Expression.class);
        this.settleFilters();
        this.verifyParameters();
        this._settler = (char)63;
    }

    private void verifyParameters() {
        List<Parameter> list = this.getParametersList();
        for (Parameter parameter : list) {
            if (parameter.isAnnotated()) continue;
            logger.warn((Object)("parameter " + this.getFullName() + " not annotated yet"));
            Project.increaseParserWarningCount();
        }
    }

    protected void settleAttributes() {
        this.track("settleAttributes");
        this._settler = (char)65;
    }

    protected void settleParameters() {
        this.track("settleParameters");
        this._settler = (char)80;
    }

    protected void settleExpressions() {
        this.track("settleExpressions");
        this._settler = (char)88;
    }

    protected void settleFilters() {
        this.track("settleFilters");
        this._settler = (char)70;
    }

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.finaliseFields();
            this.checkExpressions();
            this.checkTransitions();
        }
        return ok;
    }

    void finish() {
        if (this._finished) {
            logger.warn((Object)(this.getFullName() + " already finished! "));
            Project.increaseParserWarningCount();
            return;
        }
        this._finished = true;
        this.finishParameters();
    }

    void initialiseFields(Class<?> clazz) {
        int depth = this.depth();
        int round = this.round();
        Object[] classes = new Class[]{Parameter.class, Expression.class};
        Class<?> dac = this.getClass();
        Class<Operation> top = Operation.class;
        int i = ArrayUtils.indexOf((Object[])classes, clazz);
        if (i != -1) {
            Object c = classes[i];
            for (Field field : XS1.getFields(dac, top, c)) {
                field.setAccessible(true);
                logger.trace((Object)field);
                String name = field.getName();
                Class<?> type = field.getType();
                int modifiers = type.getModifiers();
                boolean restricted = type.isInterface() && Expression.class.isAssignableFrom(type) ? false : Modifier.isAbstract(modifiers);
                if (restricted = restricted || !Modifier.isPublic(modifiers)) continue;
                modifiers = field.getModifiers();
                boolean bl = restricted = Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers);
                if (restricted) continue;
                String errmsg = "failed to create a new instance of field \"" + field + "\" at " + this;
                try {
                    Object o = field.get(this);
                    if (o != null) continue;
                    logger.debug((Object)this.message(type, name, o, depth, round));
                    o = XS1.initialiseField(this, field);
                    if (o == null) {
                        logger.debug((Object)this.message(type, name, o, depth, round));
                        continue;
                    }
                    logger.debug((Object)this.message(type, name, o, depth, round));
                    field.set(this, o);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new InstantiationRuntimeException(errmsg, ex);
                }
            }
        }
    }

    private void finaliseFields() {
        Class[] classes = new Class[]{Parameter.class, Expression.class};
        int depth = this.depth();
        int round = this.round();
        for (Class c : classes) {
            for (Field field : XS1.getFields(this.getClass(), Operation.class, c)) {
                boolean restricted;
                field.setAccessible(true);
                logger.trace((Object)field);
                String name = field.getName();
                Class<?> type = field.getType();
                int modifiers = field.getModifiers();
                boolean bl = restricted = Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers);
                if (restricted) continue;
                String errmsg = "failed to finalize field \"" + field + "\" at " + this;
                try {
                    Object o = field.get(this);
                    if (o == null) {
                        logger.debug((Object)this.message(type, name, o, depth, round));
                        continue;
                    }
                    if (o instanceof Parameter) {
                        this.finaliseParameter(field, (Parameter)o);
                        continue;
                    }
                    if (!(o instanceof Expression)) continue;
                    this.finaliseExpression(field, (Expression)o);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    logger.error((Object)errmsg, ThrowableUtils.getCause(ex));
                    Project.increaseParserErrorCount();
                }
            }
        }
    }

    private void finaliseParameter(Field field, Parameter parameter) {
        Primitive primitive;
        if (field == null || parameter == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._parameters.containsKey(key)) {
            return;
        }
        if (parameter.isNotDeclared()) {
            XS1.declare(parameter, this, field);
        }
        if (parameter instanceof Entity) {
            Entity root;
            Entity entity = (Entity)((Object)parameter);
            if (!entity.isFinalised()) {
                entity.finalise();
            }
            if ((root = entity.getRoot()) != null) {
                root.getParameterReferencesMap().put(parameter.getPathString(), parameter);
            }
        } else if (parameter instanceof Primitive && !(primitive = (Primitive)parameter).isFinalised()) {
            primitive.finalise();
        }
        this._parameters.put(key, parameter);
    }

    private void finaliseExpression(Field field, Expression expression) {
        if (field == null || expression == null) {
            return;
        }
        String key = field.getName();
        if (key == null || this._expressions.containsKey(key)) {
            return;
        }
        if (expression.isNotDeclared()) {
            XS1.declare(expression, this, field);
        }
        this._expressions.put(key, expression);
    }

    private void finishParameters() {
        for (Parameter parameter : this._parameters.values()) {
            if (parameter instanceof PersistentEntity) {
                PersistentEntity entity = (PersistentEntity)((Object)parameter);
                BooleanExpression filter = entity.getSearchQueryFilter();
                if (filter == null) continue;
                entity.getSearchQueryPropertiesMap();
                continue;
            }
            if (!(parameter instanceof Primitive)) continue;
            ((Primitive)parameter).finish();
        }
    }

    @Override
    protected boolean checkName() {
        if (super.checkName()) {
            String name = this.getName();
            String NAME = name.toUpperCase();
            if (ArrayUtils.contains((Object[])RESERVED, (Object)NAME)) {
                logger.error((Object)(this.getFullName() + " must be renamed; " + NAME + " is a reserved operation name"));
                Project.increaseParserErrorCount();
            } else {
                return true;
            }
        }
        return false;
    }

    private void checkExpressions() {
        for (Parameter parameter : this._parameters.values()) {
            Object o;
            Entity entity;
            Expression e = parameter.getRenderingFilter();
            if (e != null) {
                this.verifyExpression(e, parameter, ExpressionUsage.RENDERING_FILTER, false);
            }
            if ((e = parameter.getRequiringFilter()) != null) {
                this.verifyExpression(e, parameter, ExpressionUsage.REQUIRING_FILTER, false);
            }
            if ((e = parameter.getNullifyingFilter()) != null) {
                this.verifyExpression(e, parameter, ExpressionUsage.NULLIFYING_FILTER, false);
            }
            if (parameter instanceof Entity && (e = (entity = (Entity)((Object)parameter)).getSearchQueryFilter()) != null) {
                this.verifyExpression(e, parameter, ExpressionUsage.SEARCH_QUERY_FILTER, false);
            }
            if ((o = parameter.getInitialValue()) instanceof Expression) {
                e = (Expression)o;
                this.verifyExpression(e, parameter, ExpressionUsage.INITIAL_VALUE, false);
            }
            if ((o = parameter.getDefaultValue()) instanceof Expression) {
                e = (Expression)o;
                this.verifyExpression(e, (Artifact)parameter, ExpressionUsage.DEFAULT_VALUE);
            }
            if (!((o = parameter.getCurrentValue()) instanceof Expression)) continue;
            e = (Expression)o;
            this.verifyExpression(e, (Artifact)parameter, ExpressionUsage.CURRENT_VALUE);
        }
        for (Expression expression : this._expressions.values()) {
            if (expression == null) continue;
            this.verifyExpression(expression);
        }
    }

    private void checkTransitions() {
        int equ = 0;
        int neq = 0;
        for (Transition transition : this._transitions.values()) {
            State x = transition.getX();
            State y = transition.getY();
            String xn = x == null ? null : x.getName();
            String yn = y == null ? null : y.getName();
            String name = this.getFullName() + "(" + xn + " -> " + yn + ")";
            if (x == null && !this.isSelfConstructor()) {
                logger.error((Object)("invalid transition: " + name + "; initial state is null"));
                Project.increaseParserErrorCount();
            }
            if (y == null) {
                logger.error((Object)("invalid transition: " + name + "; final state is null"));
                Project.increaseParserErrorCount();
            }
            if (x == null || y == null) continue;
            if (x == y) {
                ++equ;
                continue;
            }
            ++neq;
        }
        if (equ > 0 && neq > 0) {
            logger.warn((Object)("some but not all transitions of " + this.getFullName() + " have its final state equal to its initial state"));
            Project.increaseParserWarningCount();
        }
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
        if (type != null) {
            this.annotateOperationClass(type);
            this.annotateOperationDocGen(type);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidTypeAnnotations();
        valid.add(OperationClass.class);
        valid.add(OperationDocGen.class);
        return valid;
    }

    private void annotateOperationClass(Class<?> type) {
        OperationClass annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, OperationClass.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(OperationClass.class)) != null) {
            this._operationAccess = annotation.access();
            this._asynchronous = annotation.asynchronous();
            this._confirmationRequired = annotation.confirmation().toBoolean(this._confirmationRequired);
            this._complex = annotation.complex().toBoolean(this._complex);
            this._operationLogging = annotation.logging();
            this._annotatedWithOperationClass = true;
        }
    }

    private void annotateOperationDocGen(Class<?> type) {
        OperationDocGen annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, OperationDocGen.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(OperationDocGen.class)) != null) {
            this._operationActivityDiagramGenEnabled = annotation.activityDiagram().toBoolean(this._operationActivityDiagramGenEnabled);
            this._annotatedWithOperationDocGen = true;
        }
    }

    protected static BooleanScalarX truth() {
        return TRUTH;
    }

    protected static BooleanScalarX untruth() {
        return UNTRUTH;
    }

    protected static CharacterScalarX empty() {
        return EMPTY;
    }

    protected static CharacterScalarX currentUserCode() {
        return CURRENT_USER_CODE;
    }

    protected static NumericScalarX currentUserId() {
        return CURRENT_USER_ID;
    }

    protected static TemporalScalarX currentDate() {
        return CURRENT_DATE;
    }

    protected static TemporalScalarX currentTime() {
        return CURRENT_TIME;
    }

    protected static TemporalScalarX currentTimestamp() {
        return CURRENT_TIMESTAMP;
    }

    protected static EntityDataAggregateX coalesce(Entity operand1, Entity operand2, Entity ... extraOperands) {
        return XB.Entity.DataAggregate.coalesce(operand1, operand2, extraOperands);
    }

    protected static BooleanDataAggregateX coalesce(BooleanExpression operand1, BooleanExpression operand2, BooleanExpression ... extraOperands) {
        return XB.Boolean.DataAggregate.coalesce(operand1, operand2, extraOperands);
    }

    protected static CharacterDataAggregateX coalesce(CharacterExpression operand1, CharacterExpression operand2, CharacterExpression ... extraOperands) {
        return XB.Character.DataAggregate.coalesce(operand1, operand2, extraOperands);
    }

    protected static NumericDataAggregateX coalesce(NumericExpression operand1, NumericExpression operand2, NumericExpression ... extraOperands) {
        return XB.Numeric.DataAggregate.coalesce(operand1, operand2, extraOperands);
    }

    protected static TemporalDataAggregateX coalesce(TemporalExpression operand1, TemporalExpression operand2, TemporalExpression ... extraOperands) {
        return XB.Temporal.DataAggregate.coalesce(operand1, operand2, extraOperands);
    }

    protected static CharacterExpression concat(String x, Expression y) {
        return XB.Character.OrderedPair.concat(Operation.charStringOf(x), Operation.charStringOf(y));
    }

    protected static CharacterExpression concat(SpecialCharacterValue x, Expression y) {
        return XB.Character.OrderedPair.concat(Operation.charStringOf(x), Operation.charStringOf(y));
    }

    protected static CharacterExpression concat(Expression x, Expression y) {
        return XB.Character.OrderedPair.concat(Operation.charStringOf(x), Operation.charStringOf(y));
    }

    protected static CharacterExpression charStringOf(Object x) {
        return x instanceof CharacterExpression ? (CharacterExpression)x : XB.toCharString(x);
    }

    protected static TemporalExpression dateOf(Object x) {
        return x instanceof TemporalExpression ? (TemporalExpression)x : XB.toDate(x);
    }

    protected static TemporalExpression timeOf(Object x) {
        return x instanceof TemporalExpression ? (TemporalExpression)x : XB.toTime(x);
    }

    protected static TemporalExpression timestampOf(Object x) {
        return x instanceof TemporalExpression ? (TemporalExpression)x : XB.toTimestamp(x);
    }

    @Override
    public int compareTo(Operation o) {
        if (o != null) {
            Operation that = o;
            String thisName = StringUtils.trimToEmpty((String)this.getName());
            String thatName = StringUtils.trimToEmpty((String)that.getName());
            return thisName.compareTo(thatName);
        }
        return 0;
    }

    public Class<? extends OperationWrapper> getDefaultWrapperClass() {
        return OperationWrapper.class;
    }

    public String signature() {
        String asynchronous = Kleenean.TRUE.equals((Object)this._asynchronous) ? "ASYNCHRONOUS " : "";
        return asynchronous + this.getOperationAccess() + " " + this.getOperationKind() + " " + this.getOperationType() + " " + this.getFullName();
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if (fields || verbose) {
            string = (String)string + fee + tab + "parameters" + faa + this._parameters.size() + foo;
            string = (String)string + fee + tab + "expressions" + faa + this._expressions.size() + foo;
            string = (String)string + fee + tab + "transitions" + faa + this._transitions.size() + foo;
            if (verbose) {
                // empty if block
            }
        }
        return string;
    }

    @Override
    protected String mapsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        Object string = super.mapsToString(n, key, verbose, fields, maps);
        if (maps || verbose) {
            Artifact valor;
            for (String clave : this._parameters.keySet()) {
                valor = this._parameters.get(clave);
                string = (String)string + valor.toString(n + 1, clave, verbose, fields, maps);
            }
            for (String clave : this._expressions.keySet()) {
                valor = this._expressions.get(clave);
                string = (String)string + valor.toString(n + 1, clave, verbose, fields, maps);
            }
            for (String clave : this._transitions.keySet()) {
                valor = this._transitions.get(clave);
                string = (String)string + ((AbstractArtifact)valor).toString(n + 1, clave, verbose, fields, maps);
            }
        }
        return string;
    }

    private String message(Class<?> type, String name, Object value, int depth, int round) {
        String s1 = StringUtils.repeat((String)" ", (int)(0 + 4 * depth));
        String s2 = this + "," + depth + "," + round;
        String s3 = type.getSimpleName() + " " + name + "=" + value;
        String s4 = s1 + s2 + " " + s3;
        return s4;
    }

    private void track(String method) {
        this.track(method, this);
    }

    private void track(String method, Object ... parameters) {
        TLC.getProject().getParser().track(this.depth(), this.round(), this.getClassPath(), method, parameters);
    }
}

