/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.ProcessOperation;
import adalid.core.XS1;
import adalid.core.annotations.ProcedureOperationClass;
import adalid.core.enums.ProcedureDataType;
import adalid.core.enums.ProcedureType;
import java.lang.annotation.Annotation;
import java.util.List;

public abstract class ProcedureOperation
extends ProcessOperation {
    private boolean _annotatedWithProcedureOperationClass;
    private ProcedureType _procedureType = ProcedureType.SIMPLE;
    private ProcedureDataType _procedureDataType = ProcedureDataType.BIGINT;

    public boolean isAnnotatedWithProcedureOperationClass() {
        return this._annotatedWithProcedureOperationClass;
    }

    public String getProcedureName() {
        return this.getProcessName();
    }

    public ProcedureType getProcedureType() {
        return this._procedureType;
    }

    public ProcedureDataType getProcedureDataType() {
        return this._procedureDataType;
    }

    @Override
    void initializeAnnotations() {
        super.initializeAnnotations();
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
        if (type != null) {
            this.annotateProcedureOperationClass(type);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidTypeAnnotations();
        valid.add(ProcedureOperationClass.class);
        return valid;
    }

    private void annotateProcedureOperationClass(Class<?> type) {
        ProcedureOperationClass annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, ProcedureOperationClass.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(ProcedureOperationClass.class)) != null) {
            this._procedureType = annotation.type();
            this._procedureDataType = annotation.dataType();
            this._annotatedWithProcedureOperationClass = true;
        }
    }
}

