/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.ProjectObjectModelReader;
import adalid.commons.TLB;
import adalid.commons.bundles.Bundle;
import adalid.commons.enums.LoggingLevel;
import adalid.commons.properties.BootstrappingFile;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.BitUtils;
import adalid.commons.util.ColUtils;
import adalid.commons.util.LogUtils;
import adalid.commons.util.NumUtils;
import adalid.commons.util.RunUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.commons.util.TimeUtils;
import adalid.commons.velocity.Writer;
import adalid.core.AbstractArtifact;
import adalid.core.AlternativeDisplay;
import adalid.core.Constants;
import adalid.core.Display;
import adalid.core.EntityData;
import adalid.core.Operation;
import adalid.core.ProjectEntityReference;
import adalid.core.ProjectObjectModel;
import adalid.core.ProjectReference;
import adalid.core.TLC;
import adalid.core.UserFlow;
import adalid.core.XS1;
import adalid.core.XS2;
import adalid.core.annotations.AddAttributesMethod;
import adalid.core.annotations.MasterProject;
import adalid.core.annotations.ProjectModule;
import adalid.core.annotations.ProjectModuleDocGen;
import adalid.core.comparators.ByMethodSequence;
import adalid.core.enums.DisplayFormat;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.HelpFileAutoName;
import adalid.core.enums.Kleenean;
import adalid.core.enums.RoleType;
import adalid.core.exceptions.InstantiationRuntimeException;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.programmers.JDK8Programmer;
import adalid.core.programmers.PostgreSqlProgrammer;
import adalid.core.programmers.ResourceBundleProgrammer;
import adalid.core.sql.QueryTable;
import adalid.core.wrappers.PersistentEntityWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class Project
extends AbstractArtifact
implements Comparable<Project> {
    private static final Logger logger = Logger.getLogger(Project.class);
    private static final String EOL = "\n";
    private static final String TAB = "\t";
    private static int _defaultMaxDepth = 1;
    private static int _defaultMaxRound = 0;
    private static boolean _defaultEntityCodeGenBPL = true;
    private static boolean _defaultEntityCodeGenBWS = false;
    private static boolean _defaultEntityCodeGenFWS = false;
    private static boolean _defaultEntityCodeGenGUI = true;
    private static boolean _defaultEntityCodeGenSQL = true;
    private static boolean _defaultEntityCodeGenSMC = true;
    private static Boolean _defaultPropertyFieldSerializable;
    private static Boolean _defaultPropertyFieldSerializableIUID;
    private static boolean _acerose;
    private static boolean _foliose;
    private static boolean _spinose;
    private static boolean _verbose;
    private static boolean _warnose;
    private static Level _alertLevel;
    private static Level _detailLevel;
    private static Level _trackingLevel;
    private static Level _transitionLevel;
    private static Level _specialExpressionLevel;
    private static Level _unusualExpressionLevel;
    private Project _master;
    private Parser _parser;
    private Writer _writer;
    private final Set<Locale> _supportedLocales = new LinkedHashSet<Locale>();
    private final Set<Class<?>> _foreignEntityClasses = new LinkedHashSet();
    private final Set<Class<?>> _privateEntityClasses = new LinkedHashSet();
    private final Map<String, String> _environmentVariables = new LinkedHashMap<String, String>();
    private final Map<String, ProjectEntityReference> _entityReferences = new LinkedHashMap<String, ProjectEntityReference>();
    private final Map<String, ProjectReference> _projectReferences = new LinkedHashMap<String, ProjectReference>();
    private final Map<String, Display> _displays = new LinkedHashMap<String, Display>();
    private Class<? extends Entity> _userEntityClass;
    private Class<? extends Entity> _uploadedFileEntityClass;
    private final Set<Artifact> _artifacts = new LinkedHashSet<Artifact>();
    private final Set<Method> _addAttributesMethods = new LinkedHashSet<Method>();
    private final Set<String> _processingGroups = new TreeSet<String>();
    private final Set<UserFlow> _userFlows = new TreeSet<UserFlow>();
    private final List<Pattern> _fileExclusionPatterns = new ArrayList<Pattern>();
    private final List<Pattern> _filePreservationPatterns = new ArrayList<Pattern>();
    private boolean _abort;
    private boolean _built;
    private boolean _annotatedWithMasterProject;
    private boolean _annotatedWithProjectModule;
    private boolean _annotatedWithProjectModuleDocGen;
    private boolean _menuModule;
    private boolean _roleModule;
    private boolean _foreignModule;
    private boolean _privateModule;
    private String _helpDocument = "";
    private String _helpFileName = "";
    private RoleType[] _moduleRoleTypes = new RoleType[]{RoleType.REGISTRAR, RoleType.PROCESSOR, RoleType.READER, RoleType.CONFIGURATOR, RoleType.MANAGER};
    private HelpFileAutoName _helpFileAutoName = HelpFileAutoName.NONE;
    private String _helpFileAutoType = "html";
    private boolean _moduleClassDiagramGenEnabled = true;
    private static final String ENVIRONMENT_VARIABLE_PREFIX = "environment.variable.";
    Set<String> crossReferencedExpressionsSet;
    Set<String> schemasSet;
    Map<String, String> tablesMap;
    Map<String, String> catalogTablesMap;
    private Kleenean _businessOperationConfirmationRequired;
    private Kleenean _databaseOperationConfirmationRequired;
    private Boolean _databaseDefaultValuesMustBeSingleEntityExpression;
    private String _missingValueGraphicImageName;
    private String _nullValueGraphicImageName;
    private String _unnecessaryValueGraphicImageName;
    private String _buildTimestamp;
    private final ProjectObjectModel pom = new ProjectObjectModel();
    char superEntity;

    public static void setBootstrappingFileName(String name) {
        BootstrappingFile.setName(name);
    }

    public static Locale getLocale() {
        return Bundle.getLocale();
    }

    public static void setLocale(Locale locale) {
        Bundle.setLocale(locale);
    }

    public static void setDecimalSeparator(Locale locale, char separator) {
        NumUtils.setDecimalSeparator(locale, separator);
    }

    public static void setThousandSeparator(Locale locale, char separator) {
        NumUtils.setThousandSeparator(locale, separator);
    }

    public static void setDateFormat(Locale locale, String format) {
        TimeUtils.setDateFormat(locale, format);
    }

    public static void setTimeFormat(Locale locale, String format) {
        TimeUtils.setTimeFormat(locale, format);
    }

    public static void setTimestampFormat(Locale locale, String format) {
        TimeUtils.setTimestampFormat(locale, format);
    }

    public static int getDefaultMaxDepth() {
        return _defaultMaxDepth;
    }

    public static void setDefaultMaxDepth(int depth) {
        _defaultMaxDepth = depth < 1 ? 1 : depth;
    }

    public static int getDefaultMaxRound() {
        return _defaultMaxRound;
    }

    public static void setDefaultMaxRound(int round) {
        _defaultMaxRound = round < 0 ? 0 : round;
    }

    public static boolean getDefaultEntityCodeGenBPL() {
        return _defaultEntityCodeGenBPL;
    }

    public static void setDefaultEntityCodeGenBPL(boolean b) {
        _defaultEntityCodeGenBPL = b;
    }

    public static boolean getDefaultEntityCodeGenBWS() {
        return _defaultEntityCodeGenBWS;
    }

    public static void setDefaultEntityCodeGenBWS(boolean b) {
        _defaultEntityCodeGenBWS = b;
    }

    public static boolean getDefaultEntityCodeGenFWS() {
        return _defaultEntityCodeGenFWS;
    }

    public static void setDefaultEntityCodeGenFWS(boolean b) {
        _defaultEntityCodeGenFWS = b;
    }

    public static boolean getDefaultEntityCodeGenGUI() {
        return _defaultEntityCodeGenGUI;
    }

    public static void setDefaultEntityCodeGenGUI(boolean b) {
        _defaultEntityCodeGenGUI = b;
    }

    public static boolean getDefaultEntityCodeGenSQL() {
        return _defaultEntityCodeGenSQL;
    }

    public static void setDefaultEntityCodeGenSQL(boolean b) {
        _defaultEntityCodeGenSQL = b;
    }

    public static boolean getDefaultEntityCodeGenSMC() {
        return _defaultEntityCodeGenSMC;
    }

    public static void setDefaultEntityCodeGenSMC(boolean b) {
        _defaultEntityCodeGenSMC = b;
    }

    public static Boolean getDefaultPropertyFieldSerializable() {
        return _defaultPropertyFieldSerializable;
    }

    public static void setDefaultPropertyFieldSerializable(boolean b) {
        _defaultPropertyFieldSerializable = b;
    }

    public static Boolean getDefaultPropertyFieldSerializableIUID() {
        return _defaultPropertyFieldSerializableIUID;
    }

    public static void setDefaultPropertyFieldSerializableIUID(boolean b) {
        _defaultPropertyFieldSerializableIUID = b;
    }

    public static boolean isAcerose() {
        return _acerose;
    }

    public static void setAcerose(boolean acerose) {
        _acerose = acerose;
    }

    public static boolean isFoliose() {
        return _foliose;
    }

    public static void setFoliose(boolean foliose) {
        _foliose = foliose;
    }

    public static boolean isSpinose() {
        return _spinose;
    }

    public static void setSpinose(boolean spinose) {
        _spinose = spinose;
    }

    public static boolean isVerbose() {
        return _verbose;
    }

    public static void setVerbose(boolean verbose) {
        _verbose = verbose;
    }

    public static boolean isWarnose() {
        return _warnose;
    }

    public static void setWarnose(boolean warnose) {
        _warnose = warnose;
    }

    public static Level getAlertLevel() {
        return _alertLevel;
    }

    public static void setAlertLevel(Level level) {
        _alertLevel = LogUtils.check(level, Level.OFF, Level.WARN);
    }

    public static Level getDetailLevel() {
        return _detailLevel;
    }

    public static void setDetailLevel(Level level) {
        _detailLevel = LogUtils.check(level, Level.OFF, Level.INFO);
    }

    public static Level getTrackingLevel() {
        return _trackingLevel;
    }

    public static void setTrackingLevel(Level level) {
        _trackingLevel = LogUtils.check(level, Level.OFF, Level.INFO);
    }

    public static Level getTransitionLevel() {
        return _transitionLevel;
    }

    public static void setTransitionLevel(Level level) {
        _transitionLevel = LogUtils.check(level, Level.OFF, Level.FATAL);
    }

    public static Level getSpecialExpressionLevel() {
        return _specialExpressionLevel;
    }

    public static void setSpecialExpressionLevel(Level level) {
        _specialExpressionLevel = LogUtils.check(level, Level.OFF, Level.WARN);
    }

    public static Level getUnusualExpressionLevel() {
        return _unusualExpressionLevel;
    }

    public static void setUnusualExpressionLevel(Level level) {
        _unusualExpressionLevel = LogUtils.check(level, Level.OFF, Level.WARN);
    }

    public static LoggingLevel getAlertLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_alertLevel);
    }

    public static void setAlertLoggingLevel(LoggingLevel level) {
        Project.setAlertLevel(level.getLevel());
    }

    public static LoggingLevel getDetailLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_detailLevel);
    }

    public static void setDetailLoggingLevel(LoggingLevel level) {
        Project.setDetailLevel(level.getLevel());
    }

    public static LoggingLevel getTrackingLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_trackingLevel);
    }

    public static void setTrackingLoggingLevel(LoggingLevel level) {
        Project.setTrackingLevel(level.getLevel());
    }

    public static LoggingLevel getTransitionLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_transitionLevel);
    }

    public static void setTransitionLoggingLevel(LoggingLevel level) {
        Project.setTransitionLevel(level.getLevel());
    }

    public static LoggingLevel getSpecialExpressionLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_specialExpressionLevel);
    }

    public static void setSpecialExpressionLoggingLevel(LoggingLevel level) {
        Project.setSpecialExpressionLevel(level.getLevel());
    }

    public static LoggingLevel getUnusualExpressionLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_unusualExpressionLevel);
    }

    public static void setUnusualExpressionLoggingLevel(LoggingLevel level) {
        Project.setUnusualExpressionLevel(level.getLevel());
    }

    public static String[] getHelpFileTypes() {
        Project project = TLC.getProject();
        return project == null ? null : project.helpFileTypes();
    }

    public static String getHelpFileTypesCSV() {
        Project project = TLC.getProject();
        return project == null ? null : project.helpFileTypesCSV();
    }

    public static boolean isMetaHelpEnabled() {
        Project project = TLC.getProject();
        return project == null ? null : Boolean.valueOf(project.metaHelpEnabled());
    }

    public static void addEntity(Entity entity) {
        Project project = TLC.getProject();
        if (project != null) {
            project.getParser().addEntity(entity);
        }
    }

    public static void addQueryTable(QueryTable queryTable) {
        Project project = TLC.getProject();
        if (project != null) {
            project.getParser().addQueryTable(queryTable);
        }
    }

    public static void increaseParserWarningCount() {
        Project project = TLC.getProject();
        if (project != null) {
            project.getParser().increaseWarningCount();
        }
    }

    public static void increaseParserErrorCount() {
        Project project = TLC.getProject();
        if (project != null) {
            project.getParser().increaseErrorCount();
        }
    }

    public static void logParserMessage(Level level, String message) {
        Project project = TLC.getProject();
        if (project != null) {
            project.getParser().log(level, message);
        }
    }

    public static void increaseWriterWarningCount() {
        Project project = TLC.getProject();
        if (project != null) {
            project.getWriter().increaseWarningCount();
        }
    }

    public static void increaseWriterErrorCount() {
        Project project = TLC.getProject();
        if (project != null) {
            project.getWriter().increaseErrorCount();
        }
    }

    public List<Locale> getSecondaryLocales() {
        Locale primary = Bundle.getLocale();
        return this._supportedLocales.stream().filter(locale -> !locale.equals(primary)).collect(Collectors.toList());
    }

    public Set<Locale> getSupportedLocales() {
        return this._supportedLocales;
    }

    public void setSupportedLocales(Locale ... locales) {
        this._supportedLocales.clear();
        for (Locale locale : locales) {
            if (Bundle.isSupportedLocale(locale)) {
                this._supportedLocales.add(locale);
                continue;
            }
            logger.warn((Object)("Locale " + locale + " not supported yet."));
            this.increaseWarningCount();
        }
        Locale locale = Bundle.getLocale();
        if (!ArrayUtils.contains((Object[])locales, (Object)locale)) {
            this._supportedLocales.add(locale);
        }
    }

    public void clearSupportedLocales() {
        this._supportedLocales.clear();
    }

    public Set<Class<?>> getForeignEntityClasses() {
        return this._foreignEntityClasses;
    }

    public void setForeignEntityClasses(Set<Class<?>> classes) {
        this._foreignEntityClasses.clear();
        this.addForeignEntityClasses(classes);
    }

    public void setForeignEntityClasses(Class<?> clazz) {
        this._foreignEntityClasses.clear();
        this.addForeignEntityClasses(clazz);
    }

    public void addForeignEntityClasses(Set<Class<?>> classes) {
        if (classes != null && !classes.isEmpty()) {
            this._foreignEntityClasses.addAll(classes);
        }
    }

    public void addForeignEntityClasses(Class<?> clazz) {
        Set<Class<?>> classes = XS2.getLocallyDeclaredEntityClasses(clazz);
        this.addForeignEntityClasses(classes);
    }

    public void clearForeignEntityClasses() {
        this._foreignEntityClasses.clear();
    }

    public Set<Class<?>> getPrivateEntityClasses() {
        return this._privateEntityClasses;
    }

    public void setPrivateEntityClasses(Set<Class<?>> classes) {
        this._privateEntityClasses.clear();
        this.addPrivateEntityClasses(classes);
    }

    public void setPrivateEntityClasses(Class<?> clazz) {
        this._privateEntityClasses.clear();
        this.addPrivateEntityClasses(clazz);
    }

    public void addPrivateEntityClasses(Set<Class<?>> classes) {
        if (classes != null && !classes.isEmpty()) {
            this._privateEntityClasses.addAll(classes);
        }
    }

    public void addPrivateEntityClasses(Class<?> clazz) {
        Set<Class<?>> classes = XS2.getLocallyDeclaredEntityClasses(clazz);
        this.addPrivateEntityClasses(classes);
    }

    public void clearPrivateEntityClasses() {
        this._privateEntityClasses.clear();
    }

    public Map<String, String> getEnvironmentVariables() {
        return this._environmentVariables;
    }

    public String getEnvironmentVariable(String key) {
        return this._environmentVariables.get(key);
    }

    public String putEnvironmentVariable(String key, String value) {
        return this._environmentVariables.put(key, value);
    }

    public void loadEnvironmentVariables() {
        this.loadEnvironmentVariables(LoggingLevel.TRACE);
    }

    public void loadEnvironmentVariables(LoggingLevel loggingLevel) {
        ExtendedProperties properties = PropertiesHandler.getPrivateProperties();
        if (properties == null || properties.isEmpty()) {
            this._abort = true;
        } else {
            ArrayList<String> list = new ArrayList<String>();
            Iterator i = properties.getKeys();
            while (i.hasNext()) {
                list.add((String)i.next());
            }
            Level level = loggingLevel.getLevel();
            for (String name : list) {
                if (!StringUtils.startsWithIgnoreCase((String)name, (String)ENVIRONMENT_VARIABLE_PREFIX)) continue;
                String key = StringUtils.removeStartIgnoreCase((String)name, (String)ENVIRONMENT_VARIABLE_PREFIX);
                String value = properties.getString(name);
                this.putEnvironmentVariable(key, value);
                logger.log((Priority)level, (Object)(key + " = " + value));
            }
        }
    }

    public Project getMaster() {
        return this._master;
    }

    private void setMaster(Project master) {
        this._master = master;
    }

    public boolean referencesEntity(String classSimpleName) {
        return this._entityReferences.containsKey(classSimpleName);
    }

    public boolean referencesEntity(Class<?> type) {
        Entity entity = this.getEntity(type);
        return entity != null;
    }

    public Entity getEntity(Class<?> type) {
        ProjectEntityReference reference = this.getEntityReference(type);
        return reference == null ? null : reference.getEntity();
    }

    public Entity getEntity(String name) {
        ProjectEntityReference reference = this.getEntityReference(name);
        return reference == null ? null : reference.getEntity();
    }

    public List<Entity> getEntitiesList() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (ProjectEntityReference reference : this._entityReferences.values()) {
            if (reference.getEntity() == null) continue;
            list.add(reference.getEntity());
        }
        return list;
    }

    public Map<String, Entity> getEntitiesMap() {
        LinkedHashMap<String, Entity> entities = new LinkedHashMap<String, Entity>();
        for (ProjectEntityReference reference : this._entityReferences.values()) {
            if (reference.getEntity() == null) continue;
            entities.put(reference.getEntityClass().getSimpleName(), reference.getEntity());
        }
        return entities;
    }

    public boolean referencesModule(String className) {
        ProjectReference reference = this._projectReferences.get(className);
        Project project = reference == null ? null : reference.getProject();
        return project != null && project.getMaster() != null;
    }

    public boolean referencesModule(Class<?> type) {
        Project module = this.getModule(type);
        return module != null;
    }

    public Project getModule(Class<?> type) {
        Project project = this.getProject(type);
        return project == null || project.getMaster() == null ? null : project;
    }

    public List<Project> getModulesList() {
        ArrayList<Project> list = new ArrayList<Project>();
        for (ProjectReference reference : this._projectReferences.values()) {
            Project module = reference.getProject();
            if (module == null || module.getMaster() == null) continue;
            list.add(module);
        }
        return list;
    }

    public Map<String, Project> getModulesMap() {
        LinkedHashMap<String, Project> projects = new LinkedHashMap<String, Project>();
        for (ProjectReference reference : this._projectReferences.values()) {
            Project module = reference.getProject();
            if (module == null || module.getMaster() == null) continue;
            projects.put(reference.getProjectClass().getName(), module);
        }
        return projects;
    }

    public boolean referencesProject(String className) {
        return this._projectReferences.containsKey(className);
    }

    public boolean referencesProject(Class<?> type) {
        Project project = this.getProject(type);
        return project != null;
    }

    public Project getProject(Class<?> type) {
        ProjectReference reference = this.getProjectReference(type);
        return reference == null ? null : reference.getProject();
    }

    public List<Project> getProjectsList() {
        ArrayList<Project> list = new ArrayList<Project>();
        for (ProjectReference reference : this._projectReferences.values()) {
            if (reference.getProject() == null) continue;
            list.add(reference.getProject());
        }
        return list;
    }

    public Map<String, Project> getProjectsMap() {
        LinkedHashMap<String, Project> projects = new LinkedHashMap<String, Project>();
        for (ProjectReference reference : this._projectReferences.values()) {
            if (reference.getProject() == null) continue;
            projects.put(reference.getProjectClass().getName(), reference.getProject());
        }
        return projects;
    }

    public List<? extends Display> getDisplaysList() {
        return new ArrayList<Display>(this.getDisplaysMap().values());
    }

    public Map<String, ? extends Display> getDisplaysMap() {
        return this._displays;
    }

    public Set<String> getCrossReferencedExpressionsSet() {
        if (this.crossReferencedExpressionsSet == null) {
            this.crossReferencedExpressionsSet = new LinkedHashSet<String>();
            List<Entity> entities = this.getEntitiesList();
            for (Entity entity : entities) {
                if (!(entity instanceof PersistentEntity)) continue;
                PersistentEntity pent = (PersistentEntity)entity;
                this.crossReferencedExpressionsSet.addAll(pent.getCrossReferencedExpressionsSet());
            }
        }
        return this.crossReferencedExpressionsSet;
    }

    public boolean containsCrossReferencedExpression(Expression expression) {
        String key = expression == null ? null : expression.getCrossReferencedExpressionsKey();
        return key != null && this.getCrossReferencedExpressionsSet().contains(key);
    }

    public Set<String> getSchemasSet() {
        if (this.schemasSet == null) {
            this.schemasSet = new LinkedHashSet<String>();
            List<Entity> entities = this.getEntitiesList();
            for (Entity entity : entities) {
                PersistentEntity pent;
                String schema;
                if (!(entity instanceof PersistentEntity) || !StringUtils.isNotBlank((String)(schema = (pent = (PersistentEntity)entity).getSchema()))) continue;
                this.schemasSet.add(schema.trim());
            }
        }
        return this.schemasSet;
    }

    public Map<String, String> getTablesMap() {
        if (this.tablesMap == null) {
            this.tablesMap = new LinkedHashMap<String, String>();
            List<Entity> entities = this.getEntitiesList();
            for (Entity entity : entities) {
                PersistentEntity pent;
                PersistentEntityWrapper wrapper;
                String table;
                if (!(entity instanceof PersistentEntity) || !StringUtils.isNotBlank((String)(table = (wrapper = new PersistentEntityWrapper(pent = (PersistentEntity)entity)).getSqlName()))) continue;
                this.tablesMap.put(table.trim(), pent.getClass().getName());
            }
        }
        return this.tablesMap;
    }

    public Map<String, String> getCatalogTablesMap() {
        if (this.catalogTablesMap == null) {
            this.catalogTablesMap = new LinkedHashMap<String, String>();
            List<Entity> entities = this.getEntitiesList();
            for (Entity entity : entities) {
                PersistentEntity pent;
                PersistentEntityWrapper wrapper;
                String table;
                if (!(entity instanceof PersistentEntity) || !entity.isCatalogEntity() || !StringUtils.isNotBlank((String)(table = (wrapper = new PersistentEntityWrapper(pent = (PersistentEntity)entity)).getSqlName()))) continue;
                this.catalogTablesMap.put(table.trim(), pent.getClass().getName());
            }
        }
        return this.catalogTablesMap;
    }

    public Kleenean getBusinessOperationConfirmationRequired() {
        return this._businessOperationConfirmationRequired == null ? Kleenean.UNSPECIFIED : this._businessOperationConfirmationRequired;
    }

    public void setBusinessOperationConfirmationRequired(Kleenean confirmation) {
        this._businessOperationConfirmationRequired = confirmation;
    }

    public Kleenean getDatabaseOperationConfirmationRequired() {
        return this._databaseOperationConfirmationRequired == null ? Kleenean.UNSPECIFIED : this._databaseOperationConfirmationRequired;
    }

    public void setDatabaseOperationConfirmationRequired(Kleenean confirmation) {
        this._databaseOperationConfirmationRequired = confirmation;
    }

    public boolean isDatabaseDefaultValuesMustBeSingleEntityExpression() {
        if (this._databaseDefaultValuesMustBeSingleEntityExpression == null) {
            ExtendedProperties bootstrapping = PropertiesHandler.getBootstrapping();
            return bootstrapping != null && !bootstrapping.isEmpty() && BitUtils.valueOf(bootstrapping.getString("database.default.values.must.be.single.entity.expression", "false"));
        }
        return this._databaseDefaultValuesMustBeSingleEntityExpression;
    }

    public void setDatabaseDefaultValuesMustBeSingleEntityExpression(boolean b) {
        this._databaseDefaultValuesMustBeSingleEntityExpression = b;
    }

    public String getMissingValueGraphicImageName() {
        return this._missingValueGraphicImageName;
    }

    public void setMissingValueGraphicImageName(String name) {
        this._missingValueGraphicImageName = this.fairGraphicImageName(name);
    }

    public boolean isMissingValueGraphicImageNameFontAwesomeClass() {
        return this.isFontAwesomeClass(this._missingValueGraphicImageName);
    }

    public String getNullValueGraphicImageName() {
        return this._nullValueGraphicImageName;
    }

    public void setNullValueGraphicImageName(String name) {
        this._nullValueGraphicImageName = this.fairGraphicImageName(name);
    }

    public boolean isNullValueGraphicImageNameFontAwesomeClass() {
        return this.isFontAwesomeClass(this._nullValueGraphicImageName);
    }

    public String getUnnecessaryValueGraphicImageName() {
        return this._unnecessaryValueGraphicImageName;
    }

    public void setUnnecessaryValueGraphicImageName(String name) {
        this._unnecessaryValueGraphicImageName = this.fairGraphicImageName(name);
    }

    public boolean isUnnecessaryValueGraphicImageNameFontAwesomeClass() {
        return this.isFontAwesomeClass(this._unnecessaryValueGraphicImageName);
    }

    public boolean isAnnotatedWithMaster() {
        return this._annotatedWithMasterProject;
    }

    public boolean isAnnotatedWithModule() {
        return this._annotatedWithProjectModule;
    }

    public boolean isAnnotatedWithModuleDocGen() {
        return this._annotatedWithProjectModuleDocGen;
    }

    public boolean isMenuModule() {
        return this._menuModule;
    }

    public boolean isRoleModule() {
        return this._roleModule;
    }

    public boolean isForeignModule() {
        return this._foreignModule;
    }

    public boolean isPrivateModule() {
        return this._privateModule;
    }

    public RoleType[] getModuleRoleTypes() {
        return this._moduleRoleTypes;
    }

    public int[] getModuleRoleTypesNumbers() {
        if (this._moduleRoleTypes == null || this._moduleRoleTypes.length == 0) {
            return null;
        }
        int[] numbers = new int[this._moduleRoleTypes.length];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = this._moduleRoleTypes[i].getNumber();
        }
        return numbers;
    }

    public String getModuleRoleTypesNumbersString() {
        int[] numbers = this.getModuleRoleTypesNumbers();
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        String string = Arrays.toString(numbers);
        return StrUtils.disclose(string, '[', ']');
    }

    public String getHelpDocument() {
        return this._helpDocument;
    }

    public void setHelpDocument(String document) {
        if (StringUtils.isBlank((String)document)) {
            this._helpDocument = "";
        } else if (this.isValidEmbeddedDocument(document)) {
            this._helpDocument = document;
        } else {
            logger.error((Object)(this.getName() + " help document is invalid "));
            this.increaseErrorCount();
        }
    }

    public String getHelpFileName() {
        return this._helpFileName;
    }

    public void setHelpFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            this._helpFileName = "";
        } else if (this.isValidHelpFileName(fileName)) {
            if (this.isValidHelpFileType(fileName)) {
                this._helpFileName = fileName;
            } else {
                logger.error((Object)(this.getName() + " help file type is missing or invalid; valid types are: " + Project.getHelpFileTypesCSV()));
                this.increaseErrorCount();
            }
        } else {
            logger.error((Object)(this.getName() + " help file name is invalid "));
            this.increaseErrorCount();
        }
    }

    public HelpFileAutoName getHelpFileAutoName() {
        return this._helpFileAutoName;
    }

    protected void setHelpFileAutoName(HelpFileAutoName helpFileAutoName) {
        this._helpFileAutoName = this.coalesce(helpFileAutoName, HelpFileAutoName.NONE);
    }

    private void checkHelpFileAutoName() {
        if (HelpFileAutoName.META.equals((Object)this._helpFileAutoName) && !this.isAnnotatedWithMaster()) {
            logger.error((Object)(this.getName() + " META help file auto-type can only be specified in a MasterProject annotation"));
            this.increaseErrorCount();
        }
    }

    public String getHelpFileAutoType() {
        return this._helpFileAutoType;
    }

    protected void setHelpFileAutoType(String helpFileAutoType) {
        this._helpFileAutoType = StringUtils.defaultIfBlank((String)helpFileAutoType, (String)"html");
    }

    private void checkHelpFileAutoType() {
        if (HelpFileAutoName.NONE.equals((Object)this._helpFileAutoName) || HelpFileAutoName.META.equals((Object)this._helpFileAutoName)) {
            this._helpFileAutoType = "";
        } else if (StringUtils.isBlank((String)this._helpFileAutoType)) {
            this._helpFileAutoType = "html";
        } else if (!ArrayUtils.contains((Object[])this.projectHelpFileTypes(), (Object)this._helpFileAutoType)) {
            logger.error((Object)(this.getName() + " help file auto-type is invalid; valid types are: " + this.projectHelpFileTypesCSV()));
            this.increaseErrorCount();
        }
    }

    public boolean isModuleClassDiagramGenEnabled() {
        return this._moduleClassDiagramGenEnabled;
    }

    Parser getParser() {
        if (this._parser == null) {
            this._parser = new Parser();
        }
        return this._parser;
    }

    Writer getWriter() {
        if (this._writer == null) {
            this._writer = new Writer(this, "project");
        }
        return this._writer;
    }

    ProjectEntityReference getEntityReference(Class<?> type) {
        Class<?> clazz = XS1.getNamedClass(type);
        return this.getEntityReference(clazz.getSimpleName());
    }

    ProjectEntityReference getEntityReference(String name) {
        return this._entityReferences.get(name);
    }

    Class<?> getTrueType(Class<?> type) {
        Class<?> clazz = XS1.getNamedClass(type);
        String key = clazz.getSimpleName();
        if (this._entityReferences.containsKey(key)) {
            ProjectEntityReference reference = this._entityReferences.get(key);
            return reference == null ? null : reference.getEntityClass();
        }
        return type;
    }

    public Map<String, ProjectEntityReference> getEntityReferences() {
        return this._entityReferences;
    }

    ProjectReference getProjectReference(Class<?> type) {
        Class<?> clazz = XS1.getNamedClass(type);
        return this._projectReferences.get(clazz.getName());
    }

    public Map<String, ProjectReference> getProjectReferences() {
        return this._projectReferences;
    }

    public Class<? extends Entity> getUserEntityClass() {
        return this._userEntityClass;
    }

    public void setUserEntityClass(Class<? extends Entity> clazz) {
        this._userEntityClass = clazz;
    }

    public Entity getUserEntity() {
        return this.getEntity(this._userEntityClass);
    }

    public Class<? extends Entity> getUploadedFileEntityClass() {
        return this._uploadedFileEntityClass;
    }

    public void setUploadedFileEntityClass(Class<? extends Entity> clazz) {
        this._uploadedFileEntityClass = clazz;
    }

    public Entity getUploadedFileEntity() {
        return this.getEntity(this._uploadedFileEntityClass);
    }

    public Set<Artifact> getArtifacts() {
        return this._artifacts;
    }

    private void clearArtifacts() {
        this._artifacts.clear();
    }

    private void clearArtifactsAttributes() {
        for (Artifact artifact : this._artifacts) {
            artifact.clearAttributes();
        }
    }

    private void addArtifactsAttributes() {
        for (Artifact artifact : this._artifacts) {
            artifact.addAttributes();
        }
    }

    public boolean addArtifact(Artifact artifact) {
        return this._artifacts.add(artifact);
    }

    public Set<Method> getAddAttributesMethods() {
        return this._addAttributesMethods;
    }

    public void clearAddAttributesMethods() {
        this._addAttributesMethods.clear();
    }

    public void attachAddAttributesMethods() {
        this.attachAddAttributesMethods(this.getClass());
    }

    public void attachAddAttributesMethods(Class<?> clazz) {
        logger.debug((Object)this.signature("attachAddAttributesMethods", clazz));
        Method[] methods = clazz.getDeclaredMethods();
        List list = Arrays.asList(methods);
        ByMethodSequence comparator = new ByMethodSequence();
        list = (List)ColUtils.sort(list, comparator);
        for (Method method : list) {
            String name = method.getName();
            boolean addAttributesMethod = method.isAnnotationPresent(AddAttributesMethod.class);
            int modifiers = method.getModifiers();
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!addAttributesMethod || !Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Void.TYPE.equals(returnType) || parameterTypes.length != 1 || !Artifact.class.isAssignableFrom(parameterTypes[0])) continue;
            logger.debug((Object)this.signature(clazz.getSimpleName() + "." + name, parameterTypes[0]));
            this._addAttributesMethods.add(method);
        }
    }

    private void invokeAddAttributesMethods() {
        for (Method method : this._addAttributesMethods) {
            Class<?> clazz = method.getDeclaringClass();
            String name = method.getName();
            Class<?> parameterType = method.getParameterTypes()[0];
            for (Artifact artifact : this._artifacts) {
                if (!parameterType.isAssignableFrom(artifact.getClass()) || Entity.class.isAssignableFrom(artifact.getClass()) && artifact.depth() != 0) continue;
                try {
                    logger.debug((Object)this.signature(clazz.getSimpleName() + "." + name, parameterType + " " + artifact.getClassPath()));
                    method.invoke(null, artifact);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    this.fatal(ex);
                }
            }
        }
    }

    public Set<String> getProcessingGroups() {
        return this._processingGroups;
    }

    public Set<UserFlow> getUserFlows() {
        return this._userFlows;
    }

    public Project() {
        this.init();
    }

    private void init() {
        Class<?> namedClass = this.getNamedClass();
        String className = namedClass.getSimpleName();
        this.setDeclared(className);
    }

    public void loadPrivateProperties() {
        this.loadPrivateProperties(LoggingLevel.TRACE);
    }

    public void loadPrivateProperties(LoggingLevel loggingLevel) {
        if (loggingLevel != null) {
            ExtendedProperties properties = PropertiesHandler.getPrivateProperties();
            if (properties == null || properties.isEmpty()) {
                this._abort = true;
            } else {
                this.loadPrivateProperties(loggingLevel, properties);
            }
        }
    }

    protected void loadPrivateProperties(LoggingLevel loggingLevel, ExtendedProperties properties) {
        if (loggingLevel != null && properties != null && !properties.isEmpty()) {
            this.loadPrivateProperties(loggingLevel.getLevel(), properties);
        }
    }

    protected void loadPrivateProperties(Level level, ExtendedProperties properties) {
        assert (level != null);
        assert (properties != null && !properties.isEmpty());
    }

    @Override
    public String getAlias() {
        String name = this.getName();
        String alias = super.getAlias();
        return name != null && name.equals(alias) ? name.toLowerCase() : alias;
    }

    private void settle() {
        this.settleAttributes();
    }

    protected void settleAttributes() {
        this.track("settleAttributes");
    }

    public void clearDirectives() {
        this.track("clearDirectives");
        this._fileExclusionPatterns.clear();
        this._filePreservationPatterns.clear();
    }

    public void addDirectives() {
        this.track("addDirectives");
    }

    public void addFileExclusionPattern(String regex) {
        if (StringUtils.isNotBlank((String)regex)) {
            try {
                this._fileExclusionPatterns.add(Pattern.compile(regex));
            }
            catch (PatternSyntaxException ex) {
                this.getParser().error(regex + " is an invalid regular expression; file exclusion pattern cannot be added");
            }
        }
    }

    public void addFilePreservationPattern(String regex) {
        if (StringUtils.isNotBlank((String)regex)) {
            try {
                this._filePreservationPatterns.add(Pattern.compile(regex));
            }
            catch (PatternSyntaxException ex) {
                this.getParser().error(regex + " is an invalid regular expression; file preservation pattern cannot be added");
            }
        }
    }

    @Override
    public void annotate() {
        super.annotate();
        this.checkHelpFileAutoName();
        this.checkHelpFileAutoType();
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
        if (type != null) {
            this.annotateMaster(type);
            this.annotateModule(type);
            this.annotateModuleDocGen(type);
        }
    }

    @Override
    void annotate(Field field) {
        super.annotate(field);
        if (field != null) {
            this.annotateModule(field);
            this.annotateModuleDocGen(field);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidTypeAnnotations();
        valid.add(MasterProject.class);
        valid.add(ProjectModule.class);
        valid.add(ProjectModuleDocGen.class);
        return valid;
    }

    @Override
    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidFieldAnnotations();
        valid.add(ProjectModule.class);
        valid.add(ProjectModuleDocGen.class);
        return valid;
    }

    private void annotateMaster(Class<?> type) {
        MasterProject annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, MasterProject.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(MasterProject.class)) != null) {
            String fileName;
            String document;
            this._annotatedWithMasterProject = true;
            String alias = annotation.alias();
            if (StringUtils.isNotBlank((String)alias)) {
                this.setAlias(alias);
            }
            if (StringUtils.isNotBlank((String)(document = annotation.helpDocument()))) {
                this.setHelpDocument(document);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.helpFile()))) {
                this.setHelpFileName(fileName);
            }
            this._helpFileAutoName = (HelpFileAutoName)this.specified(new HelpFileAutoName[]{annotation.helpFileAutoName(), this._helpFileAutoName});
            this._helpFileAutoType = this.specified(annotation.helpFileAutoType(), this._helpFileAutoType);
        }
    }

    private void annotateModule(Class<?> type) {
        ProjectModule annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, ProjectModule.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(ProjectModule.class)) != null) {
            String fileName;
            this._annotatedWithProjectModule = true;
            this._menuModule = annotation.menu().toBoolean(this._menuModule);
            this._roleModule = annotation.role().toBoolean(this._roleModule);
            this._foreignModule = annotation.foreign().toBoolean(this._foreignModule);
            this._privateModule = annotation.privacy().toBoolean(this._privateModule);
            this._moduleRoleTypes = annotation.roleTypes();
            String document = annotation.helpDocument();
            if (StringUtils.isNotBlank((String)document)) {
                this.setHelpDocument(document);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.helpFile()))) {
                this.setHelpFileName(fileName);
            }
            this._helpFileAutoName = (HelpFileAutoName)this.specified(new HelpFileAutoName[]{annotation.helpFileAutoName(), this._helpFileAutoName});
            this._helpFileAutoType = this.specified(annotation.helpFileAutoType(), this._helpFileAutoType);
        }
        this.finalizeModuleAnnotation();
    }

    private void annotateModule(Field field) {
        this._annotatedWithProjectModule = field.isAnnotationPresent(ProjectModule.class);
        if (this._annotatedWithProjectModule) {
            String fileName;
            ProjectModule annotation = field.getAnnotation(ProjectModule.class);
            this._menuModule = annotation.menu().toBoolean(this._menuModule);
            this._roleModule = annotation.role().toBoolean(this._roleModule);
            this._foreignModule = annotation.foreign().toBoolean(this._foreignModule);
            this._privateModule = annotation.privacy().toBoolean(this._privateModule);
            this._moduleRoleTypes = annotation.roleTypes();
            String document = annotation.helpDocument();
            if (StringUtils.isNotBlank((String)document)) {
                this.setHelpDocument(document);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.helpFile()))) {
                this.setHelpFileName(fileName);
            }
            this._helpFileAutoName = (HelpFileAutoName)this.specified(new HelpFileAutoName[]{annotation.helpFileAutoName(), this._helpFileAutoName});
            this._helpFileAutoType = this.specified(annotation.helpFileAutoType(), this._helpFileAutoType);
        }
        this.finalizeModuleAnnotation();
    }

    private void finalizeModuleAnnotation() {
        if (this._master != null) {
            Class<?> namedClass = this.getNamedClass();
            if (this._foreignModule) {
                this._master.addForeignEntityClasses(namedClass);
            }
            if (this._privateModule) {
                this._master.addPrivateEntityClasses(namedClass);
            }
        }
    }

    private void finalizeModuleAnnotation(Field field) {
        Class<?> clazz;
        if (this._master != null && (StringUtils.isNotBlank((String)this._helpDocument) || StringUtils.isNotBlank((String)this._helpFileName)) && (clazz = field.getDeclaringClass()).isAnnotationPresent(MasterProject.class)) {
            List<Entity> entities = this.getEntitiesList();
            for (Entity entity : entities) {
                if (StringUtils.isBlank((String)entity.getHelpDocument()) && StringUtils.isNotBlank((String)this._helpDocument)) {
                    entity.setHelpDocument(this._helpDocument);
                }
                if (!StringUtils.isBlank((String)entity.getHelpFileName()) || !StringUtils.isNotBlank((String)this._helpFileName)) continue;
                entity.setHelpFileName(this._helpFileName);
            }
        }
    }

    private void annotateModuleDocGen(Class<?> type) {
        ProjectModuleDocGen annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, ProjectModuleDocGen.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(ProjectModuleDocGen.class)) != null) {
            this._annotatedWithProjectModuleDocGen = true;
            this._moduleClassDiagramGenEnabled = annotation.classDiagram().toBoolean(this._moduleClassDiagramGenEnabled);
        }
    }

    private void annotateModuleDocGen(Field field) {
        this._annotatedWithProjectModuleDocGen = field.isAnnotationPresent(ProjectModuleDocGen.class);
        if (this._annotatedWithProjectModuleDocGen) {
            ProjectModuleDocGen annotation = field.getAnnotation(ProjectModuleDocGen.class);
            this._moduleClassDiagramGenEnabled = annotation.classDiagram().toBoolean(this._moduleClassDiagramGenEnabled);
        }
    }

    public boolean build(String platform) {
        return this.build() && this.generate(platform);
    }

    public boolean build() {
        logger.info((Object)this.signature("build", this.getClass().getName()));
        this.getBuildTimestamp();
        if (PropertiesHandler.missingBootstrappingProperties()) {
            logger.error((Object)"build aborted due to missing or invalid bootstrapping properties");
            return false;
        }
        TLC.setProject(this);
        this.clearArtifacts();
        this.addArtifact(this);
        this.annotate();
        this.configureBuilder();
        this._built = this.parse() && this.analyze();
        this._abort |= !this._built;
        return this._built;
    }

    public String getBuildTimestamp() {
        if (this._buildTimestamp == null) {
            this._buildTimestamp = this.timestamp().substring(0, 13);
        }
        return this._buildTimestamp;
    }

    public String getBuildDate() {
        String timestamp = this.getBuildTimestamp();
        return timestamp.substring(0, 8);
    }

    private String timestamp() {
        return TimeUtils.simpleTimestampString(TimeUtils.actualTimestamp());
    }

    public ProjectObjectModelReader getProjectObjectModel() {
        return this.pom;
    }

    public String getAdalidProjectVersion() {
        return this.pom.getProjectVersionNumber();
    }

    protected void logAdalidProjectVersion() {
        this.pom.logProjectVersion();
    }

    public void configureBuilder() {
        this.track("configureBuilder");
    }

    protected boolean parse() {
        logger.info((Object)this.signature("parse", this.getClass().getName()));
        TLC.setProject(this);
        return this.getParser().parse();
    }

    protected boolean analyze() {
        logger.info((Object)this.signature("analyze", this.getClass().getName()));
        TLC.setProject(this);
        List<Project> modulesList = this.getModulesList();
        Collections.sort(modulesList);
        boolean analyzed = true;
        for (Project module : modulesList) {
            if (!(analyzed &= module.assemble())) break;
            List<? extends Display> displaysList = module.getDisplaysList();
            for (Display display : displaysList) {
                String name = display.getName();
                if (this._displays.containsKey(name)) continue;
                this._displays.put(name, display);
            }
        }
        return analyzed;
    }

    protected boolean assemble() {
        this.log(_detailLevel, this.signature("assemble", this.getClass().getName()), new Object[0]);
        return true;
    }

    public boolean generate(String platform) {
        logger.info((Object)this.signature("generate", "platform=" + platform));
        TLC.setProject(this);
        this.configureGenerator();
        boolean fee = this.readyToWrite(platform);
        boolean faa = this.checkBootstrappingProperties();
        boolean foo = this.checkProjectAlias();
        if (this._abort || !fee || !faa || !foo) {
            logger.error((Object)"generation aborted due to previous errors");
            return false;
        }
        if (!this._built) {
            logger.error((Object)"project was not built; generation aborted");
            return false;
        }
        this.configureWriter();
        Writer writer = this.getWriter();
        writer.setFileExclusionPatterns(this._fileExclusionPatterns);
        writer.setFilePreservationPatterns(this._filePreservationPatterns);
        writer.setAvailableResourceNames(this.getEntitiesMap().keySet());
        writer.setForeignResourceNames(XS2.simpleNames(this._foreignEntityClasses));
        writer.setPrivateResourceNames(XS2.simpleNames(this._privateEntityClasses));
        boolean b1 = writer.write(platform);
        boolean b2 = this.afterWriting(b1);
        boolean ok = b1 && b2;
        this.printSummary(ok);
        return ok;
    }

    protected boolean afterWriting(boolean ok) {
        return ok;
    }

    protected void printSummary(boolean ok) {
        String alias = this.getAlias();
        if (ok) {
            logger.info((Object)("project " + alias + " successfully generated"));
        } else {
            logger.warn((Object)("project " + alias + " generated with errors"));
        }
    }

    public void configureGenerator() {
        this.track("configureGenerator");
        this.clearDirectives();
        this.addDirectives();
        this.clearArtifactsAttributes();
        this.attachAddAttributesMethods();
        this.invokeAddAttributesMethods();
        this.addArtifactsAttributes();
    }

    protected boolean readyToWrite(String platform) {
        logger.trace((Object)this.signature("readyToWrite", "platform=" + platform));
        return true;
    }

    private boolean checkBootstrappingProperties() {
        ExtendedProperties bootstrapping = PropertiesHandler.getBootstrapping();
        return bootstrapping != null && !bootstrapping.isEmpty();
    }

    private boolean checkProjectAlias() {
        String alias = this.getAlias();
        return this.checkProjectAlias(alias);
    }

    private boolean checkProjectAlias(String alias) {
        if (StringUtils.isBlank((String)alias)) {
            logger.error((Object)"invalid project alias");
            return false;
        }
        if (!alias.matches("^[a-z][a-z0-9]*$")) {
            logger.error((Object)(alias + " is an invalid project alias"));
            return false;
        }
        if (alias.equalsIgnoreCase("meta") || alias.equalsIgnoreCase("workspace")) {
            logger.error((Object)(alias + " is a restricted project alias"));
            return false;
        }
        return true;
    }

    private void configureWriter() {
        Writer.setAlertLevel(_alertLevel);
        Writer.setDetailLevel(_detailLevel);
        Writer.setTrackingLevel(_trackingLevel);
    }

    private String signature(String method, Object ... parameters) {
        String pattern = "{0}({1})";
        return MessageFormat.format(pattern, method, StringUtils.join((Object[])parameters, (String)", "));
    }

    public Display getReadingTableDisplayOf(Entity entity) {
        return this.getDisplayOf(entity, DisplayMode.READING, DisplayFormat.TABLE);
    }

    public Display getReadingDetailDisplayOf(Entity entity) {
        return this.getDisplayOf(entity, DisplayMode.READING, DisplayFormat.DETAIL);
    }

    public Display getReadingTreeDisplayOf(Entity entity) {
        return this.getDisplayOf(entity, DisplayMode.READING, DisplayFormat.TREE);
    }

    public Display getWritingTableDisplayOf(Entity entity) {
        return this.getDisplayOf(entity, DisplayMode.WRITING, DisplayFormat.TABLE);
    }

    public Display getWritingDetailDisplayOf(Entity entity) {
        return this.getDisplayOf(entity, DisplayMode.WRITING, DisplayFormat.DETAIL);
    }

    public Display getWritingTreeDisplayOf(Entity entity) {
        return this.getDisplayOf(entity, DisplayMode.WRITING, DisplayFormat.TREE);
    }

    public Display getProcessingConsoleDisplayOf(Entity entity) {
        return this.getDisplayOf(entity, DisplayMode.PROCESSING, DisplayFormat.CONSOLE);
    }

    private Display getDisplayOf(Entity entity, DisplayMode mode, DisplayFormat format) {
        if (entity == null) {
            return null;
        }
        List<? extends Display> displays = this.getDisplaysList();
        for (Display display : displays) {
            Entity displayEntity = display.getEntity();
            Entity displayMaster = display.getMaster();
            DisplayMode displayMode = display.getDisplayMode();
            DisplayFormat displayFormat = display.getDisplayFormat();
            if (!entity.equals(displayEntity) || displayMaster != null || !mode.equals((Object)displayMode) || !format.equals((Object)displayFormat)) continue;
            logger.debug((Object)(entity.getName() + " " + mode + " " + format + " display is " + display.getName() + " @ " + this.getName()));
            return display;
        }
        logger.debug((Object)(entity.getName() + " " + mode + " " + format + " display is not @ " + this.getName()));
        return null;
    }

    public Display getReadingTableDisplayOf(Entity detail, Entity master, EntityReference reference) {
        return this.getDisplayOf(detail, master, reference, DisplayMode.READING, DisplayFormat.TABLE);
    }

    public Display getReadingDetailDisplayOf(Entity detail, Entity master, EntityReference reference) {
        return this.getDisplayOf(detail, master, reference, DisplayMode.READING, DisplayFormat.DETAIL);
    }

    public Display getWritingTableDisplayOf(Entity detail, Entity master, EntityReference reference) {
        return this.getDisplayOf(detail, master, reference, DisplayMode.WRITING, DisplayFormat.TABLE);
    }

    public Display getWritingDetailDisplayOf(Entity detail, Entity master, EntityReference reference) {
        return this.getDisplayOf(detail, master, reference, DisplayMode.WRITING, DisplayFormat.DETAIL);
    }

    private Display getDisplayOf(Entity detail, Entity master, EntityReference reference, DisplayMode mode, DisplayFormat format) {
        if (detail == null || master == null || reference == null) {
            return null;
        }
        List<? extends Display> displays = this.getDisplaysList();
        for (Display display : displays) {
            Entity displayEntity = display.getEntity();
            Entity displayMaster = display.getMaster();
            EntityReference displayReference = display.getReference();
            DisplayMode displayMode = display.getDisplayMode();
            DisplayFormat displayFormat = display.getDisplayFormat();
            if (!detail.equals(displayEntity) || !master.equals(displayMaster) || !displayReference.equals(reference) || !mode.equals((Object)displayMode) || !format.equals((Object)displayFormat)) continue;
            logger.debug((Object)(detail.getName() + " " + mode + " " + format + " display is " + display.getName() + " @ " + this.getName()));
            return display;
        }
        logger.debug((Object)(detail.getName() + " " + mode + " " + format + " display is not @ " + this.getName()));
        return null;
    }

    public Display getTableSiblingOf(Display display) {
        return this.getSiblingOf(display, DisplayFormat.TABLE);
    }

    public Display getDetailSiblingOf(Display display) {
        return this.getSiblingOf(display, DisplayFormat.DETAIL);
    }

    public Display getTreeSiblingOf(Display display) {
        return this.getSiblingOf(display, DisplayFormat.TREE);
    }

    public Display getConsoleSiblingOf(Display display) {
        return this.getSiblingOf(display, DisplayFormat.CONSOLE);
    }

    private Display getSiblingOf(Display display, DisplayFormat format) {
        if (display == null) {
            return null;
        }
        Entity displayEntity = display.getEntity();
        Entity displayMaster = display.getMaster();
        if (displayEntity == null) {
            return null;
        }
        DisplayMode displayMode = display.getDisplayMode();
        DisplayFormat displayFormat = display.getDisplayFormat();
        if (displayMode == null || displayFormat == null) {
            return null;
        }
        DisplayMode mode = DisplayFormat.CONSOLE.equals((Object)format) ? DisplayMode.PROCESSING : (DisplayFormat.CONSOLE.equals((Object)displayFormat) ? DisplayMode.UNSPECIFIED : displayMode);
        List<? extends Display> siblings = this.getDisplaysList();
        for (Display display2 : siblings) {
            if (display2.equals(display)) continue;
            Entity siblingEntity = display2.getEntity();
            Entity siblingMaster = display2.getMaster();
            DisplayMode siblingMode = display2.getDisplayMode();
            DisplayFormat siblingFormat = display2.getDisplayFormat();
            if (!displayEntity.equals(siblingEntity) || !format.equals((Object)DisplayFormat.UNSPECIFIED) && !format.equals((Object)siblingFormat) || !mode.equals((Object)DisplayMode.UNSPECIFIED) && !mode.equals((Object)siblingMode)) continue;
            if (siblingMaster == null && displayMaster == null) {
                logger.debug((Object)(display.getName() + " " + format + " sibling is " + display2.getName() + " @ " + this.getName()));
                return display2;
            }
            if (siblingMaster == null || !siblingMaster.equals(displayMaster)) continue;
            logger.debug((Object)(display.getName() + " " + format + " sibling is " + display2.getName() + " @ " + this.getName()));
            return display2;
        }
        logger.debug((Object)(display.getName() + " " + format + " sibling is not @ " + this.getName()));
        return null;
    }

    public Display getTableCousinOf(Display display) {
        return this.getCousinOf(display, DisplayFormat.TABLE);
    }

    public Display getDetailCousinOf(Display display) {
        return this.getCousinOf(display, DisplayFormat.DETAIL);
    }

    public Display getTreeCousinOf(Display display) {
        return this.getCousinOf(display, DisplayFormat.TREE);
    }

    public Display getConsoleCousinOf(Display display) {
        return this.getCousinOf(display, DisplayFormat.CONSOLE);
    }

    private Display getCousinOf(Display display, DisplayFormat format) {
        if (display == null) {
            return null;
        }
        Entity displayEntity = display.getEntity();
        if (displayEntity == null) {
            return null;
        }
        DisplayMode displayMode = display.getDisplayMode();
        DisplayFormat displayFormat = display.getDisplayFormat();
        if (displayMode == null || displayFormat == null) {
            return null;
        }
        DisplayMode mode = DisplayFormat.CONSOLE.equals((Object)format) ? DisplayMode.PROCESSING : (DisplayFormat.CONSOLE.equals((Object)displayFormat) ? DisplayMode.UNSPECIFIED : displayMode);
        List<? extends Display> cousins = this.getDisplaysList();
        for (Display display2 : cousins) {
            if (display2.equals(display)) continue;
            Entity cousinEntity = display2.getEntity();
            Entity cousinMaster = display2.getMaster();
            DisplayMode cousinMode = display2.getDisplayMode();
            DisplayFormat cousinFormat = display2.getDisplayFormat();
            if (!displayEntity.equals(cousinEntity) || !format.equals((Object)DisplayFormat.UNSPECIFIED) && !format.equals((Object)cousinFormat) || !mode.equals((Object)DisplayMode.UNSPECIFIED) && !mode.equals((Object)cousinMode) || cousinMaster != null) continue;
            logger.debug((Object)(display.getName() + " " + format + " cousin is " + display2.getName() + " @ " + this.getName()));
            return display2;
        }
        logger.debug((Object)(display.getName() + " " + format + " cousin is not @ " + this.getName()));
        return null;
    }

    public AlternativeDisplay getReadingTableAlternativeTo(Display display, Entity entity) {
        return this.getAlternativeTo(display, entity, DisplayMode.READING, DisplayFormat.TABLE);
    }

    public AlternativeDisplay getReadingDetailAlternativeTo(Display display, Entity entity) {
        return this.getAlternativeTo(display, entity, DisplayMode.READING, DisplayFormat.DETAIL);
    }

    public AlternativeDisplay getReadingTreeAlternativeTo(Display display, Entity entity) {
        return this.getAlternativeTo(display, entity, DisplayMode.READING, DisplayFormat.TREE);
    }

    public AlternativeDisplay getWritingTableAlternativeTo(Display display, Entity entity) {
        return this.getAlternativeTo(display, entity, DisplayMode.WRITING, DisplayFormat.TABLE);
    }

    public AlternativeDisplay getWritingDetailAlternativeTo(Display display, Entity entity) {
        return this.getAlternativeTo(display, entity, DisplayMode.WRITING, DisplayFormat.DETAIL);
    }

    public AlternativeDisplay getWritingTreeAlternativeTo(Display display, Entity entity) {
        return this.getAlternativeTo(display, entity, DisplayMode.WRITING, DisplayFormat.TREE);
    }

    public AlternativeDisplay getProcessingConsoleAlternativeTo(Display display, Entity entity) {
        return this.getAlternativeTo(display, entity, DisplayMode.PROCESSING, DisplayFormat.CONSOLE);
    }

    private AlternativeDisplay getAlternativeTo(Display display, Entity entity, DisplayMode mode, DisplayFormat format) {
        String[] kinships;
        if (display == null || entity == null || format == null || mode == null) {
            return null;
        }
        String parameters = display.getName() + "-" + entity.getName() + "-" + mode + "-" + format;
        List<? extends Display> displays = this.getDisplaysList();
        AlternativeDisplay alternative = this.getAlternativeTo(display, entity, mode, format, displays);
        if (alternative != null) {
            return alternative;
        }
        Entity thisEntity = display.getEntity();
        if (thisEntity == null) {
            return null;
        }
        if (thisEntity.equals(entity)) {
            return null;
        }
        for (String kinship : kinships = new String[]{"dependent", "collateral"}) {
            List<Entity> someEntities = this.someEntityList(display, kinship);
            if (someEntities == null || someEntities.isEmpty()) continue;
            for (Entity someEntity : someEntities) {
                alternative = this.getAlternativeTo(display, entity, mode, format, displays, "explicit", kinship, someEntity);
                if (alternative != null) {
                    return alternative;
                }
                alternative = this.getAlternativeTo(display, entity, mode, format, displays, "implicit", kinship, someEntity);
                if (alternative == null) continue;
                return alternative;
            }
        }
        logger.debug((Object)(parameters + " alternative is not @ " + this.getName()));
        return null;
    }

    private AlternativeDisplay getAlternativeTo(Display display, Entity entity, DisplayMode mode, DisplayFormat format, List<? extends Display> displays) {
        return this.getAlternativeTo(display, entity, mode, format, displays, "existentially", "independent", entity);
    }

    private AlternativeDisplay getAlternativeTo(Display display, Entity entity, DisplayMode mode, DisplayFormat format, List<? extends Display> displays, String qualifier, String kinship, Entity someEntity) {
        Level level = Level.DEBUG;
        String parameters = display.getName() + "-" + entity.getName() + "-" + mode + "-" + format + "-" + qualifier + "-" + kinship;
        EntityReference thisReference = display.getReference();
        for (Display display2 : displays) {
            boolean fair;
            if (!kinship.equals("independent") && display.equals(display2)) continue;
            Entity thatEntity = display2.getEntity();
            Entity thatMaster = display2.getMaster();
            EntityReference thatReference = display2.getReference();
            DisplayFormat thatFormat = display2.getDisplayFormat();
            DisplayMode thatMode = display2.getDisplayMode();
            if (!entity.equals(thatEntity) || !format.equals((Object)thatFormat) || !mode.equals((Object)thatMode)) continue;
            switch (qualifier) {
                case "explicit": {
                    fair = this.explicitSwitch(kinship, someEntity, thatMaster, thatReference);
                    break;
                }
                case "implicit": {
                    fair = this.implicitSwitch(kinship, someEntity, thatMaster, thatReference, thisReference);
                    break;
                }
                default: {
                    boolean bl = fair = thatMaster == null;
                }
            }
            if (!fair) continue;
            logger.log((Priority)level, (Object)(parameters + " alternative is " + display2.getName() + " @ " + this.getName()));
            return new AlternativeDisplay(display2, display, entity, mode, format, qualifier, kinship, someEntity);
        }
        return null;
    }

    private boolean explicitSwitch(String kinship, Entity someEntity, Entity thatMaster, EntityReference thatReference) {
        switch (kinship) {
            case "dependent": 
            case "collateral": {
                return this.equalEntity(thatMaster, someEntity) && this.mainReference(thatReference);
            }
        }
        return false;
    }

    private boolean implicitSwitch(String kinship, Entity someEntity, Entity thatMaster, EntityReference thatReference, EntityReference thisReference) {
        switch (kinship) {
            case "dependent": {
                return this.equalEntity(thatMaster, someEntity) && this.alikeName(thatReference, someEntity);
            }
            case "collateral": {
                return this.equalEntity(thatMaster, someEntity) && this.equalName(thatReference, thisReference);
            }
        }
        return false;
    }

    private List<Entity> someEntityList(Display display, String kinship) {
        switch (kinship) {
            case "dependent": {
                return this.someEntityList(display.getEntity());
            }
            case "collateral": {
                return this.someEntityList(display.getMaster());
            }
        }
        return null;
    }

    private List<Entity> someEntityList(Entity entity) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (entity != null) {
            list.add(entity);
            list.addAll(this.someEntityList(entity.getBaseRoot()));
        }
        return list;
    }

    private boolean equalEntity(Entity that, Entity thiz) {
        if (that == null || thiz == null) {
            return false;
        }
        return that.equals(thiz);
    }

    private boolean mainReference(EntityReference thatReference) {
        return thatReference != null && thatReference.isMainRelationship();
    }

    private boolean alikeName(EntityReference thatReference, Entity thisEntity) {
        if (thatReference == null || thisEntity == null) {
            return false;
        }
        String thatReferenceName = thatReference.getName();
        String thisReferenceName = StringUtils.uncapitalize((String)thisEntity.getName());
        return thatReferenceName != null && thatReferenceName.equals(thisReferenceName);
    }

    private boolean equalName(EntityReference thatReference, EntityReference thisReference) {
        if (thatReference == null || thisReference == null) {
            return false;
        }
        String thatReferenceName = thatReference.getName();
        String thisReferenceName = thisReference.getName();
        return thatReferenceName != null && thatReferenceName.equals(thisReferenceName);
    }

    public Set<Class<?>> getLocallyDeclaredEntityClasses() {
        Class<?> namedClass = XS2.getNamedClass(this);
        return XS2.getLocallyDeclaredEntityClasses(namedClass);
    }

    public Set<String> getLocallyDeclaredEntityClassSimpleNames() {
        Set<Class<?>> classes = this.getLocallyDeclaredEntityClasses();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Class<?> clazz : classes) {
            names.add(clazz.getSimpleName());
        }
        return names;
    }

    public String[] getLocallyDeclaredEntityClassSimpleNamesArray() {
        Set<String> names = this.getLocallyDeclaredEntityClassSimpleNames();
        String[] array = new String[names.size()];
        return names.toArray(array);
    }

    private Project project() {
        Project project = TLC.getProject();
        return project == null ? this : project;
    }

    protected void increaseWarningCount() {
        this.project().getParser().increaseWarningCount();
    }

    protected void increaseErrorCount() {
        this.project().getParser().increaseErrorCount();
    }

    protected void increaseWriterWarnings(int count) {
        this.project().getWriter().increaseWarningCount(count);
    }

    protected void increaseWriterErrors(int count) {
        this.project().getWriter().increaseErrorCount(count);
    }

    private String[] projectHelpFileTypes() {
        return this.project().helpFileTypes();
    }

    private String projectHelpFileTypesCSV() {
        return this.project().helpFileTypesCSV();
    }

    private String[] helpFileTypes() {
        if (this.metaHelpEnabled()) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(Constants.VALID_HELP_FILE_TYPES));
            list.add("java");
            String[] array = new String[list.size()];
            return list.toArray(array);
        }
        return Constants.VALID_HELP_FILE_TYPES;
    }

    private String helpFileTypesCSV() {
        String csv = Constants.VALID_HELP_FILE_TYPES_CSV;
        return this.metaHelpEnabled() ? csv + ", java" : csv;
    }

    private boolean metaHelpEnabled() {
        return HelpFileAutoName.META.equals((Object)this._helpFileAutoName);
    }

    private void fatal(Throwable throwable) {
        Throwable cause = ThrowableUtils.getCause(throwable);
        String message = throwable.equals(cause) ? throwable.getClass().getSimpleName() : throwable.getMessage();
        logger.fatal((Object)message, cause);
    }

    private void log(Level level, String method, Object ... parameters) {
        if (LogUtils.foul(logger, level)) {
            return;
        }
        String message = this.signature(method, parameters);
        logger.log((Priority)level, (Object)message);
    }

    private void track(String method) {
        this.track(method, this);
    }

    private void track(String method, Object ... parameters) {
        this.getParser().track(this.depth(), this.round(), this.getClassPath(), method, parameters);
    }

    @Override
    public int compareTo(Project o) {
        if (o != null) {
            Project that = o;
            String thisName = StringUtils.trimToEmpty((String)this.getName());
            String thatName = StringUtils.trimToEmpty((String)that.getName());
            return thisName.compareTo(thatName);
        }
        return 0;
    }

    @Override
    public String toString() {
        String str1 = this.getName();
        String str2 = this.getNamedClass().getSimpleName();
        String str3 = this.getAlias();
        String str4 = str1 == null || str1.equals(str2) ? str2 : str2 + "[" + str1 + "]";
        String str5 = str3 == null || str3.equals(str1) ? str4 : str4 + "[" + str3 + "]";
        String str6 = str5.replace("][", ", ");
        return str6;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if (fields || verbose) {
            string = (String)string + fee + tab + "entities" + faa + this._entityReferences.size() + foo;
            string = (String)string + fee + tab + "projects" + faa + this._projectReferences.size() + foo;
        }
        return string;
    }

    @Override
    protected String mapsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        Object string = super.mapsToString(n, key, verbose, fields, maps);
        if (maps || verbose) {
            Object valor;
            for (String clave : this._entityReferences.keySet()) {
                valor = this._entityReferences.get(clave);
                if (((ProjectEntityReference)valor).getEntity() == null) continue;
                string = (String)string + ((ProjectEntityReference)valor).getEntity().toString(n + 1, clave, false, fields, false);
            }
            for (String clave : this._projectReferences.keySet()) {
                valor = this._projectReferences.get(clave);
                if (((ProjectReference)valor).getProject() == null || ((ProjectReference)valor).getProject() == this) continue;
                string = (String)string + ((ProjectReference)valor).getProject().toString(n + 1, clave, false, fields, maps);
            }
        }
        return string;
    }

    static {
        _acerose = false;
        _foliose = false;
        _spinose = false;
        _verbose = false;
        _warnose = false;
        _alertLevel = Level.OFF;
        _detailLevel = Level.OFF;
        _trackingLevel = Level.OFF;
        _transitionLevel = Level.OFF;
        _specialExpressionLevel = Level.OFF;
        _unusualExpressionLevel = Level.WARN;
    }

    class Parser {
        private final Logger logger = Logger.getLogger(Parser.class);
        private int maxDepthReached = 0;
        private int maxRoundReached = 0;
        private final Map<String, EntityData> entities = new TreeMap<String, EntityData>();
        private final List<String> allocations = new ArrayList<String>();
        private int alerts = 0;
        private int warnings = 0;
        private int errors = 0;

        public Parser() {
            TLB.clearProgrammers();
            TLB.clearWrapperClasses();
            TLB.setProgrammer("BP", new ResourceBundleProgrammer());
            TLB.setProgrammer("JP", new JDK8Programmer());
            TLB.setProgrammer("SP", new PostgreSqlProgrammer());
        }

        private boolean parse() {
            this.log(_detailLevel, "parse");
            this.logJavaClassPath();
            try {
                this.printSettings();
                this.checkUserEntityClass();
                this.checkUploadedFileEntityClass();
                this.putReferences();
                this.printProjectSummary(Level.INFO);
                this.printProjectReferencesSummary(Level.INFO);
                this.printEntityReferencesSummary(Level.INFO);
                if (this.errors == 0) {
                    this.initialiseEntityReferences();
                }
                if (this.errors == 0) {
                    this.prepareEntityReferences();
                }
                if (this.errors == 0) {
                    this.settleEntityReferences();
                }
                if (this.errors == 0) {
                    this.finaliseEntityReferences();
                }
                if (this.errors == 0) {
                    this.checkEntityReferences();
                }
                if (this.errors == 0) {
                    this.initialiseProjectReferences();
                }
                if (this.errors == 0) {
                    this.settleProjectReferences();
                }
                this.setMasterFields();
                this.printSummary();
                if (_verbose) {
                    this.printProjectReferencesDetail(_detailLevel);
                    this.printEntityReferencesDetail(_detailLevel);
                }
            }
            catch (Throwable throwable) {
                this.fatal(throwable);
            }
            boolean ok = this.errors == 0;
            this.resetCounters();
            return ok;
        }

        private void logJavaClassPath() {
            String key = "java.class.path";
            String jcp = System.getProperty(key);
            if (jcp != null) {
                String[] strings;
                this.logger.debug((Object)key);
                for (String string : strings = StringUtils.splitByWholeSeparator((String)jcp, (String)";")) {
                    this.logger.debug((Object)(Project.TAB + string));
                }
            }
        }

        private void checkUserEntityClass() {
            if (Project.this._userEntityClass == null) {
                this.warn("user entity class is not set");
            }
        }

        private void checkUploadedFileEntityClass() {
            if (Project.this._uploadedFileEntityClass == null) {
                this.warn("uploaded file entity class is not set");
            }
        }

        private void putReferences() {
            this.log(_trackingLevel, "putReferences");
            Class<?> type = Project.this.getClass();
            Class<?> clazz = XS1.getNamedClass(type);
            Class<?> declaringType = null;
            this.putReferences(type, declaringType, Project.this, null);
            String key = clazz.getName();
            ProjectReference reference = Project.this._projectReferences.get(key);
            reference.setProject(Project.this);
        }

        private void putReferences(Class<?> type, Class<?> declaringType, Artifact declaringArtifact, Field declaringField) {
            boolean restricted;
            Class<?> clazz = XS1.getNamedClass(type);
            int modifiers = clazz.getModifiers();
            boolean bl = restricted = clazz.isPrimitive() || Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers);
            if (!restricted) {
                if (Entity.class.isAssignableFrom(clazz)) {
                    String key = clazz.getSimpleName();
                    if (Project.this._entityReferences.containsKey(key)) {
                        ProjectEntityReference reference = Project.this._entityReferences.get(key);
                        Class<?> entityClass = reference.getEntityClass();
                        if (clazz.equals(entityClass)) {
                            reference.putDeclaringType(declaringType);
                            reference.setExplicit(declaringType);
                            reference.setImplicit(declaringType);
                        } else if (clazz.isAssignableFrom(entityClass)) {
                            reference.putDeclaringType(declaringType);
                            reference.setExplicit(declaringType);
                            reference.setImplicit(declaringType);
                            this.logEntityReferenceOverride(_alertLevel, entityClass, clazz, declaringType, null);
                            ++this.alerts;
                        } else if (entityClass.isAssignableFrom(clazz)) {
                            this.putEntityReference(clazz, declaringType, reference);
                            this.logEntityReferenceOverride(_alertLevel, clazz, entityClass, declaringType, null);
                            ++this.alerts;
                        } else {
                            String pattern = "{0} is not assignable from {1}";
                            String remarks = MessageFormat.format(pattern, entityClass.getName(), clazz.getName());
                            this.logEntityReferenceOverride(Level.ERROR, clazz, entityClass, declaringType, remarks);
                            ++this.errors;
                        }
                    } else {
                        this.putEntityReference(clazz, declaringType);
                    }
                } else if (Project.class.isAssignableFrom(clazz) && (declaringType == null || Project.class.isAssignableFrom(declaringType))) {
                    String key = clazz.getName();
                    if (Project.this._projectReferences.containsKey(key)) {
                        ProjectReference reference = Project.this._projectReferences.get(key);
                        reference.putDeclaringType(declaringType);
                    } else {
                        this.putProjectReference(clazz, declaringType, declaringArtifact, declaringField);
                    }
                }
            }
        }

        private void logEntityReferenceOverride(Level level, Class<?> riding, Class<?> ridden, Class<?> declaring, String remarks) {
            Level detailLevel;
            if (LogUtils.foul(this.logger, level)) {
                return;
            }
            Object pattern = level.isGreaterOrEqual((Priority)Level.ERROR) ? "failed to override" : "overriding";
            pattern = (String)pattern + " reference to entity {0} at {1}";
            String name = riding.getSimpleName();
            String message = MessageFormat.format((String)pattern, name, this.typeTitleAndName(declaring));
            this.logger.log((Priority)level, (Object)message);
            Level level2 = detailLevel = level.isGreaterOrEqual((Priority)Level.WARN) ? level : _detailLevel;
            if (LogUtils.foul(this.logger, detailLevel)) {
                return;
            }
            this.logger.log((Priority)detailLevel, (Object)("\toverriding class: " + riding.getName()));
            this.logger.log((Priority)detailLevel, (Object)("\toverridden class: " + ridden.getName()));
            if (StringUtils.isNotBlank((String)remarks)) {
                this.logger.log((Priority)detailLevel, (Object)(Project.TAB + remarks));
            }
        }

        private void putEntityReference(Class<?> type, Class<?> declaringType) {
            ProjectEntityReference previousReference = null;
            this.putEntityReference(type, declaringType, previousReference);
        }

        private void putEntityReference(Class<?> type, Class<?> declaringType, ProjectEntityReference previousReference) {
            String key = type.getSimpleName();
            Class<?> concreteSuperclass = XS1.getConcreteSuperclass(type);
            if (concreteSuperclass != null) {
                this.putReferences(concreteSuperclass, type, null, null);
            }
            boolean explicit = previousReference != null && previousReference.isExplicit();
            boolean implicit = previousReference != null && previousReference.isImplicit();
            ProjectEntityReference reference = new ProjectEntityReference(type, Project.this);
            reference.putDeclaringType(declaringType);
            reference.setExplicit(explicit);
            reference.setExplicit(declaringType);
            reference.setImplicit(implicit);
            reference.setImplicit(declaringType);
            Project.this._entityReferences.put(key, reference);
            for (Field field1 : XS1.getFields(type, Entity.class)) {
                Class<?> fieldType1 = field1.getType();
                if (Entity.class.isAssignableFrom(fieldType1)) {
                    this.putReferences(fieldType1, type, null, null);
                    continue;
                }
                if (!Operation.class.isAssignableFrom(fieldType1)) continue;
                for (Field field2 : XS1.getFields(fieldType1, Operation.class)) {
                    Class<?> fieldType2 = field2.getType();
                    if (!Entity.class.isAssignableFrom(fieldType2)) continue;
                    this.putReferences(fieldType2, type, null, null);
                }
            }
        }

        private void putProjectReference(Class<?> type, Class<?> declaringType, Artifact declaringArtifact, Field declaringField) {
            String key = type.getName();
            ProjectReference reference = new ProjectReference(type, Project.this);
            reference.putDeclaringType(declaringType);
            reference.setDeclaringArtifact(declaringArtifact);
            reference.setDeclaringField(declaringField);
            Project.this._projectReferences.put(key, reference);
            for (Field field : XS1.getFields(type, Project.class)) {
                this.putReferences(field.getType(), type, null, field);
            }
        }

        private void setMasterFields() {
            this.log(_trackingLevel, "setMasterFields");
            Class<?> type = Project.this.getClass();
            for (ProjectReference reference : Project.this._projectReferences.values()) {
                Project project = reference.getProject();
                Class<?> projectClass = reference.getProjectClass();
                for (Field field : XS1.getFields(type, Project.class, projectClass)) {
                    Class<?> fieldType = field.getType();
                    if (!projectClass.equals(fieldType)) continue;
                    field.setAccessible(true);
                    try {
                        if (field.get(Project.this) != null) continue;
                        field.set(Project.this, project);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        this.fatal(ex);
                    }
                }
            }
        }

        private void initialiseEntityReferences() {
            Entity entity;
            this.log(_trackingLevel, "initialiseEntityReferences");
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                if (reference.getEntity() != null) continue;
                entity = this.getEntityInstance(reference.getEntityClass());
                XS1.postConstruct(entity);
                reference.setEntity(entity);
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "initialiseEntityReferences 1/2");
            }
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                entity = reference.getEntity();
                if (entity == null) continue;
                entity.initialise();
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "initialiseEntityReferences 2/2");
            }
        }

        private void prepareEntityReferences() {
            this.log(_trackingLevel, "prepareEntityReferences");
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                Entity entity = reference.getEntity();
                if (entity == null) continue;
                entity.prepare();
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "prepareEntityReferences");
            }
        }

        private void settleEntityReferences() {
            this.log(_trackingLevel, "settleEntityReferences");
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                Entity entity = reference.getEntity();
                if (entity == null) continue;
                entity.settle();
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "settleEntityReferences");
            }
        }

        private void finaliseEntityReferences() {
            Entity entity;
            this.log(_trackingLevel, "finaliseEntityReferences");
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                entity = reference.getEntity();
                if (entity == null) continue;
                entity.finalise();
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "finaliseEntityReferences 1/2");
            }
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                entity = reference.getEntity();
                if (entity == null) continue;
                entity.finish();
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "finaliseEntityReferences 2/2");
            }
        }

        private void checkEntityReferences() {
            this.log(_trackingLevel, "checkEntityReferences");
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                Entity entity = reference.getEntity();
                if (entity == null || !entity.isAbstractClass()) continue;
                boolean concreteless = true;
                List<Entity> extensionsList = entity.getExtensionsList();
                for (Entity extension : extensionsList) {
                    if (extension.isAbstractClass()) continue;
                    concreteless = false;
                    break;
                }
                if (!concreteless) continue;
                this.logger.error((Object)(entity.getName() + " is an abstract class without concrete extensions"));
                this.increaseErrorCount();
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "checkEntityReferences");
            }
        }

        private Entity getEntityInstance(Class<?> type) {
            String errmsg = "failed to create a new instance of " + type;
            try {
                return (Entity)type.getConstructor(Artifact.class, Field.class).newInstance(Project.this, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new InstantiationRuntimeException(errmsg, ex);
            }
        }

        private void initialiseProjectReferences() {
            Project project;
            this.log(_trackingLevel, "initialiseProjectReferences");
            for (ProjectReference reference : Project.this._projectReferences.values()) {
                if (reference.getProject() != null) continue;
                project = this.getProjectInstance(reference.getProjectClass());
                project.setMaster(Project.this);
                project.resetDeclaringArtifact(reference.getDeclaringArtifact());
                project.resetDeclaringField(reference.getDeclaringField());
                project.annotate(reference.getDeclaringField());
                reference.setProject(project);
            }
            for (ProjectReference reference : Project.this._projectReferences.values()) {
                project = reference.getProject();
                if (project == null || project == Project.this) continue;
                Map<String, ProjectEntityReference> entityReferences = project.getEntityReferences();
                Map<String, ProjectReference> projectReferences = project.getProjectReferences();
                Map<String, Class<?>> declaredTypes = reference.getDeclaredTypes();
                for (Class<?> declaredType : declaredTypes.values()) {
                    String key;
                    if (Entity.class.isAssignableFrom(declaredType)) {
                        key = declaredType.getSimpleName();
                        if (!Project.this._entityReferences.containsKey(key)) continue;
                        ProjectEntityReference entityReference = Project.this._entityReferences.get(key);
                        entityReferences.put(key, entityReference);
                        continue;
                    }
                    if (!Project.class.isAssignableFrom(declaredType) || !Project.this._projectReferences.containsKey(key = declaredType.getName())) continue;
                    ProjectReference projectReference = Project.this._projectReferences.get(key);
                    projectReferences.put(key, projectReference);
                }
                project.getParser().printProjectSummary(_detailLevel);
                project.getParser().printProjectReferencesSummary(_detailLevel);
                project.getParser().printEntityReferencesSummary(_detailLevel);
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "initialiseProjectReferences");
            }
        }

        private void settleProjectReferences() {
            this.log(_trackingLevel, "settleProjectReferences");
            for (ProjectReference reference : Project.this._projectReferences.values()) {
                Project project = reference.getProject();
                if (project == null) continue;
                project.settle();
                Field field = reference.getDeclaringField();
                if (field == null) continue;
                project.finalizeModuleAnnotation(field);
            }
            if (_spinose) {
                RunUtils.logMemory(this.logger, "settleProjectReferences");
            }
        }

        private Project getProjectInstance(Class<?> type) {
            String errmsg = "failed to create a new instance of " + type;
            try {
                return (Project)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new InstantiationRuntimeException(errmsg, ex);
            }
        }

        private void printEntityReferencesSummary(Level level) {
            if (LogUtils.foul(this.logger, level)) {
                return;
            }
            int i = Project.this._entityReferences.size();
            String pattern = i == 0 ? "project {0} contains no references to entities" : "project {0} contains references to {1} distinct entities";
            String message = MessageFormat.format(pattern, Project.this.getClass().getName(), i);
            this.logger.log((Priority)level, (Object)message);
            if (LogUtils.foul(this.logger, _detailLevel)) {
                return;
            }
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                boolean explicit = reference.isExplicit();
                boolean implicit = reference.isImplicit();
                Map<String, Class<?>> references = reference.getDeclaredTypes();
                Map<String, Class<?>> referenced = reference.getDeclaringTypes();
                Entity e = reference.getEntity();
                Object s = reference.getEntityClass().getSimpleName();
                s = (String)s + " {";
                s = (String)s + reference.getEntityClass().getName();
                s = (String)s + (String)(e == null ? "" : "@" + Integer.toHexString(e.hashCode()));
                s = (String)s + ", explicit=" + explicit;
                s = (String)s + ", implicit=" + implicit;
                s = (String)s + ", references=" + references.size();
                s = (String)s + ", referenced=" + referenced.size();
                s = (String)s + "} ";
                this.logger.log((Priority)_detailLevel, (Object)(Project.TAB + (String)s));
                for (Class<?> declaredType : references.values()) {
                    this.logger.log((Priority)_detailLevel, (Object)("\t\treferences " + this.typeTitleAndName(declaredType)));
                }
                for (Class<?> declaringType : referenced.values()) {
                    this.logger.log((Priority)_detailLevel, (Object)("\t\tis referenced by " + this.typeTitleAndName(declaringType)));
                }
            }
        }

        private void printEntityReferencesDetail(Level level) {
            if (LogUtils.foul(this.logger, level)) {
                return;
            }
            for (ProjectEntityReference reference : Project.this._entityReferences.values()) {
                boolean initialised = reference.getEntity() != null;
                if (!initialised) continue;
                String string = reference.getEntity().toString(0, null, _verbose, true, true);
                this.logger.log((Priority)level, (Object)string);
            }
        }

        private void printProjectSummary(Level level) {
            String message;
            if (LogUtils.foul(this.logger, level)) {
                return;
            }
            if (Project.this._master == null) {
                String pattern = "project {0} is the master project";
                message = MessageFormat.format(pattern, Project.this.getClass().getName());
            } else {
                String pattern = "project {0} is nested within project {1}";
                message = MessageFormat.format(pattern, Project.this.getClass().getName(), Project.this._master.getClass().getName());
            }
            this.logger.log((Priority)level, (Object)message);
        }

        private void printProjectReferencesSummary(Level level) {
            if (LogUtils.foul(this.logger, level)) {
                return;
            }
            Class<?> clazz = Project.this.getClass();
            int i = 0;
            for (ProjectReference reference : Project.this._projectReferences.values()) {
                if (clazz.equals(reference.getProjectClass())) continue;
                ++i;
            }
            String pattern = i == 0 ? "project {0} contains no references to other projects" : "project {0} contains references to {1} other projects";
            String message = MessageFormat.format(pattern, Project.this.getClass().getName(), i);
            this.logger.log((Priority)level, (Object)message);
            if (LogUtils.foul(this.logger, _detailLevel)) {
                return;
            }
            for (ProjectReference reference : Project.this._projectReferences.values()) {
                Map<String, Class<?>> references = reference.getDeclaredTypes();
                Map<String, Class<?>> referenced = reference.getDeclaringTypes();
                Project p = reference.getProject();
                Object s = reference.getProjectClass().getSimpleName();
                s = (String)s + " {";
                s = (String)s + reference.getProjectClass().getName();
                s = (String)s + (String)(p == null ? "" : "@" + Integer.toHexString(p.hashCode()));
                s = (String)s + (String)(p == null ? "" : ", master=" + p.getMaster());
                s = (String)s + ", references=" + references.size();
                s = (String)s + ", referenced=" + referenced.size();
                s = (String)s + "} ";
                this.logger.log((Priority)_detailLevel, (Object)(Project.TAB + (String)s));
                for (Class<?> declaredType : references.values()) {
                    this.logger.log((Priority)_detailLevel, (Object)("\t\treferences " + this.typeTitleAndName(declaredType)));
                }
                for (Class<?> declaringType : referenced.values()) {
                    this.logger.log((Priority)_detailLevel, (Object)("\t\tis referenced by " + this.typeTitleAndName(declaringType)));
                }
            }
        }

        private void printProjectReferencesDetail(Level level) {
            if (LogUtils.foul(this.logger, level)) {
                return;
            }
            for (ProjectReference reference : Project.this._projectReferences.values()) {
                boolean initialised = reference.getProject() != null;
                if (!initialised) continue;
                String string = reference.getProject().toString(0, null, _verbose, true, true);
                this.logger.log((Priority)level, (Object)string);
            }
        }

        private String typeTitleAndName(Class<?> type) {
            if (Entity.class.isAssignableFrom(type)) {
                return "entity " + type.getName();
            }
            if (Project.class.isAssignableFrom(type)) {
                return "project " + type.getName();
            }
            return "" + type;
        }

        private void printSettings() {
            this.logger.debug((Object)("defaultMaxDepth=" + _defaultMaxDepth));
            this.logger.debug((Object)("defaultMaxRound=" + _defaultMaxRound));
            this.logger.debug((Object)("defaultPropertyFieldSerializable=" + _defaultPropertyFieldSerializable));
            this.logger.debug((Object)("defaultPropertyFieldSerializableIUID=" + _defaultPropertyFieldSerializableIUID));
            this.logger.debug((Object)("alertLevel=" + _alertLevel));
            this.logger.debug((Object)("detailLevel=" + _detailLevel));
            this.logger.debug((Object)("trackingLevel=" + _trackingLevel));
            this.logger.debug((Object)("transitionLevel=" + _transitionLevel));
            this.logger.debug((Object)("specialExpressionLevel=" + _specialExpressionLevel));
            this.logger.debug((Object)("unusualExpressionLevel=" + _unusualExpressionLevel));
            this.logger.debug((Object)("verbose=" + _verbose));
            this.logger.debug((Object)("warnose=" + _warnose));
        }

        private void printSummary() {
            this.logger.info((Object)("maxDepthReached=" + this.maxDepthReached));
            this.logger.info((Object)("maxRoundReached=" + this.maxRoundReached));
            this.logger.info((Object)("artifacts=" + Project.this._artifacts.size()));
            this.logger.info((Object)("entities=" + this.entities.size()));
            EntityData.log(this.entities);
            EntityData.log(this.allocations);
            RunUtils.logMemory(this.logger);
            if (this.alerts != 0) {
                if (_alertLevel.equals((Object)Level.WARN)) {
                    this.logger.warn((Object)("alerts=" + this.alerts));
                } else if (_alertLevel.equals((Object)Level.INFO)) {
                    this.logger.info((Object)("alerts=" + this.alerts));
                }
            }
            if (this.warnings == 0) {
                this.logger.info((Object)("warnings=" + this.warnings));
            } else {
                this.logger.warn((Object)("warnings=" + this.warnings));
            }
            if (this.errors == 0) {
                this.logger.info((Object)("errors=" + this.errors));
            } else {
                this.logger.warn((Object)("errors=" + this.errors));
            }
        }

        private void resetCounters() {
            this.maxDepthReached = 0;
            this.maxRoundReached = 0;
            this.entities.clear();
            this.alerts = 0;
            this.warnings = 0;
            this.errors = 0;
        }

        void setMaxDepthReached(int depth) {
            if (depth > this.maxDepthReached) {
                this.maxDepthReached = depth;
            }
        }

        void setMaxRoundReached(int round) {
            if (round > this.maxRoundReached) {
                this.maxRoundReached = round;
            }
        }

        void addEntity(Entity entity) {
            if (_acerose && entity != null) {
                String name = entity.getClass().getName();
                EntityData data = this.entities.get(name);
                if (data == null) {
                    this.entities.put(name, new EntityData(entity));
                } else {
                    data.add(entity);
                }
            }
        }

        void addEntity(Entity entity, String fullName, int depth, int round, int maxDepth, int maxRound) {
            this.addEntity(entity);
            this.addAllocation(fullName, depth, round, maxDepth, maxRound);
        }

        void addAllocation(String fullName, int depth, int round, int maxDepth, int maxRound) {
            if (_foliose && fullName != null) {
                this.allocations.add(EntityData.log(fullName, depth, round, maxDepth, maxRound));
            }
        }

        void addQueryTable(QueryTable queryTable) {
            if (_acerose && queryTable != null) {
                String name = queryTable.getEntity().getClass().getName();
                EntityData data = this.entities.get(name);
                if (data == null) {
                    this.entities.put(name, new EntityData(queryTable));
                } else {
                    data.add(queryTable);
                }
            }
        }

        void increaseAlertCount() {
            ++this.alerts;
        }

        void increaseWarningCount() {
            ++this.warnings;
        }

        void increaseErrorCount() {
            ++this.errors;
        }

        void increaseTransitionCount() {
            Level level = Project.getTransitionLevel();
            if (level.equals((Object)Level.WARN)) {
                ++this.warnings;
            } else if (level.equals((Object)Level.ERROR) || level.equals((Object)Level.FATAL)) {
                ++this.errors;
            }
        }

        void log(Level level, String message) {
            if (LogUtils.foul(this.logger, level)) {
                return;
            }
            this.logger.log((Priority)level, (Object)message);
        }

        void warn(Object message) {
            this.logger.warn(message);
            ++this.warnings;
        }

        void error(Object message) {
            this.logger.error(message);
            ++this.errors;
        }

        void track(int depth, int round, String path, String method, Object ... parameters) {
            this.track(_trackingLevel, depth, round, path, Project.this.signature(method, parameters), null);
        }

        void track(int depth, int round, String path, Class<?> type, String name, String method, String remarks) {
            String tipo = type == null ? "" : type.getSimpleName();
            String note = tipo + "[" + name + "]." + method;
            this.track(_trackingLevel, depth, round, path, note, remarks);
        }

        void alert(int depth, int round, String path, Class<?> type, String name, String method, String remarks) {
            String tipo = type == null ? "" : type.getSimpleName();
            String note = tipo + "[" + name + "]." + method;
            this.track(_alertLevel, depth, round, path, note, remarks);
            ++this.alerts;
        }

        private void track(Level level, int depth, int round, String path, String note, String remarks) {
            if (LogUtils.foul(this.logger, level)) {
                return;
            }
            boolean margin = LogUtils.fair(this.logger, _trackingLevel);
            String margin1 = margin ? StringUtils.repeat((String)" ", (int)(5 * depth)) : "";
            String margin2 = margin ? StringUtils.repeat((String)" ", (int)(5 * (depth + 1))) : Project.TAB;
            Object message = margin1;
            message = (String)message + "d=" + depth + ", r=" + round + ", ";
            if (StringUtils.isNotBlank((String)path)) {
                message = (String)message + path + ".";
            }
            message = (String)message + note;
            this.logger.log((Priority)level, message);
            if (StringUtils.isNotBlank((String)remarks)) {
                this.logger.log((Priority)level, (Object)(margin2 + remarks));
            }
        }

        private void fatal(Throwable throwable) {
            Throwable cause = ThrowableUtils.getCause(throwable);
            String message = throwable.equals(cause) ? throwable.getClass().getSimpleName() : throwable.getMessage();
            this.logger.fatal((Object)message, cause);
            ++this.errors;
        }
    }
}

