/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.Project;
import adalid.core.ProjectReference;
import adalid.core.interfaces.Entity;
import java.util.Map;
import java.util.TreeMap;

public class ProjectEntityReference {
    private Entity _entity;
    private Class<?> _entityClass;
    private boolean _explicit;
    private boolean _implicit;
    private final Map<String, Class<?>> _declaredTypes = new TreeMap();
    private final Map<String, Class<?>> _declaringTypes = new TreeMap();
    private final Project _outer;

    ProjectEntityReference(Project outer) {
        this._outer = outer;
    }

    ProjectEntityReference(Entity entity, Project outer) {
        this._outer = outer;
        this._entity = entity;
        this._entityClass = entity.getClass();
    }

    ProjectEntityReference(Class<?> entityClass, Project outer) {
        this._outer = outer;
        this._entity = null;
        this._entityClass = entityClass;
    }

    public Entity getEntity() {
        return this._entity;
    }

    void setEntity(Entity entity) {
        this._entity = entity;
    }

    public Class<?> getEntityClass() {
        return this._entityClass;
    }

    void putDeclaredType(Class<?> declaredType) {
        this._declaredTypes.put(declaredType.getName(), declaredType);
    }

    public Map<String, Class<?>> getDeclaredTypes() {
        return this._declaredTypes;
    }

    void putDeclaringType(Class<?> declaringType) {
        if (declaringType != null) {
            this._declaringTypes.put(declaringType.getName(), declaringType);
            if (Entity.class.isAssignableFrom(declaringType)) {
                String key = declaringType.getSimpleName();
                if (this._outer.getEntityReferences().containsKey(key)) {
                    ProjectEntityReference reference = this._outer.getEntityReferences().get(key);
                    reference.putDeclaredType(this._entityClass);
                }
            } else if (Project.class.isAssignableFrom(declaringType)) {
                String key = declaringType.getName();
                ProjectReference reference = this._outer.getProjectReferences().get(key);
                reference.putDeclaredType(this._entityClass);
            }
        }
    }

    public Map<String, Class<?>> getDeclaringTypes() {
        return this._declaringTypes;
    }

    public boolean isExplicit() {
        return this._explicit;
    }

    void setExplicit(boolean explicit) {
        this._explicit = explicit;
    }

    void setExplicit(Class<?> declaringType) {
        this._explicit |= Project.class.isAssignableFrom(declaringType);
    }

    public boolean isImplicit() {
        return this._implicit;
    }

    void setImplicit(boolean implicit) {
        this._implicit = implicit;
    }

    void setImplicit(Class<?> declaringType) {
        this._implicit |= Entity.class.isAssignableFrom(declaringType);
    }
}

