/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.core.AbstractArtifact;
import adalid.core.ReportField;
import adalid.core.ReportGroup;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.enums.ViewFieldAggregation;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.programmers.ChiefProgrammer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Report
extends AbstractArtifact
implements Comparable<Report> {
    private static final int COLUMN_WIDTH = 960;
    private static final String EOL = "\n";
    private PersistentEntity _entity;
    private View _view;
    private int _interFieldGapWidth = 6;
    private final Map<ViewField, ReportGroup> _groupsMap = new LinkedHashMap<ViewField, ReportGroup>();
    private final List<ReportGroup> _groups = new ArrayList<ReportGroup>();
    private ReportGroup _detailGroup;
    private ReportGroup _lastControlGroup;
    private ReportGroup _penultimateControlGroup;
    private boolean _cntAtHand;
    private boolean _minAtHand;
    private boolean _maxAtHand;
    private boolean _sumAtHand;
    private boolean _avgAtHand;
    private boolean _devAtHand;
    private final Set<ViewFieldAggregation> _aggregations = new LinkedHashSet<ViewFieldAggregation>();

    private Report() {
    }

    public Report(String name) {
        if (name != null) {
            this.declare(name);
        }
    }

    private void declare(String name) {
        this.setDeclared(name);
    }

    public Report(PersistentEntity entity) {
        if (entity != null) {
            this.init(entity);
        }
    }

    private void init(PersistentEntity entity) {
        this._entity = entity;
        this._detailGroup = ReportGroup.addReportGroup(this);
        List<ReportField> fields = this._detailGroup.getFields();
        if (fields != null && fields.size() > 0) {
            this.resize(this._detailGroup);
        }
        Collections.sort(this._groups);
        this.setDeclared(entity.getName());
    }

    public Report(View view) {
        if (view != null) {
            this.init(view);
        }
    }

    private void init(View view) {
        this._view = view;
        this._entity = view.getDeclaringPersistentEntity();
        int seq = 0;
        for (ViewField field : this._view.getViewControlFields()) {
            this._penultimateControlGroup = this._lastControlGroup;
            this._lastControlGroup = ReportGroup.addReportGroup(this, field, ++seq);
        }
        if (this._lastControlGroup != null) {
            this._lastControlGroup.setLastControl(true);
        }
        if (this._penultimateControlGroup != null) {
            this._penultimateControlGroup.setPenultimateControl(true);
        }
        this._detailGroup = ReportGroup.addReportGroup(this, view);
        for (ViewField viewField : this._view.getViewFields()) {
            ReportField reportField;
            ViewField groupField = viewField.getGroupField();
            if (groupField == null) {
                reportField = ReportField.addReportField(this._detailGroup, viewField);
                this.setReportProperties(reportField);
                continue;
            }
            ReportGroup reportGroup = this._groupsMap.get(groupField);
            if (reportGroup == null) continue;
            reportField = ReportField.addReportField(reportGroup, viewField);
            if (!viewField.isControlField()) continue;
            reportGroup.setField(reportField);
        }
        this.addAggregates();
        Collections.sort(this._groups);
        this.setDeclared(this._entity.getName() + "_" + view.getName());
    }

    public PersistentEntity getEntity() {
        return this._entity;
    }

    public View getView() {
        return this._view;
    }

    public String getTitle() {
        return StrUtils.getStringJava(this._view.getName().toUpperCase());
    }

    public int getInterFieldGapWidth() {
        return this._interFieldGapWidth;
    }

    void setInterFieldGapWidth(int interFieldGapWidth) {
        this._interFieldGapWidth = interFieldGapWidth;
    }

    public Map<ViewField, ReportGroup> getGroupsMap() {
        return this._groupsMap;
    }

    public List<ReportGroup> getGroups() {
        return this._groups;
    }

    public ReportGroup getDetailGroup() {
        return this._detailGroup;
    }

    public ReportGroup getLastControlGroup() {
        return this._lastControlGroup;
    }

    public ReportGroup getPenultimateControlGroup() {
        return this._penultimateControlGroup;
    }

    public boolean isCountAtHand() {
        return this._cntAtHand;
    }

    public boolean isMinAtHand() {
        return this._minAtHand;
    }

    public boolean isMaxAtHand() {
        return this._maxAtHand;
    }

    public boolean isSumAtHand() {
        return this._sumAtHand;
    }

    public boolean isAverageAtHand() {
        return this._avgAtHand;
    }

    public boolean isDeviationAtHand() {
        return this._devAtHand;
    }

    public void addAggregates() {
        if (this._sumAtHand) {
            this._aggregations.add(ViewFieldAggregation.SUM);
        }
        if (this._cntAtHand) {
            this._aggregations.add(ViewFieldAggregation.COUNT);
        }
        if (this._avgAtHand) {
            this._aggregations.add(ViewFieldAggregation.AVERAGE);
        }
        if (this._devAtHand) {
            this._aggregations.add(ViewFieldAggregation.DEVIATION);
        }
        if (this._minAtHand) {
            this._aggregations.add(ViewFieldAggregation.MINIMUM);
        }
        if (this._maxAtHand) {
            this._aggregations.add(ViewFieldAggregation.MAXIMUM);
        }
    }

    private void setReportProperties(ReportField field) {
        this._cntAtHand |= field.isCountAtHand();
        this._minAtHand |= field.isMinAtHand();
        this._maxAtHand |= field.isMaxAtHand();
        this._sumAtHand |= field.isSumAtHand();
        this._avgAtHand |= field.isAverageAtHand();
        this._devAtHand |= field.isDeviationAtHand();
    }

    public Set<ViewFieldAggregation> getAggregations() {
        return this._aggregations;
    }

    public String getAggregateFunctionName(String aggregation) {
        ViewFieldAggregation tipo = ViewFieldAggregation.valueOf(aggregation);
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        String funcion = sqlProgrammer.getSqlFunctionName(tipo);
        return funcion;
    }

    private void resize(ReportGroup group) {
        int used = 0;
        int size = 0;
        ReportField last = null;
        for (ReportField field : group.getFields()) {
            int width = field.getPixels();
            if (width > 0 && used > 0) {
                width += this._interFieldGapWidth;
            }
            if (field.getPixels() <= 0 || width + used > 960) continue;
            used += width;
            if (!field.isResizeable()) continue;
            last = field;
            size += field.getPixels();
        }
        int free = 960 - used;
        if (last != null && free > 0) {
            for (ReportField field : group.getFields()) {
                if (field.getPixels() <= 0 || used >= 960) continue;
                int extra = field == last ? 960 - used : (field.isResizeable() ? field.getPixels() * free / size : 0);
                if (extra > field.getPixels()) {
                    extra = field.getPixels();
                }
                used += extra;
                field.setPixels(field.getPixels() + extra);
            }
        }
    }

    @Override
    public int compareTo(Report that) {
        if (that != null) {
            String thisName = StringUtils.trimToEmpty((String)this.getName());
            String thatName = StringUtils.trimToEmpty((String)that.getName());
            return thisName.compareTo(thatName);
        }
        return 0;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            if (this._entity != null) {
                string = (String)string + fee + tab + "entity" + faa + this._entity + foo;
            }
            if (this._view != null) {
                string = (String)string + fee + tab + "view" + faa + this._view + foo;
            }
        }
        return string;
    }
}

