/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.EntityCollection;
import adalid.core.Project;
import adalid.core.Step;
import adalid.core.StepField;
import adalid.core.TabField;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Property;
import adalid.core.primitives.BooleanPrimitive;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Tab
extends AbstractArtifact {
    private static final Logger logger = Logger.getLogger(Tab.class);
    private final List<TabField> _tabFieldsList = new ArrayList<TabField>();
    private int _sequenceNumber;
    private BooleanExpression _renderingFilter;
    char _finaliseFields;
    char _finaliseTabFieldArray;
    char _toString;
    char _isValidTabFor;

    public List<TabField> getTabFieldsList() {
        return this._tabFieldsList;
    }

    public BooleanExpression getRenderingFilter() {
        return this._renderingFilter;
    }

    public void setRenderingFilter(BooleanExpression renderingFilter) {
        String message = "failed to set rendering filter of " + this.getFullName();
        if (renderingFilter == null) {
            message = message + "; supplied expression is null";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        } else {
            this._renderingFilter = renderingFilter instanceof BooleanPrimitive ? renderingFilter.isTrue() : renderingFilter;
        }
    }

    public void newTabField(EntityCollection collection) {
        String message = "failed to add collection " + collection.getFullName() + " to tab " + this.getName();
        Tab tab = collection.getTab();
        if (tab == null) {
            collection.setTab(this);
            TabField tabField = new TabField(this, collection);
            this._tabFieldsList.add(tabField);
        } else {
            message = message + "; collection previously added to tab " + tab.getName();
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        }
    }

    public void newTabField(Property property) {
        TabField tabField = new TabField(this, property);
        this._tabFieldsList.add(tabField);
    }

    public void newTabField(Property ... property) {
        Property[] properties = property;
        if (properties != null) {
            for (Property p : properties) {
                TabField tabField = new TabField(this, p);
                this._tabFieldsList.add(tabField);
            }
        }
    }

    public int getSequenceNumber() {
        return this._sequenceNumber * 1000 + this.getFieldIndex();
    }

    public void setSequenceNumber(int sequenceNumber) {
        this._sequenceNumber = sequenceNumber < 0 ? 0 : (sequenceNumber > 1000000 ? 1000000 : sequenceNumber);
    }

    public int getFieldIndex() {
        Entity declaringEntityRoot = this.getDeclaringEntityRoot();
        List<Tab> tabs = declaringEntityRoot == null ? null : declaringEntityRoot.getTabsList();
        return tabs == null || tabs.isEmpty() ? 0 : tabs.indexOf(this) + 1;
    }

    public void copy(Step step) {
        this.copy(step, true);
    }

    public void copy(Step step, boolean deep) {
        this.copyLocalizedStrings(step);
        if (deep) {
            List<StepField> fields = step.stepFieldsList();
            for (StepField field : fields) {
                Property sfp = field.getProperty();
                EntityCollection sfc = field.getEntityCollection();
                if (sfp != null) {
                    this.newTabField(sfp);
                    continue;
                }
                if (sfc == null) continue;
                this.newTabField(sfc);
            }
        }
        this._sequenceNumber = step.sequenceNumber();
    }
}

