/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.data.types;

import adalid.core.XS2;
import adalid.core.primitives.NumericPrimitive;
import java.math.BigDecimal;

public class BigDecimalData
extends NumericPrimitive {
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    private int _precision = -1;
    private int _scale = -1;

    public BigDecimalData() {
        XS2.setDataClass(this, BigDecimalData.class);
        XS2.setDataType(this, BigDecimal.class);
        this.setMinValue(ZERO);
        this.setMinMaxNumbers();
    }

    public int getPrecision() {
        return this._precision;
    }

    public void setPrecision(int precision) {
        XS2.checkAccess();
        this._precision = precision;
        this.setMinMaxNumbers();
    }

    public int getScale() {
        return this._scale;
    }

    public void setScale(int scale) {
        XS2.checkAccess();
        this._scale = scale;
        this.setMinMaxNumbers();
    }

    private void setMinMaxNumbers() {
        int d = 16;
        int m = 60;
        int p = this._precision == 0 ? d : (this._precision >= 1 && this._precision <= m ? this._precision : m);
        int s = this._scale >= 0 && this._scale <= p ? this._scale : 0;
        BigDecimal one = BigDecimal.ONE.divide(BigDecimal.TEN.pow(s));
        BigDecimal max = BigDecimal.TEN.pow(p - s).subtract(one);
        BigDecimal min = BigDecimal.ZERO.subtract(max);
        this.setMinNumber(min);
        this.setMaxNumber(max);
    }
}

