/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.data.types;

import adalid.core.XS2;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.EmbeddedDocumentStyle;
import adalid.core.enums.EmbeddedDocumentType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.LetterCase;
import adalid.core.enums.MimeType;
import adalid.core.enums.UploadStorageOption;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.expressions.CharacterOrderedPairX;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Property;
import adalid.core.primitives.CharacterPrimitive;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class StringData
extends CharacterPrimitive {
    private static final String EOL = "\n";
    private static final String MIDDOT = " \u00b7 ";
    public static final String EMPTY = "";
    private int _minLength;
    private Integer _maxLength;
    private String _inputMask;
    private char _slotChar;
    private Pattern _pattern;
    private final Map<Locale, String> _localizedRegexErrorMessage;
    private LetterCase _letterCase;
    private boolean _allowDiacritics;
    private boolean _richTextFormat;
    private String _specialConverterName;
    private String _specialValidatorName;
    private CharacterExpression _typeNameExpression;
    private UrlType _urlType;
    private DisplayMode _urlDisplayMode;
    private UrlDisplayType _urlDisplayType;
    private String[] _sourceURLs;
    private String _searchURL;
    private boolean _fileUploadAutoStart;
    private int _fileUploadFileLimit;
    private int _maxInputFileSize;
    private MimeType[] _validInputFileTypes;
    private Pattern _validInputFilePattern;
    private UploadStorageOption _uploadStorageOption;
    private String _blobFieldName;
    private String _joinFieldName;
    private String _loadFieldName;
    private String _textFieldName;
    private Field _blobField;
    private Field _joinField;
    private Field _loadField;
    private Field _textField;
    private Entity _blobEntity;
    private Entity _joinEntity;
    private Entity _loadEntity;
    private Entity _textEntity;
    private Property _blobProperty;
    private Property _joinProperty;
    private Property _loadProperty;
    private Property _textProperty;
    private Kleenean _updateableFileReference;
    private EmbeddedDocumentType _embeddedDocumentType;
    private EmbeddedDocumentStyle _embeddedDocumentStyle;
    private int _displayWidth;
    private int _displayHeight;
    private Boolean _frameBorder;
    private Boolean _encryptedMedia;
    private Boolean _accelerometer;
    private Boolean _autoplay;
    private Boolean _gyroscope;
    private Boolean _pictureInPicture;
    private Boolean _fullScreen;
    private static final String MIME_TYPES_REGEX_PREFIX = "^(.*)(\\.)";
    private static final String MIME_TYPES_REGEX_SUFFIX = "$";

    public StringData() {
        XS2.setDataClass(this, StringData.class);
        XS2.setDataType(this, String.class);
        this._minLength = 0;
        this._slotChar = (char)95;
        this._localizedRegexErrorMessage = new LinkedHashMap<Locale, String>();
        this._letterCase = LetterCase.UNSPECIFIED;
        this._allowDiacritics = true;
        this._richTextFormat = false;
        this._urlType = UrlType.UNSPECIFIED;
        this._urlDisplayMode = DisplayMode.UNSPECIFIED;
        this._urlDisplayType = UrlDisplayType.UNSPECIFIED;
        this._fileUploadAutoStart = false;
        this._fileUploadFileLimit = 1;
        this._maxInputFileSize = -1;
        this._validInputFileTypes = new MimeType[0];
        this._uploadStorageOption = UploadStorageOption.UNSPECIFIED;
        this._updateableFileReference = Kleenean.UNSPECIFIED;
        this._embeddedDocumentType = EmbeddedDocumentType.UNSPECIFIED;
        this._embeddedDocumentStyle = EmbeddedDocumentStyle.UNSPECIFIED;
        this._displayWidth = -1;
        this._displayHeight = -1;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public void setMinLength(int minLength) {
        XS2.checkAccess();
        this._minLength = minLength;
    }

    public Integer getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        XS2.checkAccess();
        this._maxLength = maxLength;
    }

    public boolean isLargeObject() {
        return this._maxLength == null;
    }

    public String getInputMask() {
        return this._inputMask;
    }

    public void setInputMask(String inputMask) {
        XS2.checkAccess();
        this._inputMask = inputMask;
    }

    public char getSlotChar() {
        return this._slotChar;
    }

    public void setSlotChar(char slotChar) {
        XS2.checkAccess();
        this._slotChar = slotChar;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    public void setPattern(Pattern pattern) {
        XS2.checkAccess();
        this._pattern = pattern;
    }

    public String getPatternRegex() {
        return this._pattern == null ? null : this._pattern.pattern();
    }

    public String getDefaultRegexErrorMessage() {
        return this.getLocalizedRegexErrorMessage(null);
    }

    public void setDefaultRegexErrorMessage(String message) {
        this.setLocalizedRegexErrorMessage(null, message);
    }

    public String getLocalizedRegexErrorMessage(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedRegexErrorMessage.get(l);
    }

    public void setLocalizedRegexErrorMessage(Locale locale, String message) {
        Locale l = this.localeWritingKey(locale);
        if (message == null) {
            this._localizedRegexErrorMessage.remove(l);
        } else {
            this._localizedRegexErrorMessage.put(l, message);
        }
    }

    public LetterCase getLetterCase() {
        return this._letterCase;
    }

    public void setLetterCase(LetterCase letterCase) {
        XS2.checkAccess();
        this._letterCase = letterCase == null ? LetterCase.UNSPECIFIED : letterCase;
    }

    public boolean getAllowDiacritics() {
        return this._allowDiacritics;
    }

    public void setAllowDiacritics(boolean allowDiacritics) {
        XS2.checkAccess();
        this._allowDiacritics = allowDiacritics;
    }

    public boolean getRichTextFormat() {
        return this._richTextFormat;
    }

    public void setRichTextFormat(boolean richTextFormat) {
        XS2.checkAccess();
        this._richTextFormat = richTextFormat;
    }

    public String getSpecialConverterName() {
        return this._specialConverterName;
    }

    public void setSpecialConverterName(String converter) {
        XS2.checkAccess();
        this._specialConverterName = converter;
    }

    public String getSpecialValidatorName() {
        return this._specialValidatorName;
    }

    public void setSpecialValidatorName(String validator) {
        XS2.checkAccess();
        this._specialValidatorName = validator;
    }

    public CharacterExpression getTypeNameExpression() {
        return this._typeNameExpression;
    }

    public void setTypeNameExpression(CharacterExpression expression) {
        this._typeNameExpression = expression;
    }

    public UrlType getUrlType() {
        return this._urlType;
    }

    public void setUrlType(UrlType type) {
        XS2.checkAccess();
        this._urlType = type == null ? UrlType.UNSPECIFIED : type;
    }

    public DisplayMode getUrlDisplayMode() {
        return this._urlDisplayMode;
    }

    public void setUrlDisplayMode(DisplayMode mode) {
        XS2.checkAccess();
        this._urlDisplayMode = mode == null ? DisplayMode.UNSPECIFIED : mode;
    }

    public UrlDisplayType getUrlDisplayType() {
        return this._urlDisplayType;
    }

    public void setUrlDisplayType(UrlDisplayType type) {
        XS2.checkAccess();
        this._urlDisplayType = type == null ? UrlDisplayType.UNSPECIFIED : type;
    }

    public String getSourceURLsJoint() {
        return this.getEmbeddedDocumentURLsJoint();
    }

    public String[] getSourceURLs() {
        return this._sourceURLs;
    }

    public void setSourceURLs(String ... urls) {
        XS2.checkAccess();
        this._sourceURLs = urls;
    }

    public String getSearchURL() {
        return this._searchURL;
    }

    public void setSearchURL(String searchURL) {
        XS2.checkAccess();
        this._searchURL = searchURL;
    }

    public boolean isFileUploadAutoStart() {
        return this._fileUploadAutoStart;
    }

    public void setFileUploadAutoStart(boolean autoStart) {
        XS2.checkAccess();
        this._fileUploadAutoStart = autoStart;
    }

    public int getFileUploadFileLimit() {
        return this._fileUploadFileLimit;
    }

    public void setFileUploadFileLimit(int fileLimit) {
        XS2.checkAccess();
        this._fileUploadFileLimit = fileLimit;
    }

    public int getMaxInputFileSize() {
        return this._maxInputFileSize;
    }

    public void setMaxInputFileSize(int size) {
        XS2.checkAccess();
        this._maxInputFileSize = size;
    }

    protected int maxInputFileSize() {
        return this._maxInputFileSize;
    }

    public MimeType[] getValidInputFileTypes() {
        return this._validInputFileTypes;
    }

    public void setValidInputFileTypes(MimeType[] types) {
        XS2.checkAccess();
        this._validInputFileTypes = types == null ? new MimeType[]{} : types;
    }

    public String getValidInputFileTypesRegex() {
        MimeType[] validInputFileTypes = this.getValidInputFileTypes();
        if (validInputFileTypes == null || validInputFileTypes.length == 0) {
            return null;
        }
        Object[] strings = new String[validInputFileTypes.length];
        for (int i = 0; i < validInputFileTypes.length; ++i) {
            strings[i] = StringUtils.join((Object[])validInputFileTypes[i].getExtensions(), (String)"|");
        }
        String join = StringUtils.join((Object[])strings, (String)"|");
        return "^(.*)(\\.)(" + join + ")$";
    }

    public Pattern getValidInputFilePattern() {
        return this._validInputFilePattern;
    }

    public void setValidInputFilePattern(Pattern pattern) {
        XS2.checkAccess();
        this._validInputFilePattern = pattern;
    }

    public String getValidInputFilePatternRegex() {
        return this._validInputFilePattern == null ? null : this._validInputFilePattern.pattern();
    }

    public UploadStorageOption getUploadStorageOption() {
        return this._uploadStorageOption;
    }

    public void setUploadStorageOption(UploadStorageOption option) {
        XS2.checkAccess();
        this._uploadStorageOption = option == null ? UploadStorageOption.UNSPECIFIED : option;
    }

    public String getBlobFieldName() {
        return this._blobFieldName;
    }

    public void setBlobFieldName(String fieldName) {
        XS2.checkAccess();
        this._blobFieldName = fieldName;
    }

    public Field getBlobField() {
        return this._blobField;
    }

    public Field setBlobField(Field field) {
        XS2.checkAccess();
        Field previous = this._blobField;
        this._blobField = field;
        return previous;
    }

    public void setBlobEntity(Entity entity) {
        XS2.checkAccess();
        this._blobEntity = entity;
    }

    public Property getBlobProperty() {
        if (this._blobProperty == null && this._blobField != null && this._blobEntity != null) {
            this._blobProperty = XS2.getProperty(this._blobField, this._blobEntity, true);
        }
        return this._blobProperty;
    }

    public void setBlobProperty(Property property) {
        XS2.checkAccess();
        this._blobProperty = property;
    }

    public String getJoinFieldName() {
        return this._joinFieldName;
    }

    public void setJoinFieldName(String fieldName) {
        XS2.checkAccess();
        this._joinFieldName = fieldName;
    }

    public Field getJoinField() {
        return this._joinField;
    }

    public Field setJoinField(Field field) {
        XS2.checkAccess();
        Field previous = this._joinField;
        this._joinField = field;
        return previous;
    }

    public void setJoinEntity(Entity entity) {
        XS2.checkAccess();
        this._joinEntity = entity;
    }

    public Property getJoinProperty() {
        if (this._joinProperty == null && this._joinField != null && this._joinEntity != null) {
            this._joinProperty = XS2.getProperty(this._joinField, this._joinEntity, true);
        }
        return this._joinProperty;
    }

    public void setJoinProperty(Property property) {
        XS2.checkAccess();
        this._joinProperty = property;
    }

    public String getLoadFieldName() {
        return this._loadFieldName;
    }

    public void setLoadFieldName(String fieldName) {
        XS2.checkAccess();
        this._loadFieldName = fieldName;
    }

    public Field getLoadField() {
        return this._loadField;
    }

    public Field setLoadField(Field field) {
        XS2.checkAccess();
        Field previous = this._loadField;
        this._loadField = field;
        return previous;
    }

    public void setLoadEntity(Entity entity) {
        XS2.checkAccess();
        this._loadEntity = entity;
    }

    public Property getLoadProperty() {
        if (this._loadProperty == null && this._loadField != null && this._loadEntity != null) {
            this._loadProperty = XS2.getProperty(this._loadField, this._loadEntity, true);
        }
        return this._loadProperty;
    }

    public void setLoadProperty(Property property) {
        XS2.checkAccess();
        this._loadProperty = property;
    }

    public String getTextFieldName() {
        return this._textFieldName;
    }

    public void setTextFieldName(String fieldName) {
        XS2.checkAccess();
        this._textFieldName = fieldName;
    }

    public Field getTextField() {
        return this._textField;
    }

    public Field setTextField(Field field) {
        XS2.checkAccess();
        Field previous = this._textField;
        this._textField = field;
        return previous;
    }

    public void setTextEntity(Entity entity) {
        XS2.checkAccess();
        this._textEntity = entity;
    }

    public Property getTextProperty() {
        if (this._textProperty == null && this._textField != null && this._textEntity != null) {
            this._textProperty = XS2.getProperty(this._textField, this._textEntity, true);
        }
        return this._textProperty;
    }

    public void setTextProperty(Property property) {
        XS2.checkAccess();
        this._textProperty = property;
    }

    public Kleenean getUpdateableFileReference() {
        return this._updateableFileReference;
    }

    public void setUpdateableFileReference(Kleenean updateable) {
        XS2.checkAccess();
        this._updateableFileReference = updateable == null ? Kleenean.UNSPECIFIED : updateable;
    }

    public boolean isUpdateableFileReference() {
        Kleenean updateableFileReference = this.getUpdateableFileReference();
        return updateableFileReference != null && updateableFileReference.toBoolean(false);
    }

    public String getEmbeddedDocumentURLsJoint() {
        return this._sourceURLs == null ? EMPTY : StringUtils.join((Object[])this._sourceURLs, (String)MIDDOT);
    }

    public String[] getEmbeddedDocumentURLs() {
        return this._sourceURLs;
    }

    public void setEmbeddedDocumentURLs(String ... urls) {
        XS2.checkAccess();
        this._sourceURLs = urls;
        this.initializeSearchURL();
    }

    private void initializeSearchURL() {
        String sourceURL0;
        URL url;
        if (StringUtils.isBlank((String)this._searchURL) && this._sourceURLs != null && this._sourceURLs.length > 0 && (url = XS2.getURL(sourceURL0 = this._sourceURLs[0])) != null) {
            String path = url.getPath();
            this._searchURL = path.isEmpty() ? sourceURL0 : (path.endsWith("/embed") ? StringUtils.removeEnd((String)sourceURL0, (String)"/embed") : StringUtils.substringBefore((String)sourceURL0, (String)path));
        }
        if (StringUtils.isBlank((String)this._searchURL)) {
            this._searchURL = "https://www.google.com";
        }
    }

    public EmbeddedDocumentType getEmbeddedDocumentType() {
        return this._embeddedDocumentType;
    }

    public void setEmbeddedDocumentType(EmbeddedDocumentType type) {
        String regex;
        XS2.checkAccess();
        if (type == null) {
            type = EmbeddedDocumentType.UNSPECIFIED;
        }
        switch (type) {
            case IFRAME: {
                this._embeddedDocumentType = type;
                regex = "^(?:<iframe\\b[^>]*)\\bsrc=\"(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\".*(?:(?:\\/>)|(?:>.*?<\\/iframe>))$";
                break;
            }
            case URL: {
                this._embeddedDocumentType = type;
                regex = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]$";
                break;
            }
            default: {
                this._embeddedDocumentType = EmbeddedDocumentType.BOTH;
                regex = "^((?:<iframe\\b[^>]*)\\bsrc=\"(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\".*(?:(?:\\/>)|(?:>.*?<\\/iframe>))|(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])$";
            }
        }
        this._pattern = Pattern.compile(regex);
    }

    public EmbeddedDocumentStyle getEmbeddedDocumentStyle() {
        return this._embeddedDocumentStyle;
    }

    public void setEmbeddedDocumentStyle(EmbeddedDocumentStyle style) {
        XS2.checkAccess();
        this._embeddedDocumentStyle = style == null ? EmbeddedDocumentStyle.UNSPECIFIED : style;
    }

    public int getDisplayWidth() {
        return this._displayWidth;
    }

    public void setDisplayWidth(int width) {
        XS2.checkAccess();
        this._displayWidth = width;
    }

    public int getDisplayHeight() {
        return this._displayHeight;
    }

    public void setDisplayHeight(int height) {
        XS2.checkAccess();
        this._displayHeight = height;
    }

    public Boolean getFrameBorder() {
        return this._frameBorder;
    }

    public void setFrameBorder(Boolean frameBorder) {
        XS2.checkAccess();
        this._frameBorder = frameBorder;
    }

    public Boolean getEncryptedMedia() {
        return this._encryptedMedia;
    }

    public void setEncryptedMedia(Boolean allow) {
        XS2.checkAccess();
        this._encryptedMedia = allow;
    }

    public Boolean getAccelerometer() {
        return this._accelerometer;
    }

    public void setAccelerometer(Boolean allow) {
        XS2.checkAccess();
        this._accelerometer = allow;
    }

    public Boolean getAutoplay() {
        return this._autoplay;
    }

    public void setAutoplay(Boolean allow) {
        XS2.checkAccess();
        this._autoplay = allow;
    }

    public Boolean getGyroscope() {
        return this._gyroscope;
    }

    public void setGyroscope(Boolean allow) {
        XS2.checkAccess();
        this._gyroscope = allow;
    }

    public Boolean getPictureInPicture() {
        return this._pictureInPicture;
    }

    public void setPictureInPicture(Boolean allow) {
        XS2.checkAccess();
        this._pictureInPicture = allow;
    }

    public Boolean getFullScreen() {
        return this._fullScreen;
    }

    public void setFullScreen(Boolean allow) {
        XS2.checkAccess();
        this._fullScreen = allow;
    }

    public CharacterOrderedPairX toZeroPaddedString() {
        int l = this._maxLength == null ? 0 : this._maxLength;
        return this.toZeroPaddedString(l);
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : EMPTY;
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : EMPTY;
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "minLength" + faa + this._minLength + foo;
            if (this._maxLength != null) {
                string = (String)string + fee + tab + "maxLength" + faa + this._maxLength + foo;
            }
        }
        return string;
    }
}

