/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.expressions;

import adalid.core.AbstractExpression;
import adalid.core.enums.ConditionalOp;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.ConditionalX;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NaryExpression;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractConditionalX
extends AbstractExpression
implements ConditionalX {
    private static final String EOL = "\n";
    private final ConditionalOp _operator;
    private final BooleanExpression _booleanExpression;
    private final Object _thenValue;
    private final Object _elseValue;

    AbstractConditionalX(BooleanExpression booleanExpression, Object value) {
        this._operator = ConditionalOp.IF_THEN;
        this._booleanExpression = booleanExpression;
        this._thenValue = value;
        this._elseValue = null;
    }

    AbstractConditionalX(ConditionalX conditional, Object value) {
        this._operator = ConditionalOp.IF_THEN_ELSE;
        this._booleanExpression = conditional.getBooleanExpression();
        this._thenValue = conditional.getThenValue();
        this._elseValue = value;
    }

    @Override
    public ConditionalOp getOperator() {
        return this._operator;
    }

    @Override
    public Object[] getOperands() {
        return new Object[]{this._booleanExpression, this._thenValue, this._elseValue};
    }

    @Override
    public BooleanExpression getBooleanExpression() {
        return this._booleanExpression;
    }

    @Override
    public Object getThenValue() {
        return this._thenValue;
    }

    @Override
    public Object getElseValue() {
        return this._elseValue;
    }

    @Override
    public Class<?> getDataType() {
        Class<?> thenDataType = this.getObjectDataType(this._thenValue);
        Class<?> elseDataType = this.getObjectDataType(this._elseValue);
        if (this._thenValue == null && this._elseValue == null) {
            return null;
        }
        if (this._thenValue != null && (this._elseValue == null || thenDataType.isAssignableFrom(elseDataType))) {
            return thenDataType;
        }
        if (this._elseValue != null && (this._thenValue == null || elseDataType.isAssignableFrom(thenDataType))) {
            return elseDataType;
        }
        if (this._thenValue != null && this._elseValue != null) {
            Class[] types;
            for (Class type : types = new Class[]{Boolean.class, String.class, Number.class, Date.class}) {
                if (!type.isAssignableFrom(thenDataType) || !type.isAssignableFrom(elseDataType)) continue;
                return type;
            }
        }
        return Object.class;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            Expression e;
            if (this._booleanExpression != null) {
                string = (String)string + this._booleanExpression.toString(n + 1, "booleanExpression");
            }
            if (this._thenValue != null) {
                if (this._thenValue instanceof NaryExpression) {
                    e = (Expression)this._thenValue;
                    string = (String)string + e.toString(n + 1, "thenExpression");
                } else {
                    string = (String)string + fee + tab + "thenExpression" + faa + this.getValueString(this._thenValue) + foo;
                }
            }
            if (this._elseValue != null) {
                if (this._elseValue instanceof NaryExpression) {
                    e = (Expression)this._elseValue;
                    string = (String)string + e.toString(n + 1, "elseExpression");
                } else {
                    string = (String)string + fee + tab + "elseExpression" + faa + this.getValueString(this._elseValue) + foo;
                }
            }
        }
        return string;
    }
}

