/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.expressions;

import adalid.core.AbstractExpression;
import adalid.core.enums.DataAggregateOp;
import adalid.core.interfaces.DataAggregateX;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NaryExpression;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDataAggregateX
extends AbstractExpression
implements DataAggregateX {
    private static final String EOL = "\n";
    private final DataAggregateOp _operator;
    private Object[] _operands = null;

    protected AbstractDataAggregateX(DataAggregateOp operator, Object ... operands) {
        this._operator = operator;
        this._operands = operands;
        this.initDataType();
    }

    @Override
    public DataAggregateOp getOperator() {
        return this._operator;
    }

    @Override
    public Object[] getOperands() {
        return this._operands == null ? new Object[]{} : this._operands;
    }

    private void initDataType() {
        Object operand;
        Object object = operand = this._operands == null || this._operands.length == 0 ? null : this._operands[0];
        if (this._operator == null) {
            this.copyDataType(operand);
        } else {
            switch (this._operator) {
                case AND: 
                case NAND: 
                case OR: 
                case NOR: 
                case NAXOR: 
                case NAXNOR: 
                case NOR_OR_NAXOR: {
                    this.setDataType(Boolean.class);
                    break;
                }
                case CONCAT: {
                    this.setDataType(String.class);
                    break;
                }
                case COUNT: {
                    this.setDataType(Long.class);
                    break;
                }
                case COALESCE: 
                case MAXIMUM: 
                case MINIMUM: {
                    this.copyDataType(operand);
                    break;
                }
                case SUM: 
                case PRODUCT: 
                case AVERAGE: {
                    this.setDataType(BigDecimal.class);
                    break;
                }
                default: {
                    this.copyDataType(operand);
                }
            }
        }
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if (fields || verbose) {
            string = (String)string + fee + tab + "operands" + faa + this._operands.length + foo;
            if (verbose) {
                string = (String)string + fee + tab + "operator" + faa + this._operator + foo;
            }
        }
        return string;
    }

    @Override
    protected String mapsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.mapsToString(n, key, verbose, fields, maps);
        if ((maps || verbose) && this._operands != null) {
            for (int i = 0; i < this._operands.length; ++i) {
                String clave = "operands_" + i;
                if (this._operands[i] instanceof NaryExpression) {
                    Expression valor = (Expression)this._operands[i];
                    string = (String)string + valor.toString(n + 1, clave, verbose, fields, maps);
                    continue;
                }
                string = (String)string + fee + tab + clave + faa + this.getValueString(this._operands[i]) + foo;
            }
        }
        return string;
    }
}

