/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.jee;

import adalid.core.Display;
import adalid.core.EntityCollection;
import adalid.core.PageField;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.jee.JavaServerPage;
import adalid.core.sql.QueryTable;
import java.util.ArrayList;
import java.util.List;

public class CrudJavaServerPage
extends JavaServerPage {
    private List<PageField> _fields;
    private List<PageField> _masterFields;

    public CrudJavaServerPage(String name) {
        super(name);
    }

    @Override
    public List<PageField> getFields() {
        if (this._fields == null) {
            this._fields = new ArrayList<PageField>();
            Entity entity = this.getEntity();
            if (entity instanceof PersistentEntity) {
                PageField field;
                PersistentEntity persistentEntity = (PersistentEntity)entity;
                QueryTable queryTable = persistentEntity.getQueryTable();
                this.setQueryTable(queryTable);
                List<Property> columns = persistentEntity.getDataProviderColumnsList();
                for (Property column : columns) {
                    if (column.isHiddenField()) continue;
                    field = new PageField((Display)this, column);
                    this._fields.add(field);
                    if (!(column instanceof Entity)) continue;
                    Entity reference = (Entity)((Object)column);
                    Property keyProperty = reference.getBusinessKeyProperty();
                    PageField child = this.addChildField(this._fields, queryTable, keyProperty, field);
                    if (child != null) {
                        child.setForeignCode(true);
                    }
                    if ((child = this.addChildField(this._fields, queryTable, keyProperty = reference.getNameProperty(), field)) == null) continue;
                    child.setForeignName(true);
                }
                List<EntityCollection> collections = persistentEntity.getEntityCollectionsList();
                for (EntityCollection collection : collections) {
                    field = new PageField((Display)this, collection);
                    this._fields.add(field);
                }
            }
        }
        return this._fields;
    }

    @Override
    public List<PageField> getMasterHeadingFields() {
        if (this._masterFields == null) {
            this._masterFields = new ArrayList<PageField>();
            Entity master = this.getMaster();
            if (master instanceof PersistentEntity) {
                PersistentEntity persistentEntity = (PersistentEntity)master;
                QueryTable queryTable = persistentEntity.getQueryTable();
                this.setMasterQueryTable(queryTable);
                List<Property> columns = persistentEntity.getDataProviderColumnsList();
                for (Property column : columns) {
                    if (!column.isHeadingField()) continue;
                    PageField field = new PageField((Display)this, column);
                    this._masterFields.add(field);
                    if (!(column instanceof Entity)) continue;
                    Entity reference = (Entity)((Object)column);
                    Property keyProperty = reference.getBusinessKeyProperty();
                    PageField child = this.addChildField(this._masterFields, queryTable, keyProperty, field);
                    if (child != null) {
                        child.setForeignCode(true);
                    }
                    if ((child = this.addChildField(this._masterFields, queryTable, keyProperty = reference.getNameProperty(), field)) == null) continue;
                    child.setForeignName(true);
                }
            }
        }
        return this._masterFields;
    }

    private PageField addChildField(List<PageField> list, QueryTable queryTable, Property keyProperty, PageField parent) {
        if (keyProperty != null && queryTable.contains(keyProperty)) {
            PageField field = new PageField(this, queryTable, keyProperty, parent);
            list.add(field);
            return field;
        }
        return null;
    }
}

