/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.primitives;

import adalid.core.Instance;
import adalid.core.Primitive;
import adalid.core.ProcessOperation;
import adalid.core.Transition;
import adalid.core.Trigger;
import adalid.core.enums.RowsAggregateOp;
import adalid.core.enums.SpecialBooleanValue;
import adalid.core.enums.SpecialCharacterValue;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialNumericValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.expressions.BooleanComparisonX;
import adalid.core.expressions.BooleanConditionalX;
import adalid.core.expressions.BooleanOrderedPairX;
import adalid.core.expressions.BooleanScalarX;
import adalid.core.expressions.CharacterConditionalX;
import adalid.core.expressions.CharacterScalarX;
import adalid.core.expressions.EntityConditionalX;
import adalid.core.expressions.NumericConditionalX;
import adalid.core.expressions.TemporalConditionalX;
import adalid.core.expressions.XB;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityExpression;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.State;
import adalid.core.interfaces.TemporalExpression;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BooleanPrimitive
extends Primitive
implements State {
    private Object _calculableValue;
    private Object _initialValue;
    private Object _defaultValue;
    private Object _currentValue;
    private final Map<Locale, String> _localizedErrorMessage = new LinkedHashMap<Locale, String>();

    @Override
    public Object getCalculableValue() {
        return this._calculableValue;
    }

    public void setCalculableValueExpression(BooleanExpression expression) {
        this._calculableValue = this.validCalculableValue(expression) ? expression : null;
    }

    @Override
    public Object getInitialValue() {
        return this._initialValue;
    }

    public boolean isPrimitiveInitialValue() {
        return this._initialValue instanceof Boolean;
    }

    public boolean isSpecialInitialValue() {
        return this._initialValue instanceof SpecialBooleanValue;
    }

    public boolean isExpressInitialValue() {
        return this._initialValue instanceof BooleanExpression;
    }

    public void setInitialValue(Boolean initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    public void setInitialValue(SpecialBooleanValue initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    public void setInitialValue(BooleanExpression initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    @Override
    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public boolean isPrimitiveDefaultValue() {
        return this._defaultValue instanceof Boolean;
    }

    public boolean isSpecialDefaultValue() {
        return this._defaultValue instanceof SpecialBooleanValue;
    }

    public boolean isExpressDefaultValue() {
        return this._defaultValue instanceof BooleanExpression;
    }

    public void setDefaultValue(Boolean defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    public void setDefaultValue(SpecialBooleanValue defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    public void setDefaultValue(BooleanExpression defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    public boolean isPrimitiveCurrentValue() {
        return this._currentValue instanceof Boolean;
    }

    public boolean isSpecialCurrentValue() {
        return this._currentValue instanceof SpecialBooleanValue;
    }

    public boolean isExpressCurrentValue() {
        return this._currentValue instanceof BooleanExpression;
    }

    public void setCurrentValue(Boolean currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    public void setCurrentValue(SpecialBooleanValue currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    public void setCurrentValue(BooleanExpression currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    public void keepTallyOn(Property ... properties) {
        this.addAggregate(RowsAggregateOp.TALLY, properties);
    }

    @Override
    public BooleanComparisonX isNull() {
        return XB.Boolean.Comparison.isNull(this);
    }

    @Override
    public BooleanComparisonX isNotNull() {
        return XB.Boolean.Comparison.isNotNull(this);
    }

    @Override
    public BooleanComparisonX isTrue() {
        return XB.Boolean.Comparison.isTrue(this);
    }

    @Override
    public BooleanComparisonX isFalse() {
        return XB.Boolean.Comparison.isFalse(this);
    }

    @Override
    public BooleanComparisonX isNotTrue() {
        return this.isNullOrFalse();
    }

    @Override
    public BooleanComparisonX isNotFalse() {
        return this.isNullOrTrue();
    }

    @Override
    public BooleanComparisonX isNullOrTrue() {
        return XB.Boolean.Comparison.isNullOrTrue(this);
    }

    @Override
    public BooleanComparisonX isNullOrFalse() {
        return XB.Boolean.Comparison.isNullOrFalse(this);
    }

    @Override
    public BooleanComparisonX isEqualTo(BooleanExpression y) {
        return XB.Boolean.Comparison.isEqualTo(this, y);
    }

    @Override
    public BooleanComparisonX isNotEqualTo(BooleanExpression y) {
        return XB.Boolean.Comparison.isNotEqualTo(this, y);
    }

    @Override
    public BooleanComparisonX isNullOrEqualTo(BooleanExpression y) {
        return XB.Boolean.Comparison.isNullOrEqualTo(this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotEqualTo(BooleanExpression y) {
        return XB.Boolean.Comparison.isNullOrNotEqualTo(this, y);
    }

    @Override
    public EntityConditionalX then(Entity value) {
        return XB.Entity.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public EntityConditionalX then(Instance value) {
        return XB.Entity.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public EntityConditionalX then(SpecialEntityValue value) {
        return XB.Entity.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public EntityConditionalX then(EntityExpression value) {
        return XB.Entity.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public BooleanConditionalX then(Boolean value) {
        return XB.Boolean.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public BooleanConditionalX then(SpecialBooleanValue value) {
        return XB.Boolean.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public BooleanConditionalX then(BooleanExpression value) {
        return XB.Boolean.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public CharacterConditionalX then(String value) {
        return XB.Character.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public CharacterConditionalX then(SpecialCharacterValue value) {
        return XB.Character.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public CharacterConditionalX then(Expression value) {
        return XB.Character.Conditional.then((BooleanExpression)this, this.toCharacterExpression(value));
    }

    @Override
    public NumericConditionalX then(Number value) {
        return XB.Numeric.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public NumericConditionalX then(SpecialNumericValue value) {
        return XB.Numeric.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public NumericConditionalX then(NumericExpression value) {
        return XB.Numeric.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public TemporalConditionalX then(Date value) {
        return XB.Temporal.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public TemporalConditionalX then(SpecialTemporalValue value) {
        return XB.Temporal.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public TemporalConditionalX then(TemporalExpression value) {
        return XB.Temporal.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public BooleanOrderedPairX and(BooleanExpression y) {
        return XB.Boolean.OrderedPair.and(this, y);
    }

    @Override
    public BooleanOrderedPairX nand(BooleanExpression y) {
        return XB.Boolean.OrderedPair.nand(this, y);
    }

    @Override
    public BooleanOrderedPairX or(BooleanExpression y) {
        return XB.Boolean.OrderedPair.or(this, y);
    }

    @Override
    public BooleanOrderedPairX nor(BooleanExpression y) {
        return XB.Boolean.OrderedPair.nor(this, y);
    }

    @Override
    public BooleanOrderedPairX xor(BooleanExpression y) {
        return XB.Boolean.OrderedPair.xor(this, y);
    }

    @Override
    public BooleanOrderedPairX xnor(BooleanExpression y) {
        return XB.Boolean.OrderedPair.xnor(this, y);
    }

    @Override
    public BooleanOrderedPairX implies(BooleanExpression y) {
        return XB.Boolean.OrderedPair.xImpliesY(this, y);
    }

    @Override
    public BooleanScalarX not() {
        return XB.Boolean.Scalar.not(this);
    }

    @Override
    public CharacterScalarX toCharString() {
        return XB.Character.Scalar.toCharString(this);
    }

    private CharacterExpression toCharacterExpression(Object x) {
        return x instanceof CharacterExpression ? (CharacterExpression)x : XB.toCharString(x);
    }

    @Override
    public Transition transitionTo(State y) {
        return new Transition(this, y);
    }

    @Override
    public Trigger trigger(ProcessOperation operation) {
        return new Trigger(this, operation);
    }

    @Override
    public String getDefaultErrorMessage() {
        return this.getLocalizedErrorMessage(null);
    }

    @Override
    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.setLocalizedErrorMessage(null, defaultErrorMessage);
    }

    @Override
    public String getLocalizedErrorMessage(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedErrorMessage.get(l);
    }

    @Override
    public void setLocalizedErrorMessage(Locale locale, String localizedErrorMessage) {
        Locale l = this.localeWritingKey(locale);
        if (localizedErrorMessage == null) {
            this._localizedErrorMessage.remove(l);
        } else {
            this._localizedErrorMessage.put(l, localizedErrorMessage);
        }
    }
}

